/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCollection;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagByteArray
extends NBTTagCollection<NBTTagByte> {
    private byte[] field_74754_a;

    NBTTagByteArray() {
    }

    public NBTTagByteArray(byte[] byArray) {
        this.field_74754_a = byArray;
    }

    public NBTTagByteArray(List<Byte> list) {
        this(NBTTagByteArray.func_193589_a(list));
    }

    private static byte[] func_193589_a(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Byte by = list.get(i);
            byArray[i] = by == null ? (byte)0 : by;
        }
        return byArray;
    }

    @Override
    public void func_74734_a(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.field_74754_a.length);
        dataOutput.write(this.field_74754_a);
    }

    @Override
    public void func_152446_a(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        nBTSizeTracker.func_152450_a(192L);
        int n2 = dataInput.readInt();
        nBTSizeTracker.func_152450_a(8 * n2);
        this.field_74754_a = new byte[n2];
        dataInput.readFully(this.field_74754_a);
    }

    @Override
    public byte func_74732_a() {
        return 7;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[B;");
        for (int i = 0; i < this.field_74754_a.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.field_74754_a[i]).append('B');
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public INBTBase func_74737_b() {
        byte[] byArray = new byte[this.field_74754_a.length];
        System.arraycopy(this.field_74754_a, 0, byArray, 0, this.field_74754_a.length);
        return new NBTTagByteArray(byArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagByteArray && Arrays.equals(this.field_74754_a, ((NBTTagByteArray)object).field_74754_a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.field_74754_a);
    }

    @Override
    public ITextComponent func_199850_a(String string, int n) {
        ITextComponent iTextComponent;
        ITextComponent iTextComponent2 = new TextComponentString("B").func_211708_a(field_197641_e);
        iTextComponent = new TextComponentString("[").func_150257_a(iTextComponent2).func_150258_a(";");
        for (int i = 0; i < this.field_74754_a.length; ++i) {
            ITextComponent iTextComponent3 = new TextComponentString(String.valueOf(this.field_74754_a[i])).func_211708_a(field_197640_d);
            iTextComponent.func_150258_a(" ").func_150257_a(iTextComponent3).func_150257_a(iTextComponent2);
            if (i == this.field_74754_a.length - 1) continue;
            iTextComponent.func_150258_a(",");
        }
        iTextComponent.func_150258_a("]");
        return iTextComponent;
    }

    public byte[] func_150292_c() {
        return this.field_74754_a;
    }

    @Override
    public int size() {
        return this.field_74754_a.length;
    }

    @Override
    public NBTTagByte func_197647_c(int n) {
        return new NBTTagByte(this.field_74754_a[n]);
    }

    @Override
    public void func_197648_a(int n, INBTBase iNBTBase) {
        this.field_74754_a[n] = ((NBTPrimitive)iNBTBase).func_150290_f();
    }

    @Override
    public void func_197649_b(int n) {
        this.field_74754_a = ArrayUtils.remove((byte[])this.field_74754_a, (int)n);
    }

    @Override
    public /* synthetic */ INBTBase func_197647_c(int n) {
        return this.func_197647_c(n);
    }
}

