/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConOutputStream;
import net.minecraft.network.rcon.RConThreadBase;
import net.minecraft.network.rcon.RConUtils;
import net.minecraft.util.Util;

public class RConThreadQuery
extends RConThreadBase {
    private long field_72629_g;
    private int field_72636_h;
    private final int field_72637_i;
    private final int field_72634_j;
    private final String field_72635_k;
    private final String field_72632_l;
    private DatagramSocket field_72633_m;
    private final byte[] field_72630_n = new byte[1460];
    private DatagramPacket field_72631_o;
    private final Map<SocketAddress, String> field_72644_p;
    private String field_72643_q;
    private String field_72642_r;
    private final Map<SocketAddress, Auth> field_72641_s;
    private final long field_72640_t;
    private final RConOutputStream field_72639_u;
    private long field_72638_v;

    public RConThreadQuery(IServer iServer2) {
        super(iServer2, "Query Listener");
        this.field_72636_h = iServer2.func_71327_a("query.port", 0);
        this.field_72642_r = iServer2.func_71277_t();
        this.field_72637_i = iServer2.func_71234_u();
        this.field_72635_k = iServer2.func_71274_v();
        this.field_72634_j = iServer2.func_71275_y();
        this.field_72632_l = iServer2.func_71270_I();
        this.field_72638_v = 0L;
        this.field_72643_q = "0.0.0.0";
        if (this.field_72642_r.isEmpty() || this.field_72643_q.equals(this.field_72642_r)) {
            this.field_72642_r = "0.0.0.0";
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.field_72643_q = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.func_72606_c("Unable to determine local host IP, please set server-ip in '" + iServer2.func_71329_c() + "' : " + unknownHostException.getMessage());
            }
        } else {
            this.field_72643_q = this.field_72642_r;
        }
        if (0 == this.field_72636_h) {
            IServer iServer2;
            this.field_72636_h = this.field_72637_i;
            this.func_72609_b("Setting default query port to " + this.field_72636_h);
            iServer2.func_71328_a("query.port", this.field_72636_h);
            iServer2.func_71328_a("debug", false);
            iServer2.func_71326_a();
        }
        this.field_72644_p = Maps.newHashMap();
        this.field_72639_u = new RConOutputStream(1460);
        this.field_72641_s = Maps.newHashMap();
        this.field_72640_t = new Date().getTime();
    }

    private void func_72620_a(byte[] byArray, DatagramPacket datagramPacket) throws IOException {
        this.field_72633_m.send(new DatagramPacket(byArray, byArray.length, datagramPacket.getSocketAddress()));
    }

    private boolean func_72621_a(DatagramPacket datagramPacket) throws IOException {
        byte[] byArray = datagramPacket.getData();
        int \u26032 = datagramPacket.getLength();
        SocketAddress \u26033 = datagramPacket.getSocketAddress();
        this.func_72607_a("Packet len " + \u26032 + " [" + \u26033 + "]");
        if (3 > \u26032 || -2 != byArray[0] || -3 != byArray[1]) {
            this.func_72607_a("Invalid packet [" + \u26033 + "]");
            return false;
        }
        this.func_72607_a("Packet '" + RConUtils.func_72663_a(byArray[2]) + "' [" + \u26033 + "]");
        switch (byArray[2]) {
            case 9: {
                this.func_72622_d(datagramPacket);
                this.func_72607_a("Challenge [" + \u26033 + "]");
                return true;
            }
            case 0: {
                if (!this.func_72627_c(datagramPacket).booleanValue()) {
                    this.func_72607_a("Invalid challenge [" + \u26033 + "]");
                    return false;
                }
                if (15 == \u26032) {
                    this.func_72620_a(this.func_72624_b(datagramPacket), datagramPacket);
                    this.func_72607_a("Rules [" + \u26033 + "]");
                    break;
                }
                RConOutputStream rConOutputStream = new RConOutputStream(1460);
                rConOutputStream.func_72667_a(0);
                rConOutputStream.func_72670_a(this.func_72625_a(datagramPacket.getSocketAddress()));
                rConOutputStream.func_72671_a(this.field_72635_k);
                rConOutputStream.func_72671_a("SMP");
                rConOutputStream.func_72671_a(this.field_72632_l);
                rConOutputStream.func_72671_a(Integer.toString(this.func_72603_d()));
                rConOutputStream.func_72671_a(Integer.toString(this.field_72634_j));
                rConOutputStream.func_72668_a((short)this.field_72637_i);
                rConOutputStream.func_72671_a(this.field_72643_q);
                this.func_72620_a(rConOutputStream.func_72672_a(), datagramPacket);
                this.func_72607_a("Status [" + \u26033 + "]");
            }
        }
        return true;
    }

    private byte[] func_72624_b(DatagramPacket datagramPacket) throws IOException {
        long l = Util.func_211177_b();
        if (l < this.field_72638_v + 5000L) {
            byte[] byArray = this.field_72639_u.func_72672_a();
            \u2603 = this.func_72625_a(datagramPacket.getSocketAddress());
            byArray[1] = \u2603[0];
            byArray[2] = \u2603[1];
            byArray[3] = \u2603[2];
            byArray[4] = \u2603[3];
            return byArray;
        }
        this.field_72638_v = l;
        this.field_72639_u.func_72669_b();
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72670_a(this.func_72625_a(datagramPacket.getSocketAddress()));
        this.field_72639_u.func_72671_a("splitnum");
        this.field_72639_u.func_72667_a(128);
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72671_a("hostname");
        this.field_72639_u.func_72671_a(this.field_72635_k);
        this.field_72639_u.func_72671_a("gametype");
        this.field_72639_u.func_72671_a("SMP");
        this.field_72639_u.func_72671_a("game_id");
        this.field_72639_u.func_72671_a("MINECRAFT");
        this.field_72639_u.func_72671_a("version");
        this.field_72639_u.func_72671_a(this.field_72617_b.func_71249_w());
        this.field_72639_u.func_72671_a("plugins");
        this.field_72639_u.func_72671_a(this.field_72617_b.func_71258_A());
        this.field_72639_u.func_72671_a("map");
        this.field_72639_u.func_72671_a(this.field_72632_l);
        this.field_72639_u.func_72671_a("numplayers");
        this.field_72639_u.func_72671_a("" + this.func_72603_d());
        this.field_72639_u.func_72671_a("maxplayers");
        this.field_72639_u.func_72671_a("" + this.field_72634_j);
        this.field_72639_u.func_72671_a("hostport");
        this.field_72639_u.func_72671_a("" + this.field_72637_i);
        this.field_72639_u.func_72671_a("hostip");
        this.field_72639_u.func_72671_a(this.field_72643_q);
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72667_a(1);
        this.field_72639_u.func_72671_a("player_");
        this.field_72639_u.func_72667_a(0);
        for (String string : \u2603 = this.field_72617_b.func_71213_z()) {
            this.field_72639_u.func_72671_a(string);
        }
        this.field_72639_u.func_72667_a(0);
        return this.field_72639_u.func_72672_a();
    }

    private byte[] func_72625_a(SocketAddress socketAddress) {
        return this.field_72641_s.get(socketAddress).func_72591_c();
    }

    private Boolean func_72627_c(DatagramPacket datagramPacket) {
        SocketAddress socketAddress = datagramPacket.getSocketAddress();
        if (!this.field_72641_s.containsKey(socketAddress)) {
            return false;
        }
        byte[] \u26032 = datagramPacket.getData();
        if (this.field_72641_s.get(socketAddress).func_72592_a() != RConUtils.func_72664_c(\u26032, 7, datagramPacket.getLength())) {
            return false;
        }
        return true;
    }

    private void func_72622_d(DatagramPacket datagramPacket) throws IOException {
        Auth auth = new Auth(datagramPacket);
        this.field_72641_s.put(datagramPacket.getSocketAddress(), auth);
        this.func_72620_a(auth.func_72594_b(), datagramPacket);
    }

    private void func_72628_f() {
        if (!this.field_72619_a) {
            return;
        }
        long l = Util.func_211177_b();
        if (l < this.field_72629_g + 30000L) {
            return;
        }
        this.field_72629_g = l;
        Iterator<Map.Entry<SocketAddress, Auth>> \u26032 = this.field_72641_s.entrySet().iterator();
        while (\u26032.hasNext()) {
            Map.Entry<SocketAddress, Auth> entry = \u26032.next();
            if (!entry.getValue().func_72593_a(l).booleanValue()) continue;
            \u26032.remove();
        }
    }

    @Override
    public void run() {
        this.func_72609_b("Query running on " + this.field_72642_r + ":" + this.field_72636_h);
        this.field_72629_g = Util.func_211177_b();
        this.field_72631_o = new DatagramPacket(this.field_72630_n, this.field_72630_n.length);
        try {
            while (this.field_72619_a) {
                try {
                    this.field_72633_m.receive(this.field_72631_o);
                    this.func_72628_f();
                    this.func_72621_a(this.field_72631_o);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.func_72628_f();
                }
                catch (PortUnreachableException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    this.func_72623_a(iOException);
                }
            }
        }
        finally {
            this.func_72611_e();
        }
    }

    @Override
    public void func_72602_a() {
        if (this.field_72619_a) {
            return;
        }
        if (0 >= this.field_72636_h || 65535 < this.field_72636_h) {
            this.func_72606_c("Invalid query port " + this.field_72636_h + " found in '" + this.field_72617_b.func_71329_c() + "' (queries disabled)");
            return;
        }
        if (this.func_72626_g()) {
            super.func_72602_a();
        }
    }

    private void func_72623_a(Exception exception) {
        if (!this.field_72619_a) {
            return;
        }
        this.func_72606_c("Unexpected exception, buggy JRE? (" + exception + ")");
        if (!this.func_72626_g()) {
            this.func_72610_d("Failed to recover from buggy JRE, shutting down!");
            this.field_72619_a = false;
        }
    }

    private boolean func_72626_g() {
        try {
            this.field_72633_m = new DatagramSocket(this.field_72636_h, InetAddress.getByName(this.field_72642_r));
            this.func_72601_a(this.field_72633_m);
            this.field_72633_m.setSoTimeout(500);
            return true;
        }
        catch (SocketException socketException) {
            this.func_72606_c("Unable to initialise query system on " + this.field_72642_r + ":" + this.field_72636_h + " (Socket): " + socketException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            this.func_72606_c("Unable to initialise query system on " + this.field_72642_r + ":" + this.field_72636_h + " (Unknown Host): " + unknownHostException.getMessage());
        }
        catch (Exception exception) {
            this.func_72606_c("Unable to initialise query system on " + this.field_72642_r + ":" + this.field_72636_h + " (E): " + exception.getMessage());
        }
        return false;
    }

    class Auth {
        private final long field_72598_b = new Date().getTime();
        private final int field_72599_c;
        private final byte[] field_72596_d;
        private final byte[] field_72597_e;
        private final String field_72595_f;

        public Auth(DatagramPacket datagramPacket) {
            byte[] byArray = datagramPacket.getData();
            this.field_72596_d = new byte[4];
            this.field_72596_d[0] = byArray[3];
            this.field_72596_d[1] = byArray[4];
            this.field_72596_d[2] = byArray[5];
            this.field_72596_d[3] = byArray[6];
            this.field_72595_f = new String(this.field_72596_d, StandardCharsets.UTF_8);
            this.field_72599_c = new Random().nextInt(0x1000000);
            this.field_72597_e = String.format("\t%s%d\u0000", this.field_72595_f, this.field_72599_c).getBytes(StandardCharsets.UTF_8);
        }

        public Boolean func_72593_a(long l) {
            return this.field_72598_b < l;
        }

        public int func_72592_a() {
            return this.field_72599_c;
        }

        public byte[] func_72594_b() {
            return this.field_72597_e;
        }

        public byte[] func_72591_c() {
            return this.field_72596_d;
        }
    }
}

