/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class SwimNodeProcessor
extends NodeProcessor {
    private final boolean field_205202_j;

    public SwimNodeProcessor(boolean bl) {
        this.field_205202_j = bl;
    }

    @Override
    public PathPoint func_186318_b() {
        return super.func_176159_a(MathHelper.func_76128_c(this.field_186326_b.func_174813_aQ().field_72340_a), MathHelper.func_76128_c(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5), MathHelper.func_76128_c(this.field_186326_b.func_174813_aQ().field_72339_c));
    }

    @Override
    public PathPoint func_186325_a(double d, double d2, double d3) {
        return super.func_176159_a(MathHelper.func_76128_c(d - (double)(this.field_186326_b.field_70130_N / 2.0f)), MathHelper.func_76128_c(d2 + 0.5), MathHelper.func_76128_c(d3 - (double)(this.field_186326_b.field_70130_N / 2.0f)));
    }

    @Override
    public int func_186320_a(PathPoint[] pathPointArray, PathPoint pathPoint, PathPoint pathPoint2, float f) {
        int n = 0;
        for (EnumFacing enumFacing : EnumFacing.values()) {
            PathPoint pathPoint3 = this.func_186328_b(pathPoint.field_75839_a + enumFacing.func_82601_c(), pathPoint.field_75837_b + enumFacing.func_96559_d(), pathPoint.field_75838_c + enumFacing.func_82599_e());
            if (pathPoint3 == null || pathPoint3.field_75842_i || !(pathPoint3.func_75829_a(pathPoint2) < f)) continue;
            pathPointArray[n++] = pathPoint3;
        }
        return n;
    }

    @Override
    public PathNodeType func_186319_a(IBlockReader iBlockReader, int n, int n2, int n3, EntityLiving entityLiving, int n4, int n5, int n6, boolean bl, boolean bl2) {
        return this.func_186330_a(iBlockReader, n, n2, n3);
    }

    @Override
    public PathNodeType func_186330_a(IBlockReader iBlockReader, int n, int n2, int n3) {
        BlockPos blockPos = new BlockPos(n, n2, n3);
        IFluidState \u26032 = iBlockReader.func_204610_c(blockPos);
        IBlockState \u26033 = iBlockReader.func_180495_p(blockPos);
        if (\u26032.func_206888_e() && \u26033.func_196957_g(iBlockReader, blockPos.func_177977_b(), PathType.WATER) && \u26033.func_196958_f()) {
            return PathNodeType.BREACH;
        }
        if (!\u26032.func_206884_a(FluidTags.field_206959_a) || !\u26033.func_196957_g(iBlockReader, blockPos, PathType.WATER)) {
            return PathNodeType.BLOCKED;
        }
        return PathNodeType.WATER;
    }

    @Nullable
    private PathPoint func_186328_b(int n, int n2, int n3) {
        PathNodeType pathNodeType = this.func_186327_c(n, n2, n3);
        if (this.field_205202_j && pathNodeType == PathNodeType.BREACH || pathNodeType == PathNodeType.WATER) {
            return this.func_176159_a(n, n2, n3);
        }
        return null;
    }

    @Override
    @Nullable
    protected PathPoint func_176159_a(int n, int n2, int n3) {
        PathPoint pathPoint = null;
        PathNodeType \u26032 = this.func_186330_a(this.field_186326_b.field_70170_p, n, n2, n3);
        float \u26033 = this.field_186326_b.func_184643_a(\u26032);
        if (\u26033 >= 0.0f) {
            pathPoint = super.func_176159_a(n, n2, n3);
            pathPoint.field_186287_m = \u26032;
            pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, \u26033);
            if (this.field_176169_a.func_204610_c(new BlockPos(n, n2, n3)).func_206888_e()) {
                pathPoint.field_186286_l += 8.0f;
            }
        }
        if (\u26032 == PathNodeType.OPEN) {
            return pathPoint;
        }
        return pathPoint;
    }

    private PathNodeType func_186327_c(int n, int n2, int n3) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = n; i < n + this.field_176168_c; ++i) {
            for (\u2603 = n2; \u2603 < n2 + this.field_176165_d; ++\u2603) {
                for (\u2603 = n3; \u2603 < n3 + this.field_176166_e; ++\u2603) {
                    IFluidState iFluidState = this.field_176169_a.func_204610_c(mutableBlockPos.func_181079_c(i, \u2603, \u2603));
                    IBlockState \u26032 = this.field_176169_a.func_180495_p(mutableBlockPos.func_181079_c(i, \u2603, \u2603));
                    if (iFluidState.func_206888_e() && \u26032.func_196957_g(this.field_176169_a, mutableBlockPos.func_177977_b(), PathType.WATER) && \u26032.func_196958_f()) {
                        return PathNodeType.BREACH;
                    }
                    if (iFluidState.func_206884_a(FluidTags.field_206959_a)) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        IBlockState iBlockState = this.field_176169_a.func_180495_p(mutableBlockPos);
        if (iBlockState.func_196957_g(this.field_176169_a, mutableBlockPos, PathType.WATER)) {
            return PathNodeType.WATER;
        }
        return PathNodeType.BLOCKED;
    }
}

