/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SPacketStatistics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatisticsManagerServer
extends StatisticsManager {
    private static final Logger field_150889_b = LogManager.getLogger();
    private final MinecraftServer field_150890_c;
    private final File field_150887_d;
    private final Set<Stat<?>> field_150888_e = Sets.newHashSet();
    private int field_150885_f = -300;

    public StatisticsManagerServer(MinecraftServer minecraftServer, File file) {
        this.field_150890_c = minecraftServer;
        this.field_150887_d = file;
        if (file.isFile()) {
            try {
                this.func_199062_a(minecraftServer.func_195563_aC(), FileUtils.readFileToString((File)file));
            }
            catch (IOException iOException) {
                field_150889_b.error("Couldn't read statistics file {}", (Object)file, (Object)iOException);
            }
            catch (JsonParseException jsonParseException) {
                field_150889_b.error("Couldn't parse statistics file {}", (Object)file, (Object)jsonParseException);
            }
        }
    }

    public void func_150883_b() {
        try {
            FileUtils.writeStringToFile((File)this.field_150887_d, (String)this.func_199061_b());
        }
        catch (IOException iOException) {
            field_150889_b.error("Couldn't save stats", (Throwable)iOException);
        }
    }

    @Override
    public void func_150873_a(EntityPlayer entityPlayer, Stat<?> stat, int n) {
        super.func_150873_a(entityPlayer, stat, n);
        this.field_150888_e.add(stat);
    }

    private Set<Stat<?>> func_150878_c() {
        HashSet hashSet = Sets.newHashSet(this.field_150888_e);
        this.field_150888_e.clear();
        return hashSet;
    }

    public void func_199062_a(DataFixer dataFixer, String string) {
        try (JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));){
            jsonReader.setLenient(false);
            JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
            if (!jsonElement.isJsonNull()) {
                NBTTagCompound nBTTagCompound = StatisticsManagerServer.func_199065_a(jsonElement.getAsJsonObject());
                if (!nBTTagCompound.func_150297_b("DataVersion", 99)) {
                    nBTTagCompound.func_74768_a("DataVersion", 1343);
                }
                if ((nBTTagCompound = NBTUtil.func_210822_a(dataFixer, (DSL.TypeReference)DataFixTypes.STATS, nBTTagCompound, nBTTagCompound.func_74762_e("DataVersion"))).func_150297_b("stats", 10)) {
                    \u2603 = nBTTagCompound.func_74775_l("stats");
                    for (String string2 : \u2603.func_150296_c()) {
                        if (!\u2603.func_150297_b(string2, 10)) continue;
                        StatType<?> statType = IRegistry.field_212634_w.func_212608_b(new ResourceLocation(string2));
                        if (statType == null) {
                            field_150889_b.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.field_150887_d, (Object)string2);
                            continue;
                        }
                        NBTTagCompound \u26032 = \u2603.func_74775_l(string2);
                        for (String string32 : \u26032.func_150296_c()) {
                            String string32;
                            if (\u26032.func_150297_b(string32, 99)) {
                                Stat<?> stat = this.func_199063_a(statType, string32);
                                if (stat == null) {
                                    field_150889_b.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.field_150887_d, (Object)string32);
                                    continue;
                                }
                                this.field_150875_a.put(stat, \u26032.func_74762_e(string32));
                                continue;
                            }
                            field_150889_b.warn("Invalid statistic value in {}: Don't know what {} is for key {}", (Object)this.field_150887_d, (Object)\u26032.func_74781_a(string32), (Object)string32);
                        }
                    }
                }
            } else {
                field_150889_b.error("Unable to parse Stat data from {}", (Object)this.field_150887_d);
            }
        }
        catch (JsonParseException | IOException throwable) {
            field_150889_b.error("Unable to parse Stat data from {}", (Object)this.field_150887_d, (Object)throwable);
        }
    }

    @Nullable
    private <T> Stat<T> func_199063_a(StatType<T> statType, String string) {
        ResourceLocation resourceLocation = ResourceLocation.func_208304_a(string);
        if (resourceLocation == null) {
            return null;
        }
        T \u26032 = statType.func_199080_a().func_212608_b(resourceLocation);
        return \u26032 == null ? null : statType.func_199076_b(\u26032);
    }

    private static NBTTagCompound func_199065_a(JsonObject jsonObject) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonObject()) {
                nBTTagCompound.func_74782_a((String)entry.getKey(), StatisticsManagerServer.func_199065_a(jsonElement.getAsJsonObject()));
                continue;
            }
            if (!jsonElement.isJsonPrimitive() || !(\u2603 = jsonElement.getAsJsonPrimitive()).isNumber()) continue;
            nBTTagCompound.func_74768_a((String)entry.getKey(), \u2603.getAsInt());
        }
        return nBTTagCompound;
    }

    protected String func_199061_b() {
        HashMap hashMap = Maps.newHashMap();
        for (Object object2 : this.field_150875_a.object2IntEntrySet()) {
            Stat stat = (Stat)object2.getKey();
            hashMap.computeIfAbsent(stat.func_197921_a(), statType -> new JsonObject()).addProperty(StatisticsManagerServer.func_199066_b(stat).toString(), (Number)object2.getIntValue());
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : hashMap.entrySet()) {
            jsonObject.add(IRegistry.field_212634_w.func_177774_c((StatType<?>)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("stats", (JsonElement)jsonObject);
        jsonObject2.addProperty("DataVersion", (Number)1631);
        return jsonObject2.toString();
    }

    private static <T> ResourceLocation func_199066_b(Stat<T> stat) {
        return stat.func_197921_a().func_199080_a().func_177774_c(stat.func_197920_b());
    }

    public void func_150877_d() {
        this.field_150888_e.addAll((Collection<Stat<?>>)this.field_150875_a.keySet());
    }

    public void func_150876_a(EntityPlayerMP entityPlayerMP2) {
        EntityPlayerMP entityPlayerMP2;
        int n = this.field_150890_c.func_71259_af();
        Object2IntOpenHashMap \u26032 = new Object2IntOpenHashMap();
        if (n - this.field_150885_f > 300) {
            this.field_150885_f = n;
            for (Stat<?> stat : this.func_150878_c()) {
                \u26032.put(stat, this.func_77444_a(stat));
            }
        }
        entityPlayerMP2.field_71135_a.func_147359_a(new SPacketStatistics((Object2IntMap<Stat<?>>)\u26032));
    }
}

