/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.StringUtils;

public class ResourceLocation
implements Comparable<ResourceLocation> {
    private static final SimpleCommandExceptionType field_200118_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.id.invalid", new Object[0]));
    protected final String field_110626_a;
    protected final String field_110625_b;

    protected ResourceLocation(String[] stringArray) {
        this.field_110626_a = StringUtils.isEmpty((CharSequence)stringArray[0]) ? "minecraft" : stringArray[0];
        this.field_110625_b = stringArray[1];
        if (!this.field_110626_a.chars().allMatch(n -> n == 95 || n == 45 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 46)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + this.field_110626_a + ':' + this.field_110625_b);
        }
        if (!this.field_110625_b.chars().allMatch(n -> n == 95 || n == 45 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 47 || n == 46)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + this.field_110626_a + ':' + this.field_110625_b);
        }
    }

    public ResourceLocation(String string) {
        this(ResourceLocation.func_195823_b(string, ':'));
    }

    public ResourceLocation(String string, String string2) {
        this(new String[]{string, string2});
    }

    public static ResourceLocation func_195828_a(String string, char c) {
        return new ResourceLocation(ResourceLocation.func_195823_b(string, c));
    }

    @Nullable
    public static ResourceLocation func_208304_a(String string) {
        try {
            return new ResourceLocation(string);
        }
        catch (ResourceLocationException resourceLocationException) {
            return null;
        }
    }

    protected static String[] func_195823_b(String string, char c) {
        String[] stringArray = new String[]{"minecraft", string};
        int \u26032 = string.indexOf(c);
        if (\u26032 >= 0) {
            stringArray[1] = string.substring(\u26032 + 1, string.length());
            if (\u26032 >= 1) {
                stringArray[0] = string.substring(0, \u26032);
            }
        }
        return stringArray;
    }

    public String func_110623_a() {
        return this.field_110625_b;
    }

    public String func_110624_b() {
        return this.field_110626_a;
    }

    public String toString() {
        return this.field_110626_a + ':' + this.field_110625_b;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ResourceLocation) {
            ResourceLocation resourceLocation = (ResourceLocation)object;
            return this.field_110626_a.equals(resourceLocation.field_110626_a) && this.field_110625_b.equals(resourceLocation.field_110625_b);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.field_110626_a.hashCode() + this.field_110625_b.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation resourceLocation) {
        int n = this.field_110625_b.compareTo(resourceLocation.field_110625_b);
        if (n == 0) {
            n = this.field_110626_a.compareTo(resourceLocation.field_110626_a);
        }
        return n;
    }

    public static ResourceLocation func_195826_a(StringReader stringReader) throws CommandSyntaxException {
        int n = stringReader.getCursor();
        while (stringReader.canRead() && ResourceLocation.func_195824_a(stringReader.peek())) {
            stringReader.skip();
        }
        String \u26032 = stringReader.getString().substring(n, stringReader.getCursor());
        try {
            return new ResourceLocation(\u26032);
        }
        catch (ResourceLocationException \u26033) {
            stringReader.setCursor(n);
            throw field_200118_c.createWithContext((ImmutableStringReader)stringReader);
        }
    }

    public static boolean func_195824_a(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((ResourceLocation)object);
    }

    public static class Serializer
    implements JsonDeserializer<ResourceLocation>,
    JsonSerializer<ResourceLocation> {
        public ResourceLocation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new ResourceLocation(JsonUtils.func_151206_a(jsonElement, "location"));
        }

        public JsonElement serialize(ResourceLocation resourceLocation, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(resourceLocation.toString());
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ResourceLocation)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

