/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathType;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;

public class Village {
    private World field_75586_a;
    private final List<VillageDoorInfo> field_75584_b = Lists.newArrayList();
    private BlockPos field_75585_c = BlockPos.field_177992_a;
    private BlockPos field_75582_d = BlockPos.field_177992_a;
    private int field_75583_e;
    private int field_75580_f;
    private int field_75581_g;
    private int field_75588_h;
    private int field_82694_i;
    private final Map<String, Integer> field_82693_j = Maps.newHashMap();
    private final List<VillageAggressor> field_75589_i = Lists.newArrayList();
    private int field_75587_j;

    public Village() {
    }

    public Village(World world) {
        this.field_75586_a = world;
    }

    public void func_82691_a(World world) {
        this.field_75586_a = world;
    }

    public void func_75560_a(int n) {
        this.field_75581_g = n;
        this.func_75557_k();
        this.func_75565_j();
        if (n % 20 == 0) {
            this.func_75572_i();
        }
        if (n % 30 == 0) {
            this.func_75579_h();
        }
        if (this.field_75587_j < (\u2603 = this.field_75588_h / 10) && this.field_75584_b.size() > 20 && this.field_75586_a.field_73012_v.nextInt(7000) == 0 && (\u2603 = this.func_208059_f(this.field_75582_d)) != null) {
            ++this.field_75587_j;
        }
    }

    @Nullable
    private Entity func_208059_f(BlockPos blockPos) {
        for (int i = 0; i < 10; ++i) {
            BlockPos blockPos2 = blockPos.func_177982_a(this.field_75586_a.field_73012_v.nextInt(16) - 8, this.field_75586_a.field_73012_v.nextInt(6) - 3, this.field_75586_a.field_73012_v.nextInt(16) - 8);
            if (!this.func_179866_a(blockPos2) || (\u2603 = EntityType.field_200757_aw.func_210761_b(this.field_75586_a, null, null, null, blockPos2, false, false)) == null) continue;
            if (\u2603.func_205020_a(this.field_75586_a, false) && \u2603.func_205019_a(this.field_75586_a)) {
                this.field_75586_a.func_72838_d(\u2603);
                return \u2603;
            }
            \u2603.func_70106_y();
        }
        return null;
    }

    private void func_75579_h() {
        List<EntityIronGolem> list = this.field_75586_a.func_72872_a(EntityIronGolem.class, new AxisAlignedBB(this.field_75582_d.func_177958_n() - this.field_75583_e, this.field_75582_d.func_177956_o() - 4, this.field_75582_d.func_177952_p() - this.field_75583_e, this.field_75582_d.func_177958_n() + this.field_75583_e, this.field_75582_d.func_177956_o() + 4, this.field_75582_d.func_177952_p() + this.field_75583_e));
        this.field_75587_j = list.size();
    }

    private void func_75572_i() {
        List<EntityVillager> list = this.field_75586_a.func_72872_a(EntityVillager.class, new AxisAlignedBB(this.field_75582_d.func_177958_n() - this.field_75583_e, this.field_75582_d.func_177956_o() - 4, this.field_75582_d.func_177952_p() - this.field_75583_e, this.field_75582_d.func_177958_n() + this.field_75583_e, this.field_75582_d.func_177956_o() + 4, this.field_75582_d.func_177952_p() + this.field_75583_e));
        this.field_75588_h = list.size();
        if (this.field_75588_h == 0) {
            this.field_82693_j.clear();
        }
    }

    public BlockPos func_180608_a() {
        return this.field_75582_d;
    }

    public int func_75568_b() {
        return this.field_75583_e;
    }

    public int func_75567_c() {
        return this.field_75584_b.size();
    }

    public int func_75561_d() {
        return this.field_75581_g - this.field_75580_f;
    }

    public int func_75562_e() {
        return this.field_75588_h;
    }

    public boolean func_179866_a(BlockPos blockPos) {
        return this.field_75582_d.func_177951_i(blockPos) < (double)(this.field_75583_e * this.field_75583_e);
    }

    public List<VillageDoorInfo> func_75558_f() {
        return this.field_75584_b;
    }

    public VillageDoorInfo func_179865_b(BlockPos blockPos) {
        VillageDoorInfo \u26033 = null;
        int \u26032 = Integer.MAX_VALUE;
        for (VillageDoorInfo villageDoorInfo : this.field_75584_b) {
            int n = villageDoorInfo.func_179848_a(blockPos);
            if (n >= \u26032) continue;
            \u26033 = villageDoorInfo;
            \u26032 = n;
        }
        return \u26033;
    }

    public VillageDoorInfo func_179863_c(BlockPos blockPos) {
        VillageDoorInfo \u26033 = null;
        int \u26032 = Integer.MAX_VALUE;
        for (VillageDoorInfo villageDoorInfo : this.field_75584_b) {
            int n = villageDoorInfo.func_179848_a(blockPos);
            n = n > 256 ? (n *= 1000) : villageDoorInfo.func_75468_f();
            if (n >= \u26032 || !this.field_75586_a.func_180495_p((\u2603 = villageDoorInfo.func_179852_d()).func_177967_a(\u2603 = villageDoorInfo.func_188567_j(), 1)).func_196957_g(this.field_75586_a, \u2603.func_177967_a(\u2603, 1), PathType.LAND) || !this.field_75586_a.func_180495_p(\u2603.func_177967_a(\u2603, -1)).func_196957_g(this.field_75586_a, \u2603.func_177967_a(\u2603, -1), PathType.LAND) || !this.field_75586_a.func_180495_p(\u2603.func_177984_a().func_177967_a(\u2603, 1)).func_196957_g(this.field_75586_a, \u2603.func_177984_a().func_177967_a(\u2603, 1), PathType.LAND) || !this.field_75586_a.func_180495_p(\u2603.func_177984_a().func_177967_a(\u2603, -1)).func_196957_g(this.field_75586_a, \u2603.func_177984_a().func_177967_a(\u2603, -1), PathType.LAND)) continue;
            \u26033 = villageDoorInfo;
            \u26032 = n;
        }
        return \u26033;
    }

    @Nullable
    public VillageDoorInfo func_179864_e(BlockPos blockPos) {
        if (this.field_75582_d.func_177951_i(blockPos) > (double)(this.field_75583_e * this.field_75583_e)) {
            return null;
        }
        for (VillageDoorInfo villageDoorInfo : this.field_75584_b) {
            if (villageDoorInfo.func_179852_d().func_177958_n() != blockPos.func_177958_n() || villageDoorInfo.func_179852_d().func_177952_p() != blockPos.func_177952_p() || Math.abs(villageDoorInfo.func_179852_d().func_177956_o() - blockPos.func_177956_o()) > 1) continue;
            return villageDoorInfo;
        }
        return null;
    }

    public void func_75576_a(VillageDoorInfo villageDoorInfo) {
        this.field_75584_b.add(villageDoorInfo);
        this.field_75585_c = this.field_75585_c.func_177971_a(villageDoorInfo.func_179852_d());
        this.func_75573_l();
        this.field_75580_f = villageDoorInfo.func_75473_b();
    }

    public boolean func_75566_g() {
        return this.field_75584_b.isEmpty();
    }

    public void func_75575_a(EntityLivingBase entityLivingBase2) {
        EntityLivingBase entityLivingBase2;
        for (VillageAggressor villageAggressor : this.field_75589_i) {
            if (villageAggressor.field_75592_a != entityLivingBase2) continue;
            villageAggressor.field_75590_b = this.field_75581_g;
            return;
        }
        this.field_75589_i.add(new VillageAggressor(entityLivingBase2, this.field_75581_g));
    }

    @Nullable
    public EntityLivingBase func_75571_b(EntityLivingBase entityLivingBase) {
        double \u26034 = Double.MAX_VALUE;
        VillageAggressor \u26032 = null;
        for (int i = 0; i < this.field_75589_i.size(); ++i) {
            VillageAggressor villageAggressor = this.field_75589_i.get(i);
            double \u26033 = villageAggressor.field_75592_a.func_70068_e(entityLivingBase);
            if (\u26033 > \u26034) continue;
            \u26032 = villageAggressor;
            \u26034 = \u26033;
        }
        return \u26032 == null ? null : \u26032.field_75592_a;
    }

    public EntityPlayer func_82685_c(EntityLivingBase entityLivingBase) {
        double d = Double.MAX_VALUE;
        EntityPlayer \u26032 = null;
        for (String string : this.field_82693_j.keySet()) {
            if (!this.func_82687_d(string) || (\u2603 = this.field_75586_a.func_72924_a(string)) == null || (\u2603 = \u2603.func_70068_e(entityLivingBase)) > d) continue;
            \u26032 = \u2603;
            d = \u2603;
        }
        return \u26032;
    }

    private void func_75565_j() {
        Iterator<VillageAggressor> iterator = this.field_75589_i.iterator();
        while (iterator.hasNext()) {
            VillageAggressor villageAggressor = iterator.next();
            if (villageAggressor.field_75592_a.func_70089_S() && Math.abs(this.field_75581_g - villageAggressor.field_75590_b) <= 300) continue;
            iterator.remove();
        }
    }

    private void func_75557_k() {
        boolean \u26033 = false;
        \u2603 = this.field_75586_a.field_73012_v.nextInt(50) == 0;
        Iterator<VillageDoorInfo> \u26032 = this.field_75584_b.iterator();
        while (\u26032.hasNext()) {
            VillageDoorInfo villageDoorInfo = \u26032.next();
            if (\u2603) {
                villageDoorInfo.func_75466_d();
            }
            if (this.func_179860_f(villageDoorInfo.func_179852_d()) && Math.abs(this.field_75581_g - villageDoorInfo.func_75473_b()) <= 1200) continue;
            this.field_75585_c = this.field_75585_c.func_177973_b(villageDoorInfo.func_179852_d());
            \u26033 = true;
            villageDoorInfo.func_179853_a(true);
            \u26032.remove();
        }
        if (\u26033) {
            this.func_75573_l();
        }
    }

    private boolean func_179860_f(BlockPos blockPos) {
        IBlockState iBlockState = this.field_75586_a.func_180495_p(blockPos);
        Block \u26032 = iBlockState.func_177230_c();
        if (\u26032 instanceof BlockDoor) {
            return iBlockState.func_185904_a() == Material.field_151575_d;
        }
        return false;
    }

    private void func_75573_l() {
        int n;
        int n2 = this.field_75584_b.size();
        if (n2 == 0) {
            this.field_75582_d = BlockPos.field_177992_a;
            this.field_75583_e = 0;
            return;
        }
        this.field_75582_d = new BlockPos(this.field_75585_c.func_177958_n() / n2, this.field_75585_c.func_177956_o() / n2, this.field_75585_c.func_177952_p() / n2);
        n = 0;
        for (VillageDoorInfo villageDoorInfo : this.field_75584_b) {
            n = Math.max(villageDoorInfo.func_179848_a(this.field_75582_d), n);
        }
        this.field_75583_e = Math.max(32, (int)Math.sqrt(n) + 1);
    }

    public int func_82684_a(String string) {
        Integer n = this.field_82693_j.get(string);
        return n == null ? 0 : n;
    }

    public int func_82688_a(String string, int n) {
        \u2603 = this.func_82684_a(string);
        \u2603 = MathHelper.func_76125_a(\u2603 + n, -30, 10);
        this.field_82693_j.put(string, \u2603);
        return \u2603;
    }

    public boolean func_82687_d(String string) {
        return this.func_82684_a(string) <= -15;
    }

    public void func_82690_a(NBTTagCompound nBTTagCompound) {
        Object \u26032;
        this.field_75588_h = nBTTagCompound.func_74762_e("PopSize");
        this.field_75583_e = nBTTagCompound.func_74762_e("Radius");
        this.field_75587_j = nBTTagCompound.func_74762_e("Golems");
        this.field_75580_f = nBTTagCompound.func_74762_e("Stable");
        this.field_75581_g = nBTTagCompound.func_74762_e("Tick");
        this.field_82694_i = nBTTagCompound.func_74762_e("MTick");
        this.field_75582_d = new BlockPos(nBTTagCompound.func_74762_e("CX"), nBTTagCompound.func_74762_e("CY"), nBTTagCompound.func_74762_e("CZ"));
        this.field_75585_c = new BlockPos(nBTTagCompound.func_74762_e("ACX"), nBTTagCompound.func_74762_e("ACY"), nBTTagCompound.func_74762_e("ACZ"));
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Doors", 10);
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            \u26032 = new VillageDoorInfo(new BlockPos(nBTTagCompound2.func_74762_e("X"), nBTTagCompound2.func_74762_e("Y"), nBTTagCompound2.func_74762_e("Z")), nBTTagCompound2.func_74762_e("IDX"), nBTTagCompound2.func_74762_e("IDZ"), nBTTagCompound2.func_74762_e("TS"));
            this.field_75584_b.add((VillageDoorInfo)\u26032);
        }
        NBTTagList nBTTagList2 = nBTTagCompound.func_150295_c("Players", 10);
        for (int i = 0; i < nBTTagList2.size(); ++i) {
            \u26032 = nBTTagList2.func_150305_b(i);
            if (((NBTTagCompound)\u26032).func_74764_b("UUID") && this.field_75586_a != null && this.field_75586_a.func_73046_m() != null) {
                PlayerProfileCache playerProfileCache = this.field_75586_a.func_73046_m().func_152358_ax();
                GameProfile \u26033 = playerProfileCache.func_152652_a(UUID.fromString(((NBTTagCompound)\u26032).func_74779_i("UUID")));
                if (\u26033 == null) continue;
                this.field_82693_j.put(\u26033.getName(), ((NBTTagCompound)\u26032).func_74762_e("S"));
                continue;
            }
            this.field_82693_j.put(((NBTTagCompound)\u26032).func_74779_i("Name"), ((NBTTagCompound)\u26032).func_74762_e("S"));
        }
    }

    public void func_82689_b(NBTTagCompound nBTTagCompound2) {
        nBTTagCompound2.func_74768_a("PopSize", this.field_75588_h);
        nBTTagCompound2.func_74768_a("Radius", this.field_75583_e);
        nBTTagCompound2.func_74768_a("Golems", this.field_75587_j);
        nBTTagCompound2.func_74768_a("Stable", this.field_75580_f);
        nBTTagCompound2.func_74768_a("Tick", this.field_75581_g);
        nBTTagCompound2.func_74768_a("MTick", this.field_82694_i);
        nBTTagCompound2.func_74768_a("CX", this.field_75582_d.func_177958_n());
        nBTTagCompound2.func_74768_a("CY", this.field_75582_d.func_177956_o());
        nBTTagCompound2.func_74768_a("CZ", this.field_75582_d.func_177952_p());
        nBTTagCompound2.func_74768_a("ACX", this.field_75585_c.func_177958_n());
        nBTTagCompound2.func_74768_a("ACY", this.field_75585_c.func_177956_o());
        nBTTagCompound2.func_74768_a("ACZ", this.field_75585_c.func_177952_p());
        NBTTagList nBTTagList = new NBTTagList();
        for (VillageDoorInfo villageDoorInfo : this.field_75584_b) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("X", villageDoorInfo.func_179852_d().func_177958_n());
            nBTTagCompound.func_74768_a("Y", villageDoorInfo.func_179852_d().func_177956_o());
            nBTTagCompound.func_74768_a("Z", villageDoorInfo.func_179852_d().func_177952_p());
            nBTTagCompound.func_74768_a("IDX", villageDoorInfo.func_179847_f());
            nBTTagCompound.func_74768_a("IDZ", villageDoorInfo.func_179855_g());
            nBTTagCompound.func_74768_a("TS", villageDoorInfo.func_75473_b());
            nBTTagList.add(nBTTagCompound);
        }
        nBTTagCompound2.func_74782_a("Doors", nBTTagList);
        NBTTagList \u26032 = new NBTTagList();
        for (String string : this.field_82693_j.keySet()) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            PlayerProfileCache \u26033 = this.field_75586_a.func_73046_m().func_152358_ax();
            try {
                GameProfile gameProfile = \u26033.func_152655_a(string);
                if (gameProfile == null) continue;
                nBTTagCompound3.func_74778_a("UUID", gameProfile.getId().toString());
                nBTTagCompound3.func_74768_a("S", this.field_82693_j.get(string));
                \u26032.add(nBTTagCompound3);
            }
            catch (RuntimeException runtimeException) {}
        }
        nBTTagCompound2.func_74782_a("Players", \u26032);
    }

    public void func_82692_h() {
        this.field_82694_i = this.field_75581_g;
    }

    public boolean func_82686_i() {
        return this.field_82694_i == 0 || this.field_75581_g - this.field_82694_i >= 3600;
    }

    public void func_82683_b(int n) {
        for (String string : this.field_82693_j.keySet()) {
            this.func_82688_a(string, n);
        }
    }

    class VillageAggressor {
        public EntityLivingBase field_75592_a;
        public int field_75590_b;

        VillageAggressor(EntityLivingBase entityLivingBase, int n) {
            this.field_75592_a = entityLivingBase;
            this.field_75590_b = n;
        }
    }
}

