/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.TaskManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkCacheNeighborNotification;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.tasks.ProtoChunkScheduler;
import net.minecraft.world.storage.SessionLockException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkProviderServer
implements IChunkProvider {
    private static final Logger field_147417_b = LogManager.getLogger();
    private final LongSet field_73248_b = new LongOpenHashSet();
    private final IChunkGenerator<?> field_186029_c;
    private final IChunkLoader field_73247_e;
    private final Long2ObjectMap<Chunk> field_73244_f = Long2ObjectMaps.synchronize((Long2ObjectMap)new ChunkCacheNeighborNotification(8192));
    private Chunk field_212472_f;
    private final ProtoChunkScheduler field_201723_f;
    private final TaskManager<ChunkPos, ChunkStatus, ChunkPrimer> field_201724_g;
    private final WorldServer field_73251_h;
    private final IThreadListener field_212473_j;

    public ChunkProviderServer(WorldServer worldServer, IChunkLoader iChunkLoader, IChunkGenerator<?> iChunkGenerator, IThreadListener iThreadListener) {
        this.field_73251_h = worldServer;
        this.field_73247_e = iChunkLoader;
        this.field_186029_c = iChunkGenerator;
        this.field_212473_j = iThreadListener;
        this.field_201723_f = new ProtoChunkScheduler(2, worldServer, iChunkGenerator, iChunkLoader, iThreadListener);
        this.field_201724_g = new TaskManager<ChunkPos, ChunkStatus, ChunkPrimer>(this.field_201723_f);
    }

    public Collection<Chunk> func_189548_a() {
        return this.field_73244_f.values();
    }

    public void func_189549_a(Chunk chunk) {
        if (this.field_73251_h.field_73011_w.func_186056_c(chunk.field_76635_g, chunk.field_76647_h)) {
            this.field_73248_b.add(ChunkPos.func_77272_a(chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    public void func_73240_a() {
        for (Chunk chunk : this.field_73244_f.values()) {
            this.func_189549_a(chunk);
        }
    }

    public void func_212469_a(int n, int n2) {
        this.field_73248_b.remove(ChunkPos.func_77272_a(n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Chunk func_186025_d(int n, int n2, boolean bl, boolean bl22) {
        boolean bl22;
        Chunk \u26032;
        IChunkLoader iChunkLoader = this.field_73247_e;
        synchronized (iChunkLoader) {
            if (this.field_212472_f != null && this.field_212472_f.func_76632_l().field_77276_a == n && this.field_212472_f.func_76632_l().field_77275_b == n2) {
                return this.field_212472_f;
            }
            long l = ChunkPos.func_77272_a(n, n2);
            \u26032 = (Chunk)this.field_73244_f.get(l);
            if (\u26032 != null) {
                this.field_212472_f = \u26032;
                return \u26032;
            }
            if (bl) {
                try {
                    \u26032 = this.field_73247_e.func_199813_a(this.field_73251_h, n, n2, chunk -> {
                        chunk.func_177432_b(this.field_73251_h.func_82737_E());
                        this.field_73244_f.put(ChunkPos.func_77272_a(n, n2), chunk);
                    });
                }
                catch (Exception exception) {
                    field_147417_b.error("Couldn't load chunk", (Throwable)exception);
                }
            }
        }
        if (\u26032 != null) {
            this.field_212473_j.func_152344_a(\u26032::func_76631_c);
            return \u26032;
        }
        if (bl22) {
            try {
                this.field_201724_g.func_202928_b();
                this.field_201724_g.func_202926_a(new ChunkPos(n, n2));
                CompletableFuture<ChunkPrimer> completableFuture = this.field_201724_g.func_202927_c();
                return (Chunk)((CompletableFuture)completableFuture.thenApply(this::func_201719_a)).join();
            }
            catch (RuntimeException runtimeException) {
                throw this.func_201722_a(n, n2, runtimeException);
            }
        }
        return null;
    }

    @Override
    public IChunk func_201713_d(int n, int n2, boolean bl) {
        Chunk chunk = this.func_186025_d(n, n2, true, false);
        if (chunk != null) {
            return chunk;
        }
        return (IChunk)this.field_201723_f.func_212537_b(new ChunkPos(n, n2), bl);
    }

    public CompletableFuture<ChunkPrimer> func_201720_a(Iterable<ChunkPos> iterable, Consumer<Chunk> consumer) {
        this.field_201724_g.func_202928_b();
        for (ChunkPos chunkPos : iterable) {
            Chunk chunk = this.func_186025_d(chunkPos.field_77276_a, chunkPos.field_77275_b, true, false);
            if (chunk != null) {
                consumer.accept(chunk);
                continue;
            }
            ((CompletableFuture)this.field_201724_g.func_202926_a(chunkPos).thenApply(this::func_201719_a)).thenAccept(consumer);
        }
        return this.field_201724_g.func_202927_c();
    }

    private ReportedException func_201722_a(int n, int n2, Throwable throwable) {
        CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception generating new chunk");
        CrashReportCategory \u26032 = crashReport.func_85058_a("Chunk to be generated");
        \u26032.func_71507_a("Location", String.format("%d,%d", n, n2));
        \u26032.func_71507_a("Position hash", ChunkPos.func_77272_a(n, n2));
        \u26032.func_71507_a("Generator", this.field_186029_c);
        return new ReportedException(crashReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk func_201719_a(IChunk iChunk) {
        Chunk chunk;
        ChunkPos chunkPos = iChunk.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        long \u26034 = ChunkPos.func_77272_a(\u26032, \u26033);
        Long2ObjectMap<Chunk> long2ObjectMap = this.field_73244_f;
        synchronized (long2ObjectMap) {
            Chunk chunk2 = (Chunk)this.field_73244_f.get(\u26034);
            if (chunk2 != null) {
                return chunk2;
            }
            if (iChunk instanceof Chunk) {
                chunk = (Chunk)iChunk;
            } else if (iChunk instanceof ChunkPrimer) {
                chunk = new Chunk(this.field_73251_h, (ChunkPrimer)iChunk, \u26032, \u26033);
            } else {
                throw new IllegalStateException();
            }
            this.field_73244_f.put(\u26034, (Object)chunk);
            this.field_212472_f = chunk;
        }
        this.field_212473_j.func_152344_a(chunk::func_76631_c);
        return chunk;
    }

    private void func_73242_b(IChunk iChunk) {
        try {
            iChunk.func_177432_b(this.field_73251_h.func_82737_E());
            this.field_73247_e.func_75816_a(this.field_73251_h, iChunk);
        }
        catch (IOException iOException) {
            field_147417_b.error("Couldn't save chunk", (Throwable)iOException);
        }
        catch (SessionLockException sessionLockException) {
            field_147417_b.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)sessionLockException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_186027_a(boolean bl) {
        int n = 0;
        this.field_201723_f.func_208484_a(() -> true);
        IChunkLoader iChunkLoader = this.field_73247_e;
        synchronized (iChunkLoader) {
            for (Chunk chunk : this.field_73244_f.values()) {
                if (!chunk.func_76601_a(bl)) continue;
                this.func_73242_b(chunk);
                chunk.func_177427_f(false);
                if (++n != 24 || bl) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this.field_201724_g.func_202925_a();
        }
        catch (InterruptedException interruptedException) {
            field_147417_b.error("Couldn't stop taskManager", (Throwable)interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_104112_b() {
        IChunkLoader iChunkLoader = this.field_73247_e;
        synchronized (iChunkLoader) {
            this.field_73247_e.func_75818_b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean func_73156_b(BooleanSupplier booleanSupplier2) {
        if (!this.field_73251_h.field_73058_d) {
            BooleanSupplier booleanSupplier2;
            if (!this.field_73248_b.isEmpty()) {
                LongIterator longIterator = this.field_73248_b.iterator();
                int \u26032 = 0;
                while (longIterator.hasNext() && (booleanSupplier2.getAsBoolean() || \u26032 < 200 || this.field_73248_b.size() > 2000)) {
                    Long l = (Long)longIterator.next();
                    IChunkLoader iChunkLoader = this.field_73247_e;
                    synchronized (iChunkLoader) {
                        Chunk chunk = (Chunk)this.field_73244_f.get((Object)l);
                        if (chunk != null) {
                            chunk.func_76623_d();
                            this.func_73242_b(chunk);
                            this.field_73244_f.remove((Object)l);
                            this.field_212472_f = null;
                            ++\u26032;
                        }
                    }
                    longIterator.remove();
                }
            }
            this.field_201723_f.func_208484_a(booleanSupplier2);
        }
        return false;
    }

    public boolean func_73157_c() {
        return !this.field_73251_h.field_73058_d;
    }

    @Override
    public String func_73148_d() {
        return "ServerChunkCache: " + this.field_73244_f.size() + " Drop: " + this.field_73248_b.size();
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        return this.field_186029_c.func_177458_a(enumCreatureType, blockPos);
    }

    public int func_203082_a(World world, boolean bl, boolean bl2) {
        return this.field_186029_c.func_203222_a(world, bl, bl2);
    }

    @Nullable
    public BlockPos func_211268_a(World world, String string, BlockPos blockPos, int n, boolean bl) {
        return this.field_186029_c.func_211403_a(world, string, blockPos, n, bl);
    }

    @Override
    public IChunkGenerator<?> func_201711_g() {
        return this.field_186029_c;
    }

    public int func_73152_e() {
        return this.field_73244_f.size();
    }

    public boolean func_73149_a(int n, int n2) {
        return this.field_73244_f.containsKey(ChunkPos.func_77272_a(n, n2));
    }
}

