/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.AllowsMovementAndSolidMatcher;
import net.minecraft.block.state.pattern.AllowsMovementMatcher;
import net.minecraft.block.state.pattern.BlockMatcherReaderAware;
import net.minecraft.block.state.pattern.BlockTagMatcher;
import net.minecraft.block.state.pattern.IBlockMatcherReaderAware;
import net.minecraft.block.state.pattern.LightEmittingMatcher;
import net.minecraft.block.state.pattern.LiquidBlockMatcher;
import net.minecraft.block.state.pattern.ReaderAwareMatchers;
import net.minecraft.init.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BitArray;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public class Heightmap {
    private final BitArray field_202275_a = new BitArray(9, 256);
    private final IBlockMatcherReaderAware<IBlockState> field_202276_b;
    private final IChunk field_202277_c;

    public Heightmap(IChunk iChunk, Type type) {
        this.field_202276_b = ReaderAwareMatchers.func_202084_a(ReaderAwareMatchers.func_202083_b(type.func_202264_a()));
        this.field_202277_c = iChunk;
    }

    public void func_202266_a() {
        int n = this.field_202277_c.func_76625_h() + 16;
        try (BlockPos.PooledMutableBlockPos \u26032 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                    this.func_202272_a(\u2603, \u2603, this.func_208518_a(\u26032, \u2603, \u2603, this.field_202276_b, n));
                }
            }
        }
    }

    public boolean func_202270_a(int n, int n2, int n3, @Nullable IBlockState iBlockState) {
        int n4 = this.func_202273_a(n, n3);
        if (n2 <= n4 - 2) {
            return false;
        }
        if (this.field_202276_b.test(iBlockState, this.field_202277_c, new BlockPos(n, n2, n3))) {
            if (n2 >= n4) {
                this.func_202272_a(n, n3, n2 + 1);
                return true;
            }
        } else if (n4 - 1 == n2) {
            this.func_202272_a(n, n3, this.func_208518_a(null, n, n3, this.field_202276_b, n2));
            return true;
        }
        return false;
    }

    private int func_208518_a(@Nullable BlockPos.MutableBlockPos mutableBlockPos2, int n, int n2, IBlockMatcherReaderAware<IBlockState> iBlockMatcherReaderAware, int n3) {
        if (mutableBlockPos2 == null) {
            BlockPos.MutableBlockPos mutableBlockPos2 = new BlockPos.MutableBlockPos();
        }
        for (int i = n3 - 1; i >= 0; --i) {
            mutableBlockPos2.func_181079_c(n, i, n2);
            IBlockState iBlockState = this.field_202277_c.func_180495_p(mutableBlockPos2);
            if (!iBlockMatcherReaderAware.test(iBlockState, this.field_202277_c, mutableBlockPos2)) continue;
            return i + 1;
        }
        return 0;
    }

    public int func_202273_a(int n, int n2) {
        return this.func_202274_b(Heightmap.func_202267_b(n, n2));
    }

    private int func_202274_b(int n) {
        return this.field_202275_a.func_188142_a(n);
    }

    private void func_202272_a(int n, int n2, int n3) {
        this.field_202275_a.func_188141_a(Heightmap.func_202267_b(n, n2), n3);
    }

    public void func_202268_a(long[] lArray) {
        System.arraycopy(lArray, 0, this.field_202275_a.func_188143_a(), 0, lArray.length);
    }

    public long[] func_202269_a() {
        return this.field_202275_a.func_188143_a();
    }

    private static int func_202267_b(int n, int n2) {
        return n + n2 * 16;
    }

    public static enum Type {
        WORLD_SURFACE_WG("WORLD_SURFACE_WG", Usage.WORLDGEN, BlockMatcherReaderAware.func_202081_a(Blocks.field_150350_a)),
        OCEAN_FLOOR_WG("OCEAN_FLOOR_WG", Usage.WORLDGEN, BlockMatcherReaderAware.func_202081_a(Blocks.field_150350_a), LiquidBlockMatcher.func_206902_a()),
        LIGHT_BLOCKING("LIGHT_BLOCKING", Usage.LIVE_WORLD, BlockMatcherReaderAware.func_202081_a(Blocks.field_150350_a), LightEmittingMatcher.func_202073_a()),
        MOTION_BLOCKING("MOTION_BLOCKING", Usage.LIVE_WORLD, BlockMatcherReaderAware.func_202081_a(Blocks.field_150350_a), AllowsMovementAndSolidMatcher.func_209402_a()),
        MOTION_BLOCKING_NO_LEAVES("MOTION_BLOCKING_NO_LEAVES", Usage.LIVE_WORLD, BlockMatcherReaderAware.func_202081_a(Blocks.field_150350_a), BlockTagMatcher.func_206904_a(BlockTags.field_206952_E), AllowsMovementAndSolidMatcher.func_209402_a()),
        OCEAN_FLOOR("OCEAN_FLOOR", Usage.LIVE_WORLD, BlockMatcherReaderAware.func_202081_a(Blocks.field_150350_a), AllowsMovementMatcher.func_202079_a()),
        WORLD_SURFACE("WORLD_SURFACE", Usage.LIVE_WORLD, BlockMatcherReaderAware.func_202081_a(Blocks.field_150350_a));

        private final IBlockMatcherReaderAware<IBlockState>[] field_202265_e;
        private final String field_203502_f;
        private final Usage field_207513_i;
        private static final Map<String, Type> field_203503_g;

        private Type(String string2, Usage usage, IBlockMatcherReaderAware<IBlockState> ... iBlockMatcherReaderAwareArray) {
            this.field_203502_f = string2;
            this.field_202265_e = iBlockMatcherReaderAwareArray;
            this.field_207513_i = usage;
        }

        public IBlockMatcherReaderAware<IBlockState>[] func_202264_a() {
            return this.field_202265_e;
        }

        public String func_203500_b() {
            return this.field_203502_f;
        }

        public Usage func_207512_c() {
            return this.field_207513_i;
        }

        public static Type func_203501_a(String string) {
            return field_203503_g.get(string);
        }

        static {
            field_203503_g = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
                for (Type type : Type.values()) {
                    hashMap.put(type.field_203502_f, type);
                }
            });
        }
    }

    public static enum Usage {
        WORLDGEN,
        LIVE_WORLD;

    }
}

