/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.EndCityConfig;
import net.minecraft.world.gen.feature.structure.EndCityPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class EndCityStructure
extends Structure<EndCityConfig> {
    @Override
    protected ChunkPos func_211744_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2, int n3, int n4) {
        \u2603 = iChunkGenerator.func_201496_a_().func_202178_h();
        \u2603 = iChunkGenerator.func_201496_a_().func_211728_o();
        \u2603 = n + \u2603 * n3;
        \u2603 = n2 + \u2603 * n4;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 / \u2603;
        \u2603 = \u2603 / \u2603;
        ((SharedSeedRandom)random).func_202427_a(iChunkGenerator.func_202089_c(), \u2603, \u2603, 10387313);
        \u2603 *= \u2603;
        \u2603 *= \u2603;
        return new ChunkPos(\u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2, \u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2);
    }

    @Override
    protected boolean func_202372_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2) {
        ChunkPos chunkPos = this.func_211744_a(iChunkGenerator, random, n, n2, 0, 0);
        if (n == chunkPos.field_77276_a && n2 == chunkPos.field_77275_b) {
            Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
            if (!iChunkGenerator.func_202094_a(biome, Feature.field_202338_p)) {
                return false;
            }
            int \u26032 = EndCityStructure.func_191070_b(n, n2, iChunkGenerator);
            return \u26032 >= 60;
        }
        return false;
    }

    @Override
    protected boolean func_202365_a(IWorld iWorld) {
        return iWorld.func_72912_H().func_76089_r();
    }

    @Override
    protected StructureStart func_202369_a(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        return new Start(iWorld, iChunkGenerator, sharedSeedRandom, n, n2, biome);
    }

    @Override
    protected String func_143025_a() {
        return "EndCity";
    }

    @Override
    public int func_202367_b() {
        return 9;
    }

    private static int func_191070_b(int n, int n2, IChunkGenerator<?> iChunkGenerator) {
        Random random = new Random(n + n2 * 10387313);
        Rotation \u26032 = Rotation.values()[random.nextInt(Rotation.values().length)];
        ChunkPrimer \u26033 = new ChunkPrimer(new ChunkPos(n, n2), UpgradeData.field_196994_a);
        iChunkGenerator.func_202088_a(\u26033);
        int \u26034 = 5;
        int \u26035 = 5;
        if (\u26032 == Rotation.CLOCKWISE_90) {
            \u26034 = -5;
        } else if (\u26032 == Rotation.CLOCKWISE_180) {
            \u26034 = -5;
            \u26035 = -5;
        } else if (\u26032 == Rotation.COUNTERCLOCKWISE_90) {
            \u26035 = -5;
        }
        int \u26036 = \u26033.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7);
        int \u26037 = \u26033.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7 + \u26035);
        int \u26038 = \u26033.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + \u26034, 7);
        int \u26039 = \u26033.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + \u26034, 7 + \u26035);
        return Math.min(Math.min(\u26036, \u26037), Math.min(\u26038, \u26039));
    }

    public static class Start
    extends StructureStart {
        private boolean field_186163_c;

        public Start() {
        }

        public Start(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome) {
            super(n, n2, biome, sharedSeedRandom, iWorld.func_72905_C());
            Rotation rotation = Rotation.values()[sharedSeedRandom.nextInt(Rotation.values().length)];
            int \u26032 = EndCityStructure.func_191070_b(n, n2, iChunkGenerator);
            if (\u26032 < 60) {
                this.field_186163_c = false;
                return;
            }
            BlockPos \u26033 = new BlockPos(n * 16 + 8, \u26032, n2 * 16 + 8);
            EndCityPieces.func_191087_a(iWorld.func_72860_G().func_186340_h(), \u26033, rotation, this.field_75075_a, sharedSeedRandom);
            this.func_202500_a(iWorld);
            this.field_186163_c = true;
        }

        @Override
        public boolean func_75069_d() {
            return this.field_186163_c;
        }
    }
}

