/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Biomes;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.FortressConfig;
import net.minecraft.world.gen.feature.structure.FortressPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class FortressStructure
extends Structure<FortressConfig> {
    private static final List<Biome.SpawnListEntry> field_202381_d = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200792_f, 10, 2, 3), new Biome.SpawnListEntry(EntityType.field_200785_Y, 5, 4, 4), new Biome.SpawnListEntry(EntityType.field_200722_aA, 8, 5, 5), new Biome.SpawnListEntry(EntityType.field_200741_ag, 2, 5, 5), new Biome.SpawnListEntry(EntityType.field_200771_K, 3, 4, 4)});

    @Override
    protected boolean func_202372_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2) {
        \u2603 = n >> 4;
        \u2603 = n2 >> 4;
        random.setSeed((long)(\u2603 ^ \u2603 << 4) ^ iChunkGenerator.func_202089_c());
        random.nextInt();
        if (random.nextInt(3) != 0) {
            return false;
        }
        if (n != (\u2603 << 4) + 4 + random.nextInt(8)) {
            return false;
        }
        if (n2 != (\u2603 << 4) + 4 + random.nextInt(8)) {
            return false;
        }
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        return iChunkGenerator.func_202094_a(biome, Feature.field_202337_o);
    }

    @Override
    protected boolean func_202365_a(IWorld iWorld) {
        return iWorld.func_72912_H().func_76089_r();
    }

    @Override
    protected StructureStart func_202369_a(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        return new Start(iWorld, sharedSeedRandom, n, n2, biome);
    }

    @Override
    protected String func_143025_a() {
        return "Fortress";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_202381_d;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(IWorld iWorld, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome) {
            super(n, n2, biome, sharedSeedRandom, iWorld.func_72905_C());
            FortressPieces.Start start = new FortressPieces.Start(sharedSeedRandom, (n << 4) + 2, (n2 << 4) + 2);
            this.field_75075_a.add(start);
            start.func_74861_a(start, this.field_75075_a, sharedSeedRandom);
            List<StructurePiece> \u26032 = start.field_74967_d;
            while (!\u26032.isEmpty()) {
                int n3 = sharedSeedRandom.nextInt(\u26032.size());
                StructurePiece \u26033 = \u26032.remove(n3);
                \u26033.func_74861_a(start, this.field_75075_a, sharedSeedRandom);
            }
            this.func_202500_a(iWorld);
            this.func_75070_a(iWorld, sharedSeedRandom, 48, 70);
        }
    }
}

