/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockTorchWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class MineshaftPieces {
    public static void func_143048_a() {
        StructureIO.func_143031_a(Corridor.class, "MSCorridor");
        StructureIO.func_143031_a(Cross.class, "MSCrossing");
        StructureIO.func_143031_a(Room.class, "MSRoom");
        StructureIO.func_143031_a(Stairs.class, "MSStairs");
    }

    private static Piece func_189940_a(List<StructurePiece> list2, Random random, int n, int n2, int n3, @Nullable EnumFacing enumFacing, int n4, MineshaftStructure.Type type) {
        int n5 = random.nextInt(100);
        if (n5 >= 80) {
            MutableBoundingBox mutableBoundingBox = Cross.func_175813_a(list2, random, n, n2, n3, enumFacing);
            if (mutableBoundingBox != null) {
                return new Cross(n4, random, mutableBoundingBox, enumFacing, type);
            }
        } else if (n5 >= 70) {
            MutableBoundingBox mutableBoundingBox = Stairs.func_175812_a(list2, random, n, n2, n3, enumFacing);
            if (mutableBoundingBox != null) {
                return new Stairs(n4, random, mutableBoundingBox, enumFacing, type);
            }
        } else {
            List<StructurePiece> list2;
            MutableBoundingBox \u26032 = Corridor.func_175814_a(list2, random, n, n2, n3, enumFacing);
            if (\u26032 != null) {
                return new Corridor(n4, random, \u26032, enumFacing, type);
            }
        }
        return null;
    }

    private static Piece func_189938_b(StructurePiece structurePiece, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
        if (n4 > 8) {
            return null;
        }
        if (Math.abs(n - structurePiece.func_74874_b().field_78897_a) > 80 || Math.abs(n3 - structurePiece.func_74874_b().field_78896_c) > 80) {
            return null;
        }
        MineshaftStructure.Type type = ((Piece)structurePiece).field_189920_a;
        Piece \u26032 = MineshaftPieces.func_189940_a(list, random, n, n2, n3, enumFacing, n4 + 1, type);
        if (\u26032 != null) {
            list.add(\u26032);
            \u26032.func_74861_a(structurePiece, list, random);
        }
        return \u26032;
    }

    public static class Stairs
    extends Piece {
        public Stairs() {
        }

        public Stairs(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing, MineshaftStructure.Type type) {
            super(n, type);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        public static MutableBoundingBox func_175812_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing) {
            MutableBoundingBox mutableBoundingBox = new MutableBoundingBox(n, n2 - 5, n3, n, n2 + 3 - 1, n3);
            switch (enumFacing) {
                default: {
                    mutableBoundingBox.field_78893_d = n + 3 - 1;
                    mutableBoundingBox.field_78896_c = n3 - 8;
                    break;
                }
                case SOUTH: {
                    mutableBoundingBox.field_78893_d = n + 3 - 1;
                    mutableBoundingBox.field_78892_f = n3 + 8;
                    break;
                }
                case WEST: {
                    mutableBoundingBox.field_78897_a = n - 8;
                    mutableBoundingBox.field_78892_f = n3 + 3 - 1;
                    break;
                }
                case EAST: {
                    mutableBoundingBox.field_78893_d = n + 8;
                    mutableBoundingBox.field_78892_f = n3 + 3 - 1;
                }
            }
            if (StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            int n = this.func_74877_c();
            EnumFacing \u26032 = this.func_186165_e();
            if (\u26032 != null) {
                switch (\u26032) {
                    default: {
                        MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n);
                        break;
                    }
                    case SOUTH: {
                        MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n);
                        break;
                    }
                    case WEST: {
                        MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, n);
                        break;
                    }
                    case EAST: {
                        MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, n);
                    }
                }
            }
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            if (this.func_74860_a(iWorld, mutableBoundingBox)) {
                return false;
            }
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 5, 0, 2, 7, 1, field_202556_l, field_202556_l, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 7, 2, 2, 8, field_202556_l, field_202556_l, false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class Cross
    extends Piece {
        private EnumFacing field_74953_a;
        private boolean field_74952_b;

        public Cross() {
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("tf", this.field_74952_b);
            nBTTagCompound.func_74768_a("D", this.field_74953_a.func_176736_b());
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74952_b = nBTTagCompound.func_74767_n("tf");
            this.field_74953_a = EnumFacing.func_176731_b(nBTTagCompound.func_74762_e("D"));
        }

        public Cross(int n, Random random, MutableBoundingBox mutableBoundingBox, @Nullable EnumFacing enumFacing, MineshaftStructure.Type type) {
            super(n, type);
            this.field_74953_a = enumFacing;
            this.field_74887_e = mutableBoundingBox;
            this.field_74952_b = mutableBoundingBox.func_78882_c() > 3;
        }

        public static MutableBoundingBox func_175813_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing) {
            MutableBoundingBox mutableBoundingBox = new MutableBoundingBox(n, n2, n3, n, n2 + 3 - 1, n3);
            if (random.nextInt(4) == 0) {
                mutableBoundingBox.field_78894_e += 4;
            }
            switch (enumFacing) {
                default: {
                    mutableBoundingBox.field_78897_a = n - 1;
                    mutableBoundingBox.field_78893_d = n + 3;
                    mutableBoundingBox.field_78896_c = n3 - 4;
                    break;
                }
                case SOUTH: {
                    mutableBoundingBox.field_78897_a = n - 1;
                    mutableBoundingBox.field_78893_d = n + 3;
                    mutableBoundingBox.field_78892_f = n3 + 3 + 1;
                    break;
                }
                case WEST: {
                    mutableBoundingBox.field_78897_a = n - 4;
                    mutableBoundingBox.field_78896_c = n3 - 1;
                    mutableBoundingBox.field_78892_f = n3 + 3;
                    break;
                }
                case EAST: {
                    mutableBoundingBox.field_78893_d = n + 3 + 1;
                    mutableBoundingBox.field_78896_c = n3 - 1;
                    mutableBoundingBox.field_78892_f = n3 + 3;
                }
            }
            if (StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            int n = this.func_74877_c();
            switch (this.field_74953_a) {
                default: {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, n);
                    break;
                }
                case SOUTH: {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, n);
                    break;
                }
                case WEST: {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, n);
                    break;
                }
                case EAST: {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n);
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, n);
                }
            }
            if (this.field_74952_b) {
                if (random.nextBoolean()) {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n);
                }
                if (random.nextBoolean()) {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, n);
                }
                if (random.nextBoolean()) {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, n);
                }
                if (random.nextBoolean()) {
                    MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n);
                }
            }
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            if (this.func_74860_a(iWorld, mutableBoundingBox)) {
                return false;
            }
            IBlockState iBlockState = this.func_189917_F_();
            if (this.field_74952_b) {
                this.func_175804_a(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            }
            this.func_189923_b(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(iWorld, mutableBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(iWorld, mutableBoundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(iWorld, mutableBoundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (\u2603 = this.field_74887_e.field_78896_c; \u2603 <= this.field_74887_e.field_78892_f; ++\u2603) {
                    if (!this.func_175807_a(iWorld, i, this.field_74887_e.field_78895_b - 1, \u2603, mutableBoundingBox).func_196958_f() || !this.func_189916_b(iWorld, i, this.field_74887_e.field_78895_b - 1, \u2603, mutableBoundingBox)) continue;
                    this.func_175811_a(iWorld, iBlockState, i, this.field_74887_e.field_78895_b - 1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }

        private void func_189923_b(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4) {
            if (!this.func_175807_a(iWorld, n, n4 + 1, n3, mutableBoundingBox).func_196958_f()) {
                this.func_175804_a(iWorld, mutableBoundingBox, n, n2, n3, n, n4, n3, this.func_189917_F_(), field_202556_l, false);
            }
        }
    }

    public static class Corridor
    extends Piece {
        private boolean field_74958_a;
        private boolean field_74956_b;
        private boolean field_74957_c;
        private int field_74955_d;

        public Corridor() {
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("hr", this.field_74958_a);
            nBTTagCompound.func_74757_a("sc", this.field_74956_b);
            nBTTagCompound.func_74757_a("hps", this.field_74957_c);
            nBTTagCompound.func_74768_a("Num", this.field_74955_d);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74958_a = nBTTagCompound.func_74767_n("hr");
            this.field_74956_b = nBTTagCompound.func_74767_n("sc");
            this.field_74957_c = nBTTagCompound.func_74767_n("hps");
            this.field_74955_d = nBTTagCompound.func_74762_e("Num");
        }

        public Corridor(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing, MineshaftStructure.Type type) {
            super(n, type);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_74958_a = random.nextInt(3) == 0;
            this.field_74956_b = !this.field_74958_a && random.nextInt(23) == 0;
            this.field_74955_d = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? mutableBoundingBox.func_78880_d() / 5 : mutableBoundingBox.func_78883_b() / 5;
        }

        public static MutableBoundingBox func_175814_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing) {
            int n4;
            MutableBoundingBox mutableBoundingBox = new MutableBoundingBox(n, n2, n3, n, n2 + 3 - 1, n3);
            for (n4 = random.nextInt(3) + 2; n4 > 0; --n4) {
                \u2603 = n4 * 5;
                switch (enumFacing) {
                    default: {
                        mutableBoundingBox.field_78893_d = n + 3 - 1;
                        mutableBoundingBox.field_78896_c = n3 - (\u2603 - 1);
                        break;
                    }
                    case SOUTH: {
                        mutableBoundingBox.field_78893_d = n + 3 - 1;
                        mutableBoundingBox.field_78892_f = n3 + \u2603 - 1;
                        break;
                    }
                    case WEST: {
                        mutableBoundingBox.field_78897_a = n - (\u2603 - 1);
                        mutableBoundingBox.field_78892_f = n3 + 3 - 1;
                        break;
                    }
                    case EAST: {
                        mutableBoundingBox.field_78893_d = n + \u2603 - 1;
                        mutableBoundingBox.field_78892_f = n3 + 3 - 1;
                    }
                }
                if (StructurePiece.func_74883_a(list, mutableBoundingBox) == null) break;
            }
            if (n4 > 0) {
                return mutableBoundingBox;
            }
            return null;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            block24: {
                int n = this.func_74877_c();
                \u2603 = random.nextInt(4);
                EnumFacing \u26032 = this.func_186165_e();
                if (\u26032 != null) {
                    switch (\u26032) {
                        default: {
                            if (\u2603 <= 1) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, \u26032, n);
                                break;
                            }
                            if (\u2603 == 2) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.WEST, n);
                                break;
                            }
                            MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.EAST, n);
                            break;
                        }
                        case SOUTH: {
                            if (\u2603 <= 1) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, \u26032, n);
                                break;
                            }
                            if (\u2603 == 2) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.WEST, n);
                                break;
                            }
                            MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.EAST, n);
                            break;
                        }
                        case WEST: {
                            if (\u2603 <= 1) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, \u26032, n);
                                break;
                            }
                            if (\u2603 == 2) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n);
                                break;
                            }
                            MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n);
                            break;
                        }
                        case EAST: {
                            if (\u2603 <= 1) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, \u26032, n);
                                break;
                            }
                            if (\u2603 == 2) {
                                MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n);
                                break;
                            }
                            MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n);
                        }
                    }
                }
                if (n >= 8) break block24;
                if (\u26032 == EnumFacing.NORTH || \u26032 == EnumFacing.SOUTH) {
                    \u2603 = this.field_74887_e.field_78896_c + 3;
                    while (\u2603 + 3 <= this.field_74887_e.field_78892_f) {
                        \u2603 = random.nextInt(5);
                        if (\u2603 == 0) {
                            MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, \u2603, EnumFacing.WEST, n + 1);
                        } else if (\u2603 == 1) {
                            MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, \u2603, EnumFacing.EAST, n + 1);
                        }
                        \u2603 += 5;
                    }
                } else {
                    \u2603 = this.field_74887_e.field_78897_a + 3;
                    while (\u2603 + 3 <= this.field_74887_e.field_78893_d) {
                        \u2603 = random.nextInt(5);
                        if (\u2603 == 0) {
                            MineshaftPieces.func_189938_b(structurePiece, list, random, \u2603, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n + 1);
                        } else if (\u2603 == 1) {
                            MineshaftPieces.func_189938_b(structurePiece, list, random, \u2603, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n + 1);
                        }
                        \u2603 += 5;
                    }
                }
            }
        }

        @Override
        protected boolean func_186167_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, int n, int n2, int n3, ResourceLocation resourceLocation) {
            BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
            if (mutableBoundingBox.func_175898_b(blockPos) && iWorld.func_180495_p(blockPos).func_196958_f() && !iWorld.func_180495_p(blockPos.func_177977_b()).func_196958_f()) {
                IBlockState iBlockState = (IBlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a(BlockRail.field_176565_b, random.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST);
                this.func_175811_a(iWorld, iBlockState, n, n2, n3, mutableBoundingBox);
                EntityMinecartChest \u26032 = new EntityMinecartChest(iWorld.func_201672_e(), (float)blockPos.func_177958_n() + 0.5f, (float)blockPos.func_177956_o() + 0.5f, (float)blockPos.func_177952_p() + 0.5f);
                \u26032.func_184289_a(resourceLocation, random.nextLong());
                iWorld.func_72838_d(\u26032);
                return true;
            }
            return false;
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            int n;
            if (this.func_74860_a(iWorld, mutableBoundingBox)) {
                return false;
            }
            boolean bl = false;
            int \u26032 = 2;
            \u2603 = false;
            int \u26033 = 2;
            int \u26034 = this.field_74955_d * 5 - 1;
            IBlockState \u26035 = this.func_189917_F_();
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 2, 1, \u26034, field_202556_l, field_202556_l, false);
            this.func_189914_a(iWorld, mutableBoundingBox, random, 0.8f, 0, 2, 0, 2, 2, \u26034, field_202556_l, field_202556_l, false, false);
            if (this.field_74956_b) {
                this.func_189914_a(iWorld, mutableBoundingBox, random, 0.6f, 0, 0, 0, 2, 1, \u26034, Blocks.field_196553_aF.func_176223_P(), field_202556_l, false, true);
            }
            for (n = 0; n < this.field_74955_d; ++n) {
                i = 2 + n * 5;
                this.func_189921_a(iWorld, mutableBoundingBox, 0, 0, i, 2, 2, random);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.1f, 0, 2, i - 1);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.1f, 2, 2, i - 1);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.1f, 0, 2, i + 1);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.1f, 2, 2, i + 1);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.05f, 0, 2, i - 2);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.05f, 2, 2, i - 2);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.05f, 0, 2, i + 2);
                this.func_189922_a(iWorld, mutableBoundingBox, random, 0.05f, 2, 2, i + 2);
                if (random.nextInt(100) == 0) {
                    this.func_186167_a(iWorld, mutableBoundingBox, random, 2, 0, i - 1, LootTableList.field_186424_f);
                }
                if (random.nextInt(100) == 0) {
                    this.func_186167_a(iWorld, mutableBoundingBox, random, 0, 0, i + 1, LootTableList.field_186424_f);
                }
                if (!this.field_74956_b || this.field_74957_c) continue;
                \u2603 = this.func_74862_a(0);
                \u2603 = i - 1 + random.nextInt(3);
                \u26037 = this.func_74865_a(1, \u2603);
                BlockPos blockPos = new BlockPos(\u26037, \u2603, \u2603 = this.func_74873_b(1, \u2603));
                if (!mutableBoundingBox.func_175898_b(blockPos) || !this.func_189916_b(iWorld, 1, 0, \u2603, mutableBoundingBox)) continue;
                this.field_74957_c = true;
                iWorld.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity \u26036 = iWorld.func_175625_s(blockPos);
                if (!(\u26036 instanceof TileEntityMobSpawner)) continue;
                ((TileEntityMobSpawner)\u26036).func_145881_a().func_200876_a(EntityType.field_200794_h);
            }
            for (n = 0; n <= 2; ++n) {
                for (i = 0; i <= \u26034; ++i) {
                    \u2603 = -1;
                    IBlockState iBlockState = this.func_175807_a(iWorld, n, -1, i, mutableBoundingBox);
                    if (!iBlockState.func_196958_f() || !this.func_189916_b(iWorld, n, -1, i, mutableBoundingBox)) continue;
                    int \u26037 = -1;
                    this.func_175811_a(iWorld, \u26035, n, -1, i, mutableBoundingBox);
                }
            }
            if (this.field_74958_a) {
                \u2603 = (IBlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a(BlockRail.field_176565_b, RailShape.NORTH_SOUTH);
                for (int i = 0; i <= \u26034; ++i) {
                    IBlockState iBlockState = this.func_175807_a(iWorld, 1, -1, i, mutableBoundingBox);
                    if (iBlockState.func_196958_f() || !iBlockState.func_200015_d(iWorld, new BlockPos(this.func_74865_a(1, i), this.func_74862_a(-1), this.func_74873_b(1, i)))) continue;
                    float \u26038 = this.func_189916_b(iWorld, 1, 0, i, mutableBoundingBox) ? 0.7f : 0.9f;
                    this.func_175809_a(iWorld, mutableBoundingBox, random, \u26038, 1, 0, i, \u2603);
                }
            }
            return true;
        }

        private void func_189921_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, Random random) {
            if (!this.func_189918_a(iWorld, mutableBoundingBox, n, n5, n4, n3)) {
                return;
            }
            IBlockState iBlockState = this.func_189917_F_();
            \u2603 = this.func_189919_b();
            this.func_175804_a(iWorld, mutableBoundingBox, n, n2, n3, n, n4 - 1, n3, (IBlockState)\u2603.func_206870_a(BlockFence.field_196414_y, true), field_202556_l, false);
            this.func_175804_a(iWorld, mutableBoundingBox, n5, n2, n3, n5, n4 - 1, n3, (IBlockState)\u2603.func_206870_a(BlockFence.field_196411_b, true), field_202556_l, false);
            if (random.nextInt(4) == 0) {
                this.func_175804_a(iWorld, mutableBoundingBox, n, n4, n3, n, n4, n3, iBlockState, field_202556_l, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n5, n4, n3, n5, n4, n3, iBlockState, field_202556_l, false);
            } else {
                this.func_175804_a(iWorld, mutableBoundingBox, n, n4, n3, n5, n4, n3, iBlockState, field_202556_l, false);
                this.func_175809_a(iWorld, mutableBoundingBox, random, 0.05f, n + 1, n4, n3 - 1, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.NORTH));
                this.func_175809_a(iWorld, mutableBoundingBox, random, 0.05f, n + 1, n4, n3 + 1, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.SOUTH));
            }
        }

        private void func_189922_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, float f, int n, int n2, int n3) {
            if (this.func_189916_b(iWorld, n, n2, n3, mutableBoundingBox)) {
                this.func_175809_a(iWorld, mutableBoundingBox, random, f, n, n2, n3, Blocks.field_196553_aF.func_176223_P());
            }
        }
    }

    public static class Room
    extends Piece {
        private final List<MutableBoundingBox> field_74949_a = Lists.newLinkedList();

        public Room() {
        }

        public Room(int n, Random random, int n2, int n3, MineshaftStructure.Type type) {
            super(n, type);
            this.field_189920_a = type;
            this.field_74887_e = new MutableBoundingBox(n2, 50, n3, n2 + 7 + random.nextInt(6), 54 + random.nextInt(6), n3 + 7 + random.nextInt(6));
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            int n;
            MutableBoundingBox \u26032;
            Piece piece;
            int n2 = this.func_74877_c();
            \u2603 = this.field_74887_e.func_78882_c() - 3 - 1;
            if (\u2603 <= 0) {
                \u2603 = 1;
            }
            for (n = 0; n < this.field_74887_e.func_78883_b() && (n += random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); n += 4) {
                piece = MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + random.nextInt(\u2603) + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, n2);
                if (piece == null) continue;
                \u26032 = piece.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(\u26032.field_78897_a, \u26032.field_78895_b, this.field_74887_e.field_78896_c, \u26032.field_78893_d, \u26032.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (n = 0; n < this.field_74887_e.func_78883_b() && (n += random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); n += 4) {
                piece = MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + random.nextInt(\u2603) + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, n2);
                if (piece == null) continue;
                \u26032 = piece.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(\u26032.field_78897_a, \u26032.field_78895_b, this.field_74887_e.field_78892_f - 1, \u26032.field_78893_d, \u26032.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (n = 0; n < this.field_74887_e.func_78880_d() && (n += random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); n += 4) {
                piece = MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + random.nextInt(\u2603) + 1, this.field_74887_e.field_78896_c + n, EnumFacing.WEST, n2);
                if (piece == null) continue;
                \u26032 = piece.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(this.field_74887_e.field_78897_a, \u26032.field_78895_b, \u26032.field_78896_c, this.field_74887_e.field_78897_a + 1, \u26032.field_78894_e, \u26032.field_78892_f));
            }
            for (n = 0; n < this.field_74887_e.func_78880_d() && (n += random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); n += 4) {
                piece = MineshaftPieces.func_189938_b(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + random.nextInt(\u2603) + 1, this.field_74887_e.field_78896_c + n, EnumFacing.EAST, n2);
                if (piece == null) continue;
                \u26032 = piece.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(this.field_74887_e.field_78893_d - 1, \u26032.field_78895_b, \u26032.field_78896_c, this.field_74887_e.field_78893_d, \u26032.field_78894_e, \u26032.field_78892_f));
            }
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            if (this.func_74860_a(iWorld2, mutableBoundingBox)) {
                return false;
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, Blocks.field_150346_d.func_176223_P(), field_202556_l, true);
            this.func_175804_a(iWorld2, mutableBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
            for (MutableBoundingBox mutableBoundingBox2 : this.field_74949_a) {
                this.func_175804_a(iWorld2, mutableBoundingBox, mutableBoundingBox2.field_78897_a, mutableBoundingBox2.field_78894_e - 2, mutableBoundingBox2.field_78896_c, mutableBoundingBox2.field_78893_d, mutableBoundingBox2.field_78894_e, mutableBoundingBox2.field_78892_f, field_202556_l, field_202556_l, false);
            }
            this.func_180777_a(iWorld2, mutableBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, false);
            return true;
        }

        @Override
        public void func_181138_a(int n, int n2, int n3) {
            super.func_181138_a(n, n2, n3);
            for (MutableBoundingBox mutableBoundingBox : this.field_74949_a) {
                mutableBoundingBox.func_78886_a(n, n2, n3);
            }
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound2) {
            NBTTagCompound nBTTagCompound2;
            super.func_143012_a(nBTTagCompound2);
            NBTTagList nBTTagList = new NBTTagList();
            for (MutableBoundingBox mutableBoundingBox : this.field_74949_a) {
                nBTTagList.add(mutableBoundingBox.func_151535_h());
            }
            nBTTagCompound2.func_74782_a("Entrances", nBTTagList);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Entrances", 11);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                this.field_74949_a.add(new MutableBoundingBox(nBTTagList.func_150306_c(i)));
            }
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected MineshaftStructure.Type field_189920_a;

        public Piece() {
        }

        public Piece(int n, MineshaftStructure.Type type) {
            super(n);
            this.field_189920_a = type;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            nBTTagCompound.func_74768_a("MST", this.field_189920_a.ordinal());
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            this.field_189920_a = MineshaftStructure.Type.func_189910_a(nBTTagCompound.func_74762_e("MST"));
        }

        protected IBlockState func_189917_F_() {
            switch (this.field_189920_a) {
                default: {
                    return Blocks.field_196662_n.func_176223_P();
                }
                case MESA: 
            }
            return Blocks.field_196672_s.func_176223_P();
        }

        protected IBlockState func_189919_b() {
            switch (this.field_189920_a) {
                default: {
                    return Blocks.field_180407_aO.func_176223_P();
                }
                case MESA: 
            }
            return Blocks.field_180406_aS.func_176223_P();
        }

        protected boolean func_189918_a(IBlockReader iBlockReader, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4) {
            for (\u2603 = n; \u2603 <= n2; ++\u2603) {
                if (!this.func_175807_a(iBlockReader, \u2603, n3 + 1, n4, mutableBoundingBox).func_196958_f()) continue;
                return false;
            }
            return true;
        }
    }
}

