/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class ShipwreckPieces {
    private static final BlockPos field_207663_a = new BlockPos(4, 0, 15);
    private static final ResourceLocation[] field_204761_a = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};
    private static final ResourceLocation[] field_204762_b = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/upsidedown_full"), new ResourceLocation("shipwreck/upsidedown_fronthalf"), new ResourceLocation("shipwreck/upsidedown_backhalf"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/upsidedown_full_degraded"), new ResourceLocation("shipwreck/upsidedown_fronthalf_degraded"), new ResourceLocation("shipwreck/upsidedown_backhalf_degraded"), new ResourceLocation("shipwreck/sideways_full_degraded"), new ResourceLocation("shipwreck/sideways_fronthalf_degraded"), new ResourceLocation("shipwreck/sideways_backhalf_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};

    public static void func_204759_a() {
        StructureIO.func_143031_a(Piece.class, "Shipwreck");
    }

    public static void func_204760_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<StructurePiece> list, Random random, ShipwreckConfig shipwreckConfig) {
        ResourceLocation resourceLocation = shipwreckConfig.field_204753_a ? field_204761_a[random.nextInt(field_204761_a.length)] : field_204762_b[random.nextInt(field_204762_b.length)];
        list.add(new Piece(templateManager, resourceLocation, blockPos, rotation, shipwreckConfig.field_204753_a));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private Rotation field_204755_d;
        private ResourceLocation field_204756_e;
        private boolean field_204757_f;

        public Piece() {
        }

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, boolean bl) {
            super(0);
            this.field_186178_c = blockPos;
            this.field_204755_d = rotation;
            this.field_204756_e = resourceLocation;
            this.field_204757_f = bl;
            this.func_204754_a(templateManager);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74778_a("Template", this.field_204756_e.toString());
            nBTTagCompound.func_74757_a("isBeached", this.field_204757_f);
            nBTTagCompound.func_74778_a("Rot", this.field_204755_d.name());
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_204756_e = new ResourceLocation(nBTTagCompound.func_74779_i("Template"));
            this.field_204757_f = nBTTagCompound.func_74767_n("isBeached");
            this.field_204755_d = Rotation.valueOf(nBTTagCompound.func_74779_i("Rot"));
            this.func_204754_a(templateManager);
        }

        private void func_204754_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.field_204756_e);
            PlacementSettings \u26032 = new PlacementSettings().func_186220_a(this.field_204755_d).func_186225_a(Blocks.field_150350_a).func_186214_a(Mirror.NONE).func_207665_a(field_207663_a);
            this.func_186173_a(template, this.field_186178_c, \u26032);
        }

        @Override
        protected void func_186175_a(String string, BlockPos blockPos, IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            if ("map_chest".equals(string)) {
                TileEntityLockableLoot.func_195479_a(iWorld, random, blockPos.func_177977_b(), LootTableList.field_204771_s);
            } else if ("treasure_chest".equals(string)) {
                TileEntityLockableLoot.func_195479_a(iWorld, random, blockPos.func_177977_b(), LootTableList.field_204773_u);
            } else if ("supply_chest".equals(string)) {
                TileEntityLockableLoot.func_195479_a(iWorld, random, blockPos.func_177977_b(), LootTableList.field_204772_t);
            }
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            int n = 256;
            \u2603 = 0;
            BlockPos \u26032 = this.field_186178_c.func_177982_a(this.field_186176_a.func_186259_a().func_177958_n() - 1, 0, this.field_186176_a.func_186259_a().func_177952_p() - 1);
            for (BlockPos blockPos : BlockPos.func_177980_a(this.field_186178_c, \u26032)) {
                int n2 = iWorld.func_201676_a(this.field_204757_f ? Heightmap.Type.WORLD_SURFACE_WG : Heightmap.Type.OCEAN_FLOOR_WG, blockPos.func_177958_n(), blockPos.func_177952_p());
                \u2603 += n2;
                n = Math.min(n, n2);
            }
            \u2603 = this.field_204757_f ? n - this.field_186176_a.func_186259_a().func_177956_o() / 2 - random.nextInt(3) : (\u2603 /= this.field_186176_a.func_186259_a().func_177958_n() * this.field_186176_a.func_186259_a().func_177952_p());
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), \u2603, this.field_186178_c.func_177952_p());
            return super.func_74875_a(iWorld, random, mutableBoundingBox, chunkPos);
        }
    }
}

