/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class WoodlandMansionPieces {
    public static void func_191153_a() {
        StructureIO.func_143031_a(MansionTemplate.class, "WMP");
    }

    public static void func_191152_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<MansionTemplate> list, Random random) {
        Grid grid = new Grid(random);
        Placer \u26032 = new Placer(templateManager, random);
        \u26032.func_191125_a(blockPos, rotation, list, grid);
    }

    static class ThirdFloor
    extends SecondFloor {
        private ThirdFloor() {
        }
    }

    static class SecondFloor
    extends RoomCollection {
        private SecondFloor() {
        }

        @Override
        public String func_191104_a(Random random) {
            return "1x1_b" + (random.nextInt(4) + 1);
        }

        @Override
        public String func_191099_b(Random random) {
            return "1x1_as" + (random.nextInt(4) + 1);
        }

        @Override
        public String func_191100_a(Random random, boolean bl) {
            if (bl) {
                return "1x2_c_stairs";
            }
            return "1x2_c" + (random.nextInt(4) + 1);
        }

        @Override
        public String func_191098_b(Random random, boolean bl) {
            if (bl) {
                return "1x2_d_stairs";
            }
            return "1x2_d" + (random.nextInt(5) + 1);
        }

        @Override
        public String func_191102_c(Random random) {
            return "1x2_se" + (random.nextInt(1) + 1);
        }

        @Override
        public String func_191101_d(Random random) {
            return "2x2_b" + (random.nextInt(5) + 1);
        }

        @Override
        public String func_191103_e(Random random) {
            return "2x2_s1";
        }
    }

    static class FirstFloor
    extends RoomCollection {
        private FirstFloor() {
        }

        @Override
        public String func_191104_a(Random random) {
            return "1x1_a" + (random.nextInt(5) + 1);
        }

        @Override
        public String func_191099_b(Random random) {
            return "1x1_as" + (random.nextInt(4) + 1);
        }

        @Override
        public String func_191100_a(Random random, boolean bl) {
            return "1x2_a" + (random.nextInt(9) + 1);
        }

        @Override
        public String func_191098_b(Random random, boolean bl) {
            return "1x2_b" + (random.nextInt(5) + 1);
        }

        @Override
        public String func_191102_c(Random random) {
            return "1x2_s" + (random.nextInt(2) + 1);
        }

        @Override
        public String func_191101_d(Random random) {
            return "2x2_a" + (random.nextInt(4) + 1);
        }

        @Override
        public String func_191103_e(Random random) {
            return "2x2_s1";
        }
    }

    static abstract class RoomCollection {
        private RoomCollection() {
        }

        public abstract String func_191104_a(Random var1);

        public abstract String func_191099_b(Random var1);

        public abstract String func_191100_a(Random var1, boolean var2);

        public abstract String func_191098_b(Random var1, boolean var2);

        public abstract String func_191102_c(Random var1);

        public abstract String func_191101_d(Random var1);

        public abstract String func_191103_e(Random var1);
    }

    static class SimpleGrid {
        private final int[][] field_191148_a;
        private final int field_191149_b;
        private final int field_191150_c;
        private final int field_191151_d;

        public SimpleGrid(int n, int n2, int n3) {
            this.field_191149_b = n;
            this.field_191150_c = n2;
            this.field_191151_d = n3;
            this.field_191148_a = new int[n][n2];
        }

        public void func_191144_a(int n, int n2, int n3) {
            if (n >= 0 && n < this.field_191149_b && n2 >= 0 && n2 < this.field_191150_c) {
                this.field_191148_a[n][n2] = n3;
            }
        }

        public void func_191142_a(int n, int n2, int n3, int n4, int n5) {
            for (\u2603 = n2; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n; \u2603 <= n3; ++\u2603) {
                    this.func_191144_a(\u2603, \u2603, n5);
                }
            }
        }

        public int func_191145_a(int n, int n2) {
            if (n >= 0 && n < this.field_191149_b && n2 >= 0 && n2 < this.field_191150_c) {
                return this.field_191148_a[n][n2];
            }
            return this.field_191151_d;
        }

        public void func_197588_a(int n, int n2, int n3, int n4) {
            if (this.func_191145_a(n, n2) == n3) {
                this.func_191144_a(n, n2, n4);
            }
        }

        public boolean func_191147_b(int n, int n2, int n3) {
            return this.func_191145_a(n - 1, n2) == n3 || this.func_191145_a(n + 1, n2) == n3 || this.func_191145_a(n, n2 + 1) == n3 || this.func_191145_a(n, n2 - 1) == n3;
        }
    }

    static class Grid {
        private final Random field_191117_a;
        private final SimpleGrid field_191118_b;
        private final SimpleGrid field_191119_c;
        private final SimpleGrid[] field_191120_d;
        private final int field_191121_e;
        private final int field_191122_f;

        public Grid(Random random) {
            this.field_191117_a = random;
            int n = 11;
            this.field_191121_e = 7;
            this.field_191122_f = 4;
            this.field_191118_b = new SimpleGrid(11, 11, 5);
            this.field_191118_b.func_191142_a(this.field_191121_e, this.field_191122_f, this.field_191121_e + 1, this.field_191122_f + 1, 3);
            this.field_191118_b.func_191142_a(this.field_191121_e - 1, this.field_191122_f, this.field_191121_e - 1, this.field_191122_f + 1, 2);
            this.field_191118_b.func_191142_a(this.field_191121_e + 2, this.field_191122_f - 2, this.field_191121_e + 3, this.field_191122_f + 3, 5);
            this.field_191118_b.func_191142_a(this.field_191121_e + 1, this.field_191122_f - 2, this.field_191121_e + 1, this.field_191122_f - 1, 1);
            this.field_191118_b.func_191142_a(this.field_191121_e + 1, this.field_191122_f + 2, this.field_191121_e + 1, this.field_191122_f + 3, 1);
            this.field_191118_b.func_191144_a(this.field_191121_e - 1, this.field_191122_f - 1, 1);
            this.field_191118_b.func_191144_a(this.field_191121_e - 1, this.field_191122_f + 2, 1);
            this.field_191118_b.func_191142_a(0, 0, 11, 1, 5);
            this.field_191118_b.func_191142_a(0, 9, 11, 11, 5);
            this.func_191110_a(this.field_191118_b, this.field_191121_e, this.field_191122_f - 2, EnumFacing.WEST, 6);
            this.func_191110_a(this.field_191118_b, this.field_191121_e, this.field_191122_f + 3, EnumFacing.WEST, 6);
            this.func_191110_a(this.field_191118_b, this.field_191121_e - 2, this.field_191122_f - 1, EnumFacing.WEST, 3);
            this.func_191110_a(this.field_191118_b, this.field_191121_e - 2, this.field_191122_f + 2, EnumFacing.WEST, 3);
            while (this.func_191111_a(this.field_191118_b)) {
            }
            this.field_191120_d = new SimpleGrid[3];
            this.field_191120_d[0] = new SimpleGrid(11, 11, 5);
            this.field_191120_d[1] = new SimpleGrid(11, 11, 5);
            this.field_191120_d[2] = new SimpleGrid(11, 11, 5);
            this.func_191116_a(this.field_191118_b, this.field_191120_d[0]);
            this.func_191116_a(this.field_191118_b, this.field_191120_d[1]);
            this.field_191120_d[0].func_191142_a(this.field_191121_e + 1, this.field_191122_f, this.field_191121_e + 1, this.field_191122_f + 1, 0x800000);
            this.field_191120_d[1].func_191142_a(this.field_191121_e + 1, this.field_191122_f, this.field_191121_e + 1, this.field_191122_f + 1, 0x800000);
            this.field_191119_c = new SimpleGrid(this.field_191118_b.field_191149_b, this.field_191118_b.field_191150_c, 5);
            this.func_191115_b();
            this.func_191116_a(this.field_191119_c, this.field_191120_d[2]);
        }

        public static boolean func_191109_a(SimpleGrid simpleGrid, int n, int n2) {
            \u2603 = simpleGrid.func_191145_a(n, n2);
            return \u2603 == 1 || \u2603 == 2 || \u2603 == 3 || \u2603 == 4;
        }

        public boolean func_191114_a(SimpleGrid simpleGrid, int n, int n2, int n3, int n4) {
            return (this.field_191120_d[n3].func_191145_a(n, n2) & 0xFFFF) == n4;
        }

        @Nullable
        public EnumFacing func_191113_b(SimpleGrid simpleGrid, int n, int n2, int n3, int n4) {
            for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                if (!this.func_191114_a(simpleGrid, n + enumFacing.func_82601_c(), n2 + enumFacing.func_82599_e(), n3, n4)) continue;
                return enumFacing;
            }
            return null;
        }

        private void func_191110_a(SimpleGrid simpleGrid, int n, int n2, EnumFacing enumFacing, int n3) {
            if (n3 <= 0) {
                return;
            }
            simpleGrid.func_191144_a(n, n2, 1);
            simpleGrid.func_197588_a(n + enumFacing.func_82601_c(), n2 + enumFacing.func_82599_e(), 0, 1);
            for (\u2603 = 0; \u2603 < 8; ++\u2603) {
                EnumFacing enumFacing2 = EnumFacing.func_176731_b(this.field_191117_a.nextInt(4));
                if (enumFacing2 == enumFacing.func_176734_d() || enumFacing2 == EnumFacing.EAST && this.field_191117_a.nextBoolean()) continue;
                int \u26032 = n + enumFacing.func_82601_c();
                int \u26033 = n2 + enumFacing.func_82599_e();
                if (simpleGrid.func_191145_a(\u26032 + enumFacing2.func_82601_c(), \u26033 + enumFacing2.func_82599_e()) != 0 || simpleGrid.func_191145_a(\u26032 + enumFacing2.func_82601_c() * 2, \u26033 + enumFacing2.func_82599_e() * 2) != 0) continue;
                this.func_191110_a(simpleGrid, n + enumFacing.func_82601_c() + enumFacing2.func_82601_c(), n2 + enumFacing.func_82599_e() + enumFacing2.func_82599_e(), enumFacing2, n3 - 1);
                break;
            }
            \u2603 = enumFacing.func_176746_e();
            enumFacing2 = enumFacing.func_176735_f();
            simpleGrid.func_197588_a(n + \u2603.func_82601_c(), n2 + \u2603.func_82599_e(), 0, 2);
            simpleGrid.func_197588_a(n + enumFacing2.func_82601_c(), n2 + enumFacing2.func_82599_e(), 0, 2);
            simpleGrid.func_197588_a(n + enumFacing.func_82601_c() + \u2603.func_82601_c(), n2 + enumFacing.func_82599_e() + \u2603.func_82599_e(), 0, 2);
            simpleGrid.func_197588_a(n + enumFacing.func_82601_c() + enumFacing2.func_82601_c(), n2 + enumFacing.func_82599_e() + enumFacing2.func_82599_e(), 0, 2);
            simpleGrid.func_197588_a(n + enumFacing.func_82601_c() * 2, n2 + enumFacing.func_82599_e() * 2, 0, 2);
            simpleGrid.func_197588_a(n + \u2603.func_82601_c() * 2, n2 + \u2603.func_82599_e() * 2, 0, 2);
            simpleGrid.func_197588_a(n + enumFacing2.func_82601_c() * 2, n2 + enumFacing2.func_82599_e() * 2, 0, 2);
        }

        private boolean func_191111_a(SimpleGrid simpleGrid) {
            boolean \u26032 = false;
            for (int i = 0; i < simpleGrid.field_191150_c; ++i) {
                for (\u2603 = 0; \u2603 < simpleGrid.field_191149_b; ++\u2603) {
                    int n;
                    if (simpleGrid.func_191145_a(\u2603, i) != 0) continue;
                    n = 0;
                    n += Grid.func_191109_a(simpleGrid, \u2603 + 1, i) ? 1 : 0;
                    n += Grid.func_191109_a(simpleGrid, \u2603 - 1, i) ? 1 : 0;
                    n += Grid.func_191109_a(simpleGrid, \u2603, i + 1) ? 1 : 0;
                    if ((n += Grid.func_191109_a(simpleGrid, \u2603, i - 1) ? 1 : 0) >= 3) {
                        simpleGrid.func_191144_a(\u2603, i, 2);
                        \u26032 = true;
                        continue;
                    }
                    if (n != 2) continue;
                    \u2603 = 0;
                    \u2603 += Grid.func_191109_a(simpleGrid, \u2603 + 1, i + 1) ? 1 : 0;
                    \u2603 += Grid.func_191109_a(simpleGrid, \u2603 - 1, i + 1) ? 1 : 0;
                    \u2603 += Grid.func_191109_a(simpleGrid, \u2603 + 1, i - 1) ? 1 : 0;
                    if ((\u2603 += Grid.func_191109_a(simpleGrid, \u2603 - 1, i - 1) ? 1 : 0) > 1) continue;
                    simpleGrid.func_191144_a(\u2603, i, 2);
                    \u26032 = true;
                }
            }
            return \u26032;
        }

        private void func_191115_b() {
            ArrayList arrayList = Lists.newArrayList();
            SimpleGrid \u26032 = this.field_191120_d[1];
            for (int i = 0; i < this.field_191119_c.field_191150_c; ++i) {
                for (\u26034 = 0; \u26034 < this.field_191119_c.field_191149_b; ++\u26034) {
                    \u2603 = \u26032.func_191145_a(\u26034, i);
                    \u26036 = \u2603 & 0xF0000;
                    if (\u26036 != 131072 || (\u2603 & 0x200000) != 0x200000) continue;
                    arrayList.add(new Tuple<Integer, Integer>(\u26034, i));
                }
            }
            if (arrayList.isEmpty()) {
                this.field_191119_c.func_191142_a(0, 0, this.field_191119_c.field_191149_b, this.field_191119_c.field_191150_c, 5);
                return;
            }
            Tuple \u26033 = (Tuple)arrayList.get(this.field_191117_a.nextInt(arrayList.size()));
            int \u26034 = \u26032.func_191145_a((Integer)\u26033.func_76341_a(), (Integer)\u26033.func_76340_b());
            \u26032.func_191144_a((Integer)\u26033.func_76341_a(), (Integer)\u26033.func_76340_b(), \u26034 | 0x400000);
            EnumFacing \u26035 = this.func_191113_b(this.field_191118_b, (Integer)\u26033.func_76341_a(), (Integer)\u26033.func_76340_b(), 1, \u26034 & 0xFFFF);
            int \u26036 = (Integer)\u26033.func_76341_a() + \u26035.func_82601_c();
            int \u26037 = (Integer)\u26033.func_76340_b() + \u26035.func_82599_e();
            for (int i = 0; i < this.field_191119_c.field_191150_c; ++i) {
                for (\u26038 = 0; \u26038 < this.field_191119_c.field_191149_b; ++\u26038) {
                    if (!Grid.func_191109_a(this.field_191118_b, \u26038, i)) {
                        this.field_191119_c.func_191144_a(\u26038, i, 5);
                        continue;
                    }
                    if (\u26038 == (Integer)\u26033.func_76341_a() && i == (Integer)\u26033.func_76340_b()) {
                        this.field_191119_c.func_191144_a(\u26038, i, 3);
                        continue;
                    }
                    if (\u26038 != \u26036 || i != \u26037) continue;
                    this.field_191119_c.func_191144_a(\u26038, i, 3);
                    this.field_191120_d[2].func_191144_a(\u26038, i, 0x800000);
                }
            }
            ArrayList arrayList2 = Lists.newArrayList();
            for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                if (this.field_191119_c.func_191145_a(\u26036 + enumFacing.func_82601_c(), \u26037 + enumFacing.func_82599_e()) != 0) continue;
                arrayList2.add(enumFacing);
            }
            if (arrayList2.isEmpty()) {
                this.field_191119_c.func_191142_a(0, 0, this.field_191119_c.field_191149_b, this.field_191119_c.field_191150_c, 5);
                \u26032.func_191144_a((Integer)\u26033.func_76341_a(), (Integer)\u26033.func_76340_b(), \u26034);
                return;
            }
            EnumFacing \u26038 = (EnumFacing)arrayList2.get(this.field_191117_a.nextInt(arrayList2.size()));
            this.func_191110_a(this.field_191119_c, \u26036 + \u26038.func_82601_c(), \u26037 + \u26038.func_82599_e(), \u26038, 4);
            while (this.func_191111_a(this.field_191119_c)) {
            }
        }

        private void func_191116_a(SimpleGrid simpleGrid, SimpleGrid simpleGrid2) {
            int \u26032;
            ArrayList arrayList = Lists.newArrayList();
            for (\u26032 = 0; \u26032 < simpleGrid.field_191150_c; ++\u26032) {
                for (\u2603 = 0; \u2603 < simpleGrid.field_191149_b; ++\u2603) {
                    if (simpleGrid.func_191145_a(\u2603, \u26032) != 2) continue;
                    arrayList.add(new Tuple<Integer, Integer>(\u2603, \u26032));
                }
            }
            Collections.shuffle(arrayList, this.field_191117_a);
            \u26032 = 10;
            for (Tuple tuple : arrayList) {
                int n = (Integer)tuple.func_76341_a();
                if (simpleGrid2.func_191145_a(n, \u2603 = ((Integer)tuple.func_76340_b()).intValue()) != 0) continue;
                \u2603 = n;
                \u2603 = n;
                \u2603 = \u2603;
                \u2603 = \u2603;
                \u2603 = 65536;
                if (simpleGrid2.func_191145_a(n + 1, \u2603) == 0 && simpleGrid2.func_191145_a(n, \u2603 + 1) == 0 && simpleGrid2.func_191145_a(n + 1, \u2603 + 1) == 0 && simpleGrid.func_191145_a(n + 1, \u2603) == 2 && simpleGrid.func_191145_a(n, \u2603 + 1) == 2 && simpleGrid.func_191145_a(n + 1, \u2603 + 1) == 2) {
                    ++\u2603;
                    ++\u2603;
                    \u2603 = 262144;
                } else if (simpleGrid2.func_191145_a(n - 1, \u2603) == 0 && simpleGrid2.func_191145_a(n, \u2603 + 1) == 0 && simpleGrid2.func_191145_a(n - 1, \u2603 + 1) == 0 && simpleGrid.func_191145_a(n - 1, \u2603) == 2 && simpleGrid.func_191145_a(n, \u2603 + 1) == 2 && simpleGrid.func_191145_a(n - 1, \u2603 + 1) == 2) {
                    --\u2603;
                    ++\u2603;
                    \u2603 = 262144;
                } else if (simpleGrid2.func_191145_a(n - 1, \u2603) == 0 && simpleGrid2.func_191145_a(n, \u2603 - 1) == 0 && simpleGrid2.func_191145_a(n - 1, \u2603 - 1) == 0 && simpleGrid.func_191145_a(n - 1, \u2603) == 2 && simpleGrid.func_191145_a(n, \u2603 - 1) == 2 && simpleGrid.func_191145_a(n - 1, \u2603 - 1) == 2) {
                    --\u2603;
                    --\u2603;
                    \u2603 = 262144;
                } else if (simpleGrid2.func_191145_a(n + 1, \u2603) == 0 && simpleGrid.func_191145_a(n + 1, \u2603) == 2) {
                    ++\u2603;
                    \u2603 = 131072;
                } else if (simpleGrid2.func_191145_a(n, \u2603 + 1) == 0 && simpleGrid.func_191145_a(n, \u2603 + 1) == 2) {
                    ++\u2603;
                    \u2603 = 131072;
                } else if (simpleGrid2.func_191145_a(n - 1, \u2603) == 0 && simpleGrid.func_191145_a(n - 1, \u2603) == 2) {
                    --\u2603;
                    \u2603 = 131072;
                } else if (simpleGrid2.func_191145_a(n, \u2603 - 1) == 0 && simpleGrid.func_191145_a(n, \u2603 - 1) == 2) {
                    --\u2603;
                    \u2603 = 131072;
                }
                \u2603 = this.field_191117_a.nextBoolean() ? \u2603 : \u2603;
                \u2603 = this.field_191117_a.nextBoolean() ? \u2603 : \u2603;
                \u2603 = 0x200000;
                if (!simpleGrid.func_191147_b(\u2603, \u2603, 1)) {
                    \u2603 = \u2603 == \u2603 ? \u2603 : \u2603;
                    int n2 = \u2603 = \u2603 == \u2603 ? \u2603 : \u2603;
                    if (!simpleGrid.func_191147_b(\u2603, \u2603, 1)) {
                        int n3 = \u2603 = \u2603 == \u2603 ? \u2603 : \u2603;
                        if (!simpleGrid.func_191147_b(\u2603, \u2603, 1)) {
                            \u2603 = \u2603 == \u2603 ? \u2603 : \u2603;
                            int n4 = \u2603 = \u2603 == \u2603 ? \u2603 : \u2603;
                            if (!simpleGrid.func_191147_b(\u2603, \u2603, 1)) {
                                \u2603 = 0;
                                \u2603 = \u2603;
                                \u2603 = \u2603;
                            }
                        }
                    }
                }
                for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                    for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                        if (\u2603 == \u2603 && \u2603 == \u2603) {
                            simpleGrid2.func_191144_a(\u2603, \u2603, 0x100000 | \u2603 | \u2603 | \u26032);
                            continue;
                        }
                        simpleGrid2.func_191144_a(\u2603, \u2603, \u2603 | \u26032);
                    }
                }
                ++\u26032;
            }
        }
    }

    static class Placer {
        private final TemplateManager field_191134_a;
        private final Random field_191135_b;
        private int field_191136_c;
        private int field_191137_d;

        public Placer(TemplateManager templateManager, Random random) {
            this.field_191134_a = templateManager;
            this.field_191135_b = random;
        }

        public void func_191125_a(BlockPos blockPos, Rotation rotation, List<MansionTemplate> list2, Grid grid) {
            List<MansionTemplate> list2;
            PlacementData placementData = new PlacementData();
            placementData.field_191139_b = blockPos;
            placementData.field_191138_a = rotation;
            placementData.field_191140_c = "wall_flat";
            \u2603 = new PlacementData();
            this.func_191133_a(list2, placementData);
            \u2603.field_191139_b = placementData.field_191139_b.func_177981_b(8);
            \u2603.field_191138_a = placementData.field_191138_a;
            \u2603.field_191140_c = "wall_window";
            if (!list2.isEmpty()) {
                // empty if block
            }
            SimpleGrid \u26032 = grid.field_191118_b;
            SimpleGrid \u26033 = grid.field_191119_c;
            this.field_191136_c = grid.field_191121_e + 1;
            this.field_191137_d = grid.field_191122_f + 1;
            int \u26034 = grid.field_191121_e + 1;
            int \u26035 = grid.field_191122_f;
            this.func_191130_a(list2, placementData, \u26032, EnumFacing.SOUTH, this.field_191136_c, this.field_191137_d, \u26034, \u26035);
            this.func_191130_a(list2, \u2603, \u26032, EnumFacing.SOUTH, this.field_191136_c, this.field_191137_d, \u26034, \u26035);
            \u2603 = new PlacementData();
            \u2603.field_191139_b = placementData.field_191139_b.func_177981_b(19);
            \u2603.field_191138_a = placementData.field_191138_a;
            \u2603.field_191140_c = "wall_window";
            boolean \u26036 = false;
            for (int i = 0; i < \u26033.field_191150_c && !\u26036; ++i) {
                for (i = \u26033.field_191149_b - 1; i >= 0 && !\u26036; --i) {
                    if (!Grid.func_191109_a(\u26033, i, i)) continue;
                    \u2603.field_191139_b = \u2603.field_191139_b.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8 + (i - this.field_191137_d) * 8);
                    \u2603.field_191139_b = \u2603.field_191139_b.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), (i - this.field_191136_c) * 8);
                    this.func_191131_b(list2, \u2603);
                    this.func_191130_a(list2, \u2603, \u26033, EnumFacing.SOUTH, i, i, i, i);
                    \u26036 = true;
                }
            }
            this.func_191123_a(list2, blockPos.func_177981_b(16), rotation, \u26032, \u26033);
            this.func_191123_a(list2, blockPos.func_177981_b(27), rotation, \u26033, null);
            if (!list2.isEmpty()) {
                // empty if block
            }
            RoomCollection[] \u26037 = new RoomCollection[]{new FirstFloor(), new SecondFloor(), new ThirdFloor()};
            for (int i = 0; i < 3; ++i) {
                Object \u260314;
                BlockPos blockPos2 = blockPos.func_177981_b(8 * i + (i == 2 ? 3 : 0));
                SimpleGrid \u26038 = grid.field_191120_d[i];
                SimpleGrid \u26039 = i == 2 ? \u26033 : \u26032;
                String \u260310 = i == 0 ? "carpet_south_1" : "carpet_south_2";
                String \u260311 = i == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int j = 0; j < \u26039.field_191150_c; ++j) {
                    for (\u2603 = 0; \u2603 < \u26039.field_191149_b; ++\u2603) {
                        if (\u26039.func_191145_a(\u2603, j) != 1) continue;
                        \u260314 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8 + (j - this.field_191137_d) * 8);
                        \u260314 = ((BlockPos)\u260314).func_177967_a(rotation.func_185831_a(EnumFacing.EAST), (\u2603 - this.field_191136_c) * 8);
                        list2.add(new MansionTemplate(this.field_191134_a, "corridor_floor", (BlockPos)\u260314, rotation));
                        if (\u26039.func_191145_a(\u2603, j - 1) == 1 || (\u26038.func_191145_a(\u2603, j - 1) & 0x800000) == 0x800000) {
                            list2.add(new MansionTemplate(this.field_191134_a, "carpet_north", ((BlockPos)\u260314).func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1).func_177984_a(), rotation));
                        }
                        if (\u26039.func_191145_a(\u2603 + 1, j) == 1 || (\u26038.func_191145_a(\u2603 + 1, j) & 0x800000) == 0x800000) {
                            list2.add(new MansionTemplate(this.field_191134_a, "carpet_east", ((BlockPos)\u260314).func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 1).func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 5).func_177984_a(), rotation));
                        }
                        if (\u26039.func_191145_a(\u2603, j + 1) == 1 || (\u26038.func_191145_a(\u2603, j + 1) & 0x800000) == 0x800000) {
                            list2.add(new MansionTemplate(this.field_191134_a, \u260310, ((BlockPos)\u260314).func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 5).func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 1), rotation));
                        }
                        if (\u26039.func_191145_a(\u2603 - 1, j) != 1 && (\u26038.func_191145_a(\u2603 - 1, j) & 0x800000) != 0x800000) continue;
                        list2.add(new MansionTemplate(this.field_191134_a, \u260311, ((BlockPos)\u260314).func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 1).func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 1), rotation));
                    }
                }
                String \u260312 = i == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String \u260313 = i == 0 ? "indoors_door_1" : "indoors_door_2";
                \u260314 = Lists.newArrayList();
                for (\u2603 = 0; \u2603 < \u26039.field_191150_c; ++\u2603) {
                    for (n2 = 0; n2 < \u26039.field_191149_b; ++n2) {
                        int n;
                        int n2;
                        Object object;
                        Object \u2603152;
                        boolean bl = bl2 = i == 2 && \u26039.func_191145_a(n2, \u2603) == 3;
                        if (\u26039.func_191145_a(n2, \u2603) != 2 && !bl2) continue;
                        \u2603 = \u26038.func_191145_a(n2, \u2603);
                        n = \u2603 & 0xF0000;
                        \u2603 = \u2603 & 0xFFFF;
                        boolean bl2 = bl2 && (\u2603 & 0x800000) == 0x800000;
                        \u260314.clear();
                        if ((\u2603 & 0x200000) == 0x200000) {
                            for (Object \u2603152 : EnumFacing.Plane.HORIZONTAL) {
                                if (\u26039.func_191145_a(n2 + ((EnumFacing)\u2603152).func_82601_c(), \u2603 + ((EnumFacing)\u2603152).func_82599_e()) != 1) continue;
                                \u260314.add(\u2603152);
                            }
                        }
                        EnumFacing enumFacing = null;
                        if (!\u260314.isEmpty()) {
                            enumFacing = (EnumFacing)\u260314.get(this.field_191135_b.nextInt(\u260314.size()));
                        } else if ((\u2603 & 0x100000) == 0x100000) {
                            enumFacing = EnumFacing.UP;
                        }
                        \u2603152 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8 + (\u2603 - this.field_191137_d) * 8);
                        \u2603152 = ((BlockPos)\u2603152).func_177967_a(rotation.func_185831_a(EnumFacing.EAST), -1 + (n2 - this.field_191136_c) * 8);
                        if (Grid.func_191109_a(\u26039, n2 - 1, \u2603) && !grid.func_191114_a(\u26039, n2 - 1, \u2603, i, \u2603)) {
                            list2.add(new MansionTemplate(this.field_191134_a, enumFacing == EnumFacing.WEST ? \u260313 : \u260312, (BlockPos)\u2603152, rotation));
                        }
                        if (\u26039.func_191145_a(n2 + 1, \u2603) == 1 && !bl2) {
                            object = ((BlockPos)\u2603152).func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 8);
                            list2.add(new MansionTemplate(this.field_191134_a, enumFacing == EnumFacing.EAST ? \u260313 : \u260312, (BlockPos)object, rotation));
                        }
                        if (Grid.func_191109_a(\u26039, n2, \u2603 + 1) && !grid.func_191114_a(\u26039, n2, \u2603 + 1, i, \u2603)) {
                            object = ((BlockPos)\u2603152).func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 7);
                            object = ((BlockPos)object).func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                            list2.add(new MansionTemplate(this.field_191134_a, enumFacing == EnumFacing.SOUTH ? \u260313 : \u260312, (BlockPos)object, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
                        }
                        if (\u26039.func_191145_a(n2, \u2603 - 1) == 1 && !bl2) {
                            object = ((BlockPos)\u2603152).func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 1);
                            object = ((BlockPos)object).func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                            list2.add(new MansionTemplate(this.field_191134_a, enumFacing == EnumFacing.NORTH ? \u260313 : \u260312, (BlockPos)object, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
                        }
                        if (n == 65536) {
                            this.func_191129_a(list2, (BlockPos)\u2603152, rotation, enumFacing, \u26037[i]);
                            continue;
                        }
                        if (n == 131072 && enumFacing != null) {
                            object = grid.func_191113_b(\u26039, n2, \u2603, i, \u2603);
                            boolean \u260316 = (\u2603 & 0x400000) == 0x400000;
                            this.func_191132_a(list2, (BlockPos)\u2603152, rotation, (EnumFacing)object, enumFacing, \u26037[i], \u260316);
                            continue;
                        }
                        if (n == 262144 && enumFacing != null && enumFacing != EnumFacing.UP) {
                            object = enumFacing.func_176746_e();
                            if (!grid.func_191114_a(\u26039, n2 + ((EnumFacing)object).func_82601_c(), \u2603 + ((EnumFacing)object).func_82599_e(), i, \u2603)) {
                                object = ((EnumFacing)object).func_176734_d();
                            }
                            this.func_191127_a(list2, (BlockPos)\u2603152, rotation, (EnumFacing)object, enumFacing, \u26037[i]);
                            continue;
                        }
                        if (n != 262144 || enumFacing != EnumFacing.UP) continue;
                        this.func_191128_a(list2, (BlockPos)\u2603152, rotation, \u26037[i]);
                    }
                }
            }
        }

        private void func_191130_a(List<MansionTemplate> list, PlacementData placementData, SimpleGrid simpleGrid, EnumFacing enumFacing, int n, int n2, int n3, int n4) {
            \u2603 = n;
            \u2603 = n2;
            EnumFacing enumFacing2 = enumFacing;
            do {
                if (!Grid.func_191109_a(simpleGrid, \u2603 + enumFacing.func_82601_c(), \u2603 + enumFacing.func_82599_e())) {
                    this.func_191124_c(list, placementData);
                    enumFacing = enumFacing.func_176746_e();
                    if (\u2603 == n3 && \u2603 == n4 && enumFacing2 == enumFacing) continue;
                    this.func_191131_b(list, placementData);
                    continue;
                }
                if (Grid.func_191109_a(simpleGrid, \u2603 + enumFacing.func_82601_c(), \u2603 + enumFacing.func_82599_e()) && Grid.func_191109_a(simpleGrid, \u2603 + enumFacing.func_82601_c() + enumFacing.func_176735_f().func_82601_c(), \u2603 + enumFacing.func_82599_e() + enumFacing.func_176735_f().func_82599_e())) {
                    this.func_191126_d(list, placementData);
                    \u2603 += enumFacing.func_82601_c();
                    \u2603 += enumFacing.func_82599_e();
                    enumFacing = enumFacing.func_176735_f();
                    continue;
                }
                if ((\u2603 += enumFacing.func_82601_c()) == n3 && (\u2603 += enumFacing.func_82599_e()) == n4 && enumFacing2 == enumFacing) continue;
                this.func_191131_b(list, placementData);
            } while (\u2603 != n3 || \u2603 != n4 || enumFacing2 != enumFacing);
        }

        private void func_191123_a(List<MansionTemplate> list, BlockPos blockPos, Rotation rotation, SimpleGrid simpleGrid, @Nullable SimpleGrid simpleGrid22) {
            boolean \u26032;
            SimpleGrid simpleGrid22;
            BlockPos blockPos2;
            int n;
            for (n = 0; n < simpleGrid.field_191150_c; ++n) {
                for (\u2603 = 0; \u2603 < simpleGrid.field_191149_b; ++\u2603) {
                    blockPos2 = blockPos;
                    blockPos2 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8 + (n - this.field_191137_d) * 8);
                    blockPos2 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), (\u2603 - this.field_191136_c) * 8);
                    boolean bl = \u26032 = simpleGrid22 != null && Grid.func_191109_a(simpleGrid22, \u2603, n);
                    if (!Grid.func_191109_a(simpleGrid, \u2603, n) || \u26032) continue;
                    list.add(new MansionTemplate(this.field_191134_a, "roof", blockPos2.func_177981_b(3), rotation));
                    if (!Grid.func_191109_a(simpleGrid, \u2603 + 1, n)) {
                        \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 6);
                        list.add(new MansionTemplate(this.field_191134_a, "roof_front", \u2603, rotation));
                    }
                    if (!Grid.func_191109_a(simpleGrid, \u2603 - 1, n)) {
                        \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 0);
                        \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 7);
                        list.add(new MansionTemplate(this.field_191134_a, "roof_front", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_180)));
                    }
                    if (!Grid.func_191109_a(simpleGrid, \u2603, n - 1)) {
                        \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 1);
                        list.add(new MansionTemplate(this.field_191134_a, "roof_front", \u2603, rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (Grid.func_191109_a(simpleGrid, \u2603, n + 1)) continue;
                    \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 6);
                    \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                    list.add(new MansionTemplate(this.field_191134_a, "roof_front", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
                }
            }
            if (simpleGrid22 != null) {
                for (n = 0; n < simpleGrid.field_191150_c; ++n) {
                    for (\u2603 = 0; \u2603 < simpleGrid.field_191149_b; ++\u2603) {
                        blockPos2 = blockPos;
                        blockPos2 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8 + (n - this.field_191137_d) * 8);
                        blockPos2 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), (\u2603 - this.field_191136_c) * 8);
                        \u26032 = Grid.func_191109_a(simpleGrid22, \u2603, n);
                        if (!Grid.func_191109_a(simpleGrid, \u2603, n) || !\u26032) continue;
                        if (!Grid.func_191109_a(simpleGrid, \u2603 + 1, n)) {
                            \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                            list.add(new MansionTemplate(this.field_191134_a, "small_wall", \u2603, rotation));
                        }
                        if (!Grid.func_191109_a(simpleGrid, \u2603 - 1, n)) {
                            \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 1);
                            \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                            list.add(new MansionTemplate(this.field_191134_a, "small_wall", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_180)));
                        }
                        if (!Grid.func_191109_a(simpleGrid, \u2603, n - 1)) {
                            \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 0);
                            \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 1);
                            list.add(new MansionTemplate(this.field_191134_a, "small_wall", \u2603, rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (!Grid.func_191109_a(simpleGrid, \u2603, n + 1)) {
                            \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 6);
                            \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 7);
                            list.add(new MansionTemplate(this.field_191134_a, "small_wall", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
                        }
                        if (!Grid.func_191109_a(simpleGrid, \u2603 + 1, n)) {
                            if (!Grid.func_191109_a(simpleGrid, \u2603, n - 1)) {
                                \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                                \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 2);
                                list.add(new MansionTemplate(this.field_191134_a, "small_wall_corner", \u2603, rotation));
                            }
                            if (!Grid.func_191109_a(simpleGrid, \u2603, n + 1)) {
                                \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 8);
                                \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 7);
                                list.add(new MansionTemplate(this.field_191134_a, "small_wall_corner", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
                            }
                        }
                        if (Grid.func_191109_a(simpleGrid, \u2603 - 1, n)) continue;
                        if (!Grid.func_191109_a(simpleGrid, \u2603, n - 1)) {
                            \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 2);
                            \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 1);
                            list.add(new MansionTemplate(this.field_191134_a, "small_wall_corner", \u2603, rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (Grid.func_191109_a(simpleGrid, \u2603, n + 1)) continue;
                        \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 1);
                        \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8);
                        list.add(new MansionTemplate(this.field_191134_a, "small_wall_corner", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_180)));
                    }
                }
            }
            for (n = 0; n < simpleGrid.field_191150_c; ++n) {
                for (\u2603 = 0; \u2603 < simpleGrid.field_191149_b; ++\u2603) {
                    blockPos2 = blockPos;
                    blockPos2 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8 + (n - this.field_191137_d) * 8);
                    blockPos2 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), (\u2603 - this.field_191136_c) * 8);
                    boolean bl = \u26032 = simpleGrid22 != null && Grid.func_191109_a(simpleGrid22, \u2603, n);
                    if (!Grid.func_191109_a(simpleGrid, \u2603, n) || \u26032) continue;
                    if (!Grid.func_191109_a(simpleGrid, \u2603 + 1, n)) {
                        \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 6);
                        if (!Grid.func_191109_a(simpleGrid, \u2603, n + 1)) {
                            \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                            list.add(new MansionTemplate(this.field_191134_a, "roof_corner", \u2603, rotation));
                        } else if (Grid.func_191109_a(simpleGrid, \u2603 + 1, n + 1)) {
                            \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 5);
                            list.add(new MansionTemplate(this.field_191134_a, "roof_inner_corner", \u2603, rotation));
                        }
                        if (!Grid.func_191109_a(simpleGrid, \u2603, n - 1)) {
                            list.add(new MansionTemplate(this.field_191134_a, "roof_corner", \u2603, rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90)));
                        } else if (Grid.func_191109_a(simpleGrid, \u2603 + 1, n - 1)) {
                            \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 9);
                            \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 2);
                            list.add(new MansionTemplate(this.field_191134_a, "roof_inner_corner", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
                        }
                    }
                    if (Grid.func_191109_a(simpleGrid, \u2603 - 1, n)) continue;
                    \u2603 = blockPos2.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 0);
                    \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 0);
                    if (!Grid.func_191109_a(simpleGrid, \u2603, n + 1)) {
                        \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                        list.add(new MansionTemplate(this.field_191134_a, "roof_corner", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
                    } else if (Grid.func_191109_a(simpleGrid, \u2603 - 1, n + 1)) {
                        \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 8);
                        \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 3);
                        list.add(new MansionTemplate(this.field_191134_a, "roof_inner_corner", \u2603, rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (!Grid.func_191109_a(simpleGrid, \u2603, n - 1)) {
                        list.add(new MansionTemplate(this.field_191134_a, "roof_corner", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_180)));
                        continue;
                    }
                    if (!Grid.func_191109_a(simpleGrid, \u2603 - 1, n - 1)) continue;
                    \u2603 = \u2603.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 1);
                    list.add(new MansionTemplate(this.field_191134_a, "roof_inner_corner", \u2603, rotation.func_185830_a(Rotation.CLOCKWISE_180)));
                }
            }
        }

        private void func_191133_a(List<MansionTemplate> list, PlacementData placementData) {
            EnumFacing enumFacing = placementData.field_191138_a.func_185831_a(EnumFacing.WEST);
            list.add(new MansionTemplate(this.field_191134_a, "entrance", placementData.field_191139_b.func_177967_a(enumFacing, 9), placementData.field_191138_a));
            placementData.field_191139_b = placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.SOUTH), 16);
        }

        private void func_191131_b(List<MansionTemplate> list, PlacementData placementData) {
            list.add(new MansionTemplate(this.field_191134_a, placementData.field_191140_c, placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.EAST), 7), placementData.field_191138_a));
            placementData.field_191139_b = placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.SOUTH), 8);
        }

        private void func_191124_c(List<MansionTemplate> list, PlacementData placementData) {
            placementData.field_191139_b = placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.SOUTH), -1);
            list.add(new MansionTemplate(this.field_191134_a, "wall_corner", placementData.field_191139_b, placementData.field_191138_a));
            placementData.field_191139_b = placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.SOUTH), -7);
            placementData.field_191139_b = placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.WEST), -6);
            placementData.field_191138_a = placementData.field_191138_a.func_185830_a(Rotation.CLOCKWISE_90);
        }

        private void func_191126_d(List<MansionTemplate> list, PlacementData placementData) {
            placementData.field_191139_b = placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.SOUTH), 6);
            placementData.field_191139_b = placementData.field_191139_b.func_177967_a(placementData.field_191138_a.func_185831_a(EnumFacing.EAST), 8);
            placementData.field_191138_a = placementData.field_191138_a.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
        }

        private void func_191129_a(List<MansionTemplate> list, BlockPos blockPos, Rotation rotation, EnumFacing enumFacing, RoomCollection roomCollection) {
            Rotation rotation2 = Rotation.NONE;
            String \u26032 = roomCollection.func_191104_a(this.field_191135_b);
            if (enumFacing != EnumFacing.EAST) {
                if (enumFacing == EnumFacing.NORTH) {
                    rotation2 = rotation2.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
                } else if (enumFacing == EnumFacing.WEST) {
                    rotation2 = rotation2.func_185830_a(Rotation.CLOCKWISE_180);
                } else if (enumFacing == EnumFacing.SOUTH) {
                    rotation2 = rotation2.func_185830_a(Rotation.CLOCKWISE_90);
                } else {
                    \u26032 = roomCollection.func_191099_b(this.field_191135_b);
                }
            }
            BlockPos \u26033 = Template.func_191157_a(new BlockPos(1, 0, 0), Mirror.NONE, rotation2, 7, 7);
            rotation2 = rotation2.func_185830_a(rotation);
            \u26033 = \u26033.func_190942_a(rotation);
            BlockPos \u26034 = blockPos.func_177982_a(\u26033.func_177958_n(), 0, \u26033.func_177952_p());
            list.add(new MansionTemplate(this.field_191134_a, \u26032, \u26034, rotation2));
        }

        private void func_191132_a(List<MansionTemplate> list, BlockPos blockPos, Rotation rotation, EnumFacing enumFacing, EnumFacing enumFacing22, RoomCollection roomCollection, boolean bl) {
            EnumFacing enumFacing22;
            if (enumFacing22 == EnumFacing.EAST && enumFacing == EnumFacing.SOUTH) {
                BlockPos blockPos2 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos2, rotation));
            } else if (enumFacing22 == EnumFacing.EAST && enumFacing == EnumFacing.NORTH) {
                BlockPos blockPos3 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1);
                blockPos3 = blockPos3.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos3, rotation, Mirror.LEFT_RIGHT));
            } else if (enumFacing22 == EnumFacing.WEST && enumFacing == EnumFacing.NORTH) {
                BlockPos blockPos4 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                blockPos4 = blockPos4.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos4, rotation.func_185830_a(Rotation.CLOCKWISE_180)));
            } else if (enumFacing22 == EnumFacing.WEST && enumFacing == EnumFacing.SOUTH) {
                BlockPos blockPos5 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos5, rotation, Mirror.FRONT_BACK));
            } else if (enumFacing22 == EnumFacing.SOUTH && enumFacing == EnumFacing.EAST) {
                BlockPos blockPos6 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos6, rotation.func_185830_a(Rotation.CLOCKWISE_90), Mirror.LEFT_RIGHT));
            } else if (enumFacing22 == EnumFacing.SOUTH && enumFacing == EnumFacing.WEST) {
                BlockPos blockPos7 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos7, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
            } else if (enumFacing22 == EnumFacing.NORTH && enumFacing == EnumFacing.WEST) {
                BlockPos blockPos8 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                blockPos8 = blockPos8.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos8, rotation.func_185830_a(Rotation.CLOCKWISE_90), Mirror.FRONT_BACK));
            } else if (enumFacing22 == EnumFacing.NORTH && enumFacing == EnumFacing.EAST) {
                BlockPos blockPos9 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1);
                blockPos9 = blockPos9.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191100_a(this.field_191135_b, bl), blockPos9, rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90)));
            } else if (enumFacing22 == EnumFacing.SOUTH && enumFacing == EnumFacing.NORTH) {
                BlockPos blockPos10 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1);
                blockPos10 = blockPos10.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 8);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191098_b(this.field_191135_b, bl), blockPos10, rotation));
            } else if (enumFacing22 == EnumFacing.NORTH && enumFacing == EnumFacing.SOUTH) {
                BlockPos blockPos11 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 7);
                blockPos11 = blockPos11.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 14);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191098_b(this.field_191135_b, bl), blockPos11, rotation.func_185830_a(Rotation.CLOCKWISE_180)));
            } else if (enumFacing22 == EnumFacing.WEST && enumFacing == EnumFacing.EAST) {
                BlockPos blockPos12 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 15);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191098_b(this.field_191135_b, bl), blockPos12, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
            } else if (enumFacing22 == EnumFacing.EAST && enumFacing == EnumFacing.WEST) {
                BlockPos blockPos13 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 7);
                blockPos13 = blockPos13.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 6);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191098_b(this.field_191135_b, bl), blockPos13, rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90)));
            } else if (enumFacing22 == EnumFacing.UP && enumFacing == EnumFacing.EAST) {
                BlockPos blockPos14 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 15);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191102_c(this.field_191135_b), blockPos14, rotation.func_185830_a(Rotation.CLOCKWISE_90)));
            } else if (enumFacing22 == EnumFacing.UP && enumFacing == EnumFacing.SOUTH) {
                BlockPos blockPos15 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1);
                blockPos15 = blockPos15.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 0);
                list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191102_c(this.field_191135_b), blockPos15, rotation));
            }
        }

        private void func_191127_a(List<MansionTemplate> list, BlockPos blockPos, Rotation rotation, EnumFacing enumFacing, EnumFacing enumFacing2, RoomCollection roomCollection) {
            int n = 0;
            \u2603 = 0;
            Rotation \u26032 = rotation;
            Mirror \u26033 = Mirror.NONE;
            if (enumFacing2 == EnumFacing.EAST && enumFacing == EnumFacing.SOUTH) {
                n = -7;
            } else if (enumFacing2 == EnumFacing.EAST && enumFacing == EnumFacing.NORTH) {
                n = -7;
                \u2603 = 6;
                \u26033 = Mirror.LEFT_RIGHT;
            } else if (enumFacing2 == EnumFacing.NORTH && enumFacing == EnumFacing.EAST) {
                n = 1;
                \u2603 = 14;
                \u26032 = rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
            } else if (enumFacing2 == EnumFacing.NORTH && enumFacing == EnumFacing.WEST) {
                n = 7;
                \u2603 = 14;
                \u26032 = rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
                \u26033 = Mirror.LEFT_RIGHT;
            } else if (enumFacing2 == EnumFacing.SOUTH && enumFacing == EnumFacing.WEST) {
                n = 7;
                \u2603 = -8;
                \u26032 = rotation.func_185830_a(Rotation.CLOCKWISE_90);
            } else if (enumFacing2 == EnumFacing.SOUTH && enumFacing == EnumFacing.EAST) {
                n = 1;
                \u2603 = -8;
                \u26032 = rotation.func_185830_a(Rotation.CLOCKWISE_90);
                \u26033 = Mirror.LEFT_RIGHT;
            } else if (enumFacing2 == EnumFacing.WEST && enumFacing == EnumFacing.NORTH) {
                n = 15;
                \u2603 = 6;
                \u26032 = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            } else if (enumFacing2 == EnumFacing.WEST && enumFacing == EnumFacing.SOUTH) {
                n = 15;
                \u26033 = Mirror.FRONT_BACK;
            }
            BlockPos \u26034 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), n);
            \u26034 = \u26034.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), \u2603);
            list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191101_d(this.field_191135_b), \u26034, \u26032, \u26033));
        }

        private void func_191128_a(List<MansionTemplate> list, BlockPos blockPos, Rotation rotation, RoomCollection roomCollection) {
            BlockPos blockPos2 = blockPos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 1);
            list.add(new MansionTemplate(this.field_191134_a, roomCollection.func_191103_e(this.field_191135_b), blockPos2, rotation, Mirror.NONE));
        }
    }

    static class PlacementData {
        public Rotation field_191138_a;
        public BlockPos field_191139_b;
        public String field_191140_c;

        private PlacementData() {
        }
    }

    public static class MansionTemplate
    extends TemplateStructurePiece {
        private String field_191082_d;
        private Rotation field_191083_e;
        private Mirror field_191084_f;

        public MansionTemplate() {
        }

        public MansionTemplate(TemplateManager templateManager, String string, BlockPos blockPos, Rotation rotation) {
            this(templateManager, string, blockPos, rotation, Mirror.NONE);
        }

        public MansionTemplate(TemplateManager templateManager, String string, BlockPos blockPos, Rotation rotation, Mirror mirror) {
            super(0);
            this.field_191082_d = string;
            this.field_186178_c = blockPos;
            this.field_191083_e = rotation;
            this.field_191084_f = mirror;
            this.func_191081_a(templateManager);
        }

        private void func_191081_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(new ResourceLocation("woodland_mansion/" + this.field_191082_d));
            PlacementSettings \u26032 = new PlacementSettings().func_186222_a(true).func_186220_a(this.field_191083_e).func_186214_a(this.field_191084_f);
            this.func_186173_a(template, this.field_186178_c, \u26032);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74778_a("Template", this.field_191082_d);
            nBTTagCompound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
            nBTTagCompound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_191082_d = nBTTagCompound.func_74779_i("Template");
            this.field_191083_e = Rotation.valueOf(nBTTagCompound.func_74779_i("Rot"));
            this.field_191084_f = Mirror.valueOf(nBTTagCompound.func_74779_i("Mi"));
            this.func_191081_a(templateManager);
        }

        @Override
        protected void func_186175_a(String string, BlockPos blockPos, IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            if (string.startsWith("Chest")) {
                Rotation rotation = this.field_186177_b.func_186215_c();
                IBlockState \u26032 = Blocks.field_150486_ae.func_176223_P();
                if ("ChestWest".equals(string)) {
                    \u26032 = (IBlockState)\u26032.func_206870_a(BlockChest.field_176459_a, rotation.func_185831_a(EnumFacing.WEST));
                } else if ("ChestEast".equals(string)) {
                    \u26032 = (IBlockState)\u26032.func_206870_a(BlockChest.field_176459_a, rotation.func_185831_a(EnumFacing.EAST));
                } else if ("ChestSouth".equals(string)) {
                    \u26032 = (IBlockState)\u26032.func_206870_a(BlockChest.field_176459_a, rotation.func_185831_a(EnumFacing.SOUTH));
                } else if ("ChestNorth".equals(string)) {
                    \u26032 = (IBlockState)\u26032.func_206870_a(BlockChest.field_176459_a, rotation.func_185831_a(EnumFacing.NORTH));
                }
                this.func_191080_a(iWorld, mutableBoundingBox, random, blockPos, LootTableList.field_191192_o, \u26032);
            } else if ("Mage".equals(string)) {
                EntityEvoker \u26033 = new EntityEvoker(iWorld.func_201672_e());
                \u26033.func_110163_bv();
                \u26033.func_174828_a(blockPos, 0.0f, 0.0f);
                iWorld.func_72838_d(\u26033);
                iWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if ("Warrior".equals(string)) {
                EntityVindicator \u26034 = new EntityVindicator(iWorld.func_201672_e());
                \u26034.func_110163_bv();
                \u26034.func_174828_a(blockPos, 0.0f, 0.0f);
                \u26034.func_204210_a(iWorld.func_175649_E(new BlockPos(\u26034)), null, null);
                iWorld.func_72838_d(\u26034);
                iWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }
}

