/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePartBitSet;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.ITemplateProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public class Template {
    private final List<List<BlockInfo>> field_204769_a = Lists.newArrayList();
    private final List<EntityInfo> field_186271_b = Lists.newArrayList();
    private BlockPos field_186272_c = BlockPos.field_177992_a;
    private String field_186273_d = "?";

    public BlockPos func_186259_a() {
        return this.field_186272_c;
    }

    public void func_186252_a(String string) {
        this.field_186273_d = string;
    }

    public String func_186261_b() {
        return this.field_186273_d;
    }

    public void func_186254_a(World world2, BlockPos blockPos, BlockPos blockPos2, boolean bl, @Nullable Block block) {
        if (blockPos2.func_177958_n() < 1 || blockPos2.func_177956_o() < 1 || blockPos2.func_177952_p() < 1) {
            return;
        }
        BlockPos blockPos3 = blockPos.func_177971_a(blockPos2).func_177982_a(-1, -1, -1);
        ArrayList \u26032 = Lists.newArrayList();
        ArrayList \u26033 = Lists.newArrayList();
        ArrayList \u26034 = Lists.newArrayList();
        \u2603 = new BlockPos(Math.min(blockPos.func_177958_n(), blockPos3.func_177958_n()), Math.min(blockPos.func_177956_o(), blockPos3.func_177956_o()), Math.min(blockPos.func_177952_p(), blockPos3.func_177952_p()));
        \u2603 = new BlockPos(Math.max(blockPos.func_177958_n(), blockPos3.func_177958_n()), Math.max(blockPos.func_177956_o(), blockPos3.func_177956_o()), Math.max(blockPos.func_177952_p(), blockPos3.func_177952_p()));
        this.field_186272_c = blockPos2;
        for (BlockPos.MutableBlockPos mutableBlockPos : BlockPos.func_177975_b(\u2603, \u2603)) {
            World world2;
            BlockPos blockPos4 = mutableBlockPos.func_177973_b(\u2603);
            IBlockState \u26035 = world2.func_180495_p(mutableBlockPos);
            if (block != null && block == \u26035.func_177230_c()) continue;
            TileEntity \u26036 = world2.func_175625_s(mutableBlockPos);
            if (\u26036 != null) {
                NBTTagCompound nBTTagCompound = \u26036.func_189515_b(new NBTTagCompound());
                nBTTagCompound.func_82580_o("x");
                nBTTagCompound.func_82580_o("y");
                nBTTagCompound.func_82580_o("z");
                \u26033.add(new BlockInfo(blockPos4, \u26035, nBTTagCompound));
                continue;
            }
            if (\u26035.func_200015_d(world2, mutableBlockPos) || \u26035.func_185917_h()) {
                \u26032.add(new BlockInfo(blockPos4, \u26035, null));
                continue;
            }
            \u26034.add(new BlockInfo(blockPos4, \u26035, null));
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(\u26032);
        arrayList.addAll(\u26033);
        arrayList.addAll(\u26034);
        this.field_204769_a.clear();
        this.field_204769_a.add(arrayList);
        if (bl) {
            this.func_186255_a(world2, \u2603, \u2603.func_177982_a(1, 1, 1));
        } else {
            this.field_186271_b.clear();
        }
    }

    private void func_186255_a(World world, BlockPos blockPos, BlockPos blockPos2) {
        List<Entity> list = world.func_175647_a(Entity.class, new AxisAlignedBB(blockPos, blockPos2), entity -> !(entity instanceof EntityPlayer));
        this.field_186271_b.clear();
        for (Entity entity2 : list) {
            Vec3d vec3d = new Vec3d(entity2.field_70165_t - (double)blockPos.func_177958_n(), entity2.field_70163_u - (double)blockPos.func_177956_o(), entity2.field_70161_v - (double)blockPos.func_177952_p());
            NBTTagCompound \u26032 = new NBTTagCompound();
            entity2.func_70039_c(\u26032);
            BlockPos \u26033 = entity2 instanceof EntityPainting ? ((EntityPainting)entity2).func_174857_n().func_177973_b(blockPos) : new BlockPos(vec3d);
            this.field_186271_b.add(new EntityInfo(vec3d, \u26033, \u26032));
        }
    }

    public Map<BlockPos, String> func_186258_a(BlockPos blockPos, PlacementSettings placementSettings) {
        HashMap hashMap = Maps.newHashMap();
        MutableBoundingBox \u26032 = placementSettings.func_186213_g();
        for (BlockInfo blockInfo : placementSettings.func_204764_a(this.field_204769_a, blockPos)) {
            BlockPos blockPos2 = Template.func_186266_a(placementSettings, blockInfo.field_186242_a).func_177971_a(blockPos);
            if (\u26032 != null && !\u26032.func_175898_b(blockPos2) || (\u2603 = blockInfo.field_186243_b).func_177230_c() != Blocks.field_185779_df || blockInfo.field_186244_c == null || (\u2603 = StructureMode.valueOf(blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            hashMap.put(blockPos2, blockInfo.field_186244_c.func_74779_i("metadata"));
        }
        return hashMap;
    }

    public BlockPos func_186262_a(PlacementSettings placementSettings, BlockPos blockPos, PlacementSettings placementSettings2, BlockPos blockPos2) {
        \u2603 = Template.func_186266_a(placementSettings, blockPos);
        \u2603 = Template.func_186266_a(placementSettings2, blockPos2);
        return \u2603.func_177973_b(\u2603);
    }

    public static BlockPos func_186266_a(PlacementSettings placementSettings, BlockPos blockPos) {
        return Template.func_207669_a(blockPos, placementSettings.func_186212_b(), placementSettings.func_186215_c(), placementSettings.func_207664_d());
    }

    public void func_186260_a(IWorld iWorld, BlockPos blockPos, PlacementSettings placementSettings) {
        placementSettings.func_186224_i();
        this.func_186253_b(iWorld, blockPos, placementSettings);
    }

    public void func_186253_b(IWorld iWorld, BlockPos blockPos, PlacementSettings placementSettings) {
        this.func_189960_a(iWorld, blockPos, new IntegrityProcessor(blockPos, placementSettings), placementSettings, 2);
    }

    public boolean func_189962_a(IWorld iWorld, BlockPos blockPos, PlacementSettings placementSettings, int n) {
        return this.func_189960_a(iWorld, blockPos, new IntegrityProcessor(blockPos, placementSettings), placementSettings, n);
    }

    public boolean func_189960_a(IWorld iWorld, BlockPos blockPos, @Nullable ITemplateProcessor iTemplateProcessor, PlacementSettings placementSettings2, int n) {
        Object object;
        if (this.field_204769_a.isEmpty()) {
            return false;
        }
        List<BlockInfo> list = placementSettings2.func_204764_a(this.field_204769_a, blockPos);
        if (list.isEmpty() && (placementSettings2.func_186221_e() || this.field_186271_b.isEmpty()) || this.field_186272_c.func_177958_n() < 1 || this.field_186272_c.func_177956_o() < 1 || this.field_186272_c.func_177952_p() < 1) {
            return false;
        }
        Block \u26032 = placementSettings2.func_186219_f();
        MutableBoundingBox \u26033 = placementSettings2.func_186213_g();
        ArrayList \u26034 = Lists.newArrayListWithCapacity((int)(placementSettings2.func_204763_l() ? list.size() : 0));
        ArrayList \u26035 = Lists.newArrayListWithCapacity((int)list.size());
        int \u26036 = Integer.MAX_VALUE;
        int \u26037 = Integer.MAX_VALUE;
        int \u26038 = Integer.MAX_VALUE;
        int \u26039 = Integer.MIN_VALUE;
        int \u260310 = Integer.MIN_VALUE;
        int \u260311 = Integer.MIN_VALUE;
        for (BlockInfo blockInfo : list) {
            Object object2;
            BlockPos object3 = Template.func_186266_a(placementSettings2, blockInfo.field_186242_a).func_177971_a(blockPos);
            Object object4 = object2 = iTemplateProcessor != null ? iTemplateProcessor.func_189943_a(iWorld, object3, blockInfo) : blockInfo;
            if (object2 == null) continue;
            Block \u260312 = ((BlockInfo)object2).field_186243_b.func_177230_c();
            if (\u26032 != null && \u26032 == \u260312 || placementSettings2.func_186227_h() && \u260312 == Blocks.field_185779_df || \u26033 != null && !\u26033.func_175898_b(object3)) continue;
            IFluidState \u260313 = placementSettings2.func_204763_l() ? iWorld.func_204610_c(object3) : null;
            IBlockState \u260314 = ((BlockInfo)object2).field_186243_b.func_185902_a(placementSettings2.func_186212_b());
            IBlockState \u260315 = \u260314.func_185907_a(placementSettings2.func_186215_c());
            if (((BlockInfo)object2).field_186244_c != null) {
                object5 = iWorld.func_175625_s(object3);
                if (object5 instanceof IInventory) {
                    ((IInventory)object5).func_174888_l();
                }
                iWorld.func_180501_a(object3, Blocks.field_180401_cv.func_176223_P(), 4);
            }
            if (!iWorld.func_180501_a(object3, \u260315, n)) continue;
            \u26036 = Math.min(\u26036, object3.func_177958_n());
            \u26037 = Math.min(\u26037, object3.func_177956_o());
            \u26038 = Math.min(\u26038, object3.func_177952_p());
            \u26039 = Math.max(\u26039, object3.func_177958_n());
            \u260310 = Math.max(\u260310, object3.func_177956_o());
            \u260311 = Math.max(\u260311, object3.func_177952_p());
            \u26035.add(Pair.of((Object)object3, (Object)blockInfo.field_186244_c));
            if (((BlockInfo)object2).field_186244_c != null && (object5 = iWorld.func_175625_s(object3)) != null) {
                ((BlockInfo)object2).field_186244_c.func_74768_a("x", object3.func_177958_n());
                ((BlockInfo)object2).field_186244_c.func_74768_a("y", object3.func_177956_o());
                ((BlockInfo)object2).field_186244_c.func_74768_a("z", object3.func_177952_p());
                ((TileEntity)object5).func_145839_a(((BlockInfo)object2).field_186244_c);
                ((TileEntity)object5).func_189668_a(placementSettings2.func_186212_b());
                ((TileEntity)object5).func_189667_a(placementSettings2.func_186215_c());
            }
            if (\u260313 == null || !(\u260315.func_177230_c() instanceof ILiquidContainer)) continue;
            ((ILiquidContainer)((Object)\u260315.func_177230_c())).func_204509_a(iWorld, object3, \u260315, \u260313);
            if (\u260313.func_206889_d()) continue;
            \u26034.add(object3);
        }
        boolean \u260317 = true;
        EnumFacing[] enumFacingArray = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
        while (\u260317 && !\u26034.isEmpty()) {
            \u260317 = false;
            object = \u26034.iterator();
            while (object.hasNext()) {
                IBlockState iBlockState;
                object2 = (BlockPos)object.next();
                IFluidState iFluidState = iWorld.func_204610_c((BlockPos)object2);
                for (int i = 0; i < enumFacingArray.length && !iFluidState.func_206889_d(); ++i) {
                    \u2603 = iWorld.func_204610_c(((BlockPos)object2).func_177972_a(enumFacingArray[i]));
                    if (!(\u2603.func_206885_f() > iFluidState.func_206885_f()) && (!\u2603.func_206889_d() || iFluidState.func_206889_d())) continue;
                    iFluidState = \u2603;
                }
                if (!iFluidState.func_206889_d() || !((iBlockState = iWorld.func_180495_p((BlockPos)object2)).func_177230_c() instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)((Object)iBlockState.func_177230_c())).func_204509_a(iWorld, (BlockPos)object2, iBlockState, iFluidState);
                \u260317 = true;
                object.remove();
            }
        }
        if (\u26036 <= \u26039) {
            Object object5;
            object = new VoxelShapePartBitSet(\u26039 - \u26036 + 1, \u260310 - \u26037 + 1, \u260311 - \u26038 + 1);
            int \u260318 = \u26036;
            int \u260319 = \u26037;
            int \u260320 = \u26038;
            for (Pair pair : \u26035) {
                object5 = (BlockPos)pair.getFirst();
                ((VoxelShapePart)object).func_199625_a(((Vec3i)object5).func_177958_n() - \u260318, ((Vec3i)object5).func_177956_o() - \u260319, ((Vec3i)object5).func_177952_p() - \u260320, true, true);
            }
            ((VoxelShapePart)object).func_211540_a((enumFacing, n5, n6, n7) -> {
                BlockPos blockPos = new BlockPos(\u260318 + n5, \u260319 + n6, \u260320 + n7);
                \u2603 = blockPos.func_177972_a(enumFacing);
                IBlockState \u26032 = iWorld.func_180495_p(blockPos);
                if (\u26032 != (\u2603 = \u26032.func_196956_a(enumFacing, \u2603 = iWorld.func_180495_p(\u2603), iWorld, blockPos, \u2603))) {
                    iWorld.func_180501_a(blockPos, \u2603, n & 0xFFFFFFFE | 0x10);
                }
                if (\u2603 != (\u2603 = \u2603.func_196956_a(enumFacing.func_176734_d(), \u2603, iWorld, \u2603, blockPos))) {
                    iWorld.func_180501_a(\u2603, \u2603, n & 0xFFFFFFFE | 0x10);
                }
            });
            for (Pair pair : \u26035) {
                object5 = (BlockPos)pair.getFirst();
                IBlockState iBlockState = iWorld.func_180495_p((BlockPos)object5);
                if (iBlockState != (\u2603 = Block.func_199770_b(iBlockState, iWorld, (BlockPos)object5))) {
                    iWorld.func_180501_a((BlockPos)object5, \u2603, n & 0xFFFFFFFE | 0x10);
                }
                iWorld.func_195592_c((BlockPos)object5, \u2603.func_177230_c());
                if (pair.getSecond() == null || (\u2603 = iWorld.func_175625_s((BlockPos)object5)) == null) continue;
                \u2603.func_70296_d();
            }
        }
        if (!placementSettings2.func_186221_e()) {
            this.func_207668_a(iWorld, blockPos, placementSettings2.func_186212_b(), placementSettings2.func_186215_c(), placementSettings2.func_207664_d(), \u26033);
        }
        return true;
    }

    private void func_207668_a(IWorld iWorld, BlockPos blockPos, Mirror mirror, Rotation rotation, BlockPos blockPos2, @Nullable MutableBoundingBox mutableBoundingBox) {
        for (EntityInfo entityInfo : this.field_186271_b) {
            Entity entity;
            BlockPos blockPos3 = Template.func_207669_a(entityInfo.field_186248_b, mirror, rotation, blockPos2).func_177971_a(blockPos);
            if (mutableBoundingBox != null && !mutableBoundingBox.func_175898_b(blockPos3)) continue;
            NBTTagCompound \u26032 = entityInfo.field_186249_c;
            Vec3d \u26033 = Template.func_207667_a(entityInfo.field_186247_a, mirror, rotation, blockPos2);
            Vec3d \u26034 = \u26033.func_72441_c(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            NBTTagList \u26035 = new NBTTagList();
            \u26035.add(new NBTTagDouble(\u26034.field_72450_a));
            \u26035.add(new NBTTagDouble(\u26034.field_72448_b));
            \u26035.add(new NBTTagDouble(\u26034.field_72449_c));
            \u26032.func_74782_a("Pos", \u26035);
            \u26032.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityType.func_200716_a(\u26032, iWorld.func_201672_e());
            }
            catch (Exception exception) {
                entity = null;
            }
            if (entity == null) continue;
            float \u26036 = entity.func_184217_a(mirror);
            entity.func_70012_b(\u26034.field_72450_a, \u26034.field_72448_b, \u26034.field_72449_c, \u26036 += entity.field_70177_z - entity.func_184229_a(rotation), entity.field_70125_A);
            iWorld.func_72838_d(entity);
        }
    }

    public BlockPos func_186257_a(Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.field_186272_c.func_177952_p(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177958_n());
            }
        }
        return this.field_186272_c;
    }

    public static BlockPos func_207669_a(BlockPos blockPos, Mirror mirror, Rotation rotation, BlockPos blockPos2) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        boolean \u26032 = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                \u2603 = -\u2603;
                break;
            }
            case FRONT_BACK: {
                n = -n;
                break;
            }
            default: {
                \u26032 = false;
            }
        }
        \u2603 = blockPos2.func_177958_n();
        \u2603 = blockPos2.func_177952_p();
        switch (rotation) {
            case CLOCKWISE_180: {
                return new BlockPos(\u2603 + \u2603 - n, \u2603, \u2603 + \u2603 - \u2603);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(\u2603 - \u2603 + \u2603, \u2603, \u2603 + \u2603 - n);
            }
            case CLOCKWISE_90: {
                return new BlockPos(\u2603 + \u2603 - \u2603, \u2603, \u2603 - \u2603 + n);
            }
        }
        return \u26032 ? new BlockPos(n, \u2603, \u2603) : blockPos;
    }

    private static Vec3d func_207667_a(Vec3d vec3d, Mirror mirror, Rotation rotation, BlockPos blockPos) {
        double d = vec3d.field_72450_a;
        \u2603 = vec3d.field_72448_b;
        \u2603 = vec3d.field_72449_c;
        boolean \u26032 = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                \u2603 = 1.0 - \u2603;
                break;
            }
            case FRONT_BACK: {
                d = 1.0 - d;
                break;
            }
            default: {
                \u26032 = false;
            }
        }
        int \u26033 = blockPos.func_177958_n();
        int \u26034 = blockPos.func_177952_p();
        switch (rotation) {
            case CLOCKWISE_180: {
                return new Vec3d((double)(\u26033 + \u26033 + 1) - d, \u2603, (double)(\u26034 + \u26034 + 1) - \u2603);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vec3d((double)(\u26033 - \u26034) + \u2603, \u2603, (double)(\u26033 + \u26034 + 1) - d);
            }
            case CLOCKWISE_90: {
                return new Vec3d((double)(\u26033 + \u26034 + 1) - \u2603, \u2603, (double)(\u26034 - \u26033) + d);
            }
        }
        return \u26032 ? new Vec3d(d, \u2603, \u2603) : vec3d;
    }

    public BlockPos func_189961_a(BlockPos blockPos, Mirror mirror, Rotation rotation) {
        return Template.func_191157_a(blockPos, mirror, rotation, this.func_186259_a().func_177958_n(), this.func_186259_a().func_177952_p());
    }

    public static BlockPos func_191157_a(BlockPos blockPos, Mirror mirror, Rotation rotation, int n, int n2) {
        \u2603 = mirror == Mirror.FRONT_BACK ? --n : 0;
        \u2603 = mirror == Mirror.LEFT_RIGHT ? --n2 : 0;
        BlockPos blockPos2 = blockPos;
        switch (rotation) {
            case NONE: {
                blockPos2 = blockPos.func_177982_a(\u2603, 0, \u2603);
                break;
            }
            case CLOCKWISE_90: {
                blockPos2 = blockPos.func_177982_a(n2 - \u2603, 0, \u2603);
                break;
            }
            case CLOCKWISE_180: {
                blockPos2 = blockPos.func_177982_a(n - \u2603, 0, n2 - \u2603);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                blockPos2 = blockPos.func_177982_a(\u2603, 0, n - \u2603);
            }
        }
        return blockPos2;
    }

    /*
     * WARNING - void declaration
     */
    public NBTTagCompound func_189552_a(NBTTagCompound nBTTagCompound2) {
        Object object;
        if (this.field_204769_a.isEmpty()) {
            nBTTagCompound2.func_74782_a("blocks", new NBTTagList());
            nBTTagCompound2.func_74782_a("palette", new NBTTagList());
        } else {
            void var4_5;
            ArrayList abstractList = Lists.newArrayList();
            BasicPalette \u26032 = new BasicPalette();
            abstractList.add(\u26032);
            boolean bl = true;
            while (var4_5 < this.field_204769_a.size()) {
                abstractList.add(new BasicPalette());
                ++var4_5;
            }
            NBTTagList nBTTagList = new NBTTagList();
            object = this.field_204769_a.get(0);
            for (int i = 0; i < object.size(); ++i) {
                BlockInfo blockInfo = (BlockInfo)object.get(i);
                NBTTagCompound \u26033 = new NBTTagCompound();
                \u26033.func_74782_a("pos", this.func_186267_a(blockInfo.field_186242_a.func_177958_n(), blockInfo.field_186242_a.func_177956_o(), blockInfo.field_186242_a.func_177952_p()));
                int \u26034 = \u26032.func_189954_a(blockInfo.field_186243_b);
                \u26033.func_74768_a("state", \u26034);
                if (blockInfo.field_186244_c != null) {
                    \u26033.func_74782_a("nbt", blockInfo.field_186244_c);
                }
                nBTTagList.add(\u26033);
                for (int j = 1; j < this.field_204769_a.size(); ++j) {
                    BasicPalette basicPalette = (BasicPalette)abstractList.get(j);
                    basicPalette.func_189956_a(this.field_204769_a.get((int)i).get((int)i).field_186243_b, \u26034);
                }
            }
            nBTTagCompound2.func_74782_a("blocks", nBTTagList);
            if (abstractList.size() == 1) {
                NBTTagList nBTTagList2 = new NBTTagList();
                for (Object object2 : \u26032) {
                    nBTTagList2.add(NBTUtil.func_190009_a((IBlockState)object2));
                }
                nBTTagCompound2.func_74782_a("palette", nBTTagList2);
            } else {
                NBTTagList nBTTagList3 = new NBTTagList();
                for (Object object2 : abstractList) {
                    NBTTagList nBTTagList4 = new NBTTagList();
                    Iterator<IBlockState> iterator = ((BasicPalette)object2).iterator();
                    while (iterator.hasNext()) {
                        IBlockState object3 = iterator.next();
                        nBTTagList4.add(NBTUtil.func_190009_a(object3));
                    }
                    nBTTagList3.add(nBTTagList4);
                }
                nBTTagCompound2.func_74782_a("palettes", nBTTagList3);
            }
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (EntityInfo entityInfo : this.field_186271_b) {
            object = new NBTTagCompound();
            ((NBTTagCompound)object).func_74782_a("pos", this.func_186264_a(entityInfo.field_186247_a.field_72450_a, entityInfo.field_186247_a.field_72448_b, entityInfo.field_186247_a.field_72449_c));
            ((NBTTagCompound)object).func_74782_a("blockPos", this.func_186267_a(entityInfo.field_186248_b.func_177958_n(), entityInfo.field_186248_b.func_177956_o(), entityInfo.field_186248_b.func_177952_p()));
            if (entityInfo.field_186249_c != null) {
                ((NBTTagCompound)object).func_74782_a("nbt", entityInfo.field_186249_c);
            }
            nBTTagList.add((INBTBase)object);
        }
        nBTTagCompound2.func_74782_a("entities", nBTTagList);
        nBTTagCompound2.func_74782_a("size", this.func_186267_a(this.field_186272_c.func_177958_n(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177952_p()));
        nBTTagCompound2.func_74768_a("DataVersion", 1631);
        return nBTTagCompound2;
    }

    public void func_186256_b(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        int n;
        this.field_204769_a.clear();
        this.field_186271_b.clear();
        NBTTagList nBTTagList = nBTTagCompound2.func_150295_c("size", 3);
        this.field_186272_c = new BlockPos(nBTTagList.func_186858_c(0), nBTTagList.func_186858_c(1), nBTTagList.func_186858_c(2));
        \u2603 = nBTTagCompound2.func_150295_c("blocks", 10);
        if (nBTTagCompound2.func_150297_b("palettes", 9)) {
            \u26032 = nBTTagCompound2.func_150295_c("palettes", 9);
            for (n = 0; n < \u26032.size(); ++n) {
                this.func_204768_a(\u26032.func_202169_e(n), \u2603);
            }
        } else {
            this.func_204768_a(nBTTagCompound2.func_150295_c("palette", 10), \u2603);
        }
        NBTTagList \u26032 = nBTTagCompound2.func_150295_c("entities", 10);
        for (n = 0; n < \u26032.size(); ++n) {
            NBTTagCompound nBTTagCompound3 = \u26032.func_150305_b(n);
            NBTTagList \u26033 = nBTTagCompound3.func_150295_c("pos", 6);
            Vec3d \u26034 = new Vec3d(\u26033.func_150309_d(0), \u26033.func_150309_d(1), \u26033.func_150309_d(2));
            NBTTagList \u26035 = nBTTagCompound3.func_150295_c("blockPos", 3);
            BlockPos \u26036 = new BlockPos(\u26035.func_186858_c(0), \u26035.func_186858_c(1), \u26035.func_186858_c(2));
            if (!nBTTagCompound3.func_74764_b("nbt")) continue;
            \u2603 = nBTTagCompound3.func_74775_l("nbt");
            this.field_186271_b.add(new EntityInfo(\u26034, \u26036, \u2603));
        }
    }

    private void func_204768_a(NBTTagList nBTTagList, NBTTagList nBTTagList2) {
        int n;
        BasicPalette basicPalette = new BasicPalette();
        ArrayList \u26032 = Lists.newArrayList();
        for (n = 0; n < nBTTagList.size(); ++n) {
            basicPalette.func_189956_a(NBTUtil.func_190008_d(nBTTagList.func_150305_b(n)), n);
        }
        for (n = 0; n < nBTTagList2.size(); ++n) {
            NBTTagCompound nBTTagCompound = nBTTagList2.func_150305_b(n);
            NBTTagList \u26033 = nBTTagCompound.func_150295_c("pos", 3);
            BlockPos \u26034 = new BlockPos(\u26033.func_186858_c(0), \u26033.func_186858_c(1), \u26033.func_186858_c(2));
            IBlockState \u26035 = basicPalette.func_189955_a(nBTTagCompound.func_74762_e("state"));
            \u2603 = nBTTagCompound.func_74764_b("nbt") ? nBTTagCompound.func_74775_l("nbt") : null;
            \u26032.add(new BlockInfo(\u26034, \u26035, \u2603));
        }
        this.field_204769_a.add(\u26032);
    }

    private NBTTagList func_186267_a(int ... nArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (int n : nArray) {
            nBTTagList.add(new NBTTagInt(n));
        }
        return nBTTagList;
    }

    private NBTTagList func_186264_a(double ... dArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (double d : dArray) {
            nBTTagList.add(new NBTTagDouble(d));
        }
        return nBTTagList;
    }

    public static class EntityInfo {
        public final Vec3d field_186247_a;
        public final BlockPos field_186248_b;
        public final NBTTagCompound field_186249_c;

        public EntityInfo(Vec3d vec3d, BlockPos blockPos, NBTTagCompound nBTTagCompound) {
            this.field_186247_a = vec3d;
            this.field_186248_b = blockPos;
            this.field_186249_c = nBTTagCompound;
        }
    }

    public static class BlockInfo {
        public final BlockPos field_186242_a;
        public final IBlockState field_186243_b;
        public final NBTTagCompound field_186244_c;

        public BlockInfo(BlockPos blockPos, IBlockState iBlockState, @Nullable NBTTagCompound nBTTagCompound) {
            this.field_186242_a = blockPos;
            this.field_186243_b = iBlockState;
            this.field_186244_c = nBTTagCompound;
        }
    }

    static class BasicPalette
    implements Iterable<IBlockState> {
        public static final IBlockState field_189957_a = Blocks.field_150350_a.func_176223_P();
        private final ObjectIntIdentityMap<IBlockState> field_189958_b = new ObjectIntIdentityMap(16);
        private int field_189959_c;

        private BasicPalette() {
        }

        public int func_189954_a(IBlockState iBlockState) {
            int n = this.field_189958_b.func_148747_b(iBlockState);
            if (n == -1) {
                n = this.field_189959_c++;
                this.field_189958_b.func_148746_a(iBlockState, n);
            }
            return n;
        }

        @Nullable
        public IBlockState func_189955_a(int n) {
            IBlockState iBlockState = this.field_189958_b.func_148745_a(n);
            return iBlockState == null ? field_189957_a : iBlockState;
        }

        @Override
        public Iterator<IBlockState> iterator() {
            return this.field_189958_b.iterator();
        }

        public void func_189956_a(IBlockState iBlockState, int n) {
            this.field_189958_b.func_148746_a(iBlockState, n);
        }
    }
}

