/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionSavedDataManager {
    private static final Logger field_212776_a = LogManager.getLogger();
    private final DimensionType field_212777_b;
    private Map<String, WorldSavedData> field_212778_c = Maps.newHashMap();
    private final Object2IntMap<String> field_212779_d = new Object2IntOpenHashMap();
    @Nullable
    private final ISaveHandler field_212780_e;

    public DimensionSavedDataManager(DimensionType dimensionType, @Nullable ISaveHandler iSaveHandler) {
        this.field_212777_b = dimensionType;
        this.field_212780_e = iSaveHandler;
        this.field_212779_d.defaultReturnValue(-1);
    }

    @Nullable
    public <T extends WorldSavedData> T func_201067_a(Function<String, T> function, String string) {
        WorldSavedData worldSavedData = this.field_212778_c.get(string);
        if (worldSavedData == null && this.field_212780_e != null) {
            try {
                File file = this.field_212780_e.func_212423_a(this.field_212777_b, string);
                if (file != null && file.exists()) {
                    worldSavedData = (WorldSavedData)function.apply(string);
                    worldSavedData.func_76184_a(DimensionSavedDataManager.func_212774_a(this.field_212780_e, this.field_212777_b, string, 1631).func_74775_l("data"));
                    this.field_212778_c.put(string, worldSavedData);
                }
            }
            catch (Exception exception) {
                field_212776_a.error("Error loading saved data: {}", (Object)string, (Object)exception);
            }
        }
        return (T)worldSavedData;
    }

    public void func_75745_a(String string, WorldSavedData worldSavedData) {
        this.field_212778_c.put(string, worldSavedData);
    }

    public void func_75746_b() {
        try {
            this.field_212779_d.clear();
            if (this.field_212780_e == null) {
                return;
            }
            File file = this.field_212780_e.func_212423_a(this.field_212777_b, "idcounts");
            if (file != null && file.exists()) {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                NBTTagCompound \u26032 = CompressedStreamTools.func_74794_a(dataInputStream);
                dataInputStream.close();
                for (String string : \u26032.func_150296_c()) {
                    if (!\u26032.func_150297_b(string, 99)) continue;
                    this.field_212779_d.put((Object)string, \u26032.func_74762_e(string));
                }
            }
        }
        catch (Exception exception) {
            field_212776_a.error("Could not load aux values", (Throwable)exception);
        }
    }

    public int func_75743_a(String string) {
        int n = this.field_212779_d.getInt((Object)string) + 1;
        this.field_212779_d.put((Object)string, n);
        if (this.field_212780_e == null) {
            return n;
        }
        try {
            File file = this.field_212780_e.func_212423_a(this.field_212777_b, "idcounts");
            if (file != null) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                for (Object2IntMap.Entry entry : this.field_212779_d.object2IntEntrySet()) {
                    nBTTagCompound.func_74768_a((String)entry.getKey(), entry.getIntValue());
                }
                DataOutputStream \u26032 = new DataOutputStream(new FileOutputStream(file));
                CompressedStreamTools.func_74800_a(nBTTagCompound, \u26032);
                \u26032.close();
            }
        }
        catch (Exception exception) {
            field_212776_a.error("Could not get free aux value {}", (Object)string, (Object)exception);
        }
        return n;
    }

    public static NBTTagCompound func_212774_a(ISaveHandler iSaveHandler, DimensionType dimensionType, String string, int n) throws IOException {
        File file = iSaveHandler.func_212423_a(dimensionType, string);
        try (FileInputStream \u26032 = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a(\u26032);
            int \u26033 = nBTTagCompound.func_150297_b("DataVersion", 99) ? nBTTagCompound.func_74762_e("DataVersion") : 1343;
            NBTTagCompound nBTTagCompound2 = NBTUtil.func_210821_a(iSaveHandler.func_197718_i(), (DSL.TypeReference)DataFixTypes.SAVED_DATA, nBTTagCompound, \u26033, n);
            return nBTTagCompound2;
        }
    }

    public void func_212775_b() {
        if (this.field_212780_e == null) {
            return;
        }
        for (WorldSavedData worldSavedData : this.field_212778_c.values()) {
            if (!worldSavedData.func_76188_b()) continue;
            this.func_75747_a(worldSavedData);
            worldSavedData.func_76186_a(false);
        }
    }

    private void func_75747_a(WorldSavedData worldSavedData) {
        if (this.field_212780_e == null) {
            return;
        }
        try {
            File file = this.field_212780_e.func_212423_a(this.field_212777_b, worldSavedData.func_195925_e());
            if (file != null) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74782_a("data", worldSavedData.func_189551_b(new NBTTagCompound()));
                nBTTagCompound.func_74768_a("DataVersion", 1631);
                FileOutputStream \u26032 = new FileOutputStream(file);
                CompressedStreamTools.func_74799_a(nBTTagCompound, \u26032);
                \u26032.close();
            }
        }
        catch (Exception exception) {
            field_212776_a.error("Could not save data {}", (Object)worldSavedData, (Object)exception);
        }
    }
}

