/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveHandler
implements ISaveHandler,
IPlayerFileData {
    private static final Logger field_151478_a = LogManager.getLogger();
    private final File field_75770_b;
    private final File field_75771_c;
    private final long field_75769_e = Util.func_211177_b();
    private final String field_75767_f;
    private final TemplateManager field_186342_h;
    protected final DataFixer field_186341_a;

    public SaveHandler(File file, String string, @Nullable MinecraftServer minecraftServer, DataFixer dataFixer) {
        this.field_186341_a = dataFixer;
        this.field_75770_b = new File(file, string);
        this.field_75770_b.mkdirs();
        this.field_75771_c = new File(this.field_75770_b, "playerdata");
        this.field_75767_f = string;
        if (minecraftServer != null) {
            this.field_75771_c.mkdirs();
            this.field_186342_h = new TemplateManager(minecraftServer, this.field_75770_b, dataFixer);
        } else {
            this.field_186342_h = null;
        }
        this.func_75766_h();
    }

    private void func_75766_h() {
        try {
            File file = new File(this.field_75770_b, "session.lock");
            try (DataOutputStream \u26032 = new DataOutputStream(new FileOutputStream(file));){
                \u26032.writeLong(this.field_75769_e);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    @Override
    public File func_75765_b() {
        return this.field_75770_b;
    }

    @Override
    public void func_75762_c() throws SessionLockException {
        try {
            File file = new File(this.field_75770_b, "session.lock");
            try (DataInputStream \u26032 = new DataInputStream(new FileInputStream(file));){
                if (\u26032.readLong() != this.field_75769_e) {
                    throw new SessionLockException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException iOException) {
            throw new SessionLockException("Failed to check session lock, aborting");
        }
    }

    @Override
    public IChunkLoader func_75763_a(Dimension dimension) {
        throw new RuntimeException("Old Chunk Storage is no longer supported.");
    }

    @Override
    @Nullable
    public WorldInfo func_75757_d() {
        File file = new File(this.field_75770_b, "level.dat");
        if (file.exists() && (\u2603 = SaveFormatOld.func_186353_a(file, this.field_186341_a)) != null) {
            return \u2603;
        }
        file = new File(this.field_75770_b, "level.dat_old");
        if (file.exists()) {
            return SaveFormatOld.func_186353_a(file, this.field_186341_a);
        }
        return null;
    }

    @Override
    public void func_75755_a(WorldInfo worldInfo, @Nullable NBTTagCompound nBTTagCompound) {
        \u2603 = worldInfo.func_76082_a(nBTTagCompound);
        \u2603 = new NBTTagCompound();
        \u2603.func_74782_a("Data", \u2603);
        try {
            File file = new File(this.field_75770_b, "level.dat_new");
            \u2603 = new File(this.field_75770_b, "level.dat_old");
            \u2603 = new File(this.field_75770_b, "level.dat");
            CompressedStreamTools.func_74799_a(\u2603, new FileOutputStream(file));
            if (\u2603.exists()) {
                \u2603.delete();
            }
            \u2603.renameTo(\u2603);
            if (\u2603.exists()) {
                \u2603.delete();
            }
            file.renameTo(\u2603);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void func_75761_a(WorldInfo worldInfo) {
        this.func_75755_a(worldInfo, null);
    }

    @Override
    public void func_75753_a(EntityPlayer entityPlayer) {
        try {
            NBTTagCompound nBTTagCompound = entityPlayer.func_189511_e(new NBTTagCompound());
            File \u26032 = new File(this.field_75771_c, entityPlayer.func_189512_bd() + ".dat.tmp");
            File \u26033 = new File(this.field_75771_c, entityPlayer.func_189512_bd() + ".dat");
            CompressedStreamTools.func_74799_a(nBTTagCompound, new FileOutputStream(\u26032));
            if (\u26033.exists()) {
                \u26033.delete();
            }
            \u26032.renameTo(\u26033);
        }
        catch (Exception exception) {
            field_151478_a.warn("Failed to save player data for {}", (Object)entityPlayer.func_200200_C_().getString());
        }
    }

    @Override
    @Nullable
    public NBTTagCompound func_75752_b(EntityPlayer entityPlayer) {
        NBTTagCompound nBTTagCompound = null;
        try {
            File file = new File(this.field_75771_c, entityPlayer.func_189512_bd() + ".dat");
            if (file.exists() && file.isFile()) {
                nBTTagCompound = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            field_151478_a.warn("Failed to load player data for {}", (Object)entityPlayer.func_200200_C_().getString());
        }
        if (nBTTagCompound != null) {
            int n = nBTTagCompound.func_150297_b("DataVersion", 3) ? nBTTagCompound.func_74762_e("DataVersion") : -1;
            entityPlayer.func_70020_e(NBTUtil.func_210822_a(this.field_186341_a, (DSL.TypeReference)DataFixTypes.PLAYER, nBTTagCompound, n));
        }
        return nBTTagCompound;
    }

    @Override
    public IPlayerFileData func_75756_e() {
        return this;
    }

    @Override
    public String[] func_75754_f() {
        String[] stringArray = this.field_75771_c.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".dat")) continue;
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 4);
        }
        return stringArray;
    }

    @Override
    public void func_75759_a() {
    }

    @Override
    public File func_212423_a(DimensionType dimensionType, String string) {
        File file = new File(dimensionType.func_212679_a(this.field_75770_b), "data");
        file.mkdirs();
        return new File(file, string + ".dat");
    }

    @Override
    public TemplateManager func_186340_h() {
        return this.field_186342_h;
    }

    @Override
    public DataFixer func_197718_i() {
        return this.field_186341_a;
    }
}

