/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;

public class WorldInfo {
    private String field_186349_b;
    private int field_186350_c;
    private boolean field_186351_d;
    public static final EnumDifficulty field_176156_a = EnumDifficulty.NORMAL;
    private long field_76100_a;
    private WorldType field_76098_b = WorldType.field_77137_b;
    private NBTTagCompound field_82576_c = new NBTTagCompound();
    @Nullable
    private String field_211931_h;
    private int field_76099_c;
    private int field_76096_d;
    private int field_76097_e;
    private long field_82575_g;
    private long field_76094_f;
    private long field_76095_g;
    private long field_76107_h;
    @Nullable
    private final DataFixer field_209226_o;
    private final int field_209227_p;
    private boolean field_209228_q;
    private NBTTagCompound field_76108_i;
    private int field_76105_j;
    private String field_76106_k;
    private int field_76103_l;
    private int field_176157_p;
    private boolean field_76104_m;
    private int field_76101_n;
    private boolean field_76102_o;
    private int field_76114_p;
    private GameType field_76113_q;
    private boolean field_76112_r;
    private boolean field_76111_s;
    private boolean field_76110_t;
    private boolean field_76109_u;
    private EnumDifficulty field_176158_z;
    private boolean field_176150_A;
    private double field_176151_B;
    private double field_176152_C;
    private double field_176146_D = 6.0E7;
    private long field_176147_E;
    private double field_176148_F;
    private double field_176149_G = 5.0;
    private double field_176153_H = 0.2;
    private int field_176154_I = 5;
    private int field_176155_J = 15;
    private final Set<String> field_197721_N = Sets.newHashSet();
    private final Set<String> field_197722_O = Sets.newLinkedHashSet();
    private final Map<DimensionType, NBTTagCompound> field_186348_N = Maps.newIdentityHashMap();
    private NBTTagCompound field_201358_Q;
    private final GameRules field_82577_x = new GameRules();

    protected WorldInfo() {
        this.field_209226_o = null;
        this.field_209227_p = 1631;
        this.func_212242_b(new NBTTagCompound());
    }

    public WorldInfo(NBTTagCompound nBTTagCompound3, DataFixer dataFixer, int n, @Nullable NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound3;
        Object object;
        this.field_209226_o = dataFixer;
        if (nBTTagCompound3.func_150297_b("Version", 10)) {
            object = nBTTagCompound3.func_74775_l("Version");
            this.field_186349_b = ((NBTTagCompound)object).func_74779_i("Name");
            this.field_186350_c = ((NBTTagCompound)object).func_74762_e("Id");
            this.field_186351_d = ((NBTTagCompound)object).func_74767_n("Snapshot");
        }
        this.field_76100_a = nBTTagCompound3.func_74763_f("RandomSeed");
        if (nBTTagCompound3.func_150297_b("generatorName", 8)) {
            object = nBTTagCompound3.func_74779_i("generatorName");
            this.field_76098_b = WorldType.func_77130_a((String)object);
            if (this.field_76098_b == null) {
                this.field_76098_b = WorldType.field_77137_b;
            } else if (this.field_76098_b == WorldType.field_180271_f) {
                this.field_211931_h = nBTTagCompound3.func_74779_i("generatorOptions");
            } else if (this.field_76098_b.func_77125_e()) {
                int n2 = 0;
                if (nBTTagCompound3.func_150297_b("generatorVersion", 99)) {
                    n2 = nBTTagCompound3.func_74762_e("generatorVersion");
                }
                this.field_76098_b = this.field_76098_b.func_77132_a(n2);
            }
            this.func_212242_b(nBTTagCompound3.func_74775_l("generatorOptions"));
        }
        this.field_76113_q = GameType.func_77146_a(nBTTagCompound3.func_74762_e("GameType"));
        if (nBTTagCompound3.func_150297_b("legacy_custom_options", 8)) {
            this.field_211931_h = nBTTagCompound3.func_74779_i("legacy_custom_options");
        }
        this.field_76112_r = nBTTagCompound3.func_150297_b("MapFeatures", 99) ? nBTTagCompound3.func_74767_n("MapFeatures") : true;
        this.field_76099_c = nBTTagCompound3.func_74762_e("SpawnX");
        this.field_76096_d = nBTTagCompound3.func_74762_e("SpawnY");
        this.field_76097_e = nBTTagCompound3.func_74762_e("SpawnZ");
        this.field_82575_g = nBTTagCompound3.func_74763_f("Time");
        this.field_76094_f = nBTTagCompound3.func_150297_b("DayTime", 99) ? nBTTagCompound3.func_74763_f("DayTime") : this.field_82575_g;
        this.field_76095_g = nBTTagCompound3.func_74763_f("LastPlayed");
        this.field_76107_h = nBTTagCompound3.func_74763_f("SizeOnDisk");
        this.field_76106_k = nBTTagCompound3.func_74779_i("LevelName");
        this.field_76103_l = nBTTagCompound3.func_74762_e("version");
        this.field_176157_p = nBTTagCompound3.func_74762_e("clearWeatherTime");
        this.field_76101_n = nBTTagCompound3.func_74762_e("rainTime");
        this.field_76104_m = nBTTagCompound3.func_74767_n("raining");
        this.field_76114_p = nBTTagCompound3.func_74762_e("thunderTime");
        this.field_76102_o = nBTTagCompound3.func_74767_n("thundering");
        this.field_76111_s = nBTTagCompound3.func_74767_n("hardcore");
        this.field_76109_u = nBTTagCompound3.func_150297_b("initialized", 99) ? nBTTagCompound3.func_74767_n("initialized") : true;
        this.field_76110_t = nBTTagCompound3.func_150297_b("allowCommands", 99) ? nBTTagCompound3.func_74767_n("allowCommands") : this.field_76113_q == GameType.CREATIVE;
        this.field_209227_p = n;
        if (nBTTagCompound2 != null) {
            this.field_76108_i = nBTTagCompound2;
        }
        if (nBTTagCompound3.func_150297_b("GameRules", 10)) {
            this.field_82577_x.func_82768_a(nBTTagCompound3.func_74775_l("GameRules"));
        }
        if (nBTTagCompound3.func_150297_b("Difficulty", 99)) {
            this.field_176158_z = EnumDifficulty.func_151523_a(nBTTagCompound3.func_74771_c("Difficulty"));
        }
        if (nBTTagCompound3.func_150297_b("DifficultyLocked", 1)) {
            this.field_176150_A = nBTTagCompound3.func_74767_n("DifficultyLocked");
        }
        if (nBTTagCompound3.func_150297_b("BorderCenterX", 99)) {
            this.field_176151_B = nBTTagCompound3.func_74769_h("BorderCenterX");
        }
        if (nBTTagCompound3.func_150297_b("BorderCenterZ", 99)) {
            this.field_176152_C = nBTTagCompound3.func_74769_h("BorderCenterZ");
        }
        if (nBTTagCompound3.func_150297_b("BorderSize", 99)) {
            this.field_176146_D = nBTTagCompound3.func_74769_h("BorderSize");
        }
        if (nBTTagCompound3.func_150297_b("BorderSizeLerpTime", 99)) {
            this.field_176147_E = nBTTagCompound3.func_74763_f("BorderSizeLerpTime");
        }
        if (nBTTagCompound3.func_150297_b("BorderSizeLerpTarget", 99)) {
            this.field_176148_F = nBTTagCompound3.func_74769_h("BorderSizeLerpTarget");
        }
        if (nBTTagCompound3.func_150297_b("BorderSafeZone", 99)) {
            this.field_176149_G = nBTTagCompound3.func_74769_h("BorderSafeZone");
        }
        if (nBTTagCompound3.func_150297_b("BorderDamagePerBlock", 99)) {
            this.field_176153_H = nBTTagCompound3.func_74769_h("BorderDamagePerBlock");
        }
        if (nBTTagCompound3.func_150297_b("BorderWarningBlocks", 99)) {
            this.field_176154_I = nBTTagCompound3.func_74762_e("BorderWarningBlocks");
        }
        if (nBTTagCompound3.func_150297_b("BorderWarningTime", 99)) {
            this.field_176155_J = nBTTagCompound3.func_74762_e("BorderWarningTime");
        }
        if (nBTTagCompound3.func_150297_b("DimensionData", 10)) {
            object = nBTTagCompound3.func_74775_l("DimensionData");
            for (String string : ((NBTTagCompound)object).func_150296_c()) {
                this.field_186348_N.put(DimensionType.func_186069_a(Integer.parseInt(string)), ((NBTTagCompound)object).func_74775_l(string));
            }
        }
        if (nBTTagCompound3.func_150297_b("DataPacks", 10)) {
            object = nBTTagCompound3.func_74775_l("DataPacks");
            NBTTagList \u26032 = ((NBTTagCompound)object).func_150295_c("Disabled", 8);
            for (int i = 0; i < \u26032.size(); ++i) {
                this.field_197721_N.add(\u26032.func_150307_f(i));
            }
            NBTTagList \u26033 = ((NBTTagCompound)object).func_150295_c("Enabled", 8);
            for (int i = 0; i < \u26033.size(); ++i) {
                this.field_197722_O.add(\u26033.func_150307_f(i));
            }
        }
        if (nBTTagCompound3.func_150297_b("CustomBossEvents", 10)) {
            this.field_201358_Q = nBTTagCompound3.func_74775_l("CustomBossEvents");
        }
    }

    public WorldInfo(WorldSettings worldSettings, String string) {
        this.field_209226_o = null;
        this.field_209227_p = 1631;
        this.func_176127_a(worldSettings);
        this.field_76106_k = string;
        this.field_176158_z = field_176156_a;
        this.field_76109_u = false;
    }

    public void func_176127_a(WorldSettings worldSettings) {
        this.field_76100_a = worldSettings.func_77160_d();
        this.field_76113_q = worldSettings.func_77162_e();
        this.field_76112_r = worldSettings.func_77164_g();
        this.field_76111_s = worldSettings.func_77158_f();
        this.field_76098_b = worldSettings.func_77165_h();
        this.func_212242_b((NBTTagCompound)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)worldSettings.func_205391_j()));
        this.field_76110_t = worldSettings.func_77163_i();
    }

    public NBTTagCompound func_76082_a(@Nullable NBTTagCompound nBTTagCompound) {
        this.func_209225_Q();
        if (nBTTagCompound == null) {
            nBTTagCompound = this.field_76108_i;
        }
        \u2603 = new NBTTagCompound();
        this.func_76064_a(\u2603, nBTTagCompound);
        return \u2603;
    }

    private void func_76064_a(NBTTagCompound nBTTagCompound4, NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("Name", "1.13.2");
        nBTTagCompound.func_74768_a("Id", 1631);
        nBTTagCompound.func_74757_a("Snapshot", false);
        nBTTagCompound4.func_74782_a("Version", nBTTagCompound);
        nBTTagCompound4.func_74768_a("DataVersion", 1631);
        nBTTagCompound4.func_74772_a("RandomSeed", this.field_76100_a);
        nBTTagCompound4.func_74778_a("generatorName", this.field_76098_b.func_211889_b());
        nBTTagCompound4.func_74768_a("generatorVersion", this.field_76098_b.func_77131_c());
        if (!this.field_82576_c.isEmpty()) {
            nBTTagCompound4.func_74782_a("generatorOptions", this.field_82576_c);
        }
        if (this.field_211931_h != null) {
            nBTTagCompound4.func_74778_a("legacy_custom_options", this.field_211931_h);
        }
        nBTTagCompound4.func_74768_a("GameType", this.field_76113_q.func_77148_a());
        nBTTagCompound4.func_74757_a("MapFeatures", this.field_76112_r);
        nBTTagCompound4.func_74768_a("SpawnX", this.field_76099_c);
        nBTTagCompound4.func_74768_a("SpawnY", this.field_76096_d);
        nBTTagCompound4.func_74768_a("SpawnZ", this.field_76097_e);
        nBTTagCompound4.func_74772_a("Time", this.field_82575_g);
        nBTTagCompound4.func_74772_a("DayTime", this.field_76094_f);
        nBTTagCompound4.func_74772_a("SizeOnDisk", this.field_76107_h);
        nBTTagCompound4.func_74772_a("LastPlayed", Util.func_211179_d());
        nBTTagCompound4.func_74778_a("LevelName", this.field_76106_k);
        nBTTagCompound4.func_74768_a("version", this.field_76103_l);
        nBTTagCompound4.func_74768_a("clearWeatherTime", this.field_176157_p);
        nBTTagCompound4.func_74768_a("rainTime", this.field_76101_n);
        nBTTagCompound4.func_74757_a("raining", this.field_76104_m);
        nBTTagCompound4.func_74768_a("thunderTime", this.field_76114_p);
        nBTTagCompound4.func_74757_a("thundering", this.field_76102_o);
        nBTTagCompound4.func_74757_a("hardcore", this.field_76111_s);
        nBTTagCompound4.func_74757_a("allowCommands", this.field_76110_t);
        nBTTagCompound4.func_74757_a("initialized", this.field_76109_u);
        nBTTagCompound4.func_74780_a("BorderCenterX", this.field_176151_B);
        nBTTagCompound4.func_74780_a("BorderCenterZ", this.field_176152_C);
        nBTTagCompound4.func_74780_a("BorderSize", this.field_176146_D);
        nBTTagCompound4.func_74772_a("BorderSizeLerpTime", this.field_176147_E);
        nBTTagCompound4.func_74780_a("BorderSafeZone", this.field_176149_G);
        nBTTagCompound4.func_74780_a("BorderDamagePerBlock", this.field_176153_H);
        nBTTagCompound4.func_74780_a("BorderSizeLerpTarget", this.field_176148_F);
        nBTTagCompound4.func_74780_a("BorderWarningBlocks", this.field_176154_I);
        nBTTagCompound4.func_74780_a("BorderWarningTime", this.field_176155_J);
        if (this.field_176158_z != null) {
            nBTTagCompound4.func_74774_a("Difficulty", (byte)this.field_176158_z.func_151525_a());
        }
        nBTTagCompound4.func_74757_a("DifficultyLocked", this.field_176150_A);
        nBTTagCompound4.func_74782_a("GameRules", this.field_82577_x.func_82770_a());
        \u2603 = new NBTTagCompound();
        for (Map.Entry<DimensionType, NBTTagCompound> entry : this.field_186348_N.entrySet()) {
            \u2603.func_74782_a(String.valueOf(entry.getKey().func_186068_a()), entry.getValue());
        }
        nBTTagCompound4.func_74782_a("DimensionData", \u2603);
        if (nBTTagCompound2 != null) {
            nBTTagCompound4.func_74782_a("Player", nBTTagCompound2);
        }
        NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
        NBTTagList nBTTagList = new NBTTagList();
        for (String string : this.field_197722_O) {
            nBTTagList.add(new NBTTagString(string));
        }
        nBTTagCompound3.func_74782_a("Enabled", nBTTagList);
        NBTTagList \u26033 = new NBTTagList();
        for (String string : this.field_197721_N) {
            \u26033.add(new NBTTagString(string));
        }
        nBTTagCompound3.func_74782_a("Disabled", \u26033);
        nBTTagCompound4.func_74782_a("DataPacks", nBTTagCompound3);
        if (this.field_201358_Q != null) {
            nBTTagCompound4.func_74782_a("CustomBossEvents", this.field_201358_Q);
        }
    }

    public long func_76063_b() {
        return this.field_76100_a;
    }

    public int func_76079_c() {
        return this.field_76099_c;
    }

    public int func_76075_d() {
        return this.field_76096_d;
    }

    public int func_76074_e() {
        return this.field_76097_e;
    }

    public long func_82573_f() {
        return this.field_82575_g;
    }

    public long func_76073_f() {
        return this.field_76094_f;
    }

    private void func_209225_Q() {
        if (this.field_209228_q || this.field_76108_i == null) {
            return;
        }
        if (this.field_209227_p < 1631) {
            if (this.field_209226_o == null) {
                throw new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded.");
            }
            this.field_76108_i = NBTUtil.func_210822_a(this.field_209226_o, (DSL.TypeReference)DataFixTypes.PLAYER, this.field_76108_i, this.field_209227_p);
        }
        this.field_76105_j = this.field_76108_i.func_74762_e("Dimension");
        this.field_209228_q = true;
    }

    public NBTTagCompound func_76072_h() {
        this.func_209225_Q();
        return this.field_76108_i;
    }

    public void func_82572_b(long l) {
        this.field_82575_g = l;
    }

    public void func_76068_b(long l) {
        this.field_76094_f = l;
    }

    public void func_176143_a(BlockPos blockPos) {
        this.field_76099_c = blockPos.func_177958_n();
        this.field_76096_d = blockPos.func_177956_o();
        this.field_76097_e = blockPos.func_177952_p();
    }

    public String func_76065_j() {
        return this.field_76106_k;
    }

    public void func_76062_a(String string) {
        this.field_76106_k = string;
    }

    public int func_76088_k() {
        return this.field_76103_l;
    }

    public void func_76078_e(int n) {
        this.field_76103_l = n;
    }

    public int func_176133_A() {
        return this.field_176157_p;
    }

    public void func_176142_i(int n) {
        this.field_176157_p = n;
    }

    public boolean func_76061_m() {
        return this.field_76102_o;
    }

    public void func_76069_a(boolean bl) {
        this.field_76102_o = bl;
    }

    public int func_76071_n() {
        return this.field_76114_p;
    }

    public void func_76090_f(int n) {
        this.field_76114_p = n;
    }

    public boolean func_76059_o() {
        return this.field_76104_m;
    }

    public void func_76084_b(boolean bl) {
        this.field_76104_m = bl;
    }

    public int func_76083_p() {
        return this.field_76101_n;
    }

    public void func_76080_g(int n) {
        this.field_76101_n = n;
    }

    public GameType func_76077_q() {
        return this.field_76113_q;
    }

    public boolean func_76089_r() {
        return this.field_76112_r;
    }

    public void func_176128_f(boolean bl) {
        this.field_76112_r = bl;
    }

    public void func_76060_a(GameType gameType) {
        this.field_76113_q = gameType;
    }

    public boolean func_76093_s() {
        return this.field_76111_s;
    }

    public void func_176119_g(boolean bl) {
        this.field_76111_s = bl;
    }

    public WorldType func_76067_t() {
        return this.field_76098_b;
    }

    public void func_76085_a(WorldType worldType) {
        this.field_76098_b = worldType;
    }

    public NBTTagCompound func_211027_A() {
        return this.field_82576_c;
    }

    public void func_212242_b(NBTTagCompound nBTTagCompound) {
        this.field_82576_c = nBTTagCompound;
    }

    public boolean func_76086_u() {
        return this.field_76110_t;
    }

    public void func_176121_c(boolean bl) {
        this.field_76110_t = bl;
    }

    public boolean func_76070_v() {
        return this.field_76109_u;
    }

    public void func_76091_d(boolean bl) {
        this.field_76109_u = bl;
    }

    public GameRules func_82574_x() {
        return this.field_82577_x;
    }

    public double func_176120_C() {
        return this.field_176151_B;
    }

    public double func_176126_D() {
        return this.field_176152_C;
    }

    public double func_176137_E() {
        return this.field_176146_D;
    }

    public void func_176145_a(double d) {
        this.field_176146_D = d;
    }

    public long func_176134_F() {
        return this.field_176147_E;
    }

    public void func_176135_e(long l) {
        this.field_176147_E = l;
    }

    public double func_176132_G() {
        return this.field_176148_F;
    }

    public void func_176118_b(double d) {
        this.field_176148_F = d;
    }

    public void func_176141_c(double d) {
        this.field_176152_C = d;
    }

    public void func_176124_d(double d) {
        this.field_176151_B = d;
    }

    public double func_176138_H() {
        return this.field_176149_G;
    }

    public void func_176129_e(double d) {
        this.field_176149_G = d;
    }

    public double func_176140_I() {
        return this.field_176153_H;
    }

    public void func_176125_f(double d) {
        this.field_176153_H = d;
    }

    public int func_176131_J() {
        return this.field_176154_I;
    }

    public int func_176139_K() {
        return this.field_176155_J;
    }

    public void func_176122_j(int n) {
        this.field_176154_I = n;
    }

    public void func_176136_k(int n) {
        this.field_176155_J = n;
    }

    public EnumDifficulty func_176130_y() {
        return this.field_176158_z;
    }

    public void func_176144_a(EnumDifficulty enumDifficulty) {
        this.field_176158_z = enumDifficulty;
    }

    public boolean func_176123_z() {
        return this.field_176150_A;
    }

    public void func_180783_e(boolean bl) {
        this.field_176150_A = bl;
    }

    public void func_85118_a(CrashReportCategory crashReportCategory) {
        crashReportCategory.func_189529_a("Level seed", () -> String.valueOf(this.func_76063_b()));
        crashReportCategory.func_189529_a("Level generator", () -> String.format("ID %02d - %s, ver %d. Features enabled: %b", this.field_76098_b.func_82747_f(), this.field_76098_b.func_211888_a(), this.field_76098_b.func_77131_c(), this.field_76112_r));
        crashReportCategory.func_189529_a("Level generator options", () -> this.field_82576_c.toString());
        crashReportCategory.func_189529_a("Level spawn location", () -> CrashReportCategory.func_184876_a(this.field_76099_c, this.field_76096_d, this.field_76097_e));
        crashReportCategory.func_189529_a("Level time", () -> String.format("%d game time, %d day time", this.field_82575_g, this.field_76094_f));
        crashReportCategory.func_189529_a("Level dimension", () -> String.valueOf(this.field_76105_j));
        crashReportCategory.func_189529_a("Level storage version", () -> {
            String string = "Unknown?";
            try {
                switch (this.field_76103_l) {
                    case 19133: {
                        string = "Anvil";
                        break;
                    }
                    case 19132: {
                        string = "McRegion";
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return String.format("0x%05X - %s", this.field_76103_l, string);
        });
        crashReportCategory.func_189529_a("Level weather", () -> String.format("Rain time: %d (now: %b), thunder time: %d (now: %b)", this.field_76101_n, this.field_76104_m, this.field_76114_p, this.field_76102_o));
        crashReportCategory.func_189529_a("Level game mode", () -> String.format("Game mode: %s (ID %d). Hardcore: %b. Cheats: %b", this.field_76113_q.func_77149_b(), this.field_76113_q.func_77148_a(), this.field_76111_s, this.field_76110_t));
    }

    public NBTTagCompound func_186347_a(DimensionType dimensionType) {
        NBTTagCompound nBTTagCompound = this.field_186348_N.get(dimensionType);
        if (nBTTagCompound == null) {
            return new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    public void func_186345_a(DimensionType dimensionType, NBTTagCompound nBTTagCompound) {
        this.field_186348_N.put(dimensionType, nBTTagCompound);
    }

    public Set<String> func_197719_N() {
        return this.field_197721_N;
    }

    public Set<String> func_197720_O() {
        return this.field_197722_O;
    }

    @Nullable
    public NBTTagCompound func_201357_P() {
        return this.field_201358_Q;
    }

    public void func_201356_c(@Nullable NBTTagCompound nBTTagCompound) {
        this.field_201358_Q = nBTTagCompound;
    }
}

