/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;

public class LootContext {
    private final float field_186498_a;
    private final WorldServer field_186499_b;
    private final LootTableManager field_186500_c;
    @Nullable
    private final Entity field_186501_d;
    @Nullable
    private final EntityPlayer field_186502_e;
    @Nullable
    private final DamageSource field_186503_f;
    @Nullable
    private final BlockPos field_204316_g;
    private final Set<LootTable> field_186504_g = Sets.newLinkedHashSet();

    public LootContext(float f, WorldServer worldServer, LootTableManager lootTableManager, @Nullable Entity entity, @Nullable EntityPlayer entityPlayer, @Nullable DamageSource damageSource, @Nullable BlockPos blockPos) {
        this.field_186498_a = f;
        this.field_186499_b = worldServer;
        this.field_186500_c = lootTableManager;
        this.field_186501_d = entity;
        this.field_186502_e = entityPlayer;
        this.field_186503_f = damageSource;
        this.field_204316_g = blockPos;
    }

    @Nullable
    public Entity func_186493_a() {
        return this.field_186501_d;
    }

    @Nullable
    public Entity func_186495_b() {
        return this.field_186502_e;
    }

    @Nullable
    public Entity func_186492_c() {
        return this.field_186503_f == null ? null : this.field_186503_f.func_76346_g();
    }

    @Nullable
    public BlockPos func_204315_e() {
        return this.field_204316_g;
    }

    public boolean func_186496_a(LootTable lootTable) {
        return this.field_186504_g.add(lootTable);
    }

    public void func_186490_b(LootTable lootTable) {
        this.field_186504_g.remove(lootTable);
    }

    public LootTableManager func_186497_e() {
        return this.field_186500_c;
    }

    public float func_186491_f() {
        return this.field_186498_a;
    }

    public WorldServer func_202879_g() {
        return this.field_186499_b;
    }

    @Nullable
    public Entity func_186494_a(EntityTarget entityTarget) {
        switch (entityTarget) {
            case THIS: {
                return this.func_186493_a();
            }
            case KILLER: {
                return this.func_186492_c();
            }
            case KILLER_PLAYER: {
                return this.func_186495_b();
            }
        }
        return null;
    }

    public static enum EntityTarget {
        THIS("this"),
        KILLER("killer"),
        KILLER_PLAYER("killer_player");

        private final String field_186488_d;

        private EntityTarget(String string2) {
            this.field_186488_d = string2;
        }

        public static EntityTarget func_186482_a(String string2) {
            String string2;
            for (EntityTarget entityTarget : EntityTarget.values()) {
                if (!entityTarget.field_186488_d.equals(string2)) continue;
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + string2);
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter jsonWriter, EntityTarget entityTarget) throws IOException {
                jsonWriter.value(entityTarget.field_186488_d);
            }

            public EntityTarget read(JsonReader jsonReader) throws IOException {
                return EntityTarget.func_186482_a(jsonReader.nextString());
            }

            public /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                return this.read(jsonReader);
            }

            public /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
                this.write(jsonWriter, (EntityTarget)((Object)object));
            }
        }
    }

    public static class Builder {
        private final WorldServer field_186474_a;
        private float field_186475_b;
        private Entity field_186476_c;
        private EntityPlayer field_186477_d;
        private DamageSource field_186478_e;
        private BlockPos field_204314_f;

        public Builder(WorldServer worldServer) {
            this.field_186474_a = worldServer;
        }

        public Builder func_186469_a(float f) {
            this.field_186475_b = f;
            return this;
        }

        public Builder func_186472_a(Entity entity) {
            this.field_186476_c = entity;
            return this;
        }

        public Builder func_186470_a(EntityPlayer entityPlayer) {
            this.field_186477_d = entityPlayer;
            return this;
        }

        public Builder func_186473_a(DamageSource damageSource) {
            this.field_186478_e = damageSource;
            return this;
        }

        public Builder func_204313_a(BlockPos blockPos) {
            this.field_204314_f = blockPos;
            return this;
        }

        public LootContext func_186471_a() {
            return new LootContext(this.field_186475_b, this.field_186474_a, this.field_186474_a.func_73046_m().func_200249_aQ(), this.field_186476_c, this.field_186477_d, this.field_186478_e, this.field_204314_f);
        }
    }
}

