/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import org.apache.commons.lang3.ArrayUtils;

public class LootPool {
    private final LootEntry[] field_186453_a;
    private final LootCondition[] field_186454_b;
    private final RandomValueRange field_186455_c;
    private final RandomValueRange field_186456_d;

    public LootPool(LootEntry[] lootEntryArray, LootCondition[] lootConditionArray, RandomValueRange randomValueRange, RandomValueRange randomValueRange2) {
        this.field_186453_a = lootEntryArray;
        this.field_186454_b = lootConditionArray;
        this.field_186455_c = randomValueRange;
        this.field_186456_d = randomValueRange2;
    }

    protected void func_186452_a(Collection<ItemStack> collection, Random random, LootContext lootContext) {
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = 0;
        for (LootEntry lootEntry : this.field_186453_a) {
            if (!LootConditionManager.func_186638_a(lootEntry.field_186366_e, random, lootContext) || (\u2603 = lootEntry.func_186361_a(lootContext.func_186491_f())) <= 0) continue;
            arrayList.add(lootEntry);
            \u26032 += \u2603;
        }
        if (\u26032 == 0 || arrayList.isEmpty()) {
            return;
        }
        int \u26033 = random.nextInt(\u26032);
        for (LootEntry lootEntry : arrayList) {
            if ((\u26033 -= lootEntry.func_186361_a(lootContext.func_186491_f())) >= 0) continue;
            lootEntry.func_186363_a(collection, random, lootContext);
            return;
        }
    }

    public void func_186449_b(Collection<ItemStack> collection, Random random, LootContext lootContext) {
        if (!LootConditionManager.func_186638_a(this.field_186454_b, random, lootContext)) {
            return;
        }
        int n = this.field_186455_c.func_186511_a(random) + MathHelper.func_76141_d(this.field_186456_d.func_186507_b(random) * lootContext.func_186491_f());
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            this.func_186452_a(collection, random, lootContext);
        }
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "loot pool");
            LootEntry[] \u26032 = JsonUtils.func_188174_a(jsonObject, "entries", jsonDeserializationContext, LootEntry[].class);
            LootCondition[] \u26033 = JsonUtils.func_188177_a(jsonObject, "conditions", new LootCondition[0], jsonDeserializationContext, LootCondition[].class);
            RandomValueRange \u26034 = JsonUtils.func_188174_a(jsonObject, "rolls", jsonDeserializationContext, RandomValueRange.class);
            RandomValueRange \u26035 = JsonUtils.func_188177_a(jsonObject, "bonus_rolls", new RandomValueRange(0.0f, 0.0f), jsonDeserializationContext, RandomValueRange.class);
            return new LootPool(\u26032, \u26033, \u26034, \u26035);
        }

        public JsonElement serialize(LootPool lootPool, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("entries", jsonSerializationContext.serialize((Object)lootPool.field_186453_a));
            jsonObject.add("rolls", jsonSerializationContext.serialize((Object)lootPool.field_186455_c));
            if (lootPool.field_186456_d.func_186509_a() != 0.0f && lootPool.field_186456_d.func_186512_b() != 0.0f) {
                jsonObject.add("bonus_rolls", jsonSerializationContext.serialize((Object)lootPool.field_186456_d));
            }
            if (!ArrayUtils.isEmpty((Object[])lootPool.field_186454_b)) {
                jsonObject.add("conditions", jsonSerializationContext.serialize((Object)lootPool.field_186454_b));
            }
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootPool)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

