/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTable {
    private static final Logger field_186465_b = LogManager.getLogger();
    public static final LootTable field_186464_a = new LootTable(new LootPool[0]);
    private final LootPool[] field_186466_c;

    public LootTable(LootPool[] lootPoolArray) {
        this.field_186466_c = lootPoolArray;
    }

    public List<ItemStack> func_186462_a(Random random, LootContext lootContext2) {
        ArrayList arrayList = Lists.newArrayList();
        if (lootContext2.func_186496_a(this)) {
            LootContext lootContext2;
            for (LootPool lootPool : this.field_186466_c) {
                lootPool.func_186449_b(arrayList, random, lootContext2);
            }
            lootContext2.func_186490_b(this);
        } else {
            field_186465_b.warn("Detected infinite loop in loot tables");
        }
        return arrayList;
    }

    public void func_186460_a(IInventory iInventory, Random random, LootContext lootContext) {
        List<ItemStack> list = this.func_186462_a(random, lootContext);
        List<Integer> \u26032 = this.func_186459_a(iInventory, random);
        this.func_186463_a(list, \u26032.size(), random);
        for (ItemStack itemStack : list) {
            if (\u26032.isEmpty()) {
                field_186465_b.warn("Tried to over-fill a container");
                return;
            }
            if (itemStack.func_190926_b()) {
                iInventory.func_70299_a(\u26032.remove(\u26032.size() - 1), ItemStack.field_190927_a);
                continue;
            }
            iInventory.func_70299_a(\u26032.remove(\u26032.size() - 1), itemStack);
        }
    }

    private void func_186463_a(List<ItemStack> list2, int n2, Random random) {
        List<ItemStack> list2;
        int n2;
        ArrayList arrayList = Lists.newArrayList();
        Object \u26032 = list2.iterator();
        while (\u26032.hasNext()) {
            ItemStack itemStack = \u26032.next();
            if (itemStack.func_190926_b()) {
                \u26032.remove();
                continue;
            }
            if (itemStack.func_190916_E() <= 1) continue;
            arrayList.add(itemStack);
            \u26032.remove();
        }
        while (n2 - list2.size() - arrayList.size() > 0 && !arrayList.isEmpty()) {
            \u26032 = (ItemStack)arrayList.remove(MathHelper.func_76136_a(random, 0, arrayList.size() - 1));
            \u2603 = MathHelper.func_76136_a(random, 1, ((ItemStack)\u26032).func_190916_E() / 2);
            ItemStack itemStack = ((ItemStack)\u26032).func_77979_a(\u2603);
            if (((ItemStack)\u26032).func_190916_E() > 1 && random.nextBoolean()) {
                arrayList.add(\u26032);
            } else {
                list2.add((ItemStack)\u26032);
            }
            if (itemStack.func_190916_E() > 1 && random.nextBoolean()) {
                arrayList.add(itemStack);
                continue;
            }
            list2.add(itemStack);
        }
        list2.addAll(arrayList);
        Collections.shuffle(list2, random);
    }

    private List<Integer> func_186459_a(IInventory iInventory, Random random) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
            if (!iInventory.func_70301_a(i).func_190926_b()) continue;
            arrayList.add(i);
        }
        Collections.shuffle(arrayList, random);
        return arrayList;
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "loot table");
            LootPool[] \u26032 = JsonUtils.func_188177_a(jsonObject, "pools", new LootPool[0], jsonDeserializationContext, LootPool[].class);
            return new LootTable(\u26032);
        }

        public JsonElement serialize(LootTable lootTable, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("pools", jsonSerializationContext.serialize((Object)lootTable.field_186466_c));
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootTable)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

