/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExplorationMap
extends LootFunction {
    private static final Logger field_204317_a = LogManager.getLogger();
    private final String field_204318_b;
    private final MapDecoration.Type field_204319_c;
    private final byte field_204320_d;
    private final int field_204321_e;
    private final boolean field_212428_f;

    public ExplorationMap(LootCondition[] lootConditionArray, String string, MapDecoration.Type type, byte by, int n, boolean bl) {
        super(lootConditionArray);
        this.field_204318_b = string;
        this.field_204319_c = type;
        this.field_204320_d = by;
        this.field_204321_e = n;
        this.field_212428_f = bl;
    }

    @Override
    public ItemStack func_186553_a(ItemStack itemStack2, Random random, LootContext lootContext) {
        ItemStack itemStack2;
        if (itemStack2.func_77973_b() != Items.field_151148_bJ) {
            return itemStack2;
        }
        BlockPos blockPos = lootContext.func_204315_e();
        if (blockPos == null) {
            return itemStack2;
        }
        WorldServer \u26032 = lootContext.func_202879_g();
        \u2603 = \u26032.func_211157_a(this.field_204318_b, blockPos, this.field_204321_e, this.field_212428_f);
        if (\u2603 != null) {
            ItemStack itemStack3 = ItemMap.func_195952_a(\u26032, \u2603.func_177958_n(), \u2603.func_177952_p(), this.field_204320_d, true, true);
            ItemMap.func_190905_a(\u26032, itemStack3);
            MapData.func_191094_a(itemStack3, \u2603, "+", this.field_204319_c);
            itemStack3.func_200302_a(new TextComponentTranslation("filled_map." + this.field_204318_b.toLowerCase(Locale.ROOT), new Object[0]));
            return itemStack3;
        }
        return itemStack2;
    }

    public static class Serializer
    extends LootFunction.Serializer<ExplorationMap> {
        protected Serializer() {
            super(new ResourceLocation("exploration_map"), ExplorationMap.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject, ExplorationMap explorationMap, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("destination", jsonSerializationContext.serialize((Object)explorationMap.field_204318_b));
            jsonObject.add("decoration", jsonSerializationContext.serialize((Object)explorationMap.field_204319_c.toString().toLowerCase(Locale.ROOT)));
        }

        @Override
        public ExplorationMap func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray) {
            String string = jsonObject.has("destination") ? JsonUtils.func_151200_h(jsonObject, "destination") : "Buried_Treasure";
            string = Feature.field_202300_at.containsKey(string.toLowerCase(Locale.ROOT)) ? string : "Buried_Treasure";
            \u2603 = jsonObject.has("decoration") ? JsonUtils.func_151200_h(jsonObject, "decoration") : "mansion";
            MapDecoration.Type \u26032 = MapDecoration.Type.MANSION;
            try {
                \u26032 = MapDecoration.Type.valueOf(\u2603.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException \u26033) {
                field_204317_a.error("Error while parsing loot table decoration entry. Found {}. Defaulting to MANSION", (Object)\u2603);
            }
            byte \u26034 = jsonObject.has("zoom") ? (byte)JsonUtils.func_204331_o(jsonObject, "zoom") : (byte)2;
            int \u26035 = jsonObject.has("search_radius") ? JsonUtils.func_151203_m(jsonObject, "search_radius") : 50;
            boolean \u26036 = jsonObject.has("skip_existing_chunks") ? JsonUtils.func_151212_i(jsonObject, "skip_existing_chunks") : true;
            return new ExplorationMap(lootConditionArray, string, \u26032, \u26034, \u26035, \u26036);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, lootConditionArray);
        }
    }
}

