/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.BossInfoClient;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.model.ModelBiped;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.resource.ReloadRequirements;
import net.minecraftforge.resource.SelectiveReloadStateHandler;
import net.minecraftforge.resource.VanillaResourceType;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    private static final Logger LOGGER = LogManager.getLogger();
    static int renderPass = -1;
    static final ThreadLocal<BlockRenderLayer> renderLayer = new ThreadLocal();
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;
    static int worldRenderPass;
    private static final Matrix4f flipX;
    private static final FloatBuffer matrixBuf;
    private static final LightGatheringTransformer lightGatherer;
    private static int slotMainHand;

    public static String getArmorTexture(Entity entity, ItemStack armor, String _default, EntityEquipmentSlot slot, String type) {
        String result = armor.func_77973_b().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static boolean onDrawBlockHighlight(WorldRenderer context, EntityPlayer player, RayTraceResult target, int subID, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post((Event)new DrawBlockHighlightEvent(context, player, target, subID, partialTicks));
    }

    public static void dispatchRenderLast(WorldRenderer context, float partialTicks) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderWorldLastEvent(context, partialTicks));
    }

    public static boolean renderFirstPersonHand(WorldRenderer context, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderHandEvent(context, partialTicks));
    }

    public static boolean renderSpecificFirstPersonHand(EnumHand hand, float partialTicks, float interpPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderSpecificHandEvent(hand, partialTicks, interpPitch, swingProgress, equipProgress, stack));
    }

    public static void onTextureStitchedPre(TextureMap map) {
        MinecraftForge.EVENT_BUS.post((Event)new TextureStitchEvent.Pre(map));
        ModelDynBucket.LoaderDynBucket.INSTANCE.register(map);
    }

    public static void onTextureStitchedPost(TextureMap map) {
        MinecraftForge.EVENT_BUS.post((Event)new TextureStitchEvent.Post(map));
    }

    public static void onBlockColorsInit(BlockColors blockColors) {
        MinecraftForge.EVENT_BUS.post((Event)new ColorHandlerEvent.Block(blockColors));
    }

    public static void onItemColorsInit(ItemColors itemColors, BlockColors blockColors) {
        MinecraftForge.EVENT_BUS.post((Event)new ColorHandlerEvent.Item(itemColors, blockColors));
    }

    public static void setRenderPass(int pass) {
        renderPass = pass;
    }

    public static void setRenderLayer(BlockRenderLayer layer) {
        renderLayer.set(layer);
    }

    public static ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped _default) {
        ModelBiped model = itemStack.func_77973_b().getArmorModel(entityLiving, itemStack, slot, _default);
        return model == null ? _default : model;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ':' + base + name;
        }
        return base + name;
    }

    public static float getOffsetFOV(EntityPlayer entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post((Event)fovUpdateEvent);
        return fovUpdateEvent.getNewfov();
    }

    public static double getFOVModifier(GameRenderer renderer, Entity entity, IBlockState blockState, IFluidState fluidState, double renderPartialTicks, double fov) {
        EntityViewRenderEvent.FOVModifier event = new EntityViewRenderEvent.FOVModifier(renderer, entity, blockState, fluidState, renderPartialTicks, fov);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getFOV();
    }

    public static int getSkyBlendColour(World world, BlockPos center) {
        if (center.func_177958_n() == skyX && center.func_177952_p() == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeMod.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && ranges.length > 0) {
            distance = ranges[MathHelper.func_76125_a((int)settings.field_151451_c, (int)0, (int)(ranges.length - 1))];
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                BlockPos pos = center.func_177982_a(x, 0, z);
                Biome biome = world.func_180494_b(pos);
                int colour = biome.func_76731_a(biome.func_180626_a(pos));
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                ++divider;
            }
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b / divider & 0xFF;
        skyX = center.func_177958_n();
        skyZ = center.func_177952_p();
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    public static void renderMainMenu(GuiMainMenu gui, FontRenderer font, int width, int height) {
        String line;
        VersionChecker.Status status = ForgeVersion.getStatus();
        if (status == VersionChecker.Status.BETA || status == VersionChecker.Status.BETA_OUTDATED) {
            line = I18n.func_135052_a((String)"forge.update.beta.1", (Object[])new Object[]{TextFormatting.RED, TextFormatting.RESET});
            gui.func_73731_b(font, line, (width - font.func_78256_a(line)) / 2, 4 + 0 * (font.field_78288_b + 1), -1);
            line = I18n.func_135052_a((String)"forge.update.beta.2", (Object[])new Object[0]);
            gui.func_73731_b(font, line, (width - font.func_78256_a(line)) / 2, 4 + 1 * (font.field_78288_b + 1), -1);
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = I18n.func_135052_a((String)"forge.update.newversion", (Object[])new Object[]{ForgeVersion.getTarget()});
                break;
            }
        }
        if (line != null) {
            gui.func_73731_b(font, line, width - font.func_78256_a(line) - 2, height - 2 * (font.field_78288_b + 1), -1);
        }
    }

    public static ISound playSound(SoundManager manager, ISound sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getResultSound();
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(GuiScreen screen, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.DrawScreenEvent.Pre(screen, mouseX, mouseY, partialTicks))) {
            screen.func_73863_a(mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.DrawScreenEvent.Post(screen, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(FogRenderer fogRenderer, GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(fogRenderer, renderer, entity, state, fluidState, partial, density);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return event.getDensity();
        }
        return -1.0f;
    }

    public static void onFogRender(FogRenderer fogRenderer, GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, float partial, int mode, float distance) {
        MinecraftForge.EVENT_BUS.post((Event)new EntityViewRenderEvent.RenderFogEvent(fogRenderer, renderer, entity, state, fluidState, partial, mode, distance));
    }

    public static void onModelBake(ModelManager modelManager, Map<ModelResourceLocation, IBakedModel> modelRegistry, ModelLoader modelLoader) {
        MinecraftForge.EVENT_BUS.post((Event)new ModelBakeEvent(modelManager, modelRegistry, modelLoader));
        modelLoader.onPostBakeEvent(modelRegistry);
    }

    public static Matrix4f getMatrix(ItemTransformVec3f transform) {
        Matrix4f m = new Matrix4f();
        Matrix4f t = new Matrix4f();
        m.setIdentity();
        m.setTranslation(TRSRTransformation.toVecmath(transform.field_178365_c));
        t.setIdentity();
        t.rotY(transform.field_178364_b.func_195900_b());
        m.mul(t);
        t.setIdentity();
        t.rotX(transform.field_178364_b.func_195899_a());
        m.mul(t);
        t.setIdentity();
        t.rotZ(transform.field_178364_b.func_195902_c());
        m.mul(t);
        t.setIdentity();
        t.m00 = transform.field_178363_d.func_195899_a();
        t.m11 = transform.field_178363_d.func_195900_b();
        t.m22 = transform.field_178363_d.func_195902_c();
        m.mul(t);
        return m;
    }

    public static IBakedModel handleCameraTransforms(IBakedModel model, ItemCameraTransforms.TransformType cameraTransformType, boolean leftHandHackery) {
        Pair pair = model.handlePerspective(cameraTransformType);
        if (pair.getRight() != null) {
            Matrix4f matrix = new Matrix4f((Matrix4f)pair.getRight());
            if (leftHandHackery) {
                matrix.mul(flipX, matrix);
                matrix.mul(matrix, flipX);
            }
            ForgeHooksClient.multiplyCurrentGlMatrix(matrix);
        }
        return (IBakedModel)pair.getLeft();
    }

    public static void multiplyCurrentGlMatrix(Matrix4f matrix) {
        matrixBuf.clear();
        float[] t = new float[4];
        for (int i = 0; i < 4; ++i) {
            matrix.getColumn(i, t);
            matrixBuf.put(t);
        }
        matrixBuf.flip();
        GL11.glMultMatrixf((FloatBuffer)matrixBuf);
    }

    public static void preDraw(VertexFormatElement.EnumUsage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = format.func_177348_c(element);
        int count = attr.func_177370_d();
        int constant = attr.func_177367_b().func_177397_c();
        buffer.position(format.func_181720_d(element));
        switch (attrType) {
            case POSITION: {
                GL11.glVertexPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32884);
                break;
            }
            case NORMAL: {
                if (count != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + attr);
                }
                GL11.glNormalPointer((int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32885);
                break;
            }
            case COLOR: {
                GL11.glColorPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32886);
                break;
            }
            case UV: {
                OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + attr.func_177369_e()));
                GL11.glTexCoordPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray((int)attr.func_177369_e());
                GL20.glVertexAttribPointer((int)attr.func_177369_e(), (int)count, (int)constant, (boolean)false, (int)stride, (ByteBuffer)buffer);
                break;
            }
            default: {
                LOGGER.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.func_177384_a());
            }
        }
    }

    public static void postDraw(VertexFormatElement.EnumUsage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = format.func_177348_c(element);
        switch (attrType) {
            case POSITION: {
                GL11.glDisableClientState((int)32884);
                break;
            }
            case NORMAL: {
                GL11.glDisableClientState((int)32885);
                break;
            }
            case COLOR: {
                GL11.glDisableClientState((int)32886);
                GlStateManager.func_179117_G();
                break;
            }
            case UV: {
                OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + attr.func_177369_e()));
                GL11.glDisableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray((int)attr.func_177369_e());
                break;
            }
            default: {
                LOGGER.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.func_177384_a());
            }
        }
    }

    public static void transform(net.minecraft.client.renderer.Vector3f vec, Matrix4f m) {
        Vector4f tmp = new Vector4f(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c(), 1.0f);
        m.transform((Tuple4f)tmp);
        if ((double)Math.abs(tmp.w - 1.0f) > 1.0E-5) {
            tmp.scale(1.0f / tmp.w);
        }
        vec.func_195905_a(tmp.x, tmp.y, tmp.z);
    }

    public static Matrix4f getMatrix(ModelRotation modelRotation) {
        Matrix4f ret = new Matrix4f(TRSRTransformation.toVecmath(modelRotation.func_195820_a()), new Vector3f(), 1.0f);
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.invert();
        ret.mul(tmp);
        return ret;
    }

    public static void putQuadColor(BufferBuilder renderer, BakedQuad quad, int color) {
        float cb = color & 0xFF;
        float cg = color >>> 8 & 0xFF;
        float cr = color >>> 16 & 0xFF;
        float ca = color >>> 24 & 0xFF;
        VertexFormat format = quad.getFormat();
        int size = format.func_181719_f();
        int offset = format.func_177340_e() / 4;
        boolean hasColor = format.func_207752_d();
        for (int i = 0; i < 4; ++i) {
            int vc = hasColor ? quad.func_178209_a()[offset + size * i] : -1;
            float vcr = vc & 0xFF;
            float vcg = vc >>> 8 & 0xFF;
            float vcb = vc >>> 16 & 0xFF;
            float vca = vc >>> 24 & 0xFF;
            int ncr = Math.min(255, (int)(cr * vcr / 255.0f));
            int ncg = Math.min(255, (int)(cg * vcg / 255.0f));
            int ncb = Math.min(255, (int)(cb * vcb / 255.0f));
            int nca = Math.min(255, (int)(ca * vca / 255.0f));
            renderer.putColorRGBA(renderer.func_78909_a(4 - i), ncr, ncg, ncb, nca);
        }
    }

    public static void renderLitItem(ItemRenderer ri, IBakedModel model, int color, ItemStack stack) {
        ArrayList allquads = new ArrayList();
        Random random = new Random();
        long seed = 42L;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            random.setSeed(seed);
            allquads.addAll(model.func_200117_a(null, enumfacing, random));
        }
        random.setSeed(seed);
        allquads.addAll(model.func_200117_a(null, null, random));
        if (allquads.isEmpty()) {
            return;
        }
        ArrayList<BakedQuad> segment = new ArrayList<BakedQuad>();
        int segmentBlockLight = 0;
        int segmentSkyLight = 0;
        boolean segmentShading = true;
        boolean segmentLightingDirty = false;
        boolean segmentShadingDirty = false;
        boolean hasLighting = false;
        for (int i = 0; i < allquads.size(); ++i) {
            boolean shadeDirty;
            BakedQuad q = (BakedQuad)allquads.get(i);
            int bl = 0;
            int sl = 0;
            if (q.getFormat() != DefaultVertexFormats.field_176599_b && q.getFormat().func_207750_a(1)) {
                q.pipe((IVertexConsumer)lightGatherer);
                if (lightGatherer.hasLighting()) {
                    bl = ForgeHooksClient.lightGatherer.blockLight;
                    sl = ForgeHooksClient.lightGatherer.skyLight;
                }
            }
            boolean shade = q.shouldApplyDiffuseLighting();
            boolean lightingDirty = segmentBlockLight != bl || segmentSkyLight != sl;
            boolean bl2 = shadeDirty = shade != segmentShading;
            if (lightingDirty || shadeDirty) {
                if (i > 0) {
                    ForgeHooksClient.drawSegment(ri, color, stack, segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < i), segmentShadingDirty);
                }
                segmentBlockLight = bl;
                segmentSkyLight = sl;
                segmentShading = shade;
                segmentLightingDirty = lightingDirty;
                segmentShadingDirty = shadeDirty;
                hasLighting = segmentBlockLight > 0 || segmentSkyLight > 0 || !segmentShading;
            }
            segment.add(q);
        }
        ForgeHooksClient.drawSegment(ri, color, stack, segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < allquads.size()), segmentShadingDirty);
        if (hasLighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77478_a, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
            GlStateManager.func_179145_e();
        }
    }

    private static void drawSegment(ItemRenderer ri, int baseColor, ItemStack stack, List<BakedQuad> segment, int bl, int sl, boolean shade, boolean updateLighting, boolean updateShading) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        float lastBl = OpenGlHelper.lastBrightnessX;
        float lastSl = OpenGlHelper.lastBrightnessY;
        if (updateShading) {
            if (shade) {
                GlStateManager.func_179145_e();
            } else {
                GlStateManager.func_179140_f();
            }
        }
        if (updateLighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77478_a, (float)Math.max((float)bl, lastBl), (float)Math.max((float)sl, lastSl));
        }
        ri.func_191970_a(bufferbuilder, segment, baseColor, stack);
        Tessellator.func_178181_a().func_78381_a();
        OpenGlHelper.lastBrightnessX = lastBl;
        OpenGlHelper.lastBrightnessY = lastSl;
        segment.clear();
    }

    public static void fillNormal(int[] faceData, EnumFacing facing) {
        Vector3f v1 = ForgeHooksClient.getVertexPos(faceData, 3);
        Vector3f t = ForgeHooksClient.getVertexPos(faceData, 1);
        Vector3f v2 = ForgeHooksClient.getVertexPos(faceData, 2);
        v1.sub((Tuple3f)t);
        t.set((Tuple3f)ForgeHooksClient.getVertexPos(faceData, 0));
        v2.sub((Tuple3f)t);
        v1.cross(v2, v1);
        v1.normalize();
        int x = (byte)Math.round(v1.x * 127.0f) & 0xFF;
        int y = (byte)Math.round(v1.y * 127.0f) & 0xFF;
        int z = (byte)Math.round(v1.z * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 7 + 6] = normal;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 7;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static Optional<TRSRTransformation> applyTransform(ItemTransformVec3f transform, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(TRSRTransformation.blockCenterToCorner(TRSRTransformation.from(transform)));
    }

    public static Optional<TRSRTransformation> applyTransform(ModelRotation rotation, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(TRSRTransformation.from(rotation));
    }

    public static Optional<TRSRTransformation> applyTransform(Matrix4f matrix, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new TRSRTransformation(matrix));
    }

    public static void loadEntityShader(Entity entity, GameRenderer entityRenderer) {
        ResourceLocation shader;
        if (entity != null && (shader = ClientRegistry.getEntityShader(entity.getClass())) != null) {
            entityRenderer.func_175069_a(shader);
        }
    }

    public static IBakedModel getDamageModel(IBakedModel ibakedmodel, TextureAtlasSprite texture, IBlockState state, IWorldReader world, BlockPos pos) {
        state = state.func_177230_c().getExtendedState(state, (IBlockReader)world, pos);
        return new SimpleBakedModel.Builder(state, ibakedmodel, texture, new Random(), 42L).func_177645_b();
    }

    public static boolean shouldCauseReequipAnimation(@Nonnull ItemStack from, @Nonnull ItemStack to, int slot) {
        boolean fromInvalid = from.func_190926_b();
        boolean toInvalid = to.func_190926_b();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.func_77973_b().shouldCauseReequipAnimation(from, to, changed);
    }

    public static BlockFaceUV applyUVLock(BlockFaceUV blockFaceUV, EnumFacing originalSide, ITransformation rotation) {
        float t;
        TRSRTransformation global = new TRSRTransformation(rotation.getMatrixVec());
        Matrix4f uv = global.getUVLockTransform(originalSide).getMatrixVec();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        float u0 = blockFaceUV.func_178348_a(blockFaceUV.func_178345_c(0));
        float v0 = blockFaceUV.func_178346_b(blockFaceUV.func_178345_c(0));
        vec.x = u0 / 16.0f;
        vec.y = v0 / 16.0f;
        uv.transform((Tuple4f)vec);
        float uMin = 16.0f * vec.x;
        float vMin = 16.0f * vec.y;
        float u1 = blockFaceUV.func_178348_a(blockFaceUV.func_178345_c(2));
        float v1 = blockFaceUV.func_178346_b(blockFaceUV.func_178345_c(2));
        vec.x = u1 / 16.0f;
        vec.y = v1 / 16.0f;
        vec.z = 0.0f;
        vec.w = 1.0f;
        uv.transform((Tuple4f)vec);
        float uMax = 16.0f * vec.x;
        float vMax = 16.0f * vec.y;
        if (uMin > uMax && u0 < u1 || uMin < uMax && u0 > u1) {
            t = uMin;
            uMin = uMax;
            uMax = t;
        }
        if (vMin > vMax && v0 < v1 || vMin < vMax && v0 > v1) {
            t = vMin;
            vMin = vMax;
            vMax = t;
        }
        float a = (float)Math.toRadians(blockFaceUV.field_178350_b);
        Vector3f rv = new Vector3f(MathHelper.func_76134_b((float)a), MathHelper.func_76126_a((float)a), 0.0f);
        Matrix3f rot = new Matrix3f();
        uv.getRotationScale(rot);
        rot.transform((Tuple3f)rv);
        int angle = MathHelper.func_180184_b((int)(-((int)Math.round(Math.toDegrees(Math.atan2(rv.y, rv.x)) / 90.0)) * 90), (int)360);
        return new BlockFaceUV(new float[]{uMin, vMin, uMax, vMax}, angle);
    }

    public static RenderGameOverlayEvent.BossInfo bossBarRenderPre(MainWindow res, BossInfoClient bossInfo, int x, int y, int increment) {
        RenderGameOverlayEvent.BossInfo evt = new RenderGameOverlayEvent.BossInfo(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO, bossInfo, x, y, increment);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static void bossBarRenderPost(MainWindow res) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO));
    }

    public static ScreenshotEvent onScreenshot(NativeImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static Pair<? extends IBakedModel, Matrix4f> handlePerspective(IBakedModel model, ItemCameraTransforms.TransformType type) {
        TRSRTransformation tr = TRSRTransformation.from(model.func_177552_f().func_181688_b(type));
        Matrix4f mat = null;
        if (!tr.equals(TRSRTransformation.identity())) {
            mat = tr.getMatrixVec();
        }
        return Pair.of((Object)model, (Object)mat);
    }

    public static void onInputUpdate(EntityPlayer player, MovementInput movementInput) {
        MinecraftForge.EVENT_BUS.post((Event)new InputUpdateEvent(player, movementInput));
    }

    public static void refreshResources(Minecraft mc, VanillaResourceType ... types) {
        SelectiveReloadStateHandler.INSTANCE.beginReload(ReloadRequirements.include(types));
        mc.func_110436_a();
        SelectiveReloadStateHandler.INSTANCE.endReload();
    }

    public static boolean onGuiMouseClickedPre(GuiScreen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseClickedEvent.Pre event = new GuiScreenEvent.MouseClickedEvent.Pre(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseClickedPost(GuiScreen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseClickedEvent.Post event = new GuiScreenEvent.MouseClickedEvent.Post(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseReleasedPre(GuiScreen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseReleasedEvent.Pre event = new GuiScreenEvent.MouseReleasedEvent.Pre(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseReleasedPost(GuiScreen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseReleasedEvent.Post event = new GuiScreenEvent.MouseReleasedEvent.Post(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseDragPre(GuiScreen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        GuiScreenEvent.MouseDragEvent.Pre event = new GuiScreenEvent.MouseDragEvent.Pre(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseDragPost(GuiScreen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        GuiScreenEvent.MouseDragEvent.Post event = new GuiScreenEvent.MouseDragEvent.Post(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseScrollPre(MouseHelper mouseHelper, GuiScreen guiScreen, double scrollDelta) {
        MainWindow mainWindow = guiScreen.field_146297_k.field_195558_d;
        double mouseX = mouseHelper.func_198024_e() * (double)mainWindow.func_198107_o() / (double)mainWindow.func_198105_m();
        double mouseY = mouseHelper.func_198026_f() * (double)mainWindow.func_198087_p() / (double)mainWindow.func_198083_n();
        GuiScreenEvent.MouseScrollEvent.Pre event = new GuiScreenEvent.MouseScrollEvent.Pre(guiScreen, mouseX, mouseY, scrollDelta);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseScrollPost(MouseHelper mouseHelper, GuiScreen guiScreen, double scrollDelta) {
        MainWindow mainWindow = guiScreen.field_146297_k.field_195558_d;
        double mouseX = mouseHelper.func_198024_e() * (double)mainWindow.func_198107_o() / (double)mainWindow.func_198105_m();
        double mouseY = mouseHelper.func_198026_f() * (double)mainWindow.func_198087_p() / (double)mainWindow.func_198083_n();
        GuiScreenEvent.MouseScrollEvent.Post event = new GuiScreenEvent.MouseScrollEvent.Post(guiScreen, mouseX, mouseY, scrollDelta);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyPressedPre(GuiScreen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyPressedEvent.Pre event = new GuiScreenEvent.KeyboardKeyPressedEvent.Pre(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyPressedPost(GuiScreen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyPressedEvent.Post event = new GuiScreenEvent.KeyboardKeyPressedEvent.Post(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyReleasedPre(GuiScreen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyReleasedEvent.Pre event = new GuiScreenEvent.KeyboardKeyReleasedEvent.Pre(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyReleasedPost(GuiScreen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyReleasedEvent.Post event = new GuiScreenEvent.KeyboardKeyReleasedEvent.Post(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiCharTypedPre(GuiScreen guiScreen, char codePoint, int modifiers) {
        GuiScreenEvent.KeyboardCharTypedEvent.Pre event = new GuiScreenEvent.KeyboardCharTypedEvent.Pre(guiScreen, codePoint, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiCharTypedPost(GuiScreen guiScreen, char codePoint, int modifiers) {
        GuiScreenEvent.KeyboardCharTypedEvent.Post event = new GuiScreenEvent.KeyboardCharTypedEvent.Post(guiScreen, codePoint, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void onRecipesUpdated() {
        RecipesUpdatedEvent event = new RecipesUpdatedEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void invalidateLog4jThreadCache() {
        try {
            Field nameField = ThreadNameCachingStrategy.class.getDeclaredField("THREADLOCAL_NAME");
            Field logEventField = ReusableLogEventFactory.class.getDeclaredField("mutableLogEventThreadLocal");
            nameField.setAccessible(true);
            logEventField.setAccessible(true);
            ((ThreadLocal)nameField.get(null)).set(null);
            ((ThreadLocal)logEventField.get(null)).set(null);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            LOGGER.error("Unable to invalidate log4j thread cache, thread fields in logs may be inaccurate", e);
        }
    }

    public static void fireMouseInput(int button, int action, int mods) {
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.MouseInputEvent(button, action, mods));
    }

    public static void fireKeyInput(int key, int scanCode, int action, int modifiers) {
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.KeyInputEvent(key, scanCode, action, modifiers));
    }

    static {
        flipX = new Matrix4f();
        flipX.setIdentity();
        ForgeHooksClient.flipX.m00 = -1.0f;
        matrixBuf = BufferUtils.createFloatBuffer((int)16);
        lightGatherer = new LightGatheringTransformer();
        slotMainHand = 0;
    }

    private static class LightGatheringTransformer
    extends QuadGatheringTransformer {
        private static final VertexFormat FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p);
        int blockLight;
        int skyLight;

        private LightGatheringTransformer() {
            this.setVertexFormat(FORMAT);
        }

        boolean hasLighting() {
            return this.dataLength[1] >= 2;
        }

        @Override
        protected void processQuad() {
            this.blockLight = 0;
            this.skyLight = 0;
            for (int i = 0; i < 4; ++i) {
                this.blockLight += (int)(this.quadData[1][i][0] * 65535.0f / 32.0f);
                this.skyLight += (int)(this.quadData[1][i][1] * 65535.0f / 32.0f);
            }
            this.blockLight *= 4;
            this.skyLight *= 4;
        }

        @Override
        public void setQuadTint(int tint) {
        }

        @Override
        public void setQuadOrientation(EnumFacing orientation) {
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        @Override
        public void setTexture(TextureAtlasSprite texture) {
        }
    }
}

