/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.EndDimension;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public interface IForgeBlock {
    default public Block getBlock() {
        return (Block)this;
    }

    public float getSlipperiness(IBlockState var1, IWorldReader var2, BlockPos var3, @Nullable Entity var4);

    default public int getLightValue(IBlockState state, IWorldReader world, BlockPos pos) {
        return state.func_185906_d();
    }

    default public boolean isLadder(IBlockState state, IWorldReader world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    default public boolean isNormalCube(IBlockState state, IBlockReader world, BlockPos pos) {
        return state.func_185915_l();
    }

    default public boolean doesSideBlockRendering(IBlockState state, IWorldReader world, BlockPos pos, EnumFacing face) {
        return state.func_200015_d((IBlockReader)world, pos);
    }

    default public boolean isBurning(IBlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    default public boolean hasTileEntity(IBlockState state) {
        return this instanceof ITileEntityProvider;
    }

    @Nullable
    default public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        if (this.getBlock() instanceof ITileEntityProvider) {
            return ((ITileEntityProvider)this.getBlock()).func_196283_a_(world);
        }
        return null;
    }

    public boolean canSilkHarvest(IBlockState var1, IWorldReader var2, BlockPos var3, EntityPlayer var4);

    default public boolean canHarvestBlock(IBlockState state, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return ForgeHooks.canHarvestBlock(state, player, world, pos);
    }

    default public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        this.getBlock().func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, fluid.func_206883_i(), world.field_72995_K ? 11 : 3);
    }

    default public boolean isBed(IBlockState state, IBlockReader world, BlockPos pos, @Nullable Entity player) {
        return this.getBlock() instanceof BlockBed;
    }

    default public boolean canCreatureSpawn(IBlockState state, IWorldReaderBase world, BlockPos pos, EntitySpawnPlacementRegistry.SpawnPlacementType type, @Nullable EntityType<? extends EntityLiving> entityType) {
        return state.func_185896_q() || entityType != null && EntitySpawnPlacementRegistry.func_209345_a(entityType, (IBlockState)state);
    }

    @Nullable
    default public BlockPos getBedSpawnPosition(IBlockState state, IBlockReader world, BlockPos pos, @Nullable EntityPlayer player) {
        if (world instanceof World) {
            return BlockBed.func_176468_a((IBlockReader)world, (BlockPos)pos, (int)0);
        }
        return null;
    }

    default public void setBedOccupied(IBlockState state, IWorldReader world, BlockPos pos, EntityPlayer player, boolean occupied) {
        if (world instanceof IWorldWriter) {
            ((IWorldWriter)world).func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 4);
        }
    }

    default public EnumFacing getBedDirection(IBlockState state, IWorldReader world, BlockPos pos) {
        return (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    default public boolean isBedFoot(IBlockState state, IWorldReader world, BlockPos pos) {
        return state.func_177229_b((IProperty)BlockBed.field_176472_a) == BedPart.FOOT;
    }

    default public void beginLeaveDecay(IBlockState state, IWorldReader world, BlockPos pos) {
    }

    default public boolean isAir(IBlockState state, IBlockReader world, BlockPos pos) {
        return state.func_185904_a() == Material.field_151579_a;
    }

    default public boolean canBeReplacedByLeaves(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        return this.isAir(state, (IBlockReader)world, pos) || state.func_203425_a(BlockTags.field_206952_E) || !state.func_200015_d((IBlockReader)world, pos);
    }

    default public boolean isReplaceableOreGen(IBlockState state, IWorldReader world, BlockPos pos, Predicate<IBlockState> target) {
        return target.test(state);
    }

    default public float getExplosionResistance(IBlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getBlock().func_149638_a();
    }

    default public void onBlockExploded(IBlockState state, World world, BlockPos pos, Explosion explosion) {
        world.func_175698_g(pos);
        this.getBlock().func_180652_a(world, pos, explosion);
    }

    default public boolean canConnectRedstone(IBlockState state, IBlockReader world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_185897_m() && side != null;
    }

    default public boolean canPlaceTorchOnTop(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        if (this == Blocks.field_185775_db) {
            return false;
        }
        if (this instanceof BlockFence || this instanceof BlockStainedGlass || this == Blocks.field_150359_w || this == Blocks.field_150463_bK || this == Blocks.field_196723_eg || state.func_185896_q()) {
            return true;
        }
        BlockFaceShape shape = state.func_193401_d((IBlockReader)world, pos, EnumFacing.UP);
        return (shape == BlockFaceShape.SOLID || shape == BlockFaceShape.CENTER || shape == BlockFaceShape.CENTER_BIG) && !Block.func_193384_b((Block)this.getBlock());
    }

    default public ItemStack getPickBlock(IBlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return this.getBlock().func_185473_a(world, pos, state);
    }

    default public boolean isFoliage(IBlockState state, IWorldReader world, BlockPos pos) {
        return false;
    }

    default public boolean addLandingEffects(IBlockState state1, WorldServer worldserver, BlockPos pos, IBlockState state2, EntityLivingBase entity, int numberOfParticles) {
        return false;
    }

    default public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean addDestroyEffects(IBlockState state, World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    public boolean canSustainPlant(IBlockState var1, IBlockReader var2, BlockPos var3, EnumFacing var4, IPlantable var5);

    default public void onPlantGrow(IBlockState state, IWorld world, BlockPos pos, BlockPos source) {
        if (this.getBlock() == Blocks.field_196658_i || this.getBlock() == Blocks.field_150391_bh || this.getBlock() == Blocks.field_150458_ak || this.getBlock() == Blocks.field_150350_a) {
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
        }
    }

    default public boolean isFertile(IBlockState state, IBlockReader world, BlockPos pos) {
        if (this.getBlock() == Blocks.field_150458_ak) {
            return (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) > 0;
        }
        return false;
    }

    default public boolean isBeaconBase(IBlockState state, IWorldReader world, BlockPos pos, BlockPos beacon) {
        return this.getBlock() == Blocks.field_150475_bE || this.getBlock() == Blocks.field_150340_R || this.getBlock() == Blocks.field_150484_ah || this.getBlock() == Blocks.field_150339_S;
    }

    default public int getExpDrop(IBlockState state, IWorldReader world, BlockPos pos, int fortune) {
        return 0;
    }

    default public IBlockState rotate(IBlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return state.func_185907_a(direction);
    }

    @Nullable
    default public EnumFacing[] getValidRotations(IBlockState state, IBlockReader world, BlockPos pos) {
        for (IProperty prop : state.func_206869_a()) {
            if (!prop.func_177701_a().equals("facing") && !prop.func_177701_a().equals("rotation") || prop.func_177699_b() != EnumFacing.class) continue;
            Collection values = prop.func_177700_c();
            return values.toArray(new EnumFacing[values.size()]);
        }
        return null;
    }

    default public float getEnchantPowerBonus(IBlockState state, IWorldReader world, BlockPos pos) {
        return this.getBlock() == Blocks.field_150342_X ? 1.0f : 0.0f;
    }

    default public boolean recolorBlock(IBlockState state, IWorld world, BlockPos pos, EnumFacing facing, EnumDyeColor color) {
        for (IProperty prop : state.func_206869_a()) {
            EnumDyeColor current;
            if (!prop.func_177701_a().equals("color") || prop.func_177699_b() != EnumDyeColor.class || (current = (EnumDyeColor)state.func_177229_b(prop)) == color || !prop.func_177700_c().contains(color)) continue;
            world.func_180501_a(pos, (IBlockState)state.func_206870_a(prop, (Comparable)color), 3);
            return true;
        }
        return false;
    }

    default public void onNeighborChange(IBlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
    }

    default public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
    }

    default public boolean shouldCheckWeakPower(IBlockState state, IWorldReader world, BlockPos pos, EnumFacing side) {
        return state.isNormalCube((IBlockReader)world, pos);
    }

    default public boolean getWeakChanges(IBlockState state, IWorldReader world, BlockPos pos) {
        return false;
    }

    public ToolType getHarvestTool(IBlockState var1);

    public int getHarvestLevel(IBlockState var1);

    default public boolean isToolEffective(IBlockState state, ToolType tool) {
        if (tool == ToolType.PICKAXE && (this.getBlock() == Blocks.field_150450_ax || this.getBlock() == Blocks.field_150379_bu || this.getBlock() == Blocks.field_150343_Z)) {
            return false;
        }
        return tool == this.getHarvestTool(state);
    }

    default public IBlockState getExtendedState(IBlockState state, IBlockReader world, BlockPos pos) {
        return state;
    }

    default public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.getBlock().func_180664_k() == layer;
    }

    default public SoundType getSoundType(IBlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getBlock().func_185467_w();
    }

    @Nullable
    default public float[] getBeaconColorMultiplier(IBlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Vec3d getFogColor(IBlockState state, IWorldReader world, BlockPos pos, Entity entity, Vec3d originalColor, float partialTicks) {
        if (state.func_185904_a() == Material.field_151586_h) {
            float f12 = 0.0f;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)entity;
                f12 = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)ent) * 0.2f;
                if (ent.func_70644_a(MobEffects.field_76427_o)) {
                    f12 = f12 * 0.3f + 0.6f;
                }
            }
            return new Vec3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
        }
        if (state.func_185904_a() == Material.field_151587_i) {
            return new Vec3d((double)0.6f, (double)0.1f, 0.0);
        }
        return originalColor;
    }

    default public IBlockState getStateAtViewpoint(IBlockState state, IBlockReader world, BlockPos pos, Vec3d viewpoint) {
        return state;
    }

    default public IBlockState getStateForPlacement(IBlockState state, EnumFacing facing, IBlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, EnumHand hand) {
        return this.getBlock().func_196271_a(state, facing, state2, world, pos1, pos2);
    }

    default public boolean canBeConnectedTo(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    @Nullable
    default public PathNodeType getAiPathNodeType(IBlockState state, IBlockReader world, BlockPos pos, @Nullable EntityLiving entity) {
        return state.isBurning(world, pos) ? PathNodeType.DAMAGE_FIRE : null;
    }

    default public boolean doesSideBlockChestOpening(IBlockState blockState, IBlockReader world, BlockPos pos, EnumFacing side) {
        ResourceLocation registryName = this.getBlock().getRegistryName();
        if (registryName != null && "minecraft".equals(registryName.func_110624_b())) {
            return blockState.isNormalCube(world, pos);
        }
        return blockState.func_185896_q();
    }

    default public boolean isStickyBlock(IBlockState state) {
        return state.func_177230_c() == Blocks.field_180399_cE;
    }

    default public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        int count = this.getBlock().func_196251_a(state, fortune, world, pos, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.getBlock().func_199769_a(state, world, pos, fortune).func_199767_j();
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack((IItemProvider)item));
        }
    }

    default public int getFlammability(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing face) {
        return ((BlockFire)Blocks.field_150480_ab).func_176532_c(this.getBlock());
    }

    default public boolean isFlammable(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing face) {
        return state.getFlammability(world, pos, face) > 0;
    }

    default public int getFireSpreadSpeed(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing face) {
        return ((BlockFire)Blocks.field_150480_ab).func_176534_d(this.getBlock());
    }

    default public boolean isFireSource(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP) {
            return false;
        }
        if (this.getBlock() == Blocks.field_150424_aL || this.getBlock() == Blocks.field_196814_hQ) {
            return true;
        }
        return world instanceof World && ((World)world).field_73011_w instanceof EndDimension && this.getBlock() == Blocks.field_150357_h;
    }

    default public boolean canEntityDestroy(IBlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon) {
            return this != Blocks.field_180401_cv && this != Blocks.field_150343_Z && this != Blocks.field_150377_bs && this != Blocks.field_150357_h && this != Blocks.field_150384_bq && this != Blocks.field_150378_br && this != Blocks.field_150483_bI && this != Blocks.field_185776_dc && this != Blocks.field_185777_dd && this != Blocks.field_150411_aY && this != Blocks.field_185775_db;
        }
        if (entity instanceof EntityWither || entity instanceof EntityWitherSkull) {
            return EntityWither.func_181033_a((Block)this.getBlock());
        }
        return true;
    }

    default public boolean isTopSolid(IBlockState state, IWorldReader world, BlockPos pos) {
        return state.func_185896_q();
    }

    @Nullable
    default public RayTraceResult getRayTraceResult(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end, RayTraceResult original) {
        return original;
    }
}

