/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.terraingen;

import java.util.Random;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.world.WorldEvent;

public class InitNoiseGensEvent<T extends Context>
extends WorldEvent {
    private final Random rand;
    private final T original;
    private T newValues;

    public InitNoiseGensEvent(IWorld world, Random rand, T original) {
        super(world);
        this.rand = rand;
        this.original = original;
        this.newValues = ((Context)original).clone();
    }

    public Random getRandom() {
        return this.rand;
    }

    public T getOriginal() {
        return this.original;
    }

    public T getNewValues() {
        return this.newValues;
    }

    public static class ContextHell
    extends Context {
        private NoiseGeneratorOctaves perlin2;

        public ContextHell(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorOctaves perlin2, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.perlin2 = perlin2;
        }

        @Override
        public ContextHell clone() {
            return new ContextHell(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.perlin2, this.getScale(), this.getDepth());
        }

        public NoiseGeneratorOctaves getPerlin2() {
            return this.perlin2;
        }

        public void getPerlin2(NoiseGeneratorOctaves value) {
            this.perlin2 = value;
        }
    }

    public static class ContextEnd
    extends Context {
        private NoiseGeneratorPerlin island;

        public ContextEnd(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth, NoiseGeneratorPerlin field_205478_l) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.island = field_205478_l;
        }

        @Override
        public ContextEnd clone() {
            return new ContextEnd(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.getScale(), this.getDepth(), this.island);
        }

        public NoiseGeneratorPerlin getIsland() {
            return this.island;
        }

        public void getIsland(NoiseGeneratorPerlin value) {
            this.island = value;
        }
    }

    public static class ContextOverworld
    extends Context {
        private NoiseGeneratorPerlin height;

        public ContextOverworld(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorPerlin height, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.height = height;
        }

        @Override
        public ContextOverworld clone() {
            return new ContextOverworld(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.height, this.getScale(), this.getDepth());
        }

        public NoiseGeneratorPerlin getHeight() {
            return this.height;
        }

        public void getHeight(NoiseGeneratorPerlin value) {
            this.height = value;
        }
    }

    public static class Context {
        private NoiseGeneratorOctaves lperlin1;
        private NoiseGeneratorOctaves lperlin2;
        private NoiseGeneratorOctaves perlin;
        private NoiseGeneratorOctaves scale;
        private NoiseGeneratorOctaves depth;

        public Context(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth) {
            this.lperlin1 = lperlin1;
            this.lperlin2 = lperlin2;
            this.perlin = perlin;
            this.scale = scale;
            this.depth = depth;
        }

        public NoiseGeneratorOctaves getLPerlin1() {
            return this.lperlin1;
        }

        public NoiseGeneratorOctaves getLPerlin2() {
            return this.lperlin2;
        }

        public NoiseGeneratorOctaves getPerlin() {
            return this.perlin;
        }

        public NoiseGeneratorOctaves getScale() {
            return this.scale;
        }

        public NoiseGeneratorOctaves getDepth() {
            return this.depth;
        }

        public void setLPerlin1(NoiseGeneratorOctaves value) {
            this.lperlin1 = value;
        }

        public void getLPerlin2(NoiseGeneratorOctaves value) {
            this.lperlin2 = value;
        }

        public void getPerlin(NoiseGeneratorOctaves value) {
            this.perlin = value;
        }

        public void getScale(NoiseGeneratorOctaves value) {
            this.scale = value;
        }

        public void getDepth(NoiseGeneratorOctaves value) {
            this.depth = value;
        }

        public Context clone() {
            return new Context(this.lperlin1, this.lperlin2, this.perlin, this.scale, this.depth);
        }
    }
}

