/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DispenseFluidContainer
extends BehaviorDefaultDispenseItem {
    private static final DispenseFluidContainer INSTANCE = new DispenseFluidContainer();
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    public static DispenseFluidContainer getInstance() {
        return INSTANCE;
    }

    private DispenseFluidContainer() {
    }

    @Nonnull
    public ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        if (FluidUtil.getFluidContained(stack) != null) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    @Nonnull
    private ItemStack fillContainer(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        World world = source.func_197524_h();
        EnumFacing dispenserFacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);
        FluidActionResult actionResult = FluidUtil.tryPickUpFluid(stack, null, world, blockpos, dispenserFacing.func_176734_d());
        ItemStack resultStack = actionResult.getResult();
        if (!actionResult.isSuccess() || resultStack.func_190926_b()) {
            return super.func_82487_b(source, stack);
        }
        if (stack.func_190916_E() == 1) {
            return resultStack;
        }
        if (((TileEntityDispenser)source.func_150835_j()).func_146019_a(resultStack) < 0) {
            this.dispenseBehavior.dispense(source, resultStack);
        }
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.func_190918_g(1);
        return stackCopy;
    }

    @Nonnull
    private ItemStack dumpContainer(IBlockSource source, @Nonnull ItemStack stack) {
        FluidActionResult result;
        ItemStack singleStack = stack.func_77946_l();
        singleStack.func_190920_e(1);
        IFluidHandler fluidHandler = null;
        if (fluidHandler == null) {
            return super.func_82487_b(source, stack);
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        EnumFacing dispenserFacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);
        FluidActionResult fluidActionResult = result = fluidStack != null ? FluidUtil.tryPlaceFluid(null, source.func_197524_h(), blockpos, stack, fluidStack) : FluidActionResult.FAILURE;
        if (result.isSuccess()) {
            ItemStack drainedStack = result.getResult();
            if (drainedStack.func_190916_E() == 1) {
                return drainedStack;
            }
            if (!drainedStack.func_190926_b() && ((TileEntityDispenser)source.func_150835_j()).func_146019_a(drainedStack) < 0) {
                this.dispenseBehavior.dispense(source, drainedStack);
            }
            ItemStack stackCopy = drainedStack.func_77946_l();
            stackCopy.func_190918_g(1);
            return stackCopy;
        }
        return this.dispenseBehavior.dispense(source, stack);
    }
}

