/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.collect.ImmutableList;
import cpw.mods.modlauncher.TransformingClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LifecycleEventProvider;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ModLoader INSTANCE;
    private final TransformingClassLoader launchClassLoader;
    private final LoadingModList loadingModList;
    private final List<ModLoadingException> loadingExceptions;
    private final List<ModLoadingWarning> loadingWarnings;

    private ModLoader() {
        INSTANCE = this;
        this.launchClassLoader = FMLLoader.getLaunchClassLoader();
        this.loadingModList = FMLLoader.getLoadingModList();
        this.loadingExceptions = FMLLoader.getLoadingModList().getErrors().stream().flatMap(ModLoadingException::fromEarlyException).collect(Collectors.toList());
        this.loadingWarnings = FMLLoader.getLoadingModList().getBrokenFiles().stream().map(file -> new ModLoadingWarning(null, ModLoadingStage.VALIDATE, "fml.modloading.brokenfile", file.getFileName())).collect(Collectors.toList());
        LOGGER.info(Logging.CORE, "Loading Network data for FML net version: {}", (Object)"FML2");
    }

    public static ModLoader get() {
        return INSTANCE == null ? (INSTANCE = new ModLoader()) : INSTANCE;
    }

    private static Runnable fireClientEvents() {
        return () -> MinecraftForge.EVENT_BUS.post((Event)new ModelRegistryEvent());
    }

    public void loadMods() {
        ModList modList = ModList.of(this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).collect(Collectors.toList()), this.loadingModList.getMods());
        if (!this.loadingExceptions.isEmpty()) {
            throw new LoadingFailedException(this.loadingExceptions);
        }
        List<ModContainer> modContainers = this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).map(mf -> this.buildMods((ModFile)mf, this.launchClassLoader)).flatMap(Collection::stream).collect(Collectors.toList());
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to initialize mod containers");
            throw new LoadingFailedException(this.loadingExceptions);
        }
        modList.setLoadedMods(modContainers);
        this.dispatchAndHandleError(LifecycleEventProvider.CONSTRUCT);
        GameData.fireCreateRegistryEvents(LifecycleEventProvider.CREATE_REGISTRIES, this::dispatchAndHandleError);
        ObjectHolderRegistry.findObjectHolders();
        CapabilityManager.INSTANCE.injectCapabilities(modList.getAllScanData());
        GameData.fireRegistryEvents(rl -> true, LifecycleEventProvider.LOAD_REGISTRIES, this::dispatchAndHandleError);
        DistExecutor.runWhenOn(Dist.CLIENT, () -> () -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get()));
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, FMLPaths.CONFIGDIR.get());
        this.dispatchAndHandleError(LifecycleEventProvider.SETUP);
        DistExecutor.runWhenOn(Dist.CLIENT, ModLoader::fireClientEvents);
        this.dispatchAndHandleError(LifecycleEventProvider.SIDED_SETUP);
    }

    private void dispatchAndHandleError(LifecycleEventProvider event) {
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.error(Logging.LOADING, "Skipping lifecycle event {}, {} errors found.", (Object)event, (Object)this.loadingExceptions.size());
        } else {
            event.dispatch(this::accumulateErrors);
        }
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.LOADING, "Failed to complete lifecycle event {}, {} errors found", (Object)event, (Object)this.loadingExceptions.size());
            throw new LoadingFailedException(this.loadingExceptions);
        }
    }

    private void accumulateErrors(List<ModLoadingException> errors) {
        this.loadingExceptions.addAll(errors);
    }

    private List<ModContainer> buildMods(ModFile modFile, TransformingClassLoader modClassLoader) {
        Map modInfoMap = modFile.getModFileInfo().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, Function.identity()));
        LOGGER.debug(Logging.LOADING, "ModContainer is {}", (Object)ModContainer.class.getClassLoader());
        List<ModContainer> containers = modFile.getScanResult().getTargets().entrySet().stream().map(e -> this.buildModContainerFromTOML(modFile, modClassLoader, modInfoMap, (Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader>)e)).collect(Collectors.toList());
        if (containers.size() != modInfoMap.size()) {
            LOGGER.fatal(Logging.LOADING, "File {} constructed {} mods: {}, but had {} mods specified: {}", (Object)modFile.getFilePath(), (Object)containers.size(), containers.stream().map(ModContainer::getModId).collect(Collectors.toList()), (Object)modInfoMap.size(), modInfoMap.values().stream().map(IModInfo::getModId).collect(Collectors.toList()));
            this.loadingExceptions.add(new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingclasses", null, modFile.getFilePath()));
        }
        return containers;
    }

    private ModContainer buildModContainerFromTOML(ModFile modFile, TransformingClassLoader modClassLoader, Map<String, IModInfo> modInfoMap, Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader> idToProviderEntry) {
        try {
            String modId = idToProviderEntry.getKey();
            IModLanguageProvider.IModLanguageLoader languageLoader = idToProviderEntry.getValue();
            IModInfo info = Optional.ofNullable(modInfoMap.get(modId)).orElseThrow(() -> new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingmetadata", null, modId));
            return (ModContainer)languageLoader.loadMod(info, (ClassLoader)modClassLoader, modFile.getScanResult());
        }
        catch (ModLoadingException mle) {
            this.loadingExceptions.add(mle);
            return null;
        }
    }

    public void finishMods() {
        this.dispatchAndHandleError(LifecycleEventProvider.ENQUEUE_IMC);
        this.dispatchAndHandleError(LifecycleEventProvider.PROCESS_IMC);
        this.dispatchAndHandleError(LifecycleEventProvider.COMPLETE);
        GameData.freezeData();
        NetworkRegistry.lock();
    }

    public List<ModLoadingWarning> getWarnings() {
        return ImmutableList.copyOf(this.loadingWarnings);
    }

    public void addWarning(ModLoadingWarning warning) {
        this.loadingWarnings.add(warning);
    }
}

