/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkEvent;

public class FMLPlayMessages {

    public static class OpenContainer {
        private final ResourceLocation id;
        private final int windowId;
        private final PacketBuffer additionalData;

        OpenContainer(ResourceLocation id, int windowId, PacketBuffer additionalData) {
            this.id = id;
            this.windowId = windowId;
            this.additionalData = additionalData;
        }

        public static void encode(OpenContainer msg, PacketBuffer buf) {
            buf.func_192572_a(msg.id);
            buf.func_150787_b(msg.windowId);
            buf.func_179250_a(msg.additionalData.func_179251_a());
        }

        public static OpenContainer decode(PacketBuffer buf) {
            return new OpenContainer(buf.func_192575_l(), buf.func_150792_a(), new PacketBuffer(Unpooled.wrappedBuffer((byte[])buf.func_189425_b(32600))));
        }

        public static void handle(OpenContainer msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> ModList.get().getModContainerById(msg.id.func_110624_b()).ifPresent(mc -> mc.getCustomExtension(ExtensionPoint.GUIFACTORY).map(f -> (GuiScreen)f.apply(msg)).ifPresent(gui -> {
                Minecraft.func_71410_x().func_147108_a(gui);
                Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75152_c = msg.windowId;
            })));
            ctx.get().setPacketHandled(true);
        }

        public final ResourceLocation getId() {
            return this.id;
        }

        public int getWindowId() {
            return this.windowId;
        }

        public PacketBuffer getAdditionalData() {
            return this.additionalData;
        }
    }

    public static class SpawnEntity {
        private final Entity entity;
        private final int typeId;
        private final int entityId;
        private final UUID uuid;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final byte pitch;
        private final byte yaw;
        private final byte headYaw;
        private final short velX;
        private final short velY;
        private final short velZ;
        private final PacketBuffer buf;

        SpawnEntity(Entity e) {
            this.entity = e;
            this.typeId = IRegistry.field_212629_r.func_148757_b((Object)e.func_200600_R());
            this.entityId = e.func_145782_y();
            this.uuid = e.func_110124_au();
            this.posX = e.field_70165_t;
            this.posY = e.field_70163_u;
            this.posZ = e.field_70161_v;
            this.pitch = (byte)MathHelper.func_76141_d((float)(e.field_70125_A * 256.0f / 360.0f));
            this.yaw = (byte)MathHelper.func_76141_d((float)(e.field_70177_z * 256.0f / 360.0f));
            this.headYaw = (byte)(e.func_70079_am() * 256.0f / 360.0f);
            this.velX = (short)(MathHelper.func_151237_a((double)e.field_70159_w, (double)-3.9, (double)3.9) * 8000.0);
            this.velY = (short)(MathHelper.func_151237_a((double)e.field_70181_x, (double)-3.9, (double)3.9) * 8000.0);
            this.velZ = (short)(MathHelper.func_151237_a((double)e.field_70179_y, (double)-3.9, (double)3.9) * 8000.0);
            this.buf = null;
        }

        private SpawnEntity(int typeId, int entityId, UUID uuid, double posX, double posY, double posZ, byte pitch, byte yaw, byte headYaw, short velX, short velY, short velZ, PacketBuffer buf) {
            this.entity = null;
            this.typeId = typeId;
            this.entityId = entityId;
            this.uuid = uuid;
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.pitch = pitch;
            this.yaw = yaw;
            this.headYaw = headYaw;
            this.velX = velX;
            this.velY = velY;
            this.velZ = velZ;
            this.buf = buf;
        }

        public static void encode(SpawnEntity msg, PacketBuffer buf) {
            buf.func_150787_b(msg.typeId);
            buf.writeInt(msg.entityId);
            buf.writeLong(msg.uuid.getMostSignificantBits());
            buf.writeLong(msg.uuid.getLeastSignificantBits());
            buf.writeDouble(msg.posX);
            buf.writeDouble(msg.posY);
            buf.writeDouble(msg.posZ);
            buf.writeByte((int)msg.pitch);
            buf.writeByte((int)msg.yaw);
            buf.writeByte((int)msg.headYaw);
            buf.writeShort((int)msg.velX);
            buf.writeShort((int)msg.velY);
            buf.writeShort((int)msg.velZ);
            if (msg.entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)msg.entity).writeSpawnData(buf);
            }
        }

        public static SpawnEntity decode(PacketBuffer buf) {
            return new SpawnEntity(buf.func_150792_a(), buf.readInt(), new UUID(buf.readLong(), buf.readLong()), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readByte(), buf.readByte(), buf.readByte(), buf.readShort(), buf.readShort(), buf.readShort(), buf);
        }

        public static void handle(SpawnEntity msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityType type = (EntityType)IRegistry.field_212629_r.func_148754_a(msg.typeId);
                if (type == null) {
                    throw new RuntimeException(String.format("Could not spawn entity (id %d) with unknown type at (%f, %f, %f)", msg.entityId, msg.posX, msg.posY, msg.posZ));
                }
                Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide());
                Entity e = world.map(w -> type.handleSpawnMessage(w, msg)).orElse(null);
                if (e == null) {
                    return;
                }
                EntityTracker.func_187254_a((Entity)e, (double)msg.posX, (double)msg.posY, (double)msg.posZ);
                e.func_70080_a(msg.posX, msg.posY, msg.posZ, (float)(msg.yaw * 360) / 256.0f, (float)(msg.pitch * 360) / 256.0f);
                e.func_70034_d((float)(msg.headYaw * 360) / 256.0f);
                e.func_181013_g((float)(msg.headYaw * 360) / 256.0f);
                Entity[] parts = e.func_70021_al();
                if (parts != null) {
                    int offset = msg.entityId - e.func_145782_y();
                    for (Entity part : parts) {
                        part.func_145769_d(part.func_145782_y() + offset);
                    }
                }
                e.func_145769_d(msg.entityId);
                e.func_184221_a(msg.uuid);
                Minecraft.func_71410_x().field_71441_e.func_73027_a(msg.entityId, e);
                e.func_70016_h((double)msg.velX / 8000.0, (double)msg.velY / 8000.0, (double)msg.velZ / 8000.0);
                if (e instanceof IEntityAdditionalSpawnData) {
                    ((IEntityAdditionalSpawnData)e).readSpawnData(msg.buf);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

