/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.FMLHandshakeMessages;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.util.ThreeConsumer;
import net.minecraftforge.registries.RegistryManager;

class NetworkInitialization {
    NetworkInitialization() {
    }

    public static SimpleChannel getHandshakeChannel() {
        SimpleChannel handshakeChannel = NetworkRegistry.ChannelBuilder.named(FMLNetworkConstants.FML_HANDSHAKE_RESOURCE).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").simpleChannel();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.C2SAcknowledge.class, 99).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.C2SAcknowledge::decode).encoder(FMLHandshakeMessages.C2SAcknowledge::encode).consumer(NetworkInitialization.indexFirst(FMLHandshakeHandler::handleClientAck)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.S2CModList.class, 1).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.S2CModList::decode).encoder(FMLHandshakeMessages.S2CModList::encode).markAsLoginPacket().consumer(NetworkInitialization.biConsumerFor(FMLHandshakeHandler::handleServerModListOnClient)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.C2SModListReply.class, 2).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.C2SModListReply::decode).encoder(FMLHandshakeMessages.C2SModListReply::encode).consumer(NetworkInitialization.indexFirst(FMLHandshakeHandler::handleClientModListOnServer)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.S2CRegistry.class, 3).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.S2CRegistry::decode).encoder(FMLHandshakeMessages.S2CRegistry::encode).buildLoginPacketList(RegistryManager::generateRegistryPackets).consumer(NetworkInitialization.biConsumerFor(FMLHandshakeHandler::handleRegistryMessage)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.S2CConfigData.class, 4).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.S2CConfigData::decode).encoder(FMLHandshakeMessages.S2CConfigData::encode).buildLoginPacketList(ConfigTracker.INSTANCE::syncConfigs).consumer(NetworkInitialization.biConsumerFor(FMLHandshakeHandler::handleConfigSync)).add();
        return handshakeChannel;
    }

    public static SimpleChannel getPlayChannel() {
        SimpleChannel playChannel = NetworkRegistry.ChannelBuilder.named(FMLNetworkConstants.FML_PLAY_RESOURCE).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").simpleChannel();
        playChannel.messageBuilder(FMLPlayMessages.SpawnEntity.class, 0).decoder(FMLPlayMessages.SpawnEntity::decode).encoder(FMLPlayMessages.SpawnEntity::encode).consumer(FMLPlayMessages.SpawnEntity::handle).add();
        playChannel.messageBuilder(FMLPlayMessages.OpenContainer.class, 1).decoder(FMLPlayMessages.OpenContainer::decode).encoder(FMLPlayMessages.OpenContainer::encode).consumer(FMLPlayMessages.OpenContainer::handle).add();
        return playChannel;
    }

    private static <MSG extends FMLHandshakeMessages.LoginIndexedMessage> BiConsumer<MSG, Supplier<NetworkEvent.Context>> biConsumerFor(ThreeConsumer<FMLHandshakeHandler, ? super MSG, ? super Supplier<NetworkEvent.Context>> consumer) {
        return (m, c) -> ThreeConsumer.bindArgs(consumer, m, c).accept(NetworkInitialization.getHandshake(c));
    }

    private static <MSG extends FMLHandshakeMessages.LoginIndexedMessage> BiConsumer<MSG, Supplier<NetworkEvent.Context>> indexFirst(ThreeConsumer<FMLHandshakeHandler, MSG, Supplier<NetworkEvent.Context>> next) {
        BiConsumer<FMLHandshakeMessages.LoginIndexedMessage, Supplier<NetworkEvent.Context>> loginIndexedMessageSupplierBiConsumer = NetworkInitialization.biConsumerFor(FMLHandshakeHandler::handleIndexedMessage);
        return loginIndexedMessageSupplierBiConsumer.andThen(NetworkInitialization.biConsumerFor(next));
    }

    private static FMLHandshakeHandler getHandshake(Supplier<NetworkEvent.Context> contextSupplier) {
        return (FMLHandshakeHandler)contextSupplier.get().attr(FMLNetworkConstants.FML_HANDSHAKE_HANDLER).get();
    }
}

