/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CapabilityItemHandler {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IItemHandler.class, new Capability.IStorage<IItemHandler>(){

            @Override
            public INBTBase writeNBT(Capability<IItemHandler> capability, IItemHandler instance, EnumFacing side) {
                NBTTagList nbtTagList = new NBTTagList();
                int size = instance.getSlots();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = instance.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    NBTTagCompound itemTag = new NBTTagCompound();
                    itemTag.func_74768_a("Slot", i);
                    stack.func_77955_b(itemTag);
                    nbtTagList.add((INBTBase)itemTag);
                }
                return nbtTagList;
            }

            @Override
            public void readNBT(Capability<IItemHandler> capability, IItemHandler instance, EnumFacing side, INBTBase base) {
                if (!(instance instanceof IItemHandlerModifiable)) {
                    throw new RuntimeException("IItemHandler instance does not implement IItemHandlerModifiable");
                }
                IItemHandlerModifiable itemHandlerModifiable = (IItemHandlerModifiable)instance;
                NBTTagList tagList = (NBTTagList)base;
                for (int i = 0; i < tagList.size(); ++i) {
                    NBTTagCompound itemTags = tagList.func_150305_b(i);
                    int j = itemTags.func_74762_e("Slot");
                    if (j < 0 || j >= instance.getSlots()) continue;
                    itemHandlerModifiable.setStackInSlot(j, ItemStack.func_199557_a((NBTTagCompound)itemTags));
                }
            }
        }, ItemStackHandler::new);
    }
}

