/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.util.Optional;
import net.minecraftforge.eventbus.LogMarkers;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventSubclassTransformer {
    private static final Logger LOGGER = LogManager.getLogger();

    public Optional<ClassNode> transform(ClassNode classNode, Type classType) {
        try {
            if (!this.buildEvents(classNode)) {
                return Optional.empty();
            }
        }
        catch (Exception e) {
            LOGGER.error(LogMarkers.EVENTBUS, "An error occurred building event handler", (Throwable)e);
        }
        return Optional.of(classNode);
    }

    private boolean buildEvents(ClassNode classNode) throws Exception {
        MethodNode method;
        Class<?> parent = null;
        try {
            parent = Thread.currentThread().getContextClassLoader().loadClass(classNode.superName.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(LogMarkers.EVENTBUS, "Could not find parent {} for class {} in classloader {} on thread {}", (Object)classNode.superName, (Object)classNode.name, (Object)Thread.currentThread().getContextClassLoader(), (Object)Thread.currentThread());
            throw e;
        }
        if (!Event.class.isAssignableFrom(parent)) {
            return false;
        }
        LOGGER.debug(LogMarkers.EVENTBUS, "Event transform begin: {}", (Object)classNode.name);
        Type tList = Type.getType((String)"Lnet/minecraftforge/eventbus/ListenerList;");
        boolean hasSetup = false;
        boolean hasGetListenerList = false;
        boolean hasDefaultCtr = false;
        boolean hasCancelable = false;
        boolean hasResult = false;
        String voidDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        String boolDesc = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
        String listDesc = tList.getDescriptor();
        String listDescM = Type.getMethodDescriptor((Type)tList, (Type[])new Type[0]);
        for (MethodNode method2 : classNode.methods) {
            if (method2.name.equals("setup") && method2.desc.equals(voidDesc) && (method2.access & 4) == 4) {
                hasSetup = true;
            }
            if ((method2.access & 1) == 1) {
                if (method2.name.equals("getListenerList") && method2.desc.equals(listDescM)) {
                    hasGetListenerList = true;
                }
                if (method2.name.equals("isCancelable") && method2.desc.equals(boolDesc)) {
                    hasCancelable = true;
                }
                if (method2.name.equals("hasResult") && method2.desc.equals(boolDesc)) {
                    hasResult = true;
                }
            }
            if (!method2.name.equals("<init>") || !method2.desc.equals(voidDesc)) continue;
            hasDefaultCtr = true;
        }
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode node : classNode.visibleAnnotations) {
                if (!hasResult && node.desc.equals("Lnet/minecraftforge/eventbus/api/Event$HasResult;")) {
                    method = new MethodNode(1, "hasResult", boolDesc, null, null);
                    method.instructions.add((AbstractInsnNode)new InsnNode(4));
                    method.instructions.add((AbstractInsnNode)new InsnNode(172));
                    classNode.methods.add(method);
                    continue;
                }
                if (hasCancelable || !node.desc.equals("Lnet/minecraftforge/eventbus/api/Cancelable;")) continue;
                method = new MethodNode(1, "isCancelable", boolDesc, null, null);
                method.instructions.add((AbstractInsnNode)new InsnNode(4));
                method.instructions.add((AbstractInsnNode)new InsnNode(172));
                classNode.methods.add(method);
            }
        }
        if (hasSetup) {
            if (!hasGetListenerList) {
                LOGGER.error(LogMarkers.EVENTBUS, "Event class {} defines a custom setup() method and is missing getListenerList", (Object)classNode.name);
                throw new RuntimeException("Event class defines setup() but does not define getListenerList! " + classNode.name);
            }
            LOGGER.debug(LogMarkers.EVENTBUS, "Transforming event complete - already done: {}", (Object)classNode.name);
            return true;
        }
        Type tThis = Type.getObjectType((String)classNode.name);
        Type tSuper = Type.getObjectType((String)classNode.superName);
        classNode.fields.add(new FieldNode(74, "LISTENER_LIST", listDesc, null, null));
        if (!hasDefaultCtr) {
            method = new MethodNode(1, "<init>", voidDesc, null, null);
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "<init>", voidDesc, false));
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(method);
        }
        method = this.generateSetupMethod(tThis, tSuper, tList);
        classNode.methods.add(method);
        method = new MethodNode(1, "getListenerList", listDescM, null, null);
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", listDesc));
        method.instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(method);
        LOGGER.debug(LogMarkers.EVENTBUS, "Event transform complete: {}", (Object)classNode.name);
        return true;
    }

    private MethodNode generateSetupMethod(Type thisType, Type superType, Type llType) {
        Type objType = Type.getType(Object.class);
        Type clzType = Type.getType(Class.class);
        MethodNode methodVisitor = new MethodNode(4, "setup", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        methodVisitor.visitTryCatchBlock(label0, label1, label2, null);
        Label label3 = new Label();
        Label label4 = new Label();
        methodVisitor.visitTryCatchBlock(label3, label4, label2, null);
        Label label5 = new Label();
        methodVisitor.visitTryCatchBlock(label2, label5, label2, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, superType.getInternalName(), "setup", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitFieldInsn(178, thisType.getInternalName(), "LISTENER_LIST", llType.getDescriptor());
        Label label8 = new Label();
        methodVisitor.visitJumpInsn(198, label8);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label8);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, objType.getInternalName(), "getClass", Type.getMethodDescriptor((Type)clzType, (Type[])new Type[0]), false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(58, 1);
        methodVisitor.visitInsn(194);
        methodVisitor.visitLabel(label0);
        methodVisitor.visitFieldInsn(178, thisType.getInternalName(), "LISTENER_LIST", llType.getDescriptor());
        methodVisitor.visitJumpInsn(198, label3);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(195);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(1, 1, new Object[]{objType.getInternalName()}, 0, null);
        methodVisitor.visitTypeInsn(187, llType.getInternalName());
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, thisType.getInternalName(), "getParentListenerList", Type.getMethodDescriptor((Type)llType, (Type[])new Type[0]), false);
        methodVisitor.visitMethodInsn(183, llType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{llType}), false);
        methodVisitor.visitFieldInsn(179, thisType.getInternalName(), "LISTENER_LIST", llType.getDescriptor());
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(195);
        methodVisitor.visitLabel(label4);
        Label label10 = new Label();
        methodVisitor.visitJumpInsn(167, label10);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        methodVisitor.visitVarInsn(58, 2);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(195);
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(label10);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitInsn(177);
        methodVisitor.visitEnd();
        return methodVisitor;
    }
}

