/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModelDynBucket
implements IUnbakedModel,
IModelGeometry<ModelDynBucket> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Deprecated
    public static final ModelDynBucket MODEL = new ModelDynBucket();
    @Deprecated
    @Nullable
    private ResourceLocation particleLocation;
    @Deprecated
    @Nullable
    private ResourceLocation baseLocation;
    @Deprecated
    @Nullable
    private ResourceLocation fluidMaskLocation;
    @Deprecated
    @Nullable
    private ResourceLocation coverLocation;
    @Nonnull
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean tint;
    private final boolean coverIsMask;

    @Deprecated
    public ModelDynBucket() {
        this(Fluids.field_204541_a, false, true, false);
    }

    @Deprecated
    public ModelDynBucket(@Nullable ResourceLocation baseLocation, @Nullable ResourceLocation fluidMaskLocation, @Nullable ResourceLocation coverLocation, @Nullable Fluid fluid, boolean flipGas, boolean tint) {
        this(fluid != null ? fluid : Fluids.field_204541_a, flipGas, tint, false);
        this.baseLocation = baseLocation;
        this.fluidMaskLocation = fluidMaskLocation;
        this.coverLocation = coverLocation;
    }

    public ModelDynBucket(Fluid fluid, boolean flipGas, boolean tint, boolean coverIsMask) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.tint = tint;
        this.coverIsMask = coverIsMask;
    }

    @Deprecated
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.particleLocation != null) {
            builder.add((Object)this.particleLocation);
        }
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.fluidMaskLocation != null) {
            builder.add((Object)this.fluidMaskLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        if (this.fluid != Fluids.field_204541_a) {
            builder.add((Object)this.fluid.getAttributes().getStillTexture());
        }
        return builder.build();
    }

    @Deprecated
    public Collection<ResourceLocation> func_187965_e() {
        return Collections.emptyList();
    }

    @Deprecated
    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        return this.bakeInternal(bakery, spriteGetter, sprite, format, null, this.particleLocation, this.baseLocation, this.fluidMaskLocation, this.coverLocation);
    }

    @Deprecated
    public ModelDynBucket process(ImmutableMap<String, String> customData) {
        ResourceLocation fluidName = new ResourceLocation((String)customData.get((Object)"fluid"));
        Fluid fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        boolean tint = this.tint;
        if (customData.containsKey((Object)"applyTint")) {
            String string;
            switch (string = (String)customData.get((Object)"applyTint")) {
                case "true": {
                    tint = true;
                    break;
                }
                case "false": {
                    tint = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("DynBucket custom data \"applyTint\" must have value 'true' or 'false' (was '%s')", string));
                }
            }
        }
        return new ModelDynBucket(this.baseLocation, this.fluidMaskLocation, this.coverLocation, fluid, flip, tint);
    }

    @Deprecated
    public ModelDynBucket retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        ResourceLocation liquid = this.fluidMaskLocation;
        ResourceLocation cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new ResourceLocation((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new ResourceLocation((String)textures.get((Object)"cover"));
        }
        return new ModelDynBucket(base, liquid, cover, this.fluid, this.flipGas, this.tint);
    }

    @Deprecated
    @Nullable
    protected static IResource getResource(ResourceLocation resourceLocation) {
        try {
            return Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Deprecated
    @Nullable
    protected static PngSizeInfo getSizeInfo(IResource resource) {
        try {
            return new PngSizeInfo(resource.toString(), resource.func_199027_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
        String particle = owner.resolveTexture("particle");
        if (!MissingTextureSprite.func_195675_b().toString().equals(particle)) {
            this.particleLocation = new ResourceLocation(particle);
        }
        String base = owner.resolveTexture("base");
        if (!MissingTextureSprite.func_195675_b().toString().equals(base)) {
            this.baseLocation = new ResourceLocation(base);
        }
        String template = owner.resolveTexture("fluid");
        if (!MissingTextureSprite.func_195675_b().toString().equals(template)) {
            this.fluidMaskLocation = new ResourceLocation(template);
        }
        String cover = owner.resolveTexture("cover");
        if (!MissingTextureSprite.func_195675_b().toString().equals(cover)) {
            this.coverLocation = new ResourceLocation(cover);
        }
        return this.bakeInternal(bakery, spriteGetter, sprite, format, owner.getCombinedState(), this.particleLocation, this.baseLocation, this.fluidMaskLocation, this.coverLocation);
    }

    private IBakedModel bakeInternal(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, @Nullable IModelState transformsFromModel, @Nullable ResourceLocation particleLocation, @Nullable ResourceLocation baseLocation, @Nullable ResourceLocation fluidMaskLocation, @Nullable ResourceLocation coverLocation) {
        TextureAtlasSprite coverSprite;
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite fluidSprite;
        TextureAtlasSprite particle;
        IModelState state = sprite.getState();
        ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap = transformsFromModel != null ? PerspectiveMapWrapper.getTransforms(new ModelStateComposition(transformsFromModel, state)) : PerspectiveMapWrapper.getTransforms(state);
        TextureAtlasSprite textureAtlasSprite = particle = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (this.flipGas && this.fluid != Fluids.field_204541_a && this.fluid.getAttributes().isLighterThanAir()) {
            sprite = new ModelStateComposition(state, TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
            state = sprite.getState();
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        ResourceLocation fluidLocation = this.fluid != Fluids.field_204541_a ? this.fluid.getAttributes().getStillTexture() : null;
        TextureAtlasSprite textureAtlasSprite2 = fluidSprite = fluidLocation != null ? spriteGetter.apply(fluidLocation) : null;
        if (particle == null) {
            particle = fluidSprite;
        }
        Random random = new Random();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (baseLocation != null) {
            IBakedModel model = new ItemLayerModel((ImmutableList<ResourceLocation>)ImmutableList.of((Object)baseLocation)).bake(bakery, spriteGetter, sprite, format);
            random.setSeed(42L);
            builder.addAll((Iterable)model.func_200117_a(null, null, random));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, templateSprite, fluidSprite, 0.468625f, Direction.NORTH, this.tint ? this.fluid.getAttributes().getColor() : -1, 1));
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, templateSprite, fluidSprite, 0.531375f, Direction.SOUTH, this.tint ? this.fluid.getAttributes().getColor() : -1, 1));
        }
        if (!(coverLocation == null || this.coverIsMask && baseLocation == null || (coverSprite = spriteGetter.apply(coverLocation)) == null)) {
            if (this.coverIsMask) {
                TextureAtlasSprite baseSprite = spriteGetter.apply(baseLocation);
                builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, coverSprite, baseSprite, 0.4685f, Direction.NORTH, -1, 1));
                builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, coverSprite, baseSprite, 0.5315f, Direction.SOUTH, -1, 1));
            } else {
                builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, coverSprite, Direction.NORTH, -1, 2));
                builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, coverSprite, Direction.SOUTH, -1, 2));
                if (particle == null) {
                    particle = coverSprite;
                }
            }
        }
        return new BakedDynBucket(bakery, this, (ImmutableList<BakedQuad>)builder.build(), particle, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap(transformMap), Maps.newHashMap(), transform.isIdentity());
    }

    @Override
    public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        texs.add(new ResourceLocation(owner.resolveTexture("particle")));
        texs.add(new ResourceLocation(owner.resolveTexture("base")));
        texs.add(new ResourceLocation(owner.resolveTexture("fluid")));
        texs.add(new ResourceLocation(owner.resolveTexture("cover")));
        return texs;
    }

    private static final class BakedDynBucket
    extends BakedItemModel {
        private final ModelDynBucket parent;
        private final Map<String, IBakedModel> cache;
        private final VertexFormat format;

        BakedDynBucket(ModelBakery bakery, ModelDynBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache, boolean untransformed) {
            super(quads, particle, transforms, new BakedDynBucketOverrideHandler(bakery), untransformed);
            this.format = format;
            this.parent = parent;
            this.cache = cache;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends ItemOverrideList {
        private final ModelBakery bakery;

        private BakedDynBucketOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            return FluidUtil.getFluidContained(stack).map(fluidStack -> {
                BakedDynBucket model = (BakedDynBucket)originalModel;
                Fluid fluid = fluidStack.getFluid();
                String name = fluid.getRegistryName().toString();
                if (!model.cache.containsKey(name)) {
                    ModelDynBucket parent = model.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"fluid", (Object)name));
                    Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    IBakedModel bakedModel = parent.bake(this.bakery, textureGetter, new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)model.transforms), model.format);
                    model.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return (IBakedModel)model.cache.get(name);
            }).orElse(originalModel);
        }
    }

    @Deprecated
    private static final class BucketCoverSprite
    extends TextureAtlasSprite {
        private final ResourceLocation bucket = new ResourceLocation("item/bucket");
        private final ResourceLocation bucketCoverMask = new ResourceLocation("forge", "item/vanilla_bucket_cover_mask");
        private final ImmutableList<ResourceLocation> dependencies = ImmutableList.of((Object)this.bucket, (Object)this.bucketCoverMask);

        private BucketCoverSprite(ResourceLocation res) {
            super(res, ModelDynBucket.getSizeInfo(ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png"))), (AnimationMetadataSection)ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png")).func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a));
        }
    }

    @Deprecated
    private static final class BucketBaseSprite
    extends TextureAtlasSprite {
        private final ResourceLocation bucket = new ResourceLocation("item/bucket");
        private final ImmutableList<ResourceLocation> dependencies = ImmutableList.of((Object)this.bucket);

        private BucketBaseSprite(ResourceLocation res) {
            super(res, ModelDynBucket.getSizeInfo(ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png"))), (AnimationMetadataSection)ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png")).func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a));
        }
    }

    public static enum Loader implements IModelLoader<ModelDynBucket>
    {
        INSTANCE;


        @Override
        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        @Override
        public ModelDynBucket read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            ResourceLocation fluidName = new ResourceLocation(modelContents.get("fluid").getAsString());
            Fluid fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
            boolean flip = false;
            if (modelContents.has("flipGas")) {
                flip = modelContents.get("flipGas").getAsBoolean();
            }
            boolean tint = true;
            if (modelContents.has("applyTint")) {
                tint = modelContents.get("applyTint").getAsBoolean();
            }
            boolean coverIsMask = true;
            if (modelContents.has("coverIsMask")) {
                coverIsMask = modelContents.get("coverIsMask").getAsBoolean();
            }
            return new ModelDynBucket(fluid, flip, tint, coverIsMask);
        }
    }

    @Deprecated
    public static enum LoaderDynBucket implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("forge") && modelLocation.func_110623_a().contains("forgebucket");
        }

        @Override
        public IUnbakedModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        @Override
        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        @Deprecated
        public void register(AtlasTexture map) {
            TextureAtlasSprite textureAtlasSprite;
            if (ModelDynBucket.getResource(new ResourceLocation("forge", "textures/items/bucket_cover.png")) == null) {
                ResourceLocation bucketCover = new ResourceLocation("forge", "items/bucket_cover");
                textureAtlasSprite = new BucketCoverSprite(bucketCover);
            }
            if (ModelDynBucket.getResource(new ResourceLocation("forge", "textures/items/bucket_base.png")) == null) {
                ResourceLocation bucketBase = new ResourceLocation("forge", "items/bucket_base");
                textureAtlasSprite = new BucketBaseSprite(bucketBase);
            }
        }
    }
}

