/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;
import net.minecraftforge.client.model.obj.OBJLoader2;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelLoaderRegistry2 {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String WHITE_TEXTURE = "forge:white";
    private static final Map<ResourceLocation, IModelLoader<?>> loaders = Maps.newHashMap();
    private static volatile boolean registryFrozen = false;
    private static final Pattern FILESYSTEM_PATH_TO_RESLOC = Pattern.compile("(?:.*[\\\\/]assets[\\\\/](?<namespace>[a-z_-]+)[\\\\/]textures[\\\\/])?(?<path>[a-z_\\\\/-]+)\\.png");

    public static void init() {
        ModelLoaderRegistry2.registerLoader(new ResourceLocation("minecraft", "elements"), VanillaProxy.Loader.INSTANCE);
        ModelLoaderRegistry2.registerLoader(new ResourceLocation("forge", "obj"), OBJLoader2.INSTANCE);
        ModelLoaderRegistry2.registerLoader(new ResourceLocation("forge", "bucket"), ModelDynBucket.Loader.INSTANCE);
        ModelLoaderRegistry2.registerLoader(new ResourceLocation("forge", "composite"), CompositeModel.Loader.INSTANCE);
        ModelLoaderRegistry2.registerLoader(new ResourceLocation("forge", "b3d"), new ModelLoaderAdapter(B3DLoader.INSTANCE));
        ModelLoaderRegistry2.registerLoader(new ResourceLocation("forge", "fluid"), new ModelLoaderAdapter(ModelFluid.FluidLoader.INSTANCE));
        ModelLoaderRegistry2.registerLoader(new ResourceLocation("forge", "multi-layer"), new ModelLoaderAdapter(MultiLayerModel.Loader.INSTANCE));
    }

    public static void initComplete() {
        registryFrozen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLoader(ResourceLocation id, IModelLoader<?> loader) {
        if (registryFrozen) {
            throw new IllegalStateException("Can not register model loaders after models have started loading. Please use FMLClientSetupEvent or ModelRegistryEvent to register your loaders.");
        }
        Map<ResourceLocation, IModelLoader<?>> map = loaders;
        synchronized (map) {
            loaders.put(id, loader);
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a(loader);
        }
    }

    public static IModelGeometry<?> getModel(ResourceLocation loaderId, JsonDeserializationContext deserializationContext, JsonObject data) {
        try {
            if (!loaders.containsKey(loaderId)) {
                throw new IllegalStateException(String.format("Model loader '%s' not found. Registered loaders: %s", loaderId, loaders.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))));
            }
            IModelLoader<?> loader = loaders.get(loaderId);
            return loader.read(deserializationContext, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Nullable
    public static IModelGeometry<?> deserializeGeometry(JsonDeserializationContext deserializationContext, JsonObject object) {
        if (!object.has("loader")) {
            return null;
        }
        ResourceLocation loader = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"loader"));
        return ModelLoaderRegistry2.getModel(loader, deserializationContext, object);
    }

    public static ResourceLocation resolveTexture(@Nullable String tex, IModelConfiguration owner) {
        if (tex == null) {
            return new ResourceLocation(WHITE_TEXTURE);
        }
        if (tex.startsWith("#")) {
            return new ResourceLocation(owner.resolveTexture(tex));
        }
        Matcher match = FILESYSTEM_PATH_TO_RESLOC.matcher(tex);
        if (match.matches()) {
            String namespace = match.group("namespace");
            String path = match.group("path").replace("\\", "/");
            if (namespace != null) {
                return new ResourceLocation(namespace, path);
            }
            return new ResourceLocation(path);
        }
        return new ResourceLocation(tex);
    }

    @Nullable
    public static IModelState deserializeModelTransforms(JsonDeserializationContext deserializationContext, JsonObject modelData) {
        if (!modelData.has("transform")) {
            return null;
        }
        return ModelLoaderRegistry2.deserializeTransform(deserializationContext, modelData.get("transform")).orElse(null);
    }

    public static Optional<IModelState> deserializeTransform(JsonDeserializationContext context, JsonElement transformData) {
        if (transformData.isJsonPrimitive() && transformData.getAsJsonPrimitive().isString()) {
            String transform = transformData.getAsString();
            Optional<IModelState> state = ForgeBlockStateV1.Transforms.get(transform);
            if (!state.isPresent()) {
                throw new JsonParseException("transform: unknown default string: " + transform);
            }
            return state;
        }
        if (!transformData.isJsonObject()) {
            try {
                TRSRTransformation base = (TRSRTransformation)context.deserialize(transformData, TRSRTransformation.class);
                return Optional.of(TRSRTransformation.blockCenterToCorner(base));
            }
            catch (JsonParseException e) {
                throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + transformData);
            }
        }
        JsonObject transform = transformData.getAsJsonObject();
        EnumMap transforms = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "thirdperson", ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "thirdperson_righthand", ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "thirdperson_lefthand", ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "firstperson", ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "firstperson_righthand", ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "firstperson_lefthand", ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "head", ItemCameraTransforms.TransformType.HEAD);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "gui", ItemCameraTransforms.TransformType.GUI);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "ground", ItemCameraTransforms.TransformType.GROUND);
        ModelLoaderRegistry2.deserializeTRSR(context, transforms, transform, "fixed", ItemCameraTransforms.TransformType.FIXED);
        int k = transform.entrySet().size();
        if (transform.has("matrix")) {
            --k;
        }
        if (transform.has("translation")) {
            --k;
        }
        if (transform.has("rotation")) {
            --k;
        }
        if (transform.has("scale")) {
            --k;
        }
        if (transform.has("post-rotation")) {
            --k;
        }
        if (k > 0) {
            throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation'");
        }
        TRSRTransformation base = TRSRTransformation.identity();
        if (!transform.entrySet().isEmpty()) {
            base = (TRSRTransformation)context.deserialize((JsonElement)transform, TRSRTransformation.class);
            base = TRSRTransformation.blockCenterToCorner(base);
        }
        IModelState state = transforms.isEmpty() ? base : new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)Maps.immutableEnumMap((Map)transforms), Optional.of(base));
        return Optional.of(state);
    }

    private static void deserializeTRSR(JsonDeserializationContext context, EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, JsonObject transform, String name, ItemCameraTransforms.TransformType itemCameraTransform) {
        if (transform.has(name)) {
            TRSRTransformation t = (TRSRTransformation)context.deserialize(transform.remove(name), TRSRTransformation.class);
            transforms.put(itemCameraTransform, TRSRTransformation.blockCenterToCorner(t));
        }
    }

    public static IBakedModel bakeHelper(BlockModel blockModel, ModelBakery modelBakery, BlockModel otherModel, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        try {
            IBakedModel model;
            IModelGeometry<?> customModel = blockModel.customData.getCustomGeometry();
            IModelState customModelState = blockModel.customData.getCustomModelState();
            if (customModelState != null) {
                sprite = new ModelStateComposition(customModelState.apply(Optional.empty()).orElse(TRSRTransformation.identity()), sprite.getState(), sprite.func_188049_c());
            }
            if (customModel != null) {
                model = customModel.bake(blockModel.customData, modelBakery, spriteGetter, sprite, format, blockModel.getOverrides(modelBakery, otherModel, spriteGetter, format));
            } else {
                if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                    throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
                }
                model = blockModel.bakeVanilla(modelBakery, otherModel, spriteGetter, sprite, format);
            }
            if (customModelState != null && !model.doesHandlePerspectives()) {
                model = new PerspectiveMapWrapper(model, customModelState);
            }
            return model;
        }
        catch (Exception e) {
            LOGGER.error("Error baking model", (Throwable)e);
            throw e;
        }
    }

    public static class ExpandedBlockModelDeserializer
    extends BlockModel.Deserializer {
        public static final Gson INSTANCE = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new ExpandedBlockModelDeserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();

        public BlockModel deserialize(JsonElement element, Type targetType, JsonDeserializationContext deserializationContext) throws JsonParseException {
            IModelState modelState;
            BlockModel model = super.deserialize(element, targetType, deserializationContext);
            JsonObject jsonobject = element.getAsJsonObject();
            IModelGeometry<?> geometry = ModelLoaderRegistry2.deserializeGeometry(deserializationContext, jsonobject);
            List elements = model.func_178298_a();
            if (geometry != null) {
                elements.clear();
                model.customData.setCustomGeometry(geometry);
            }
            if ((modelState = ModelLoaderRegistry2.deserializeModelTransforms(deserializationContext, jsonobject)) != null) {
                model.customData.setCustomModelState(modelState);
            }
            if (jsonobject.has("visibility")) {
                JsonObject visibility = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"visibility");
                for (Map.Entry part : visibility.entrySet()) {
                    model.customData.visibilityData.setVisibilityState((String)part.getKey(), ((JsonElement)part.getValue()).getAsBoolean());
                }
            }
            return model;
        }
    }

    public static class VanillaProxy
    implements ISimpleModelGeometry<VanillaProxy> {
        private final List<BlockPart> elements;

        public VanillaProxy(List<BlockPart> list) {
            this.elements = list;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            for (BlockPart blockpart : this.elements) {
                for (Direction direction : blockpart.field_178240_c.keySet()) {
                    BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(direction);
                    TextureAtlasSprite textureatlassprite1 = spriteGetter.apply(new ResourceLocation(owner.resolveTexture(blockpartface.field_178242_d)));
                    if (blockpartface.field_178244_b == null) {
                        modelBuilder.addGeneralQuad(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)textureatlassprite1, (Direction)direction, (ISprite)sprite));
                        continue;
                    }
                    modelBuilder.addFaceQuad(sprite.getState().apply(Optional.empty()).map(trsr -> trsr.rotateTransform(blockpartface.field_178244_b)).orElse(blockpartface.field_178244_b), BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)textureatlassprite1, (Direction)direction, (ISprite)sprite));
                }
            }
        }

        @Override
        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            HashSet textures = Sets.newHashSet();
            for (BlockPart part : this.elements) {
                for (BlockPartFace face : part.field_178240_c.values()) {
                    String texture = owner.resolveTexture(face.field_178242_d);
                    if (Objects.equals(texture, MissingTextureSprite.func_195675_b().toString())) {
                        missingTextureErrors.add(String.format("%s in %s", face.field_178242_d, owner.getModelName()));
                    }
                    textures.add(new ResourceLocation(texture));
                }
            }
            return textures;
        }

        public static class Loader
        implements IModelLoader<VanillaProxy> {
            public static final Loader INSTANCE = new Loader();

            private Loader() {
            }

            @Override
            public void func_195410_a(IResourceManager resourceManager) {
            }

            @Override
            public VanillaProxy read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
                List<BlockPart> list = this.getModelElements(deserializationContext, modelContents);
                return new VanillaProxy(list);
            }

            private List<BlockPart> getModelElements(JsonDeserializationContext deserializationContext, JsonObject object) {
                ArrayList list = Lists.newArrayList();
                if (object.has("elements")) {
                    for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)object, (String)"elements")) {
                        list.add(deserializationContext.deserialize(jsonelement, BlockPart.class));
                    }
                }
                return list;
            }
        }
    }

    public static class ModelAdapter
    implements IModelGeometry<ModelAdapter> {
        private final ImmutableMap<String, String> customData;
        private IUnbakedModel wrappedModel;
        private boolean processed;

        public ModelAdapter(IUnbakedModel wrappedModel, ImmutableMap<String, String> customData) {
            this.wrappedModel = wrappedModel;
            this.customData = customData;
        }

        private void process(IModelConfiguration owner, @Nullable TextureAtlasSprite particle) {
            if (!this.processed) {
                this.processed = true;
                this.wrappedModel = (IUnbakedModel)this.wrappedModel.process(this.customData);
                if (owner instanceof BlockModel) {
                    HashMap replacements = Maps.newHashMap();
                    BlockModel src = (BlockModel)owner;
                    while (src != null) {
                        for (Map.Entry entry : src.field_178318_c.entrySet()) {
                            replacements.putIfAbsent(entry.getKey(), entry.getValue());
                        }
                        src = src.field_178315_d;
                    }
                    for (String string : replacements.keySet()) {
                        String value = (String)replacements.get(string);
                        boolean replaced = value.startsWith("#");
                        while (value.startsWith("#")) {
                            String newkey = value.substring(1);
                            value = (String)replacements.get(newkey);
                        }
                        if (!replaced) continue;
                        replacements.put(string, value);
                    }
                    this.wrappedModel = (IUnbakedModel)this.wrappedModel.retexture(ImmutableMap.copyOf((Map)replacements));
                }
                if (owner.useSmoothLighting()) {
                    this.wrappedModel = (IUnbakedModel)this.wrappedModel.smoothLighting(true);
                }
                if (owner.isShadedInGui()) {
                    this.wrappedModel = (IUnbakedModel)this.wrappedModel.gui3d(true);
                }
            }
        }

        @Override
        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            this.process(owner, null);
            return this.wrappedModel.func_209559_a(modelGetter, missingTextureErrors);
        }

        @Override
        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
            TextureAtlasSprite particle = spriteGetter.apply(new ResourceLocation(owner.resolveTexture("particle")));
            this.process(owner, particle);
            sprite = new ModelStateComposition(owner.getCombinedState(), sprite.getState(), sprite.func_188049_c());
            return this.wrappedModel.bake(bakery, spriteGetter, sprite, format);
        }
    }

    public static class ModelLoaderAdapter
    implements IModelLoader<ModelAdapter> {
        private final ICustomModelLoader parent;

        public ModelLoaderAdapter(ICustomModelLoader parent) {
            this.parent = parent;
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public ModelAdapter read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("model")) {
                throw new RuntimeException("ModelLoaderAdapter requires a 'model' key that points to a model file.");
            }
            String modelLocation = modelContents.get("model").getAsString();
            boolean forceLoad = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"force", (boolean)false);
            try {
                ResourceLocation loc = new ResourceLocation(modelLocation);
                if (!forceLoad && !this.parent.accepts(loc)) {
                    throw new IllegalStateException("The loader does not accept the requested model.");
                }
                IUnbakedModel model = this.parent.loadModel(loc);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (modelContents.has("custom")) {
                    for (Map.Entry e : modelContents.get("custom").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonNull()) {
                            builder.put(e.getKey(), null);
                            continue;
                        }
                        builder.put(e.getKey(), (Object)((JsonElement)e.getValue()).toString());
                    }
                }
                return new ModelAdapter(model, (ImmutableMap<String, String>)builder.build());
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading model from legacy model loader", e);
            }
        }
    }
}

