/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MultiLayerModel
implements IUnbakedModel {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MultiLayerModel INSTANCE = new MultiLayerModel((ImmutableMap<Optional<BlockRenderLayer>, ? extends ResourceLocation>)ImmutableMap.of());
    private final ImmutableMap<Optional<BlockRenderLayer>, ? extends ResourceLocation> models;

    public MultiLayerModel(ImmutableMap<Optional<BlockRenderLayer>, ? extends ResourceLocation> models) {
        this.models = models;
    }

    public Collection<ResourceLocation> func_187965_e() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        return Collections.emptyList();
    }

    private static ImmutableMap<Optional<BlockRenderLayer>, IBakedModel> buildModels(ImmutableMap<Optional<BlockRenderLayer>, ? extends ResourceLocation> models, ISprite sprite, VertexFormat format, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IUnbakedModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)models.get((Object)key), "Couldn't load MultiLayerModel dependency: " + models.get((Object)key));
            builder.put((Object)key, (Object)model.bake(bakery, spriteGetter, (ISprite)new ModelStateComposition(sprite.getState(), model.getDefaultState(), sprite.func_188049_c()), format));
        }
        return builder.build();
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        IUnbakedModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, sprite, format, bakery, spriteGetter), missing.bake(bakery, spriteGetter, (ISprite)new BasicState(missing.getDefaultState(), sprite.func_188049_c()), format), PerspectiveMapWrapper.getTransforms(sprite.getState()));
    }

    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put(Optional.empty(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put(Optional.of(layer), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel((ImmutableMap<Optional<BlockRenderLayer>, ? extends ResourceLocation>)models);
    }

    private ResourceLocation getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new ModelResourceLocation(e.getAsString());
        }
        LOGGER.fatal("Expect ModelResourceLocation, got: {}", (Object)json);
        return new ModelResourceLocation("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("forge") && (modelLocation.func_110623_a().equals("multi-layer") || modelLocation.func_110623_a().equals("models/block/multi-layer") || modelLocation.func_110623_a().equals("models/item/multi-layer"));
        }

        @Override
        public IUnbakedModel loadModel(ResourceLocation modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements IBakedModel {
        private final ImmutableMap<Optional<BlockRenderLayer>, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms;
        private final IBakedModel base;
        private final IBakedModel missing;

        public MultiLayerBakedModel(ImmutableMap<Optional<BlockRenderLayer>, IBakedModel> models, IBakedModel missing, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = (IBakedModel)models.getOrDefault(Optional.empty(), (Object)missing);
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (IBakedModel model : this.models.values()) {
                    builder.addAll((Iterable)model.func_200117_a(state, side, rand));
                }
                return builder.build();
            }
            return ((IBakedModel)this.models.getOrDefault(Optional.of(layer), (Object)this.missing)).func_200117_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return this.base.func_177555_b();
        }

        public boolean isAmbientOcclusion(BlockState state) {
            return this.base.isAmbientOcclusion(state);
        }

        public boolean func_177556_c() {
            return this.base.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.base.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.base.func_177554_e();
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, cameraTransformType);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

