/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.packs;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;

public class ResourcePackLoader {
    private static Map<ModFile, ModFileResourcePack> modResourcePacks;
    private static ResourcePackList<?> resourcePackList;

    public static Optional<ModFileResourcePack> getResourcePackFor(String modId) {
        return Optional.ofNullable(ModList.get().getModFileById(modId)).map(ModFileInfo::getFile).map(mf -> modResourcePacks.get(mf));
    }

    public static <T extends ResourcePackInfo> void loadResourcePacks(ResourcePackList<T> resourcePacks, BiFunction<Map<ModFile, ? extends ModFileResourcePack>, BiConsumer<? super ModFileResourcePack, T>, IPackInfoFinder> packFinder) {
        resourcePackList = resourcePacks;
        modResourcePacks = ModList.get().getModFiles().stream().filter(mf -> !Objects.equals(mf.getModLoader(), "minecraft")).map(mf -> new ModFileResourcePack(mf.getFile())).collect(Collectors.toMap(ModFileResourcePack::getModFile, Function.identity()));
        resourcePacks.func_198982_a((IPackFinder)new LambdaFriendlyPackFinder(packFinder.apply(modResourcePacks, ModFileResourcePack::setPackInfo)));
    }

    private static class LambdaFriendlyPackFinder
    implements IPackFinder {
        private IPackInfoFinder wrapped;

        private LambdaFriendlyPackFinder(IPackInfoFinder wrapped) {
            this.wrapped = wrapped;
        }

        public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packList, ResourcePackInfo.IFactory<T> factory) {
            this.wrapped.addPackInfosToMap(packList, factory);
        }
    }

    public static interface IPackInfoFinder<T extends ResourcePackInfo> {
        public void addPackInfosToMap(Map<String, T> var1, ResourcePackInfo.IFactory<T> var2);
    }
}

