/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.progress;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.minecraftforge.fml.loading.progress.EarlyProgressVisualization;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.stb.STBEasyFont;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

class ClientVisualization
implements EarlyProgressVisualization.Visualization {
    private final int screenWidth = 800;
    private final int screenHeight = 400;
    private long window;
    private Thread thread;
    private boolean running;
    private static final float[] memorycolour = new float[]{0.0f, 0.0f, 0.0f};

    ClientVisualization() {
    }

    private void initWindow() {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        long glfwInitBegin = System.nanoTime();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        long glfwInitEnd = System.nanoTime();
        if ((double)(glfwInitEnd - glfwInitBegin) > 1.0E9) {
            LogManager.getLogger().fatal("WARNING : glfwInit took {} seconds to start.", (Object)((double)(glfwInitEnd - glfwInitBegin) / 1.0E9));
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)0);
        this.window = GLFW.glfwCreateWindow((int)800, (int)400, (CharSequence)"FML early loading progress", (long)0L, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            IntBuffer monPosLeft = stack.mallocInt(1);
            IntBuffer monPosTop = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwGetMonitorPos((long)GLFW.glfwGetPrimaryMonitor(), (IntBuffer)monPosLeft, (IntBuffer)monPosTop);
            GLFW.glfwSetWindowPos((long)this.window, (int)((vidmode.width() - pWidth.get(0)) / 2 + monPosLeft.get(0)), (int)((vidmode.height() - pHeight.get(0)) / 2 + monPosTop.get(0)));
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        GLFW.glfwShowWindow((long)this.window);
        GL.createCapabilities();
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16384);
    }

    private void renderProgress() {
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)800.0, (double)400.0, (double)0.0, (double)-1000.0, (double)1000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glEnableClientState((int)32884);
        GL11.glEnable((int)3042);
        this.renderMessages();
        GLFW.glfwSwapBuffers((long)this.window);
        GLFW.glfwPollEvents();
    }

    private static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    private static int clamp(int num, int min, int max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    private static int hsvToRGB(float hue, float saturation, float value) {
        float f6;
        float f5;
        float f4;
        int i = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)i;
        float f1 = value * (1.0f - saturation);
        float f2 = value * (1.0f - f * saturation);
        float f3 = value * (1.0f - (1.0f - f) * saturation);
        switch (i) {
            case 0: {
                f4 = value;
                f5 = f3;
                f6 = f1;
                break;
            }
            case 1: {
                f4 = f2;
                f5 = value;
                f6 = f1;
                break;
            }
            case 2: {
                f4 = f1;
                f5 = value;
                f6 = f3;
                break;
            }
            case 3: {
                f4 = f1;
                f5 = f2;
                f6 = value;
                break;
            }
            case 4: {
                f4 = f3;
                f5 = f1;
                f6 = value;
                break;
            }
            case 5: {
                f4 = value;
                f5 = f1;
                f6 = f2;
                break;
            }
            default: {
                throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
            }
        }
        int j = ClientVisualization.clamp((int)(f4 * 255.0f), 0, 255);
        int k = ClientVisualization.clamp((int)(f5 * 255.0f), 0, 255);
        int l = ClientVisualization.clamp((int)(f6 * 255.0f), 0, 255);
        return j << 16 | k << 8 | l;
    }

    private void renderMessages() {
        List<Pair<Integer, StartupMessageManager.Message>> messages = StartupMessageManager.getMessages();
        for (int i = 0; i < messages.size(); ++i) {
            Pair<Integer, StartupMessageManager.Message> pair = messages.get(i);
            float fade = ClientVisualization.clamp((4000.0f - (float)((Integer)pair.getLeft()).intValue() - (float)(i - 4) * 1000.0f) / 5000.0f, 0.0f, 1.0f);
            if (fade < 0.01f) continue;
            StartupMessageManager.Message msg = (StartupMessageManager.Message)pair.getRight();
            this.renderMessage(msg.getText(), msg.getTypeColour(), 19 - i, fade);
        }
        this.renderMemoryInfo();
    }

    private void renderMemoryInfo() {
        MemoryUsage heapusage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage offheapusage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        float pctmemory = (float)heapusage.getUsed() / (float)heapusage.getMax();
        String memory = String.format("Memory Heap: %d / %d MB (%.1f%%)  OffHeap: %d MB", heapusage.getUsed() >> 20, heapusage.getMax() >> 20, (double)pctmemory * 100.0, offheapusage.getUsed() >> 20);
        int i = ClientVisualization.hsvToRGB((1.0f - (float)Math.pow(pctmemory, 1.5)) / 3.0f, 1.0f, 0.5f);
        ClientVisualization.memorycolour[2] = (float)(i & 0xFF) / 255.0f;
        ClientVisualization.memorycolour[1] = (float)(i >> 8 & 0xFF) / 255.0f;
        ClientVisualization.memorycolour[0] = (float)(i >> 16 & 0xFF) / 255.0f;
        this.renderMessage(memory, memorycolour, 1, 1.0f);
    }

    private void renderMessage(String message, float[] colour, int row, float alpha) {
        ByteBuffer charBuffer = MemoryUtil.memAlloc((int)(message.length() * 270));
        int quads = STBEasyFont.stb_easy_font_print((float)0.0f, (float)0.0f, (CharSequence)message, null, (ByteBuffer)charBuffer);
        GL11.glVertexPointer((int)3, (int)5126, (int)16, (ByteBuffer)charBuffer);
        GL11.glEnable((int)3042);
        GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        GL11.glBlendFunc((int)32771, (int)32772);
        GL11.glColor3f((float)colour[0], (float)colour[1], (float)colour[2]);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)10.0f, (float)(row * 20), (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glDrawArrays((int)7, (int)0, (int)(quads * 4));
        GL11.glPopMatrix();
        MemoryUtil.memFree((Buffer)charBuffer);
    }

    private void closeWindow() {
        Callbacks.glfwFreeCallbacks((long)this.window);
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
        GLFW.glfwSetErrorCallback(null).free();
    }

    @Override
    public void start() {
        this.thread = new Thread(this::run);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void run() {
        this.running = true;
        this.initWindow();
        while (this.running) {
            this.renderProgress();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.closeWindow();
    }

    @Override
    public void join() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

