/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.advancements;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.advancements.AdvancementEntryGui;
import net.minecraft.client.gui.advancements.AdvancementTabGui;
import net.minecraft.client.gui.advancements.AdvancementTabType;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CSeenAdvancementsPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementsScreen
extends Screen
implements ClientAdvancementManager.IListener {
    private static final ResourceLocation field_191943_f = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation field_191945_g = new ResourceLocation("textures/gui/advancements/tabs.png");
    private final ClientAdvancementManager field_191946_h;
    private final Map<Advancement, AdvancementTabGui> field_191947_i = Maps.newLinkedHashMap();
    private AdvancementTabGui field_191940_s;
    private boolean field_191944_v;
    private static int tabPage;
    private static int maxPages;

    public AdvancementsScreen(ClientAdvancementManager p_i47383_1_) {
        super(NarratorChatListener.field_216868_a);
        this.field_191946_h = p_i47383_1_;
    }

    @Override
    protected void init() {
        this.field_191947_i.clear();
        this.field_191940_s = null;
        this.field_191946_h.func_192798_a((ClientAdvancementManager.IListener)this);
        if (this.field_191940_s == null && !this.field_191947_i.isEmpty()) {
            this.field_191946_h.func_194230_a(this.field_191947_i.values().iterator().next().func_193935_c(), true);
        } else {
            this.field_191946_h.func_194230_a(this.field_191940_s == null ? null : this.field_191940_s.func_193935_c(), true);
        }
        if (this.field_191947_i.size() > AdvancementTabType.MAX_TABS) {
            int guiLeft = (this.width - 252) / 2;
            int guiTop = (this.height - 140) / 2;
            this.addButton(new Button(guiLeft, guiTop - 50, 20, 20, "<", b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }));
            this.addButton(new Button(guiLeft + 252 - 20, guiTop - 50, 20, 20, ">", b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }));
            maxPages = this.field_191947_i.size() / AdvancementTabType.MAX_TABS;
        }
    }

    @Override
    public void removed() {
        this.field_191946_h.func_192798_a((ClientAdvancementManager.IListener)null);
        ClientPlayNetHandler clientplaynethandler = this.minecraft.func_147114_u();
        if (clientplaynethandler != null) {
            clientplaynethandler.func_147297_a((IPacket<?>)CSeenAdvancementsPacket.func_194164_a());
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (p_mouseClicked_5_ == 0) {
            int i = (this.width - 252) / 2;
            int j = (this.height - 140) / 2;
            for (AdvancementTabGui advancementtabgui : this.field_191947_i.values()) {
                if (advancementtabgui.getPage() != tabPage || !advancementtabgui.func_195627_a(i, j, p_mouseClicked_1_, p_mouseClicked_3_)) continue;
                this.field_191946_h.func_194230_a(advancementtabgui.func_193935_c(), true);
                break;
            }
        }
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.minecraft.field_71474_y.field_194146_ao.func_197976_a(p_keyPressed_1_, p_keyPressed_2_)) {
            this.minecraft.func_147108_a(null);
            this.minecraft.field_71417_B.func_198034_i();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        int i = (this.width - 252) / 2;
        int j = (this.height - 140) / 2;
        this.renderBackground();
        this.func_191936_c(p_render_1_, p_render_2_, i, j);
        if (maxPages != 0) {
            String page = String.format("%d / %d", tabPage + 1, maxPages + 1);
            int width = this.font.func_78256_a(page);
            GlStateManager.disableLighting();
            this.font.func_175063_a(page, (float)(i + 126 - width / 2), (float)(j - 44), -1);
        }
        this.func_191934_b(i, j);
        this.func_191937_d(p_render_1_, p_render_2_, i, j);
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (p_mouseDragged_5_ != 0) {
            this.field_191944_v = false;
            return false;
        }
        if (!this.field_191944_v) {
            this.field_191944_v = true;
        } else if (this.field_191940_s != null) {
            this.field_191940_s.func_195626_a(p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return true;
    }

    private void func_191936_c(int p_191936_1_, int p_191936_2_, int p_191936_3_, int p_191936_4_) {
        AdvancementTabGui advancementtabgui = this.field_191940_s;
        if (advancementtabgui == null) {
            AdvancementsScreen.fill((int)(p_191936_3_ + 9), (int)(p_191936_4_ + 18), (int)(p_191936_3_ + 9 + 234), (int)(p_191936_4_ + 18 + 113), (int)-16777216);
            String s = I18n.func_135052_a("advancements.empty", new Object[0]);
            int i = this.font.func_78256_a(s);
            this.font.func_211126_b(s, (float)(p_191936_3_ + 9 + 117 - i / 2), (float)(p_191936_4_ + 18 + 56 - 4), -1);
            this.font.func_211126_b(":(", (float)(p_191936_3_ + 9 + 117 - this.font.func_78256_a(":(") / 2), (float)(p_191936_4_ + 18 + 113 - 9), -1);
        } else {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)(p_191936_3_ + 9), (float)(p_191936_4_ + 18), (float)-400.0f);
            GlStateManager.enableDepthTest();
            advancementtabgui.func_191799_a();
            GlStateManager.popMatrix();
            GlStateManager.depthFunc((int)515);
            GlStateManager.disableDepthTest();
        }
    }

    public void func_191934_b(int p_191934_1_, int p_191934_2_) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        RenderHelper.func_74518_a();
        this.minecraft.func_110434_K().func_110577_a(field_191943_f);
        this.blit(p_191934_1_, p_191934_2_, 0, 0, 252, 140);
        if (this.field_191947_i.size() > 1) {
            this.minecraft.func_110434_K().func_110577_a(field_191945_g);
            for (AdvancementTabGui advancementtabgui : this.field_191947_i.values()) {
                if (advancementtabgui.getPage() != tabPage) continue;
                advancementtabgui.func_191798_a(p_191934_1_, p_191934_2_, advancementtabgui == this.field_191940_s);
            }
            GlStateManager.enableRescaleNormal();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_74520_c();
            for (AdvancementTabGui advancementtabgui1 : this.field_191947_i.values()) {
                if (advancementtabgui1.getPage() != tabPage) continue;
                advancementtabgui1.func_191796_a(p_191934_1_, p_191934_2_, this.itemRenderer);
            }
            GlStateManager.disableBlend();
        }
        this.font.func_211126_b(I18n.func_135052_a("gui.advancements", new Object[0]), (float)(p_191934_1_ + 8), (float)(p_191934_2_ + 6), 0x404040);
    }

    private void func_191937_d(int p_191937_1_, int p_191937_2_, int p_191937_3_, int p_191937_4_) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_191940_s != null) {
            GlStateManager.pushMatrix();
            GlStateManager.enableDepthTest();
            GlStateManager.translatef((float)(p_191937_3_ + 9), (float)(p_191937_4_ + 18), (float)400.0f);
            this.field_191940_s.func_192991_a(p_191937_1_ - p_191937_3_ - 9, p_191937_2_ - p_191937_4_ - 18, p_191937_3_, p_191937_4_);
            GlStateManager.disableDepthTest();
            GlStateManager.popMatrix();
        }
        if (this.field_191947_i.size() > 1) {
            for (AdvancementTabGui advancementtabgui : this.field_191947_i.values()) {
                if (advancementtabgui.getPage() != tabPage || !advancementtabgui.func_195627_a(p_191937_3_, p_191937_4_, p_191937_1_, p_191937_2_)) continue;
                this.renderTooltip(advancementtabgui.func_191795_d(), p_191937_1_, p_191937_2_);
            }
        }
    }

    public void func_191931_a(Advancement advancementIn) {
        AdvancementTabGui advancementtabgui = AdvancementTabGui.func_193936_a(this.minecraft, this, this.field_191947_i.size(), advancementIn);
        if (advancementtabgui != null) {
            this.field_191947_i.put(advancementIn, advancementtabgui);
        }
    }

    public void func_191928_b(Advancement advancementIn) {
    }

    public void func_191932_c(Advancement advancementIn) {
        AdvancementTabGui advancementtabgui = this.func_191935_f(advancementIn);
        if (advancementtabgui != null) {
            advancementtabgui.func_191800_a(advancementIn);
        }
    }

    public void func_191929_d(Advancement advancementIn) {
    }

    public void func_191933_a(Advancement advancementIn, AdvancementProgress progress) {
        AdvancementEntryGui advancemententrygui = this.func_191938_e(advancementIn);
        if (advancemententrygui != null) {
            advancemententrygui.func_191824_a(progress);
        }
    }

    public void func_193982_e(@Nullable Advancement advancementIn) {
        this.field_191940_s = this.field_191947_i.get(advancementIn);
    }

    public void func_191930_a() {
        this.field_191947_i.clear();
        this.field_191940_s = null;
    }

    @Nullable
    public AdvancementEntryGui func_191938_e(Advancement p_191938_1_) {
        AdvancementTabGui advancementtabgui = this.func_191935_f(p_191938_1_);
        return advancementtabgui == null ? null : advancementtabgui.func_191794_b(p_191938_1_);
    }

    @Nullable
    private AdvancementTabGui func_191935_f(Advancement p_191935_1_) {
        while (p_191935_1_.func_192070_b() != null) {
            p_191935_1_ = p_191935_1_.func_192070_b();
        }
        return this.field_191947_i.get(p_191935_1_);
    }
}

