/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ChunkRenderTask
implements Comparable<ChunkRenderTask> {
    private final ChunkRender field_178553_a;
    private final ReentrantLock field_178551_b = new ReentrantLock();
    private final List<Runnable> field_178552_c = Lists.newArrayList();
    private final Type field_178549_d;
    private final double field_188229_e;
    @Nullable
    private ChunkRenderCache field_217668_f;
    private RegionRenderCacheBuilder field_178550_e;
    private CompiledChunk field_178547_f;
    private Status field_178548_g = Status.PENDING;
    private boolean field_178554_h;
    private Map<BlockPos, IModelData> modelData;

    public ChunkRenderTask(ChunkRender chunkRenderIn, Type typeIn, double distanceSqIn, @Nullable ChunkRenderCache chunkRenderCacheIn) {
        this.field_178553_a = chunkRenderIn;
        this.field_178549_d = typeIn;
        this.field_188229_e = distanceSqIn;
        this.field_217668_f = chunkRenderCacheIn;
        this.modelData = ModelDataManager.getModelData((World)Minecraft.func_71410_x().field_71441_e, (ChunkPos)new ChunkPos(chunkRenderIn.func_178568_j()));
    }

    public Status func_178546_a() {
        return this.field_178548_g;
    }

    public ChunkRender func_178536_b() {
        return this.field_178553_a;
    }

    @Nullable
    public ChunkRenderCache func_217667_c() {
        ChunkRenderCache chunkrendercache = this.field_217668_f;
        this.field_217668_f = null;
        return chunkrendercache;
    }

    public CompiledChunk func_178544_c() {
        return this.field_178547_f;
    }

    public void func_178543_a(CompiledChunk compiledChunkIn) {
        this.field_178547_f = compiledChunkIn;
    }

    public RegionRenderCacheBuilder func_178545_d() {
        return this.field_178550_e;
    }

    public void func_178541_a(RegionRenderCacheBuilder regionRenderCacheBuilderIn) {
        this.field_178550_e = regionRenderCacheBuilderIn;
    }

    public void func_178535_a(Status statusIn) {
        this.field_178551_b.lock();
        try {
            this.field_178548_g = statusIn;
        }
        finally {
            this.field_178551_b.unlock();
        }
    }

    public void func_178542_e() {
        this.field_178551_b.lock();
        try {
            this.field_217668_f = null;
            if (this.field_178549_d == Type.REBUILD_CHUNK && this.field_178548_g != Status.DONE) {
                this.field_178553_a.func_178575_a(false);
            }
            this.field_178554_h = true;
            this.field_178548_g = Status.DONE;
            for (Runnable runnable : this.field_178552_c) {
                runnable.run();
            }
        }
        finally {
            this.field_178551_b.unlock();
        }
    }

    public void func_178539_a(Runnable runnable) {
        this.field_178551_b.lock();
        try {
            this.field_178552_c.add(runnable);
            if (this.field_178554_h) {
                runnable.run();
            }
        }
        finally {
            this.field_178551_b.unlock();
        }
    }

    public ReentrantLock func_178540_f() {
        return this.field_178551_b;
    }

    public Type func_178538_g() {
        return this.field_178549_d;
    }

    public boolean func_178537_h() {
        return this.field_178554_h;
    }

    @Override
    public int compareTo(ChunkRenderTask p_compareTo_1_) {
        return Doubles.compare((double)this.field_188229_e, (double)p_compareTo_1_.field_188229_e);
    }

    public double func_188228_i() {
        return this.field_188229_e;
    }

    public IModelData getModelData(BlockPos pos) {
        return this.modelData.getOrDefault(pos, (IModelData)EmptyModelData.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        REBUILD_CHUNK,
        RESORT_TRANSPARENCY;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Status {
        PENDING,
        COMPILING,
        UPLOADING,
        DONE;

    }
}

