/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.item.DyeColor;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LayeredColorMaskTexture
extends Texture {
    private static final Logger field_174947_f = LogManager.getLogger();
    private final ResourceLocation field_174948_g;
    private final List<String> field_174949_h;
    private final List<DyeColor> field_174950_i;

    public LayeredColorMaskTexture(ResourceLocation textureLocationIn, List<String> p_i46101_2_, List<DyeColor> p_i46101_3_) {
        this.field_174948_g = textureLocationIn;
        this.field_174949_h = p_i46101_2_;
        this.field_174950_i = p_i46101_3_;
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        try (IResource iresource = manager.func_199002_a(this.field_174948_g);
             NativeImage nativeimage = NativeImage.func_195713_a(iresource.func_199027_b());
             NativeImage nativeimage1 = new NativeImage(nativeimage.func_195702_a(), nativeimage.func_195714_b(), false);){
            nativeimage1.func_195703_a(nativeimage);
            for (int i = 0; i < 17 && i < this.field_174949_h.size() && i < this.field_174950_i.size(); ++i) {
                String s = this.field_174949_h.get(i);
                if (s == null) continue;
                try (NativeImage nativeimage2 = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(s), (IResourceManager)manager);){
                    int j = this.field_174950_i.get(i).func_196057_c();
                    if (nativeimage2.func_195702_a() != nativeimage1.func_195702_a() || nativeimage2.func_195714_b() != nativeimage1.func_195714_b()) continue;
                    for (int k = 0; k < nativeimage2.func_195714_b(); ++k) {
                        for (int l = 0; l < nativeimage2.func_195702_a(); ++l) {
                            int i1 = nativeimage2.func_195709_a(l, k);
                            if ((i1 & 0xFF000000) == 0) continue;
                            int j1 = (i1 & 0xFF) << 24 & 0xFF000000;
                            int k1 = nativeimage.func_195709_a(l, k);
                            int l1 = MathHelper.func_180188_d((int)k1, (int)j) & 0xFFFFFF;
                            nativeimage1.func_195718_b(l, k, j1 | l1);
                        }
                    }
                    continue;
                }
            }
            TextureUtil.prepareImage((int)this.func_110552_b(), (int)nativeimage1.func_195702_a(), (int)nativeimage1.func_195714_b());
            GlStateManager.pixelTransfer((int)3357, (float)Float.MAX_VALUE);
            nativeimage1.func_195697_a(0, 0, 0, false);
            GlStateManager.pixelTransfer((int)3357, (float)0.0f);
        }
        catch (IOException ioexception) {
            field_174947_f.error("Couldn't load layered color mask image", (Throwable)ioexception);
        }
    }
}

