/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.World;

public abstract class PathNavigator {
    protected final MobEntity field_75515_a;
    protected final World field_75513_b;
    @Nullable
    protected Path field_75514_c;
    protected double field_75511_d;
    private final IAttributeInstance field_75512_e;
    protected int field_75510_g;
    protected int field_75520_h;
    protected Vec3d field_75521_i = Vec3d.field_186680_a;
    protected Vec3d field_188557_k = Vec3d.field_186680_a;
    protected long field_188558_l;
    protected long field_188559_m;
    protected double field_188560_n;
    protected float field_188561_o = 0.5f;
    protected boolean field_188562_p;
    protected long field_188563_q;
    protected NodeProcessor field_179695_a;
    private BlockPos field_188564_r;
    private int field_225468_r;
    private PathFinder field_179681_j;

    public PathNavigator(MobEntity entityIn, World worldIn) {
        this.field_75515_a = entityIn;
        this.field_75513_b = worldIn;
        this.field_75512_e = entityIn.func_110148_a(SharedMonsterAttributes.field_111265_b);
        this.field_179681_j = this.func_179679_a(MathHelper.func_76128_c((double)(this.field_75512_e.func_111126_e() * 16.0)));
    }

    public BlockPos func_208485_j() {
        return this.field_188564_r;
    }

    protected abstract PathFinder func_179679_a(int var1);

    public void func_75489_a(double speedIn) {
        this.field_75511_d = speedIn;
    }

    public float func_111269_d() {
        return (float)this.field_75512_e.func_111126_e();
    }

    public boolean func_188553_i() {
        return this.field_188562_p;
    }

    public void func_188554_j() {
        if (this.field_75513_b.func_82737_E() - this.field_188563_q > 20L) {
            if (this.field_188564_r != null) {
                this.field_75514_c = null;
                this.field_75514_c = this.func_179680_a(this.field_188564_r, this.field_225468_r);
                this.field_188563_q = this.field_75513_b.func_82737_E();
                this.field_188562_p = false;
            }
        } else {
            this.field_188562_p = true;
        }
    }

    @Nullable
    public final Path func_225466_a(double p_225466_1_, double p_225466_3_, double p_225466_5_, int p_225466_7_) {
        return this.func_179680_a(new BlockPos(p_225466_1_, p_225466_3_, p_225466_5_), p_225466_7_);
    }

    @Nullable
    public Path func_225463_a(Stream<BlockPos> p_225463_1_, int p_225463_2_) {
        return this.func_225464_a(p_225463_1_.collect(Collectors.toSet()), 8, false, p_225463_2_);
    }

    @Nullable
    public Path func_179680_a(BlockPos pos, int p_179680_2_) {
        return this.func_225464_a((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, p_179680_2_);
    }

    @Nullable
    public Path func_75494_a(Entity entityIn, int p_75494_2_) {
        return this.func_225464_a((Set<BlockPos>)ImmutableSet.of((Object)new BlockPos(entityIn)), 16, true, p_75494_2_);
    }

    @Nullable
    protected Path func_225464_a(Set<BlockPos> p_225464_1_, int p_225464_2_, boolean p_225464_3_, int p_225464_4_) {
        if (p_225464_1_.isEmpty()) {
            return null;
        }
        if (this.field_75515_a.field_70163_u < 0.0) {
            return null;
        }
        if (!this.func_75485_k()) {
            return null;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b() && p_225464_1_.contains(this.field_188564_r)) {
            return this.field_75514_c;
        }
        this.field_75513_b.func_217381_Z().func_76320_a("pathfind");
        float f = this.func_111269_d();
        BlockPos blockpos = p_225464_3_ ? new BlockPos((Entity)this.field_75515_a).func_177984_a() : new BlockPos((Entity)this.field_75515_a);
        int i = (int)(f + (float)p_225464_2_);
        Region iworldreader = new Region(this.field_75513_b, blockpos.func_177982_a(-i, -i, -i), blockpos.func_177982_a(i, i, i));
        Path path = this.field_179681_j.func_224775_a((IWorldReader)iworldreader, this.field_75515_a, p_225464_1_, f, p_225464_4_);
        this.field_75513_b.func_217381_Z().func_76319_b();
        if (path != null && path.func_224770_k() != null) {
            this.field_188564_r = path.func_224770_k();
            this.field_225468_r = p_225464_4_;
        }
        return path;
    }

    public boolean func_75492_a(double x, double y, double z, double speedIn) {
        return this.func_75484_a(this.func_225466_a(x, y, z, 1), speedIn);
    }

    public boolean func_75497_a(Entity entityIn, double speedIn) {
        Path path = this.func_75494_a(entityIn, 1);
        return path != null && this.func_75484_a(path, speedIn);
    }

    public boolean func_75484_a(@Nullable Path pathentityIn, double speedIn) {
        if (pathentityIn == null) {
            this.field_75514_c = null;
            return false;
        }
        if (!pathentityIn.func_75876_a(this.field_75514_c)) {
            this.field_75514_c = pathentityIn;
        }
        this.func_75487_m();
        if (this.field_75514_c.func_75874_d() <= 0) {
            return false;
        }
        this.field_75511_d = speedIn;
        Vec3d vec3d = this.func_75502_i();
        this.field_75520_h = this.field_75510_g;
        this.field_75521_i = vec3d;
        return true;
    }

    @Nullable
    public Path func_75505_d() {
        return this.field_75514_c;
    }

    public void func_75501_e() {
        ++this.field_75510_g;
        if (this.field_188562_p) {
            this.func_188554_j();
        }
        if (!this.func_75500_f()) {
            if (this.func_75485_k()) {
                this.func_75508_h();
            } else if (this.field_75514_c != null && this.field_75514_c.func_75873_e() < this.field_75514_c.func_75874_d()) {
                Vec3d vec3d = this.func_75502_i();
                Vec3d vec3d1 = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, this.field_75514_c.func_75873_e());
                if (vec3d.field_72448_b > vec3d1.field_72448_b && !this.field_75515_a.field_70122_E && MathHelper.func_76128_c((double)vec3d.field_72450_a) == MathHelper.func_76128_c((double)vec3d1.field_72450_a) && MathHelper.func_76128_c((double)vec3d.field_72449_c) == MathHelper.func_76128_c((double)vec3d1.field_72449_c)) {
                    this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1);
                }
            }
            DebugPacketSender.func_218803_a((World)this.field_75513_b, (MobEntity)this.field_75515_a, (Path)this.field_75514_c, (float)this.field_188561_o);
            if (!this.func_75500_f()) {
                Vec3d vec3d2 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                BlockPos blockpos = new BlockPos(vec3d2);
                this.field_75515_a.func_70605_aq().func_75642_a(vec3d2.field_72450_a, this.field_75513_b.func_180495_p(blockpos.func_177977_b()).func_196958_f() ? vec3d2.field_72448_b : WalkNodeProcessor.func_197682_a((IBlockReader)this.field_75513_b, blockpos), vec3d2.field_72449_c, this.field_75511_d);
            }
        }
    }

    protected void func_75508_h() {
        Vec3d vec3d = this.func_75502_i();
        this.field_188561_o = this.field_75515_a.func_213311_cf() > 0.75f ? this.field_75515_a.func_213311_cf() / 2.0f : 0.75f - this.field_75515_a.func_213311_cf() / 2.0f;
        Vec3d vec3d1 = this.field_75514_c.func_186310_f();
        if (Math.abs(this.field_75515_a.field_70165_t - (vec3d1.field_72450_a + (double)((int)(this.field_75515_a.func_213311_cf() + 1.0f)) / 2.0)) < (double)this.field_188561_o && Math.abs(this.field_75515_a.field_70161_v - (vec3d1.field_72449_c + (double)((int)(this.field_75515_a.func_213311_cf() + 1.0f)) / 2.0)) < (double)this.field_188561_o && Math.abs(this.field_75515_a.field_70163_u - vec3d1.field_72448_b) < 1.0) {
            this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1);
        }
        this.func_179677_a(vec3d);
    }

    protected void func_179677_a(Vec3d positionVec3) {
        if (this.field_75510_g - this.field_75520_h > 100) {
            if (positionVec3.func_72436_e(this.field_75521_i) < 2.25) {
                this.func_75499_g();
            }
            this.field_75520_h = this.field_75510_g;
            this.field_75521_i = positionVec3;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vec3d vec3d = this.field_75514_c.func_186310_f();
            if (vec3d.equals(this.field_188557_k)) {
                this.field_188558_l += Util.func_211177_b() - this.field_188559_m;
            } else {
                this.field_188557_k = vec3d;
                double d0 = positionVec3.func_72438_d(this.field_188557_k);
                double d = this.field_188560_n = this.field_75515_a.func_70689_ay() > 0.0f ? d0 / (double)this.field_75515_a.func_70689_ay() * 1000.0 : 0.0;
            }
            if (this.field_188560_n > 0.0 && (double)this.field_188558_l > this.field_188560_n * 3.0) {
                this.field_188557_k = Vec3d.field_186680_a;
                this.field_188558_l = 0L;
                this.field_188560_n = 0.0;
                this.func_75499_g();
            }
            this.field_188559_m = Util.func_211177_b();
        }
    }

    public boolean func_75500_f() {
        return this.field_75514_c == null || this.field_75514_c.func_75879_b();
    }

    public void func_75499_g() {
        this.field_75514_c = null;
    }

    protected abstract Vec3d func_75502_i();

    protected abstract boolean func_75485_k();

    protected boolean func_75506_l() {
        return this.field_75515_a.func_203005_aq() || this.field_75515_a.func_180799_ab();
    }

    protected void func_75487_m() {
        if (this.field_75514_c != null) {
            for (int i = 0; i < this.field_75514_c.func_75874_d(); ++i) {
                PathPoint pathpoint = this.field_75514_c.func_75877_a(i);
                PathPoint pathpoint1 = i + 1 < this.field_75514_c.func_75874_d() ? this.field_75514_c.func_75877_a(i + 1) : null;
                BlockState blockstate = this.field_75513_b.func_180495_p(new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c));
                Block block = blockstate.func_177230_c();
                if (block != Blocks.field_150383_bp) continue;
                this.field_75514_c.func_186309_a(i, pathpoint.func_186283_a(pathpoint.field_75839_a, pathpoint.field_75837_b + 1, pathpoint.field_75838_c));
                if (pathpoint1 == null || pathpoint.field_75837_b < pathpoint1.field_75837_b) continue;
                this.field_75514_c.func_186309_a(i + 1, pathpoint1.func_186283_a(pathpoint1.field_75839_a, pathpoint.field_75837_b + 1, pathpoint1.field_75838_c));
            }
        }
    }

    protected abstract boolean func_75493_a(Vec3d var1, Vec3d var2, int var3, int var4, int var5);

    public boolean func_188555_b(BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.field_75513_b.func_180495_p(blockpos).func_200015_d((IBlockReader)this.field_75513_b, blockpos);
    }

    public NodeProcessor func_189566_q() {
        return this.field_179695_a;
    }

    public void func_212239_d(boolean canSwim) {
        this.field_179695_a.func_186316_c(canSwim);
    }

    public boolean func_212238_t() {
        return this.field_179695_a.func_186322_e();
    }

    public void func_220970_c(BlockPos p_220970_1_) {
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b() && this.field_75514_c.func_75874_d() != 0) {
            PathPoint pathpoint = this.field_75514_c.func_75870_c();
            Vec3d vec3d = new Vec3d(((double)pathpoint.field_75839_a + this.field_75515_a.field_70165_t) / 2.0, ((double)pathpoint.field_75837_b + this.field_75515_a.field_70163_u) / 2.0, ((double)pathpoint.field_75838_c + this.field_75515_a.field_70161_v) / 2.0);
            if (p_220970_1_.func_218137_a((IPosition)vec3d, (double)(this.field_75514_c.func_75874_d() - this.field_75514_c.func_75873_e()))) {
                this.func_188554_j();
            }
        }
    }
}

