/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.BrewingStandContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class BrewingStandTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] field_145941_a = new int[]{3};
    private static final int[] field_184277_f = new int[]{0, 1, 2, 3};
    private static final int[] field_145947_i = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> field_145945_j = NonNullList.func_191197_a((int)5, (Object)((Object)ItemStack.field_190927_a));
    private int field_145946_k;
    private boolean[] field_145943_l;
    private Item field_145944_m;
    private int field_184278_m;
    protected final IIntArray field_213954_a = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return BrewingStandTileEntity.this.field_145946_k;
                }
                case 1: {
                    return BrewingStandTileEntity.this.field_184278_m;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    BrewingStandTileEntity.this.field_145946_k = value;
                    break;
                }
                case 1: {
                    BrewingStandTileEntity.this.field_184278_m = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public BrewingStandTileEntity() {
        super(TileEntityType.field_200981_l);
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.brewing", new Object[0]);
    }

    public int func_70302_i_() {
        return this.field_145945_j.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.field_145945_j) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        boolean[] aboolean;
        ItemStack itemstack = (ItemStack)((Object)this.field_145945_j.get(4));
        if (this.field_184278_m <= 0 && itemstack.func_77973_b() == Items.field_151065_br) {
            this.field_184278_m = 20;
            itemstack.func_190918_g(1);
            this.func_70296_d();
        }
        boolean flag = this.func_145934_k();
        boolean flag1 = this.field_145946_k > 0;
        ItemStack itemstack1 = (ItemStack)((Object)this.field_145945_j.get(3));
        if (flag1) {
            boolean flag2;
            --this.field_145946_k;
            boolean bl = flag2 = this.field_145946_k == 0;
            if (flag2 && flag) {
                this.func_145940_l();
                this.func_70296_d();
            } else if (!flag) {
                this.field_145946_k = 0;
                this.func_70296_d();
            } else if (this.field_145944_m != itemstack1.func_77973_b()) {
                this.field_145946_k = 0;
                this.func_70296_d();
            }
        } else if (flag && this.field_184278_m > 0) {
            --this.field_184278_m;
            this.field_145946_k = 400;
            this.field_145944_m = itemstack1.func_77973_b();
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && !Arrays.equals(aboolean = this.func_174902_m(), this.field_145943_l)) {
            this.field_145943_l = aboolean;
            BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!(blockstate.func_177230_c() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.field_176451_a.length; ++i) {
                blockstate = (BlockState)((Object)blockstate.func_206870_a((IProperty)BrewingStandBlock.field_176451_a[i], Boolean.valueOf(aboolean[i])));
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 2);
        }
    }

    public boolean[] func_174902_m() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)((Object)this.field_145945_j.get(i))).func_190926_b()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean func_145934_k() {
        ItemStack itemstack = (ItemStack)((Object)this.field_145945_j.get(3));
        if (!itemstack.func_190926_b()) {
            return BrewingRecipeRegistry.canBrew(this.field_145945_j, (ItemStack)itemstack, (int[])field_145947_i);
        }
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (!PotionBrewing.func_185205_a(itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = (ItemStack)((Object)this.field_145945_j.get(i));
            if (itemstack1.func_190926_b() || !PotionBrewing.func_185208_a(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    private void func_145940_l() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.field_145945_j)) {
            return;
        }
        ItemStack itemstack = (ItemStack)((Object)this.field_145945_j.get(3));
        BrewingRecipeRegistry.brewPotions(this.field_145945_j, (ItemStack)itemstack, (int[])field_145947_i);
        itemstack.func_190918_g(1);
        ForgeEventFactory.onPotionBrewed(this.field_145945_j);
        BlockPos blockpos = this.func_174877_v();
        if (itemstack.hasContainerItem()) {
            ItemStack itemstack1 = itemstack.getContainerItem();
            if (itemstack.func_190926_b()) {
                itemstack = itemstack1;
            } else if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (ItemStack)itemstack1);
            }
        }
        this.field_145945_j.set(3, (Object)itemstack);
        this.field_145850_b.func_217379_c(1035, blockpos, 0);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.field_145945_j = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.field_145945_j);
        this.field_145946_k = compound.func_74765_d("BrewTime");
        this.field_184278_m = compound.func_74771_c("Fuel");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("BrewTime", (short)this.field_145946_k);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.field_145945_j);
        compound.func_74774_a("Fuel", (byte)this.field_184278_m);
        return compound;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.field_145945_j.size() ? (ItemStack)((Object)this.field_145945_j.get(index)) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.field_145945_j, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.field_145945_j, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.field_145945_j.size()) {
            this.field_145945_j.set(index, (Object)stack);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
        }
        Item item = stack.func_77973_b();
        if (index == 4) {
            return item == Items.field_151065_br;
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack) && this.func_70301_a(index).func_190926_b();
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.UP) {
            return field_145941_a;
        }
        return side == Direction.DOWN ? field_184277_f : field_145947_i;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (index == 3) {
            return stack.func_77973_b() == Items.field_151069_bo;
        }
        return true;
    }

    public void func_174888_l() {
        this.field_145945_j.clear();
    }

    @Override
    protected Container func_213906_a(int id, PlayerInventory player) {
        return new BrewingStandContainer(id, player, this, this.field_213954_a);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

