/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SavannaTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState field_181643_a = Blocks.field_196621_O.func_176223_P();
    private static final BlockState field_181644_b = Blocks.field_196572_aa.func_176223_P();

    public SavannaTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51443_1_, boolean p_i51443_2_) {
        super(p_i51443_1_, p_i51443_2_);
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i = rand.nextInt(3) + rand.nextInt(3) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (SavannaTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (SavannaTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                int k2 = i - rand.nextInt(4) - 1;
                int l2 = 3 - rand.nextInt(3);
                int i3 = position.func_177958_n();
                int j3 = position.func_177952_p();
                int j1 = 0;
                for (int k1 = 0; k1 < i; ++k1) {
                    BlockPos blockpos;
                    int l1 = position.func_177956_o() + k1;
                    if (k1 >= k2 && l2 > 0) {
                        i3 += direction.func_82601_c();
                        j3 += direction.func_82599_e();
                        --l2;
                    }
                    if (!SavannaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, blockpos = new BlockPos(i3, l1, j3))) continue;
                    this.func_208532_a(changedBlocks, (IWorldWriter)worldIn, blockpos, p_208519_5_);
                    j1 = l1;
                }
                BlockPos blockpos2 = new BlockPos(i3, j1, j3);
                for (int k3 = -3; k3 <= 3; ++k3) {
                    for (int j4 = -3; j4 <= 3; ++j4) {
                        if (Math.abs(k3) == 3 && Math.abs(j4) == 3) continue;
                        this.func_175924_b(changedBlocks, worldIn, blockpos2.func_177982_a(k3, 0, j4), p_208519_5_);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int l3 = -1; l3 <= 1; ++l3) {
                    for (int k4 = -1; k4 <= 1; ++k4) {
                        this.func_175924_b(changedBlocks, worldIn, blockpos2.func_177982_a(l3, 0, k4), p_208519_5_);
                    }
                }
                this.func_175924_b(changedBlocks, worldIn, blockpos2.func_177965_g(2), p_208519_5_);
                this.func_175924_b(changedBlocks, worldIn, blockpos2.func_177985_f(2), p_208519_5_);
                this.func_175924_b(changedBlocks, worldIn, blockpos2.func_177970_e(2), p_208519_5_);
                this.func_175924_b(changedBlocks, worldIn, blockpos2.func_177964_d(2), p_208519_5_);
                i3 = position.func_177958_n();
                j3 = position.func_177952_p();
                Direction direction1 = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                if (direction1 != direction) {
                    int i4 = k2 - rand.nextInt(2) - 1;
                    int l4 = 1 + rand.nextInt(3);
                    j1 = 0;
                    for (int i2 = i4; i2 < i && l4 > 0; ++i2, --l4) {
                        if (i2 < 1) continue;
                        int j2 = position.func_177956_o() + i2;
                        BlockPos blockpos1 = new BlockPos(i3 += direction1.func_82601_c(), j2, j3 += direction1.func_82599_e());
                        if (!SavannaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, blockpos1)) continue;
                        this.func_208532_a(changedBlocks, (IWorldWriter)worldIn, blockpos1, p_208519_5_);
                        j1 = j2;
                    }
                    if (j1 > 0) {
                        BlockPos blockpos3 = new BlockPos(i3, j1, j3);
                        for (int i5 = -2; i5 <= 2; ++i5) {
                            for (int k5 = -2; k5 <= 2; ++k5) {
                                if (Math.abs(i5) == 2 && Math.abs(k5) == 2) continue;
                                this.func_175924_b(changedBlocks, worldIn, blockpos3.func_177982_a(i5, 0, k5), p_208519_5_);
                            }
                        }
                        blockpos3 = blockpos3.func_177984_a();
                        for (int j5 = -1; j5 <= 1; ++j5) {
                            for (int l5 = -1; l5 <= 1; ++l5) {
                                this.func_175924_b(changedBlocks, worldIn, blockpos3.func_177982_a(j5, 0, l5), p_208519_5_);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void func_208532_a(Set<BlockPos> p_208532_1_, IWorldWriter p_208532_2_, BlockPos p_208532_3_, MutableBoundingBox p_208532_4_) {
        this.func_208520_a(p_208532_1_, p_208532_2_, p_208532_3_, field_181643_a, p_208532_4_);
    }

    private void func_175924_b(Set<BlockPos> worldIn, IWorldGenerationReader pos, BlockPos p_175924_3_, MutableBoundingBox p_175924_4_) {
        if (SavannaTreeFeature.func_214572_g((IWorldGenerationBaseReader)pos, p_175924_3_)) {
            this.func_208520_a(worldIn, (IWorldWriter)pos, p_175924_3_, field_181644_b, p_175924_4_);
        }
    }
}

