/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Structures {
    private static final Logger field_151687_a = LogManager.getLogger();
    public static final Structure<?> field_215143_a = Structures.func_215141_a("Mineshaft", Feature.field_202329_g);
    public static final Structure<?> field_215144_b = Structures.func_215141_a("Pillager_Outpost", Feature.field_214536_b);
    public static final Structure<?> field_215145_c = Structures.func_215141_a("Fortress", Feature.field_202337_o);
    public static final Structure<?> field_215146_d = Structures.func_215141_a("Stronghold", Feature.field_202335_m);
    public static final Structure<?> field_215147_e = Structures.func_215141_a("Jungle_Pyramid", Feature.field_202331_i);
    public static final Structure<?> field_215148_f = Structures.func_215141_a("Ocean_Ruin", Feature.field_204029_o);
    public static final Structure<?> field_215149_g = Structures.func_215141_a("Desert_Pyramid", Feature.field_202332_j);
    public static final Structure<?> field_215150_h = Structures.func_215141_a("Igloo", Feature.field_202333_k);
    public static final Structure<?> field_215151_i = Structures.func_215141_a("Swamp_Hut", Feature.field_202334_l);
    public static final Structure<?> field_215152_j = Structures.func_215141_a("Monument", Feature.field_202336_n);
    public static final Structure<?> field_215153_k = Structures.func_215141_a("EndCity", Feature.field_204292_r);
    public static final Structure<?> field_215154_l = Structures.func_215141_a("Mansion", Feature.field_202330_h);
    public static final Structure<?> field_215155_m = Structures.func_215141_a("Buried_Treasure", Feature.field_214549_o);
    public static final Structure<?> field_215156_n = Structures.func_215141_a("Shipwreck", Feature.field_204751_l);
    public static final Structure<?> field_215157_o = Structures.func_215141_a("Village", Feature.field_214550_p);

    private static Structure<?> func_215141_a(String key, Structure<?> p_215141_1_) {
        return p_215141_1_;
    }

    public static void func_215140_a() {
    }

    @Nullable
    public static StructureStart func_215142_a(ChunkGenerator<?> p_215142_0_, TemplateManager p_215142_1_, BiomeProvider p_215142_2_, CompoundNBT p_215142_3_) {
        String s = p_215142_3_.func_74779_i("id");
        if ("INVALID".equals(s)) {
            return StructureStart.field_214630_a;
        }
        Structure<?> structure = Registry.field_218361_B.func_82594_a(new ResourceLocation(s.toLowerCase(Locale.ROOT)));
        if (structure == null) {
            field_151687_a.error("Unknown feature id: {}", (Object)s);
            return null;
        }
        int i = p_215142_3_.func_74762_e("ChunkX");
        int j = p_215142_3_.func_74762_e("ChunkZ");
        Biome biome = p_215142_3_.func_74764_b("biome") ? Registry.field_212624_m.func_82594_a(new ResourceLocation(p_215142_3_.func_74779_i("biome"))) : p_215142_2_.func_222364_a(new BlockPos((i << 4) + 9, 0, (j << 4) + 9));
        MutableBoundingBox mutableboundingbox = p_215142_3_.func_74764_b("BB") ? new MutableBoundingBox(p_215142_3_.func_74759_k("BB")) : MutableBoundingBox.func_78887_a();
        ListNBT listnbt = p_215142_3_.func_150295_c("Children", 10);
        try {
            StructureStart structurestart = structure.func_214557_a().create(structure, i, j, biome, mutableboundingbox, 0, p_215142_0_.func_202089_c());
            for (int k = 0; k < listnbt.size(); ++k) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(k);
                String s1 = compoundnbt.func_74779_i("id");
                IStructurePieceType istructurepiecetype = Registry.field_218362_C.func_82594_a(new ResourceLocation(s1.toLowerCase(Locale.ROOT)));
                if (istructurepiecetype == null) {
                    field_151687_a.error("Unknown structure piece id: {}", (Object)s1);
                    continue;
                }
                try {
                    StructurePiece structurepiece = istructurepiecetype.load(p_215142_1_, compoundnbt);
                    structurestart.field_75075_a.add(structurepiece);
                    continue;
                }
                catch (Exception exception) {
                    field_151687_a.error("Exception loading structure piece with id {}", (Object)s1, (Object)exception);
                }
            }
            return structurestart;
        }
        catch (Exception exception1) {
            field_151687_a.error("Failed Start with id {}", (Object)s, (Object)exception1);
            return null;
        }
    }
}

