/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.command.impl.AdvancementCommand;
import net.minecraft.command.impl.BanCommand;
import net.minecraft.command.impl.BanIpCommand;
import net.minecraft.command.impl.BanListCommand;
import net.minecraft.command.impl.BossBarCommand;
import net.minecraft.command.impl.ClearCommand;
import net.minecraft.command.impl.CloneCommand;
import net.minecraft.command.impl.DataPackCommand;
import net.minecraft.command.impl.DeOpCommand;
import net.minecraft.command.impl.DebugCommand;
import net.minecraft.command.impl.DefaultGameModeCommand;
import net.minecraft.command.impl.DifficultyCommand;
import net.minecraft.command.impl.EffectCommand;
import net.minecraft.command.impl.EnchantCommand;
import net.minecraft.command.impl.ExecuteCommand;
import net.minecraft.command.impl.ExperienceCommand;
import net.minecraft.command.impl.FillCommand;
import net.minecraft.command.impl.ForceLoadCommand;
import net.minecraft.command.impl.FunctionCommand;
import net.minecraft.command.impl.GameModeCommand;
import net.minecraft.command.impl.GameRuleCommand;
import net.minecraft.command.impl.GiveCommand;
import net.minecraft.command.impl.HelpCommand;
import net.minecraft.command.impl.KickCommand;
import net.minecraft.command.impl.KillCommand;
import net.minecraft.command.impl.ListCommand;
import net.minecraft.command.impl.LocateCommand;
import net.minecraft.command.impl.LootCommand;
import net.minecraft.command.impl.MeCommand;
import net.minecraft.command.impl.MessageCommand;
import net.minecraft.command.impl.OpCommand;
import net.minecraft.command.impl.PardonCommand;
import net.minecraft.command.impl.PardonIpCommand;
import net.minecraft.command.impl.ParticleCommand;
import net.minecraft.command.impl.PlaySoundCommand;
import net.minecraft.command.impl.PublishCommand;
import net.minecraft.command.impl.RecipeCommand;
import net.minecraft.command.impl.ReloadCommand;
import net.minecraft.command.impl.ReplaceItemCommand;
import net.minecraft.command.impl.SaveAllCommand;
import net.minecraft.command.impl.SaveOffCommand;
import net.minecraft.command.impl.SaveOnCommand;
import net.minecraft.command.impl.SayCommand;
import net.minecraft.command.impl.ScheduleCommand;
import net.minecraft.command.impl.ScoreboardCommand;
import net.minecraft.command.impl.SeedCommand;
import net.minecraft.command.impl.SetBlockCommand;
import net.minecraft.command.impl.SetIdleTimeoutCommand;
import net.minecraft.command.impl.SetWorldSpawnCommand;
import net.minecraft.command.impl.SpawnPointCommand;
import net.minecraft.command.impl.SpreadPlayersCommand;
import net.minecraft.command.impl.StopCommand;
import net.minecraft.command.impl.StopSoundCommand;
import net.minecraft.command.impl.SummonCommand;
import net.minecraft.command.impl.TagCommand;
import net.minecraft.command.impl.TeamCommand;
import net.minecraft.command.impl.TeamMsgCommand;
import net.minecraft.command.impl.TeleportCommand;
import net.minecraft.command.impl.TellRawCommand;
import net.minecraft.command.impl.TimeCommand;
import net.minecraft.command.impl.TitleCommand;
import net.minecraft.command.impl.TriggerCommand;
import net.minecraft.command.impl.WeatherCommand;
import net.minecraft.command.impl.WhitelistCommand;
import net.minecraft.command.impl.WorldBorderCommand;
import net.minecraft.command.impl.data.DataCommand;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SCommandListPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Commands {
    private static final Logger field_197061_a = LogManager.getLogger();
    private final CommandDispatcher<CommandSource> field_197062_b = new CommandDispatcher();

    public Commands(boolean bl2) {
        AdvancementCommand.func_198199_a(this.field_197062_b);
        ExecuteCommand.func_198378_a(this.field_197062_b);
        BossBarCommand.func_201413_a(this.field_197062_b);
        ClearCommand.func_198243_a(this.field_197062_b);
        CloneCommand.func_198265_a(this.field_197062_b);
        DataCommand.func_198937_a(this.field_197062_b);
        DataPackCommand.func_198299_a(this.field_197062_b);
        DebugCommand.func_198330_a(this.field_197062_b);
        DefaultGameModeCommand.func_198340_a(this.field_197062_b);
        DifficultyCommand.func_198344_a(this.field_197062_b);
        EffectCommand.func_198353_a(this.field_197062_b);
        MeCommand.func_198364_a(this.field_197062_b);
        EnchantCommand.func_202649_a(this.field_197062_b);
        ExperienceCommand.func_198437_a(this.field_197062_b);
        FillCommand.func_198465_a(this.field_197062_b);
        ForceLoadCommand.func_212712_a(this.field_197062_b);
        FunctionCommand.func_198476_a(this.field_197062_b);
        GameModeCommand.func_198482_a(this.field_197062_b);
        GameRuleCommand.func_198487_a(this.field_197062_b);
        GiveCommand.func_198494_a(this.field_197062_b);
        HelpCommand.func_198510_a(this.field_197062_b);
        KickCommand.func_198514_a(this.field_197062_b);
        KillCommand.func_198518_a(this.field_197062_b);
        ListCommand.func_198522_a(this.field_197062_b);
        LocateCommand.func_198528_a(this.field_197062_b);
        LootCommand.func_218886_a(this.field_197062_b);
        MessageCommand.func_198537_a(this.field_197062_b);
        ParticleCommand.func_198563_a(this.field_197062_b);
        PlaySoundCommand.func_198572_a(this.field_197062_b);
        PublishCommand.func_198581_a(this.field_197062_b);
        ReloadCommand.func_198597_a(this.field_197062_b);
        RecipeCommand.func_198589_a(this.field_197062_b);
        ReplaceItemCommand.func_198602_a(this.field_197062_b);
        SayCommand.func_198625_a(this.field_197062_b);
        ScheduleCommand.func_218909_a(this.field_197062_b);
        ScoreboardCommand.func_198647_a(this.field_197062_b);
        SeedCommand.func_198671_a(this.field_197062_b);
        SetBlockCommand.func_198684_a(this.field_197062_b);
        SpawnPointCommand.func_198695_a(this.field_197062_b);
        SetWorldSpawnCommand.func_198702_a(this.field_197062_b);
        SpreadPlayersCommand.func_198716_a(this.field_197062_b);
        StopSoundCommand.func_198730_a(this.field_197062_b);
        SummonCommand.func_198736_a(this.field_197062_b);
        TagCommand.func_198743_a(this.field_197062_b);
        TeamCommand.func_198771_a(this.field_197062_b);
        TeamMsgCommand.func_218915_a(this.field_197062_b);
        TeleportCommand.func_198809_a(this.field_197062_b);
        TellRawCommand.func_198818_a(this.field_197062_b);
        TimeCommand.func_198823_a(this.field_197062_b);
        TitleCommand.func_198839_a(this.field_197062_b);
        TriggerCommand.func_198852_a(this.field_197062_b);
        WeatherCommand.func_198862_a(this.field_197062_b);
        WorldBorderCommand.func_198894_a(this.field_197062_b);
        if (bl2) {
            BanIpCommand.func_198220_a(this.field_197062_b);
            BanListCommand.func_198229_a(this.field_197062_b);
            BanCommand.func_198235_a(this.field_197062_b);
            DeOpCommand.func_198321_a(this.field_197062_b);
            OpCommand.func_198541_a(this.field_197062_b);
            PardonCommand.func_198547_a(this.field_197062_b);
            PardonIpCommand.func_198553_a(this.field_197062_b);
            SaveAllCommand.func_198611_a(this.field_197062_b);
            SaveOffCommand.func_198617_a(this.field_197062_b);
            SaveOnCommand.func_198621_a(this.field_197062_b);
            SetIdleTimeoutCommand.func_198690_a(this.field_197062_b);
            StopCommand.func_198725_a(this.field_197062_b);
            WhitelistCommand.func_198873_a(this.field_197062_b);
        }
        this.field_197062_b.findAmbiguities((commandNode, commandNode2, commandNode3, collection) -> field_197061_a.warn("Ambiguity between arguments {} and {} with inputs: {}", (Object)this.field_197062_b.getPath(commandNode2), (Object)this.field_197062_b.getPath(commandNode3), (Object)collection));
        this.field_197062_b.setConsumer((commandContext, bl, n) -> ((CommandSource)commandContext.getSource()).func_197038_a((CommandContext<CommandSource>)commandContext, bl, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_197059_a(CommandSource commandSource2, String string) {
        CommandSource commandSource2;
        StringReader stringReader = new StringReader(string);
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        commandSource2.func_197028_i().func_213185_aS().func_76320_a(string);
        try {
            int n = this.field_197062_b.execute(stringReader, (Object)commandSource2);
            return n;
        }
        catch (CommandException \u26032) {
            commandSource2.func_197021_a(\u26032.func_197003_a());
            int n = 0;
            return n;
        }
        catch (CommandSyntaxException \u26033) {
            int n;
            commandSource2.func_197021_a(TextComponentUtils.func_202465_a(\u26033.getRawMessage()));
            if (\u26033.getInput() != null && \u26033.getCursor() >= 0) {
                n = Math.min(\u26033.getInput().length(), \u26033.getCursor());
                ITextComponent \u26034 = new StringTextComponent("").func_211708_a(TextFormatting.GRAY).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, string)));
                if (n > 10) {
                    \u26034.func_150258_a("...");
                }
                \u26034.func_150258_a(\u26033.getInput().substring(Math.max(0, n - 10), n));
                if (n < \u26033.getInput().length()) {
                    ITextComponent iTextComponent = new StringTextComponent(\u26033.getInput().substring(n)).func_211709_a(TextFormatting.RED, TextFormatting.UNDERLINE);
                    \u26034.func_150257_a(iTextComponent);
                }
                \u26034.func_150257_a(new TranslationTextComponent("command.context.here", new Object[0]).func_211709_a(TextFormatting.RED, TextFormatting.ITALIC));
                commandSource2.func_197021_a(\u26034);
            }
            n = 0;
            return n;
        }
        catch (Exception exception) {
            StringTextComponent stringTextComponent = new StringTextComponent(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (field_197061_a.isDebugEnabled()) {
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                for (int i = 0; i < Math.min(stackTraceElementArray.length, 3); ++i) {
                    stringTextComponent.func_150258_a("\n\n").func_150258_a(stackTraceElementArray[i].getMethodName()).func_150258_a("\n ").func_150258_a(stackTraceElementArray[i].getFileName()).func_150258_a(":").func_150258_a(String.valueOf(stackTraceElementArray[i].getLineNumber()));
                }
            }
            commandSource2.func_197021_a(new TranslationTextComponent("command.failed", new Object[0]).func_211710_a(style -> style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, stringTextComponent))));
            int n = 0;
            return n;
        }
        finally {
            commandSource2.func_197028_i().func_213185_aS().func_76319_b();
        }
    }

    public void func_197051_a(ServerPlayerEntity serverPlayerEntity) {
        HashMap hashMap = Maps.newHashMap();
        RootCommandNode \u26032 = new RootCommandNode();
        hashMap.put(this.field_197062_b.getRoot(), \u26032);
        this.func_197052_a((CommandNode<CommandSource>)this.field_197062_b.getRoot(), (CommandNode<ISuggestionProvider>)\u26032, serverPlayerEntity.func_195051_bN(), hashMap);
        serverPlayerEntity.field_71135_a.func_147359_a(new SCommandListPacket((RootCommandNode<ISuggestionProvider>)\u26032));
    }

    private void func_197052_a(CommandNode<CommandSource> commandNode, CommandNode<ISuggestionProvider> commandNode2, CommandSource commandSource, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> map) {
        for (CommandNode commandNode3 : commandNode.getChildren()) {
            if (!commandNode3.canUse((Object)commandSource)) continue;
            ArgumentBuilder argumentBuilder = commandNode3.createBuilder();
            argumentBuilder.requires(iSuggestionProvider -> true);
            if (argumentBuilder.getCommand() != null) {
                argumentBuilder.executes(commandContext -> 0);
            }
            if (argumentBuilder instanceof RequiredArgumentBuilder && (\u26032 = (RequiredArgumentBuilder)argumentBuilder).getSuggestionsProvider() != null) {
                \u26032.suggests(SuggestionProviders.func_197496_b((SuggestionProvider<ISuggestionProvider>)\u26032.getSuggestionsProvider()));
            }
            if (argumentBuilder.getRedirect() != null) {
                argumentBuilder.redirect(map.get(argumentBuilder.getRedirect()));
            }
            RequiredArgumentBuilder \u26032 = argumentBuilder.build();
            map.put((CommandNode<CommandSource>)commandNode3, (CommandNode<ISuggestionProvider>)\u26032);
            commandNode2.addChild((CommandNode)\u26032);
            if (commandNode3.getChildren().isEmpty()) continue;
            this.func_197052_a((CommandNode<CommandSource>)commandNode3, (CommandNode<ISuggestionProvider>)\u26032, commandSource, map);
        }
    }

    public static LiteralArgumentBuilder<CommandSource> func_197057_a(String string) {
        return LiteralArgumentBuilder.literal((String)string);
    }

    public static <T> RequiredArgumentBuilder<CommandSource, T> func_197056_a(String string, ArgumentType<T> argumentType) {
        return RequiredArgumentBuilder.argument((String)string, argumentType);
    }

    public static Predicate<String> func_212590_a(IParser iParser) {
        return string -> {
            try {
                iParser.parse(new StringReader(string));
                return true;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return false;
            }
        };
    }

    public CommandDispatcher<CommandSource> func_197054_a() {
        return this.field_197062_b;
    }

    @FunctionalInterface
    public static interface IParser {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

