/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ZombiePigmanEntity
extends ZombieEntity {
    private static final UUID field_110189_bq = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier field_110190_br = new AttributeModifier(field_110189_bq, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private int field_70837_d;
    private int field_70838_e;
    private UUID field_175459_bn;

    public ZombiePigmanEntity(EntityType<? extends ZombiePigmanEntity> entityType, World world) {
        super((EntityType<? extends ZombieEntity>)entityType, world);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
    }

    @Override
    public void func_70604_c(@Nullable LivingEntity livingEntity) {
        super.func_70604_c(livingEntity);
        if (livingEntity != null) {
            this.field_175459_bn = livingEntity.func_110124_au();
        }
    }

    @Override
    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(2, new ZombieAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70715_bh.func_75776_a(1, new HurtByAggressorGoal(this));
        this.field_70715_bh.func_75776_a(2, new TargetAggressorGoal(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(field_110186_bp).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    protected boolean func_204703_dA() {
        return false;
    }

    @Override
    protected void func_70619_bc() {
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        LivingEntity \u26032 = this.func_70643_av();
        if (this.func_175457_ck()) {
            if (!this.func_70631_g_() && !iAttributeInstance.func_180374_a(field_110190_br)) {
                iAttributeInstance.func_111121_a(field_110190_br);
            }
            --this.field_70837_d;
            LivingEntity livingEntity = livingEntity = \u26032 != null ? \u26032 : this.func_70638_az();
            if (!this.func_175457_ck() && livingEntity != null) {
                if (!this.func_70685_l(livingEntity)) {
                    this.func_70604_c(null);
                    this.func_70624_b(null);
                } else {
                    this.field_70837_d = this.func_223336_ef();
                }
            }
        } else if (iAttributeInstance.func_180374_a(field_110190_br)) {
            iAttributeInstance.func_111124_b(field_110190_br);
        }
        if (this.field_70838_e > 0 && --this.field_70838_e == 0) {
            this.func_184185_a(SoundEvents.field_187936_hj, this.func_70599_aP() * 2.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        if (this.func_175457_ck() && this.field_175459_bn != null && \u26032 == null) {
            LivingEntity livingEntity = this.field_70170_p.func_217371_b(this.field_175459_bn);
            this.func_70604_c(livingEntity);
            this.field_70717_bb = livingEntity;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    public static boolean func_223337_b(EntityType<ZombiePigmanEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return iWorld.func_175659_aa() != Difficulty.PEACEFUL;
    }

    @Override
    public boolean func_205019_a(IWorldReader iWorldReader) {
        return iWorldReader.func_217346_i(this) && !iWorldReader.func_72953_d(this.func_174813_aQ());
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74777_a("Anger", (short)this.field_70837_d);
        if (this.field_175459_bn != null) {
            compoundNBT.func_74778_a("HurtBy", this.field_175459_bn.toString());
        } else {
            compoundNBT.func_74778_a("HurtBy", "");
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_70837_d = compoundNBT.func_74765_d("Anger");
        String string = compoundNBT.func_74779_i("HurtBy");
        if (!string.isEmpty()) {
            this.field_175459_bn = UUID.fromString(string);
            PlayerEntity playerEntity = this.field_70170_p.func_217371_b(this.field_175459_bn);
            this.func_70604_c(playerEntity);
            if (playerEntity != null) {
                this.field_70717_bb = playerEntity;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() && this.func_70685_l(entity)) {
            this.func_70835_c(entity);
        }
        return super.func_70097_a(damageSource, f);
    }

    private boolean func_70835_c(Entity entity) {
        this.field_70837_d = this.func_223336_ef();
        this.field_70838_e = this.field_70146_Z.nextInt(40);
        if (entity instanceof LivingEntity) {
            this.func_70604_c((LivingEntity)entity);
        }
        return true;
    }

    private int func_223336_ef() {
        return 400 + this.field_70146_Z.nextInt(400);
    }

    private boolean func_175457_ck() {
        return this.field_70837_d > 0;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187935_hi;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187938_hl;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187937_hk;
    }

    @Override
    public boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        return false;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151010_B));
    }

    @Override
    protected ItemStack func_190732_dj() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_191990_c(PlayerEntity playerEntity) {
        return this.func_175457_ck();
    }

    static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public TargetAggressorGoal(ZombiePigmanEntity zombiePigmanEntity) {
            super((MobEntity)zombiePigmanEntity, PlayerEntity.class, true);
        }

        @Override
        public boolean func_75250_a() {
            return ((ZombiePigmanEntity)this.field_75299_d).func_175457_ck() && super.func_75250_a();
        }
    }

    static class HurtByAggressorGoal
    extends HurtByTargetGoal {
        public HurtByAggressorGoal(ZombiePigmanEntity zombiePigmanEntity) {
            super(zombiePigmanEntity, new Class[0]);
            this.func_220794_a(ZombieEntity.class);
        }

        @Override
        protected void func_220793_a(MobEntity mobEntity, LivingEntity livingEntity) {
            if (mobEntity instanceof ZombiePigmanEntity && this.field_75299_d.func_70685_l(livingEntity) && ((ZombiePigmanEntity)mobEntity).func_70835_c(livingEntity)) {
                mobEntity.func_70624_b(livingEntity);
            }
        }
    }
}

