/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

public class NBTDynamicOps
implements DynamicOps<INBT> {
    public static final NBTDynamicOps field_210820_a = new NBTDynamicOps();

    protected NBTDynamicOps() {
    }

    public INBT empty() {
        return new EndNBT();
    }

    public Type<?> getType(INBT iNBT) {
        switch (iNBT.func_74732_a()) {
            case 0: {
                return DSL.nilType();
            }
            case 1: {
                return DSL.byteType();
            }
            case 2: {
                return DSL.shortType();
            }
            case 3: {
                return DSL.intType();
            }
            case 4: {
                return DSL.longType();
            }
            case 5: {
                return DSL.floatType();
            }
            case 6: {
                return DSL.doubleType();
            }
            case 7: {
                return DSL.list((Type)DSL.byteType());
            }
            case 8: {
                return DSL.string();
            }
            case 9: {
                return DSL.list((Type)DSL.remainderType());
            }
            case 10: {
                return DSL.compoundList((Type)DSL.remainderType(), (Type)DSL.remainderType());
            }
            case 11: {
                return DSL.list((Type)DSL.intType());
            }
            case 12: {
                return DSL.list((Type)DSL.longType());
            }
        }
        return DSL.remainderType();
    }

    public Optional<Number> getNumberValue(INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            return Optional.of(((NumberNBT)iNBT).func_209908_j());
        }
        return Optional.empty();
    }

    public INBT createNumeric(Number number) {
        return new DoubleNBT(number.doubleValue());
    }

    public INBT createByte(byte by) {
        return new ByteNBT(by);
    }

    public INBT createShort(short s) {
        return new ShortNBT(s);
    }

    public INBT createInt(int n) {
        return new IntNBT(n);
    }

    public INBT createLong(long l) {
        return new LongNBT(l);
    }

    public INBT createFloat(float f) {
        return new FloatNBT(f);
    }

    public INBT createDouble(double d) {
        return new DoubleNBT(d);
    }

    public Optional<String> getStringValue(INBT iNBT) {
        if (iNBT instanceof StringNBT) {
            return Optional.of(iNBT.func_150285_a_());
        }
        return Optional.empty();
    }

    public INBT createString(String string) {
        return new StringNBT(string);
    }

    public INBT mergeInto(INBT iNBT3, INBT iNBT22) {
        INBT iNBT3;
        if (iNBT22 instanceof EndNBT) {
            return iNBT3;
        }
        if (iNBT3 instanceof CompoundNBT) {
            if (iNBT22 instanceof CompoundNBT) {
                INBT iNBT22;
                CompoundNBT compoundNBT = new CompoundNBT();
                \u2603 = (CompoundNBT)iNBT3;
                for (String string : \u2603.func_150296_c()) {
                    compoundNBT.func_218657_a(string, \u2603.func_74781_a(string));
                }
                CompoundNBT \u26032 = (CompoundNBT)iNBT22;
                for (String string : \u26032.func_150296_c()) {
                    compoundNBT.func_218657_a(string, \u26032.func_74781_a(string));
                }
                return compoundNBT;
            }
            return iNBT3;
        }
        if (iNBT3 instanceof EndNBT) {
            throw new IllegalArgumentException("mergeInto called with a null input.");
        }
        if (!(iNBT3 instanceof CollectionNBT)) {
            return iNBT3;
        }
        ListNBT \u26033 = new ListNBT();
        CollectionNBT \u26034 = (CollectionNBT)iNBT3;
        \u26033.addAll(\u26034);
        \u26033.add(iNBT22);
        return \u26033;
    }

    public INBT mergeInto(INBT iNBT4, INBT iNBT2, INBT iNBT3) {
        INBT iNBT4;
        CompoundNBT compoundNBT;
        if (iNBT4 instanceof EndNBT) {
            compoundNBT = new CompoundNBT();
        } else if (iNBT4 instanceof CompoundNBT) {
            CompoundNBT compoundNBT2 = (CompoundNBT)iNBT4;
            compoundNBT = new CompoundNBT();
            compoundNBT2.func_150296_c().forEach(string -> compoundNBT.func_218657_a((String)string, compoundNBT2.func_74781_a((String)string)));
        } else {
            return iNBT4;
        }
        compoundNBT.func_218657_a(iNBT2.func_150285_a_(), iNBT3);
        return compoundNBT;
    }

    public INBT merge(INBT iNBT3, INBT iNBT2) {
        INBT iNBT3;
        if (iNBT3 instanceof EndNBT) {
            return iNBT2;
        }
        if (iNBT2 instanceof EndNBT) {
            return iNBT3;
        }
        if (iNBT3 instanceof CompoundNBT && iNBT2 instanceof CompoundNBT) {
            \u2603 = (CompoundNBT)iNBT3;
            CompoundNBT compoundNBT = (CompoundNBT)iNBT2;
            \u2603 = new CompoundNBT();
            ((CompoundNBT)\u2603).func_150296_c().forEach(arg_0 -> NBTDynamicOps.func_211384_c(\u2603, (CompoundNBT)\u2603, arg_0));
            compoundNBT.func_150296_c().forEach(string -> \u2603.func_218657_a((String)string, compoundNBT.func_74781_a((String)string)));
        }
        if (iNBT3 instanceof CollectionNBT && iNBT2 instanceof CollectionNBT) {
            \u2603 = new ListNBT();
            ((AbstractCollection)((Object)\u2603)).addAll((CollectionNBT)iNBT3);
            ((AbstractCollection)((Object)\u2603)).addAll((CollectionNBT)iNBT2);
            return \u2603;
        }
        throw new IllegalArgumentException("Could not merge " + iNBT3 + " and " + iNBT2);
    }

    public Optional<Map<INBT, INBT>> getMapValues(INBT iNBT) {
        if (iNBT instanceof CompoundNBT) {
            CompoundNBT compoundNBT = (CompoundNBT)iNBT;
            return Optional.of(compoundNBT.func_150296_c().stream().map(string -> Pair.of((Object)this.createString((String)string), (Object)compoundNBT.func_74781_a((String)string))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }
        return Optional.empty();
    }

    public INBT createMap(Map<INBT, INBT> map) {
        CompoundNBT compoundNBT = new CompoundNBT();
        for (Map.Entry<INBT, INBT> entry : map.entrySet()) {
            compoundNBT.func_218657_a(entry.getKey().func_150285_a_(), entry.getValue());
        }
        return compoundNBT;
    }

    public Optional<Stream<INBT>> getStream(INBT iNBT2) {
        if (iNBT2 instanceof CollectionNBT) {
            return Optional.of(((CollectionNBT)iNBT2).stream().map(iNBT -> iNBT));
        }
        return Optional.empty();
    }

    public Optional<ByteBuffer> getByteBuffer(INBT iNBT) {
        if (iNBT instanceof ByteArrayNBT) {
            return Optional.of(ByteBuffer.wrap(((ByteArrayNBT)iNBT).func_150292_c()));
        }
        return super.getByteBuffer((Object)iNBT);
    }

    public INBT createByteList(ByteBuffer byteBuffer) {
        return new ByteArrayNBT(DataFixUtils.toArray((ByteBuffer)byteBuffer));
    }

    public Optional<IntStream> getIntStream(INBT iNBT) {
        if (iNBT instanceof IntArrayNBT) {
            return Optional.of(Arrays.stream(((IntArrayNBT)iNBT).func_150302_c()));
        }
        return super.getIntStream((Object)iNBT);
    }

    public INBT createIntList(IntStream intStream) {
        return new IntArrayNBT(intStream.toArray());
    }

    public Optional<LongStream> getLongStream(INBT iNBT) {
        if (iNBT instanceof LongArrayNBT) {
            return Optional.of(Arrays.stream(((LongArrayNBT)iNBT).func_197652_h()));
        }
        return super.getLongStream((Object)iNBT);
    }

    public INBT createLongList(LongStream longStream) {
        return new LongArrayNBT(longStream.toArray());
    }

    public INBT createList(Stream<INBT> stream) {
        PeekingIterator peekingIterator = Iterators.peekingIterator(stream.iterator());
        if (!peekingIterator.hasNext()) {
            return new ListNBT();
        }
        INBT \u26032 = (INBT)peekingIterator.peek();
        if (\u26032 instanceof ByteNBT) {
            ArrayList arrayList = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBT -> ((ByteNBT)iNBT).func_150290_f()));
            return new ByteArrayNBT(arrayList);
        }
        if (\u26032 instanceof IntNBT) {
            ArrayList \u26033 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBT -> ((IntNBT)iNBT).func_150287_d()));
            return new IntArrayNBT(\u26033);
        }
        if (\u26032 instanceof LongNBT) {
            ArrayList \u26034 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBT -> ((LongNBT)iNBT).func_150291_c()));
            return new LongArrayNBT(\u26034);
        }
        ListNBT listNBT = new ListNBT();
        while (peekingIterator.hasNext()) {
            INBT iNBT2 = (INBT)peekingIterator.next();
            if (iNBT2 instanceof EndNBT) continue;
            listNBT.add(iNBT2);
        }
        return listNBT;
    }

    public INBT remove(INBT iNBT2, String string3) {
        INBT iNBT2;
        if (iNBT2 instanceof CompoundNBT) {
            CompoundNBT compoundNBT = (CompoundNBT)iNBT2;
            \u2603 = new CompoundNBT();
            compoundNBT.func_150296_c().stream().filter(string2 -> !Objects.equals(string2, string3)).forEach(string -> \u2603.func_218657_a((String)string, compoundNBT.func_74781_a((String)string)));
            return \u2603;
        }
        return iNBT2;
    }

    public String toString() {
        return "NBT";
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((INBT)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ Optional getLongStream(Object object) {
        return this.getLongStream((INBT)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ Optional getIntStream(Object object) {
        return this.getIntStream((INBT)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ Optional getByteBuffer(Object object) {
        return this.getByteBuffer((INBT)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ Optional getStream(Object object) {
        return this.getStream((INBT)object);
    }

    public /* synthetic */ Object createMap(Map map) {
        return this.createMap(map);
    }

    public /* synthetic */ Optional getMapValues(Object object) {
        return this.getMapValues((INBT)object);
    }

    public /* synthetic */ Object merge(Object object, Object object2) {
        return this.merge((INBT)object, (INBT)object2);
    }

    public /* synthetic */ Object mergeInto(Object object, Object object2, Object object3) {
        return this.mergeInto((INBT)object, (INBT)object2, (INBT)object3);
    }

    public /* synthetic */ Object mergeInto(Object object, Object object2) {
        return this.mergeInto((INBT)object, (INBT)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ Optional getStringValue(Object object) {
        return this.getStringValue((INBT)object);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ Optional getNumberValue(Object object) {
        return this.getNumberValue((INBT)object);
    }

    public /* synthetic */ Type getType(Object object) {
        return this.getType((INBT)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    private static /* synthetic */ void func_211384_c(CompoundNBT compoundNBT, CompoundNBT compoundNBT2, String string) {
        compoundNBT.func_218657_a(string, compoundNBT2.func_74781_a(string));
    }
}

