/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.Profiler;
import net.minecraft.resources.AsyncReloader;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugAsyncReloader
extends AsyncReloader<DataPoint> {
    private static final Logger field_219583_d = LogManager.getLogger();
    private final Stopwatch field_219584_e = Stopwatch.createUnstarted();

    public DebugAsyncReloader(IResourceManager iResourceManager2, List<IFutureReloadListener> list, Executor executor, Executor executor4, CompletableFuture<Unit> completableFuture) {
        super(executor, executor4, iResourceManager2, list, (iStage, iResourceManager, iFutureReloadListener, executor2, executor3) -> {
            AtomicLong atomicLong = new AtomicLong();
            \u2603 = new AtomicLong();
            Profiler \u26032 = new Profiler(Util.func_211178_c(), () -> 0);
            Profiler \u26033 = new Profiler(Util.func_211178_c(), () -> 0);
            CompletableFuture<Void> \u26034 = iFutureReloadListener.func_215226_a(iStage, iResourceManager, \u26032, \u26033, runnable -> executor2.execute(() -> {
                long l = Util.func_211178_c();
                runnable.run();
                atomicLong.addAndGet(Util.func_211178_c() - l);
            }), runnable -> executor3.execute(() -> {
                long l = Util.func_211178_c();
                runnable.run();
                \u2603.addAndGet(Util.func_211178_c() - l);
            }));
            return \u26034.thenApplyAsync(void_ -> new DataPoint(iFutureReloadListener.getClass().getSimpleName(), \u26032.func_219905_d(), \u26033.func_219905_d(), atomicLong, \u2603), executor4);
        }, completableFuture);
        this.field_219584_e.start();
        this.field_219567_c.thenAcceptAsync(this::func_219575_a, executor4);
    }

    private void func_219575_a(List<DataPoint> list) {
        this.field_219584_e.stop();
        int n = 0;
        field_219583_d.info("Resource reload finished after " + this.field_219584_e.elapsed(TimeUnit.MILLISECONDS) + " ms");
        for (DataPoint dataPoint : list) {
            IProfileResult iProfileResult = dataPoint.field_219548_b;
            \u2603 = dataPoint.field_219549_c;
            int \u26032 = (int)((double)dataPoint.field_219550_d.get() / 1000000.0);
            int \u26033 = (int)((double)dataPoint.field_219551_e.get() / 1000000.0);
            int \u26034 = \u26032 + \u26033;
            String \u26035 = dataPoint.field_219547_a;
            field_219583_d.info(\u26035 + " took approximately " + \u26034 + " ms (" + \u26032 + " ms preparing, " + \u26033 + " ms applying)");
            String \u26036 = iProfileResult.func_219920_e();
            if (\u26036.length() > 0) {
                field_219583_d.debug(\u26035 + " preparations:\n" + \u26036);
            }
            if ((\u2603 = \u2603.func_219920_e()).length() > 0) {
                field_219583_d.debug(\u26035 + " reload:\n" + \u2603);
            }
            field_219583_d.info("----------");
            n += \u26033;
        }
        field_219583_d.info("Total blocking time: " + n + " ms");
    }

    public static class DataPoint {
        private final String field_219547_a;
        private final IProfileResult field_219548_b;
        private final IProfileResult field_219549_c;
        private final AtomicLong field_219550_d;
        private final AtomicLong field_219551_e;

        private DataPoint(String string, IProfileResult iProfileResult, IProfileResult iProfileResult2, AtomicLong atomicLong, AtomicLong atomicLong2) {
            this.field_219547_a = string;
            this.field_219548_b = iProfileResult;
            this.field_219549_c = iProfileResult2;
            this.field_219550_d = atomicLong;
            this.field_219551_e = atomicLong2;
        }
    }
}

