/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.shapes;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.OffsetDoubleList;
import net.minecraft.util.math.shapes.SplitVoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeArray;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapes;

public abstract class VoxelShape {
    protected final VoxelShapePart field_197768_g;
    @Nullable
    private VoxelShape[] field_222864_b;

    VoxelShape(VoxelShapePart voxelShapePart) {
        this.field_197768_g = voxelShapePart;
    }

    public double func_197762_b(Direction.Axis axis) {
        int n = this.field_197768_g.func_199623_a(axis);
        if (n >= this.field_197768_g.func_197819_a(axis)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.func_197759_b(axis, n);
    }

    public double func_197758_c(Direction.Axis axis) {
        int n = this.field_197768_g.func_199624_b(axis);
        if (n <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.func_197759_b(axis, n);
    }

    public AxisAlignedBB func_197752_a() {
        if (this.func_197766_b()) {
            throw new UnsupportedOperationException("No bounds for empty shape.");
        }
        return new AxisAlignedBB(this.func_197762_b(Direction.Axis.X), this.func_197762_b(Direction.Axis.Y), this.func_197762_b(Direction.Axis.Z), this.func_197758_c(Direction.Axis.X), this.func_197758_c(Direction.Axis.Y), this.func_197758_c(Direction.Axis.Z));
    }

    protected double func_197759_b(Direction.Axis axis, int n) {
        return this.func_197757_a(axis).getDouble(n);
    }

    protected abstract DoubleList func_197757_a(Direction.Axis var1);

    public boolean func_197766_b() {
        return this.field_197768_g.func_197830_a();
    }

    public VoxelShape func_197751_a(double d, double d2, double d3) {
        if (this.func_197766_b()) {
            return VoxelShapes.func_197880_a();
        }
        return new VoxelShapeArray(this.field_197768_g, (DoubleList)new OffsetDoubleList(this.func_197757_a(Direction.Axis.X), d), (DoubleList)new OffsetDoubleList(this.func_197757_a(Direction.Axis.Y), d2), (DoubleList)new OffsetDoubleList(this.func_197757_a(Direction.Axis.Z), d3));
    }

    public VoxelShape func_197753_c() {
        VoxelShape[] voxelShapeArray = new VoxelShape[]{VoxelShapes.func_197880_a()};
        this.func_197755_b((d, d2, d3, d4, d5, d6) -> {
            voxelShapeArray[0] = VoxelShapes.func_197882_b(voxelShapeArray[0], VoxelShapes.func_197873_a(d, d2, d3, d4, d5, d6), IBooleanFunction.field_223244_o_);
        });
        return voxelShapeArray[0];
    }

    public void func_197755_b(VoxelShapes.ILineConsumer iLineConsumer) {
        DoubleList doubleList = this.func_197757_a(Direction.Axis.X);
        \u2603 = this.func_197757_a(Direction.Axis.Y);
        \u2603 = this.func_197757_a(Direction.Axis.Z);
        this.field_197768_g.func_197831_b((n, n2, n3, n4, n5, n6) -> iLineConsumer.consume(doubleList.getDouble(n), \u2603.getDouble(n2), \u2603.getDouble(n3), doubleList.getDouble(n4), \u2603.getDouble(n5), \u2603.getDouble(n6)), true);
    }

    public List<AxisAlignedBB> func_197756_d() {
        ArrayList arrayList = Lists.newArrayList();
        this.func_197755_b((d, d2, d3, d4, d5, d6) -> arrayList.add(new AxisAlignedBB(d, d2, d3, d4, d5, d6)));
        return arrayList;
    }

    protected int func_197749_a(Direction.Axis axis, double d) {
        return MathHelper.func_199093_a(0, this.field_197768_g.func_197819_a(axis) + 1, n -> {
            if (n < 0) {
                return false;
            }
            if (n > this.field_197768_g.func_197819_a(axis)) {
                return true;
            }
            return d < this.func_197759_b(axis, n);
        }) - 1;
    }

    protected boolean func_211542_b(double d, double d2, double d3) {
        return this.field_197768_g.func_197818_c(this.func_197749_a(Direction.Axis.X, d), this.func_197749_a(Direction.Axis.Y, d2), this.func_197749_a(Direction.Axis.Z, d3));
    }

    @Nullable
    public BlockRayTraceResult func_212433_a(Vec3d vec3d, Vec3d vec3d2, BlockPos blockPos) {
        if (this.func_197766_b()) {
            return null;
        }
        Vec3d vec3d3 = vec3d2.func_178788_d(vec3d);
        if (vec3d3.func_189985_c() < 1.0E-7) {
            return null;
        }
        \u2603 = vec3d.func_178787_e(vec3d3.func_186678_a(0.001));
        if (this.func_211542_b(\u2603.field_72450_a - (double)blockPos.func_177958_n(), \u2603.field_72448_b - (double)blockPos.func_177956_o(), \u2603.field_72449_c - (double)blockPos.func_177952_p())) {
            return new BlockRayTraceResult(\u2603, Direction.func_210769_a(vec3d3.field_72450_a, vec3d3.field_72448_b, vec3d3.field_72449_c).func_176734_d(), blockPos, true);
        }
        return AxisAlignedBB.func_197743_a(this.func_197756_d(), vec3d, vec3d2, blockPos);
    }

    public VoxelShape func_212434_a(Direction direction) {
        VoxelShape voxelShape;
        if (this.func_197766_b() || this == VoxelShapes.func_197868_b()) {
            return this;
        }
        if (this.field_222864_b != null) {
            voxelShape = this.field_222864_b[direction.ordinal()];
            if (voxelShape != null) {
                return voxelShape;
            }
        } else {
            this.field_222864_b = new VoxelShape[6];
        }
        this.field_222864_b[direction.ordinal()] = voxelShape = this.func_222863_b(direction);
        return voxelShape;
    }

    private VoxelShape func_222863_b(Direction direction) {
        Direction.Axis axis = direction.func_176740_k();
        Direction.AxisDirection \u26032 = direction.func_176743_c();
        DoubleList \u26033 = this.func_197757_a(axis);
        if (\u26033.size() == 2 && DoubleMath.fuzzyEquals((double)\u26033.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)\u26033.getDouble(1), (double)1.0, (double)1.0E-7)) {
            return this;
        }
        int \u26034 = this.func_197749_a(axis, \u26032 == Direction.AxisDirection.POSITIVE ? 0.9999999 : 1.0E-7);
        return new SplitVoxelShape(this, axis, \u26034);
    }

    public double func_212430_a(Direction.Axis axis, AxisAlignedBB axisAlignedBB, double d) {
        return this.func_212431_a(AxisRotation.func_197516_a(axis, Direction.Axis.X), axisAlignedBB, d);
    }

    protected double func_212431_a(AxisRotation axisRotation, AxisAlignedBB axisAlignedBB, double d2) {
        double d2;
        block11: {
            int \u260312;
            int \u260310;
            double \u26036;
            Direction.Axis \u26032;
            block10: {
                if (this.func_197766_b()) {
                    return d2;
                }
                if (Math.abs(d2) < 1.0E-7) {
                    return 0.0;
                }
                AxisRotation axisRotation2 = axisRotation.func_197514_a();
                \u26032 = axisRotation2.func_197513_a(Direction.Axis.X);
                Direction.Axis \u26033 = axisRotation2.func_197513_a(Direction.Axis.Y);
                Direction.Axis \u26034 = axisRotation2.func_197513_a(Direction.Axis.Z);
                double \u26035 = axisAlignedBB.func_197742_b(\u26032);
                \u26036 = axisAlignedBB.func_197745_a(\u26032);
                int \u26037 = this.func_197749_a(\u26032, \u26036 + 1.0E-7);
                int \u26038 = this.func_197749_a(\u26032, \u26035 - 1.0E-7);
                int \u26039 = Math.max(0, this.func_197749_a(\u26033, axisAlignedBB.func_197745_a(\u26033) + 1.0E-7));
                \u260310 = Math.min(this.field_197768_g.func_197819_a(\u26033), this.func_197749_a(\u26033, axisAlignedBB.func_197742_b(\u26033) - 1.0E-7) + 1);
                int \u260311 = Math.max(0, this.func_197749_a(\u26034, axisAlignedBB.func_197745_a(\u26034) + 1.0E-7));
                \u260312 = Math.min(this.field_197768_g.func_197819_a(\u26034), this.func_197749_a(\u26034, axisAlignedBB.func_197742_b(\u26034) - 1.0E-7) + 1);
                int \u260313 = this.field_197768_g.func_197819_a(\u26032);
                if (!(d2 > 0.0)) break block10;
                for (int i = \u26038 + 1; i < \u260313; ++i) {
                    for (\u2603 = \u26039; \u2603 < \u260310; ++\u2603) {
                        for (\u2603 = \u260311; \u2603 < \u260312; ++\u2603) {
                            if (!this.field_197768_g.func_197824_a(axisRotation2, i, \u2603, \u2603)) continue;
                            double d3 = this.func_197759_b(\u26032, i) - \u26035;
                            if (d3 >= -1.0E-7) {
                                d2 = Math.min(d2, d3);
                            }
                            return d2;
                        }
                    }
                }
                break block11;
            }
            if (!(d2 < 0.0)) break block11;
            for (int i = \u26037 - 1; i >= 0; --i) {
                for (\u2603 = \u26039; \u2603 < \u260310; ++\u2603) {
                    for (\u2603 = \u260311; \u2603 < \u260312; ++\u2603) {
                        if (!this.field_197768_g.func_197824_a(axisRotation2, i, \u2603, \u2603)) continue;
                        double d4 = this.func_197759_b(\u26032, i + 1) - \u26036;
                        if (d4 <= 1.0E-7) {
                            d2 = Math.max(d2, d4);
                        }
                        return d2;
                    }
                }
            }
        }
        return d2;
    }

    public String toString() {
        return this.func_197766_b() ? "EMPTY" : "VoxelShape[" + this.func_197752_a() + "]";
    }
}

