/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ITickList;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class ServerTickList<T>
implements ITickList<T> {
    protected final Predicate<T> field_205371_a;
    private final Function<T, ResourceLocation> field_205372_b;
    private final Function<ResourceLocation, T> field_205373_c;
    private final Set<NextTickListEntry<T>> field_205374_d = Sets.newHashSet();
    private final TreeSet<NextTickListEntry<T>> field_205375_e = Sets.newTreeSet(NextTickListEntry.func_223192_a());
    private final ServerWorld field_205376_f;
    private final Queue<NextTickListEntry<T>> field_205377_g = Queues.newArrayDeque();
    private final List<NextTickListEntry<T>> field_223189_h = Lists.newArrayList();
    private final Consumer<NextTickListEntry<T>> field_205378_h;

    public ServerTickList(ServerWorld serverWorld, Predicate<T> predicate, Function<T, ResourceLocation> function, Function<ResourceLocation, T> function2, Consumer<NextTickListEntry<T>> consumer) {
        this.field_205371_a = predicate;
        this.field_205372_b = function;
        this.field_205373_c = function2;
        this.field_205376_f = serverWorld;
        this.field_205378_h = consumer;
    }

    public void func_205365_a() {
        NextTickListEntry<T> nextTickListEntry;
        int n = this.field_205375_e.size();
        if (n != this.field_205374_d.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 65536) {
            n = 65536;
        }
        ServerChunkProvider \u26032 = this.field_205376_f.func_72863_F();
        Iterator<NextTickListEntry<T>> \u26033 = this.field_205375_e.iterator();
        this.field_205376_f.func_217381_Z().func_76320_a("cleaning");
        while (n > 0 && \u26033.hasNext()) {
            nextTickListEntry = \u26033.next();
            if (nextTickListEntry.field_77180_e > this.field_205376_f.func_82737_E()) break;
            if (!\u26032.func_222866_a(nextTickListEntry.field_180282_a)) continue;
            \u26033.remove();
            this.field_205374_d.remove(nextTickListEntry);
            this.field_205377_g.add(nextTickListEntry);
            --n;
        }
        this.field_205376_f.func_217381_Z().func_219895_b("ticking");
        while ((nextTickListEntry = this.field_205377_g.poll()) != null) {
            if (\u26032.func_222866_a(nextTickListEntry.field_180282_a)) {
                try {
                    this.field_223189_h.add(nextTickListEntry);
                    this.field_205378_h.accept(nextTickListEntry);
                    continue;
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception while ticking");
                    CrashReportCategory \u26034 = crashReport.func_85058_a("Block being ticked");
                    CrashReportCategory.func_175750_a(\u26034, nextTickListEntry.field_180282_a, null);
                    throw new ReportedException(crashReport);
                }
            }
            this.func_205360_a(nextTickListEntry.field_180282_a, nextTickListEntry.func_151351_a(), 0);
        }
        this.field_205376_f.func_217381_Z().func_76319_b();
        this.field_223189_h.clear();
        this.field_205377_g.clear();
    }

    @Override
    public boolean func_205361_b(BlockPos blockPos, T t) {
        return this.field_205377_g.contains(new NextTickListEntry<T>(blockPos, t));
    }

    @Override
    public void func_219497_a(Stream<NextTickListEntry<T>> stream) {
        stream.forEach(this::func_219504_a);
    }

    public List<NextTickListEntry<T>> func_223188_a(ChunkPos chunkPos, boolean bl, boolean bl2) {
        int n = (chunkPos.field_77276_a << 4) - 2;
        \u2603 = n + 16 + 2;
        \u2603 = (chunkPos.field_77275_b << 4) - 2;
        \u2603 = \u2603 + 16 + 2;
        return this.func_205366_a(new MutableBoundingBox(n, 0, \u2603, \u2603, 256, \u2603), bl, bl2);
    }

    public List<NextTickListEntry<T>> func_205366_a(MutableBoundingBox mutableBoundingBox, boolean bl, boolean bl2) {
        List<NextTickListEntry<T>> list = this.func_223187_a(null, this.field_205375_e, mutableBoundingBox, bl);
        if (bl && list != null) {
            this.field_205374_d.removeAll(list);
        }
        list = this.func_223187_a(list, this.field_205377_g, mutableBoundingBox, bl);
        if (!bl2) {
            list = this.func_223187_a(list, this.field_223189_h, mutableBoundingBox, bl);
        }
        return list == null ? Collections.emptyList() : list;
    }

    @Nullable
    private List<NextTickListEntry<T>> func_223187_a(@Nullable List<NextTickListEntry<T>> arrayList2, Collection<NextTickListEntry<T>> collection, MutableBoundingBox mutableBoundingBox, boolean bl) {
        ArrayList arrayList2;
        Iterator<NextTickListEntry<T>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry<T> nextTickListEntry = iterator.next();
            BlockPos \u26032 = nextTickListEntry.field_180282_a;
            if (\u26032.func_177958_n() < mutableBoundingBox.field_78897_a || \u26032.func_177958_n() >= mutableBoundingBox.field_78893_d || \u26032.func_177952_p() < mutableBoundingBox.field_78896_c || \u26032.func_177952_p() >= mutableBoundingBox.field_78892_f) continue;
            if (bl) {
                iterator.remove();
            }
            if (arrayList2 == null) {
                arrayList2 = Lists.newArrayList();
            }
            arrayList2.add(nextTickListEntry);
        }
        return arrayList2;
    }

    public void func_205368_a(MutableBoundingBox mutableBoundingBox, BlockPos blockPos) {
        List<NextTickListEntry<T>> list = this.func_205366_a(mutableBoundingBox, false, false);
        for (NextTickListEntry<T> nextTickListEntry : list) {
            if (!mutableBoundingBox.func_175898_b(nextTickListEntry.field_180282_a)) continue;
            BlockPos blockPos2 = nextTickListEntry.field_180282_a.func_177971_a(blockPos);
            T \u26032 = nextTickListEntry.func_151351_a();
            this.func_219504_a(new NextTickListEntry<T>(blockPos2, \u26032, nextTickListEntry.field_77180_e, nextTickListEntry.field_82754_f));
        }
    }

    public ListNBT func_219503_a(ChunkPos chunkPos) {
        List<NextTickListEntry<T>> list = this.func_223188_a(chunkPos, false, true);
        return ServerTickList.func_219502_a(this.field_205372_b, list, this.field_205376_f.func_82737_E());
    }

    public static <T> ListNBT func_219502_a(Function<T, ResourceLocation> function, Iterable<NextTickListEntry<T>> iterable, long l) {
        ListNBT listNBT = new ListNBT();
        for (NextTickListEntry<T> nextTickListEntry : iterable) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74778_a("i", function.apply(nextTickListEntry.func_151351_a()).toString());
            compoundNBT.func_74768_a("x", nextTickListEntry.field_180282_a.func_177958_n());
            compoundNBT.func_74768_a("y", nextTickListEntry.field_180282_a.func_177956_o());
            compoundNBT.func_74768_a("z", nextTickListEntry.field_180282_a.func_177952_p());
            compoundNBT.func_74768_a("t", (int)(nextTickListEntry.field_77180_e - l));
            compoundNBT.func_74768_a("p", nextTickListEntry.field_82754_f.func_205398_a());
            listNBT.add(compoundNBT);
        }
        return listNBT;
    }

    @Override
    public boolean func_205359_a(BlockPos blockPos, T t) {
        return this.field_205374_d.contains(new NextTickListEntry<T>(blockPos, t));
    }

    @Override
    public void func_205362_a(BlockPos blockPos, T t, int n, TickPriority tickPriority) {
        if (!this.field_205371_a.test(t)) {
            this.func_219504_a(new NextTickListEntry<T>(blockPos, t, (long)n + this.field_205376_f.func_82737_E(), tickPriority));
        }
    }

    private void func_219504_a(NextTickListEntry<T> nextTickListEntry) {
        if (!this.field_205374_d.contains(nextTickListEntry)) {
            this.field_205374_d.add(nextTickListEntry);
            this.field_205375_e.add(nextTickListEntry);
        }
    }

    public int func_225420_a() {
        return this.field_205374_d.size();
    }
}

