/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.IDynamicDeserializer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class AbstractVillagePiece
extends StructurePiece {
    protected final JigsawPiece field_214832_a;
    protected BlockPos field_214833_b;
    private final int field_214835_d;
    protected final Rotation field_214834_c;
    private final List<JigsawJunction> field_214836_e = Lists.newArrayList();
    private final TemplateManager field_214837_f;

    public AbstractVillagePiece(IStructurePieceType iStructurePieceType, TemplateManager templateManager, JigsawPiece jigsawPiece, BlockPos blockPos, int n, Rotation rotation, MutableBoundingBox mutableBoundingBox) {
        super(iStructurePieceType, 0);
        this.field_214837_f = templateManager;
        this.field_214832_a = jigsawPiece;
        this.field_214833_b = blockPos;
        this.field_214835_d = n;
        this.field_214834_c = rotation;
        this.field_74887_e = mutableBoundingBox;
    }

    public AbstractVillagePiece(TemplateManager templateManager, CompoundNBT compoundNBT, IStructurePieceType iStructurePieceType) {
        super(iStructurePieceType, compoundNBT);
        this.field_214837_f = templateManager;
        this.field_214833_b = new BlockPos(compoundNBT.func_74762_e("PosX"), compoundNBT.func_74762_e("PosY"), compoundNBT.func_74762_e("PosZ"));
        this.field_214835_d = compoundNBT.func_74762_e("ground_level_delta");
        this.field_214832_a = IDynamicDeserializer.func_214907_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT.func_74775_l("pool_element")), Registry.field_218365_F, "element_type", EmptyJigsawPiece.field_214856_a);
        this.field_214834_c = Rotation.valueOf(compoundNBT.func_74779_i("rotation"));
        this.field_74887_e = this.field_214832_a.func_214852_a(templateManager, this.field_214833_b, this.field_214834_c);
        ListNBT listNBT = compoundNBT.func_150295_c("junctions", 10);
        this.field_214836_e.clear();
        listNBT.forEach(iNBT -> this.field_214836_e.add(JigsawJunction.func_214894_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, iNBT))));
    }

    @Override
    protected void func_143011_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        compoundNBT2.func_74768_a("PosX", this.field_214833_b.func_177958_n());
        compoundNBT2.func_74768_a("PosY", this.field_214833_b.func_177956_o());
        compoundNBT2.func_74768_a("PosZ", this.field_214833_b.func_177952_p());
        compoundNBT2.func_74768_a("ground_level_delta", this.field_214835_d);
        compoundNBT2.func_218657_a("pool_element", (INBT)this.field_214832_a.func_214847_b(NBTDynamicOps.field_210820_a).getValue());
        compoundNBT2.func_74778_a("rotation", this.field_214834_c.name());
        ListNBT listNBT = new ListNBT();
        for (JigsawJunction jigsawJunction : this.field_214836_e) {
            listNBT.add(jigsawJunction.func_214897_a(NBTDynamicOps.field_210820_a).getValue());
        }
        compoundNBT2.func_218657_a("junctions", listNBT);
    }

    @Override
    public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
        return this.field_214832_a.func_214848_a(this.field_214837_f, iWorld, this.field_214833_b, this.field_214834_c, mutableBoundingBox, random);
    }

    @Override
    public void func_181138_a(int n, int n2, int n3) {
        super.func_181138_a(n, n2, n3);
        this.field_214833_b = this.field_214833_b.func_177982_a(n, n2, n3);
    }

    @Override
    public Rotation func_214809_Y_() {
        return this.field_214834_c;
    }

    public String toString() {
        return String.format("<%s | %s | %s | %s>", new Object[]{this.getClass().getSimpleName(), this.field_214833_b, this.field_214834_c, this.field_214832_a});
    }

    public JigsawPiece func_214826_b() {
        return this.field_214832_a;
    }

    public BlockPos func_214828_c() {
        return this.field_214833_b;
    }

    public int func_214830_d() {
        return this.field_214835_d;
    }

    public void func_214831_a(JigsawJunction jigsawJunction) {
        this.field_214836_e.add(jigsawJunction);
    }

    public List<JigsawJunction> func_214829_e() {
        return this.field_214836_e;
    }
}

