/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.ClientModLoader;
import net.minecraftforge.fml.loading.FMLConfig;

@OnlyIn(value=Dist.CLIENT)
public class NotificationModUpdateScreen
extends Screen {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final Button modButton;
    private VersionChecker.Status showNotification = null;
    private boolean hasCheckedForUpdates = false;

    public NotificationModUpdateScreen(Button modButton) {
        super((ITextComponent)new TranslationTextComponent("forge.menu.updatescreen.title", new Object[0]));
        this.modButton = modButton;
    }

    public void init() {
        if (!this.hasCheckedForUpdates) {
            if (this.modButton != null) {
                this.showNotification = ClientModLoader.checkForUpdates();
            }
            this.hasCheckedForUpdates = true;
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.showNotification == null || !this.showNotification.shouldDraw() || !FMLConfig.runVersionCheck()) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        int x = this.modButton.x;
        int y = this.modButton.y;
        int w = this.modButton.getWidth();
        int h = this.modButton.getHeight();
        NotificationModUpdateScreen.blit((int)(x + w - (h / 2 + 4)), (int)(y + (h / 2 - 4)), (float)(this.showNotification.getSheetOffset() * 8), (float)(this.showNotification.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f), (int)8, (int)8, (int)64, (int)16);
        GlStateManager.popMatrix();
    }

    public static NotificationModUpdateScreen init(MainMenuScreen guiMainMenu, Button modButton) {
        NotificationModUpdateScreen notificationModUpdateScreen = new NotificationModUpdateScreen(modButton);
        notificationModUpdateScreen.init(guiMainMenu.getMinecraft(), guiMainMenu.width, guiMainMenu.height);
        notificationModUpdateScreen.init();
        return notificationModUpdateScreen;
    }
}

